/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* ScrollBar.C,v 1.3 1994/10/27 23:26:51 pgw Exp */
/*
* Motif is a registered trademark of the Open Software Foundation, Inc.
*/

/* Include(s): */
#include <Xarm/ScrollBar.h>

void
ScrollBarClass::increment(int v)
{
   XtVaSetValues(widget(),XmNincrement,v, NULL);
}

int 
ScrollBarClass::increment()
{
   int v;
   XtVaGetValues(widget(),XmNincrement,&v, NULL);
   return v;
}

void 
ScrollBarClass::initialDelay(int v)
{
   XtVaSetValues(widget(),XmNinitialDelay,v, NULL);
}

int 
ScrollBarClass::initialDelay()
{
   int v;
   XtVaGetValues(widget(),XmNinitialDelay,&v, NULL);
   return v;
}

void 
ScrollBarClass::maximum(int v)
{
   XtVaSetValues(widget(),XmNmaximum,v, NULL);
}

int 
ScrollBarClass::maximum()
{
   int v;
   XtVaGetValues(widget(),XmNmaximum,&v, NULL);
   return v;
}

void 
ScrollBarClass::minimum(int v)
{
   XtVaSetValues(widget(),XmNminimum,v, NULL);
}

int 
ScrollBarClass::minimum()
{
   int v;
   XtVaGetValues(widget(),XmNminimum,&v, NULL);
   return v;
}
   
void 
ScrollBarClass::processingDirection(unsigned char v)   
{
   XtVaSetValues(widget(),XmNprocessingDirection,v, NULL);
}

unsigned char 
ScrollBarClass::processingDirection()   
{
   unsigned char v;
   XtVaGetValues(widget(),XmNprocessingDirection,&v, NULL);
   return v;
}

void 
ScrollBarClass::repeatDelay(int v)
{
   XtVaSetValues(widget(),XmNrepeatDelay,v, NULL);
}

int 
ScrollBarClass::repeatDelay()
{
   int v;
   XtVaGetValues(widget(),XmNrepeatDelay,&v, NULL);
   return v;
}

void 
ScrollBarClass::showArrows(Boolean v)
{
   XtVaSetValues(widget(),XmNshowArrows,v, NULL);
}

Boolean 
ScrollBarClass::showArrows()
{
   Boolean v;
   XtVaGetValues(widget(),XmNshowArrows,&v, NULL);
   return v;
}

void 
ScrollBarClass::sliderSize(int v)
{
   XtVaSetValues(widget(),XmNsliderSize,v, NULL);
}

int
ScrollBarClass::sliderSize()
{
   int v;
   XtVaGetValues(widget(),XmNsliderSize,&v, NULL);
   return v;
}

void 
ScrollBarClass::troughColor(Pixel v)
{
   XtVaSetValues(widget(),XmNtroughColor,v, NULL);
}

Pixel 
ScrollBarClass::troughColor()
{
   Pixel v;
   XtVaGetValues(widget(),XmNtroughColor,&v, NULL);
   return v;
}

void 
ScrollBarClass::value(int v)
{
   XtVaSetValues(widget(),XmNvalue,v, NULL);
}

int 
ScrollBarClass::value()
{
   int v;
   XtVaGetValues(widget(),XmNvalue,&v, NULL);
   return v;
}

void 
ScrollBarClass::decrementCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNdecrementCallback,funcp,data);
}

void 
ScrollBarClass::dragCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNdragCallback,funcp,data);
}

void 
ScrollBarClass::incrementCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNincrementCallback,funcp,data);
}

void 
ScrollBarClass::pageDecrementCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNpageDecrementCallback,funcp,data);
}

void 
ScrollBarClass::pageIncrementCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNpageIncrementCallback,funcp,data);
}

void 
ScrollBarClass::toBottomCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNtoBottomCallback,funcp,data);
}

void 
ScrollBarClass::toTopCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNtoTopCallback,funcp,data);
}

void 
ScrollBarClass::valueChangedCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNvalueChangedCallback,funcp,data);
}


/* constructors */

ScrollBar::ScrollBar(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateScrollBar(parent, "XmScrollBar", arglist, cnt);
   widget(wid);
}

