/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* RectObj.C,v 1.2 1994/10/27 23:26:48 pgw Exp */

/* Include(s): */
#include <Xarm/RectObj.h>

/* RectObjClass Members */

Boolean
_RectObjClass::ancestorSensitive() 
{
   Boolean cond;
   XtVaGetValues(widget(), XmNancestorSensitive, &cond, NULL);
   return cond;
}

Dimension
_RectObjClass::borderWidth() 
{
   Dimension h; 
   XtVaGetValues(widget(), XmNborderWidth, &h, NULL); 
   return h;
}

void 
_RectObjClass::borderWidth(Dimension w) 
{
   Dimension b = (Dimension) w;
   XtVaSetValues(widget(),XmNborderWidth,w,NULL);
}

void 
_RectObjClass::sensitive(Boolean cond) 
{
   XtSetSensitive(widget(),cond);
}

Boolean 
_RectObjClass::sensitive() 
{
   return XtIsSensitive(widget());
}

Dimension 
_RectObjClass::width() 
{ 
   Dimension w; 
   XtVaGetValues(widget(), XmNwidth, &w, NULL); 
   return w; 
}

void
_RectObjClass::width(Dimension w) 
{ 
   XtVaSetValues(widget(), XmNwidth, w, NULL); 
}

Dimension 
_RectObjClass::height() 
{
   Dimension h; 
   XtVaGetValues(widget(), XmNheight, &h, NULL);
   return h;
}

void
_RectObjClass::height(Dimension h) 
{
   XtVaSetValues(widget(), XmNheight, h, NULL);
}

Position 
_RectObjClass::x() 
{
   Position xpos;
   XtVaGetValues(widget(),XmNx,&xpos, NULL);
   return xpos;
}

void
_RectObjClass::x(Position xpos) 
{
   XtVaSetValues(widget(),XmNx,xpos, NULL);
}

Position 
_RectObjClass::y() 
{
   Position ypos;
   XtVaGetValues(widget(),XmNy,&ypos,NULL);
   return ypos;
}

void
_RectObjClass::y(Position ypos) 
{
   XtVaSetValues(widget(),XmNy,ypos,NULL);
}

