/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* PanedW.C,v 1.4 1994/10/28 03:49:38 pgw Exp */

/* Include(s): */
#include <Xarm/PanedW.h>

/* PanedWindowClass members */
/* resources */
void PanedWindowClass::marginHeight(Dimension v)
{
   XtVaSetValues(widget(),XmNmarginHeight, v, NULL);
}

Dimension PanedWindowClass::marginHeight()
{
   Dimension v;
   XtVaGetValues(widget(),XmNmarginHeight, &v, NULL);
   return v;
}

void PanedWindowClass::marginWidth(Dimension v)
{
   XtVaSetValues(widget(),XmNmarginWidth, v, NULL);
}

Dimension PanedWindowClass::marginWidth()
{
   Dimension v;
   XtVaGetValues(widget(),XmNmarginWidth, &v, NULL);
   return v;
}

void PanedWindowClass::refigureMode(Boolean v)
{
   XtVaSetValues(widget(),XmNrefigureMode, v, NULL);
}

Boolean PanedWindowClass::refigureMode()
{
   Boolean v;
   XtVaGetValues(widget(),XmNrefigureMode, &v, NULL);
   return v;
}

void PanedWindowClass::sashHeight(Dimension v)
{
   XtVaSetValues(widget(),XmNsashHeight, v, NULL);
}

Dimension PanedWindowClass::sashHeight()
{
   Dimension v;
   XtVaGetValues(widget(),XmNsashHeight, &v, NULL);
   return v;
}

void PanedWindowClass::sashIndent(Position v)
{
   XtVaSetValues(widget(),XmNsashIndent, v, NULL);
}

Position PanedWindowClass::sashIndent()
{
   Position v;
   XtVaGetValues(widget(),XmNsashIndent, &v, NULL);
   return v;
}

void PanedWindowClass::sashShadowThickness(Dimension v)
{
   XtVaSetValues(widget(),XmNsashShadowThickness, v, NULL);
}

Dimension PanedWindowClass::sashShadowThickness()
{
   Dimension v;
   XtVaGetValues(widget(),XmNsashShadowThickness, &v, NULL);
   return v;
}

void PanedWindowClass::sashWidth(Dimension v)
{
   XtVaSetValues(widget(),XmNsashWidth, v, NULL);
}

Dimension PanedWindowClass::sashWidth()
{
   Dimension v;
   XtVaGetValues(widget(),XmNsashWidth, &v, NULL);
   return v;
}

void PanedWindowClass::separatorOn(Boolean v)
{
   XtVaSetValues(widget(),XmNseparatorOn, v, NULL);
}

Boolean PanedWindowClass::separatorOn()
{
   Boolean v;
   XtVaGetValues(widget(),XmNseparatorOn, &v, NULL);
   return v;
}

void PanedWindowClass::spacing(Dimension v)
{
   XtVaSetValues(widget(),XmNspacing, v, NULL);
}

Dimension PanedWindowClass::spacing()
{
   Dimension v;
   XtVaGetValues(widget(),XmNspacing, &v, NULL);
   return v;
}

PanedWindow::PanedWindow(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreatePanedWindow(parent, "XmPanedWindow", arglist, cnt);
   widget(wid);
}

/* */
