/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* MainW.C,v 1.4 1994/10/27 23:26:38 pgw Exp */
#include <Xarm/MainW.h>
/* MainWindowClass members */

/* convenience routines */
Widget
MainWindowClass::separator1()
{
  return XmMainWindowSep1(widget());
}

Widget
MainWindowClass::separator2()
{
  return XmMainWindowSep1(widget());
}

Widget
MainWindowClass::separator3()
{
  return XmMainWindowSep1(widget());
}
      
void
MainWindowClass::setArea(Widget menu,
	Widget command,
	Widget hscroll,
	Widget vscroll,
	Widget work)
{
   XmMainWindowSetAreas(widget(),menu,command,hscroll,vscroll,work);
}

/* resources */
void
MainWindowClass::commandWindow(Widget w)
{
   XtVaSetValues(widget(), XmNcommandWindow, w, NULL);
}

Widget
MainWindowClass::commandWindow()
{
   Widget w;
   XtVaGetValues(widget(), XmNcommandWindow, &w, NULL);
   return w;
}

unsigned char
MainWindowClass::commandWindowLocation()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNcommandWindowLocation, &c, NULL);
   return c;
}

void
MainWindowClass::mainWindowMarginHeight(Dimension d)
{
   XtVaSetValues(widget(), XmNmainWindowMarginHeight, d, NULL);
}

Dimension
MainWindowClass::mainWindowMarginHeight()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmainWindowMarginHeight, &d, NULL);
   return d;
}

void
MainWindowClass::mainWindowMarginWidth(Dimension d)
{
   XtVaSetValues(widget(), XmNmainWindowMarginWidth, d, NULL);
}

Dimension
MainWindowClass::mainWindowMarginWidth()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmainWindowMarginWidth, &d, NULL);
   return d;
}

void
MainWindowClass::menuBar(Widget w)
{
   XtVaSetValues(widget(), XmNmenuBar, w, NULL);
}

Widget
MainWindowClass::menuBar()
{
   Widget w;
   XtVaGetValues(widget(), XmNmenuBar, &w, NULL);
   return w;
}

void
MainWindowClass::messageWindow(Widget w)
{
   XtVaSetValues(widget(), XmNmessageWindow, w, NULL);
}

Widget
MainWindowClass::messageWindow()
{
   Widget w;
   XtVaGetValues(widget(), XmNmessageWindow, &w, NULL);
   return w;
}

void
MainWindowClass::showSeparator(Boolean b)
{
   XtVaSetValues(widget(), XmNshowSeparator, b, NULL);
}

Boolean
MainWindowClass::showSeparator()
{
   Boolean b;
   XtVaGetValues(widget(), XmNshowSeparator, &b, NULL);
   return b;
}

/* class constructor */
MainWindow::MainWindow(Widget parent, unsigned char policy,
                                 Boolean show_separator)
{
   Widget w = XtVaCreateWidget("XmMainWindow",
                               xmMainWindowWidgetClass,
                               parent,
                               XmNscrollingPolicy, policy,
                               XmNshowSeparator, show_separator,
                               NULL);
   widget(w);
}

MainWindow::MainWindow(Widget parent, Dimension w, Dimension h, 
                                 unsigned char policy,
                                 Boolean show_separator)
{
   Widget wid = XtVaCreateWidget("XmMainWindow",
                               xmMainWindowWidgetClass,
                               parent,
                               XmNwidth, w,
                               XmNheight, h,
                               XmNscrollingPolicy, policy,
                               XmNshowSeparator, show_separator,
                               NULL);
                                
   widget(wid);
}

MainWindow::MainWindow(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateMainWindow(parent,"XmMainWindow",arglist, cnt);
   widget(wid);
}

