/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* LabelG.C,v 1.3 1994/10/27 23:26:36 pgw Exp */
#include <Xarm/LabelG.h>
/* LabelGadgetClass Members */

void
LabelGadgetClass::accelerator(String acc)
{
   XtVaSetValues(widget(),XmNaccelerator,acc,NULL);
}

String
LabelGadgetClass::accelerator()
{
   String acc;
   XtVaGetValues(widget(),XmNaccelerator, &acc,NULL);
   return acc;
}

void
LabelGadgetClass::acceleratorText(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNacceleratorText, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
LabelGadgetClass::acceleratorText()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNacceleratorText, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
LabelGadgetClass::alignment(unsigned char setting)
{
   XtVaSetValues(widget(), XmNalignment, setting, NULL);
}

unsigned char
LabelGadgetClass::alignment()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNalignment, &c, NULL);
   return c;
}

void
LabelGadgetClass::fontList(XmFontList fl)
{
   XtVaSetValues(widget(), XmNfontList, fl, NULL);
}

XmFontList
LabelGadgetClass::fontList()
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNfontList, &fl, NULL);
   return fl;
}

void
LabelGadgetClass::labelInsensitivePixmap(Pixmap p)
{
   XtVaSetValues(widget(), XmNlabelInsensitivePixmap, p, NULL);
}

Pixmap
LabelGadgetClass::labelInsensitivePixmap()
{
   Pixmap p;
   XtVaGetValues(widget(), XmNlabelInsensitivePixmap, &p, NULL);
   return p;
}

void
LabelGadgetClass::labelPixmap(Pixmap p)
{
   XtVaSetValues(widget(), XmNlabelPixmap, p, NULL);
}

Pixmap
LabelGadgetClass::labelPixmap()
{
   Pixmap p;
   XtVaGetValues(widget(), XmNlabelPixmap, &p, NULL);
   return p;
}

void
LabelGadgetClass::labelString(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNlabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
LabelGadgetClass::labelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNlabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
LabelGadgetClass::labelType(unsigned char c)
{
   XtVaSetValues(widget(), XmNlabelType, c, NULL);
}

unsigned char
LabelGadgetClass::labelType()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNlabelType, &c, NULL);
   return c;
}

void
LabelGadgetClass::marginBottom(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginBottom, d, NULL);
}

Dimension
LabelGadgetClass::marginBottom()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginBottom, &d, NULL);
   return d;
}

void
LabelGadgetClass::marginHeight(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginHeight, d, NULL);
}

Dimension
LabelGadgetClass::marginHeight()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginHeight, &d, NULL);
   return d;
}

void
LabelGadgetClass::marginLeft(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginLeft, d, NULL);
}

Dimension
LabelGadgetClass::marginLeft()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginLeft, &d, NULL);
   return d;
}

void
LabelGadgetClass::marginRight(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginRight, d, NULL);
}

Dimension
LabelGadgetClass::marginRight()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginRight, &d, NULL);
   return d;
}

void
LabelGadgetClass::marginTop(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginTop, d, NULL);
}

Dimension
LabelGadgetClass::marginTop()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginTop, &d, NULL);
   return d;
}

void
LabelGadgetClass::marginWidth(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginWidth, d, NULL);
}

Dimension
LabelGadgetClass::marginWidth()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginWidth, &d, NULL);
   return d;
}

void 
LabelGadgetClass::mnemonic(KeySym ch) 
{
   XtVaSetValues(widget(),XmNmnemonic,ch,NULL);
}

KeySym
LabelGadgetClass::mnemonic() 
{
   KeySym ch;
   XtVaGetValues(widget(),XmNmnemonic,&ch,NULL);
   return ch;
}

void 
LabelGadgetClass::mnemonicCharSet(String str)
{
   XtVaSetValues(widget(),XmNmnemonicCharSet,str,NULL);
}

String
LabelGadgetClass::mnemonicCharSet()
{
   String str;
   XtVaGetValues(widget(),XmNmnemonicCharSet,&str,NULL);
   return str;
}

void 
LabelGadgetClass::recomputeSize(Boolean expr)
{
   XtVaSetValues(widget(),XmNrecomputeSize,expr,NULL);
}

Boolean
LabelGadgetClass::recomputeSize()
{
   Boolean b;
   XtVaGetValues(widget(),XmNrecomputeSize, &b,NULL);
   return b;
}

void
LabelGadgetClass::stringDirection(XmStringDirection dir)
{
   XtVaSetValues(widget(), XmNstringDirection, dir, NULL);
}

XmStringDirection
LabelGadgetClass::stringDirection()
{
   XmStringDirection dir;
   XtVaGetValues(widget(), XmNstringDirection, &dir, NULL);
   return dir;
}

LabelGadget::LabelGadget(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateLabel(parent,"XmLabel", arglist, cnt);
   widget(wid);
   manage();
}

LabelGadget::LabelGadget(Widget parent, char *str)
{
   Widget wid = XtVaCreateWidget("XmLabel",
                               xmLabelWidgetClass,
                               parent,
                               NULL);
   widget(wid);
   labelString(str);
   manage();
}


