/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Label.C,v 1.4 1994/10/27 23:26:34 pgw Exp */
#include <Xarm/Label.h>
/* LabelClass Members */

void
LabelClass::accelerator(String acc)
{
   XtVaSetValues(widget(),XmNaccelerator,acc,NULL);
}

String
LabelClass::accelerator()
{
   String acc;
   XtVaGetValues(widget(),XmNaccelerator, &acc,NULL);
   return acc;
}

void
LabelClass::acceleratorText(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNacceleratorText, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
LabelClass::acceleratorText()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNacceleratorText, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
LabelClass::alignment(unsigned char setting)
{
   XtVaSetValues(widget(), XmNalignment, setting, NULL);
}

unsigned char
LabelClass::alignment()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNalignment, &c, NULL);
   return c;
}

void
LabelClass::fontList(XmFontList fl)
{
   XtVaSetValues(widget(), XmNfontList, fl, NULL);
}

XmFontList
LabelClass::fontList()
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNfontList, &fl, NULL);
   return fl;
}

void
LabelClass::labelInsensitivePixmap(Pixmap p)
{
   XtVaSetValues(widget(), XmNlabelInsensitivePixmap, p, NULL);
}

Pixmap
LabelClass::labelInsensitivePixmap()
{
   Pixmap p;
   XtVaGetValues(widget(), XmNlabelInsensitivePixmap, &p, NULL);
   return p;
}

void
LabelClass::labelPixmap(Pixmap p)
{
   XtVaSetValues(widget(), XmNlabelPixmap, p, NULL);
}

Pixmap
LabelClass::labelPixmap()
{
   Pixmap p;
   XtVaGetValues(widget(), XmNlabelPixmap, &p, NULL);
   return p;
}

void
LabelClass::labelString(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNlabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
LabelClass::labelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNlabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
LabelClass::labelType(unsigned char c)
{
   XtVaSetValues(widget(), XmNlabelType, c, NULL);
}

unsigned char
LabelClass::labelType()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNlabelType, &c, NULL);
   return c;
}

void
LabelClass::marginBottom(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginBottom, d, NULL);
}

Dimension
LabelClass::marginBottom()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginBottom, &d, NULL);
   return d;
}

void
LabelClass::marginHeight(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginHeight, d, NULL);
}

Dimension
LabelClass::marginHeight()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginHeight, &d, NULL);
   return d;
}

void
LabelClass::marginLeft(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginLeft, d, NULL);
}

Dimension
LabelClass::marginLeft()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginLeft, &d, NULL);
   return d;
}

void
LabelClass::marginRight(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginRight, d, NULL);
}

Dimension
LabelClass::marginRight()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginRight, &d, NULL);
   return d;
}

void
LabelClass::marginTop(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginTop, d, NULL);
}

Dimension
LabelClass::marginTop()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginTop, &d, NULL);
   return d;
}

void
LabelClass::marginWidth(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginWidth, d, NULL);
}

Dimension
LabelClass::marginWidth()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginWidth, &d, NULL);
   return d;
}

void 
LabelClass::mnemonic(KeySym ch) 
{
   XtVaSetValues(widget(),XmNmnemonic,ch,NULL);
}

KeySym
LabelClass::mnemonic() 
{
   KeySym ch;
   XtVaGetValues(widget(),XmNmnemonic,&ch,NULL);
   return ch;
}

void 
LabelClass::mnemonicCharSet(String str)
{
   XtVaSetValues(widget(),XmNmnemonicCharSet,str,NULL);
}

String
LabelClass::mnemonicCharSet()
{
   String str;
   XtVaGetValues(widget(),XmNmnemonicCharSet,&str,NULL);
   return str;
}

void 
LabelClass::recomputeSize(Boolean expr)
{
   XtVaSetValues(widget(),XmNrecomputeSize,expr,NULL);
}

Boolean
LabelClass::recomputeSize()
{
   Boolean b;
   XtVaGetValues(widget(),XmNrecomputeSize, &b,NULL);
   return b;
}

void
LabelClass::stringDirection(XmStringDirection dir)
{
   XtVaSetValues(widget(), XmNstringDirection, dir, NULL);
}

XmStringDirection
LabelClass::stringDirection()
{
   XmStringDirection dir;
   XtVaGetValues(widget(), XmNstringDirection, &dir, NULL);
   return dir;
}

/* Label constructors */
Label::Label(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateLabel(parent,"XmLabel", arglist, cnt);
   widget(wid);
   manage();
}

Label::Label(Widget parent, char *str)
{
   Widget wid = XtVaCreateWidget("XmLabel",
                               xmLabelWidgetClass,
                               parent,
                               NULL);
   widget(wid);
   labelString(str);
   manage();
}

