/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* FileSB.C,v 1.3 1994/10/27 23:26:30 pgw Exp */
#include <Xarm/FileSB.h>

/* FileSelectionBoxClass Members */
/* convenience routines */
Widget
FileSelectionBoxClass::getChild(unsigned char child)
{
   return XmFileSelectionBoxGetChild(widget(),child);
}

void
FileSelectionBoxClass::doSearch(char *dirmask)
{
   XmString xmstr = cvtStringToXmString(dirmask);
   XmFileSelectionDoSearch(widget(),xmstr);
   XmStringFree(xmstr);
}

/* resources */
void
FileSelectionBoxClass::directory(char *d)
{
   XmString xmstr = cvtStringToXmString(d);
   XtVaSetValues(widget(), XmNdirectory, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::directory()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNdirectory, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::directoryValid(Boolean b)
{
   XtVaSetValues(widget(), XmNdirectoryValid, b, NULL);
}

Boolean
FileSelectionBoxClass::directoryValid()
{
   Boolean b;
   XtVaGetValues(widget(), XmNdirectoryValid, &b, NULL);
   return b;
}

void
FileSelectionBoxClass::dirListItems(XmStringTable st)
{
   XtVaSetValues(widget(), XmNdirListItems, st, NULL);
}

XmStringTable
FileSelectionBoxClass::dirListItems()
{
   XmStringTable st;
   XtVaGetValues(widget(), XmNdirListItems, &st, NULL);
   return st;
}

void
FileSelectionBoxClass::dirListItemCount(int i)
{
   XtVaSetValues(widget(), XmNdirListItemCount, i, NULL);
}

int
FileSelectionBoxClass::dirListItemCount()
{
   int i;
   XtVaGetValues(widget(), XmNdirListItemCount, &i, NULL);
   return i;
}

void
FileSelectionBoxClass::dirListLabelString(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNdirListLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::dirListLabelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNdirListLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::dirMask(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNdirMask, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::dirMask()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNdirMask, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::dirSearchProc(XmSearchProc fp)
{
   XtVaSetValues(widget(), XmNdirSearchProc, fp, NULL);
}

XmSearchProc
FileSelectionBoxClass::dirSearchProc()
{
   XmSearchProc fp;
   XtVaGetValues(widget(), XmNdirSearchProc, &fp, NULL);
   return fp;
}

void
FileSelectionBoxClass::dirSpec(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNdirSpec, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::dirSpec()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNdirSpec, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::fileListItems(XmStringTable st)
{
   XtVaSetValues(widget(), XmNfileListItems, st, NULL);
}

XmStringTable
FileSelectionBoxClass::fileListItems()
{
   XmStringTable st;
   XtVaGetValues(widget(), XmNfileListItems, &st, NULL);
   return st;
}

void
FileSelectionBoxClass::fileListItemCount(int i)
{
   XtVaSetValues(widget(), XmNfileListItemCount, i, NULL);
}

int
FileSelectionBoxClass::fileListItemCount()
{
   int i;
   XtVaGetValues(widget(), XmNfileListItemCount, &i, NULL);
   return i;
}

void
FileSelectionBoxClass::fileListLabelString(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNfileListLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::fileListLabelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNfileListLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::fileSearchProc(XmSearchProc fp)
{
   XtVaSetValues(widget(), XmNfileSearchProc, fp, NULL);
}

XmSearchProc
FileSelectionBoxClass::fileSearchProc()
{
   XmSearchProc fp;
   XtVaGetValues(widget(), XmNfileSearchProc, &fp, NULL);
   return fp;
}

void
FileSelectionBoxClass::fileTypeMask(unsigned char c)
{
   XtVaSetValues(widget(), XmNfileTypeMask, c, NULL);
}

unsigned char
FileSelectionBoxClass::fileTypeMask()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNfileTypeMask, &c, NULL);
   return c;
}

void
FileSelectionBoxClass::filterLabelString(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNfilterLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::filterLabelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNfilterLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::listUpdated(Boolean b)
{
   XtVaSetValues(widget(), XmNlistUpdated, b, NULL);
}

Boolean
FileSelectionBoxClass::listUpdated()
{
   Boolean b;
   XtVaGetValues(widget(), XmNlistUpdated, &b, NULL);
   return b;
}

void
FileSelectionBoxClass::noMatchString(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNnoMatchString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::noMatchString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNnoMatchString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::pattern(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNpattern, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
FileSelectionBoxClass::pattern()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNpattern, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
FileSelectionBoxClass::qualifySearchDataProc(XmQualifyProc fp)
{
   XtVaSetValues(widget(), XmNqualifySearchDataProc, fp, NULL);
}

XmQualifyProc
FileSelectionBoxClass::qualifySearchDataProc()
{
   XmQualifyProc fp;
   XtVaGetValues(widget(), XmNqualifySearchDataProc, &fp, NULL);
   return fp;
}

/* constructors */
FileSelectionBox::FileSelectionBox(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateFileSelectionBox(parent,"XmFileSelectionBox",
                                         arglist, cnt);
   widget(wid);
}

FileSelectionDialog::FileSelectionDialog(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreateFileSelectionDialog(parent,"XmFileSelectionDialog",
                                          arglist,cnt); 
   widget(w);
}

