/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* DrawnB.C,v 1.3 1994/10/27 23:26:29 pgw Exp */
#include <Xarm/DrawnB.h>

/* DrawnButtonClass member functions */
/* Callbacks */
void 
DrawnButtonClass::activateCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNactivateCallback,funcp,data);
}

void 
DrawnButtonClass::armCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNarmCallback,funcp,data);
}

void 
DrawnButtonClass::disarmCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNdisarmCallback,funcp,data);
}

void 
DrawnButtonClass::exposeCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNexposeCallback,funcp,data);
}

void 
DrawnButtonClass::resizeCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNresizeCallback,funcp,data);
}

/* Resources */
void 
DrawnButtonClass::multiClick(unsigned char c)
{
   XtVaSetValues(widget(),XmNmultiClick,c,NULL);
}

unsigned char 
DrawnButtonClass::multiClick()
{
   unsigned char c;
   XtVaGetValues(widget(),XmNmultiClick, &c,NULL);
   return c;
}

void 
DrawnButtonClass::pushButtonEnabled(Boolean b)
{
   XtVaSetValues(widget(),XmNpushButtonEnabled,b,NULL);
}

Boolean 
DrawnButtonClass::pushButtonEnabled()
{
   Boolean b;
   XtVaGetValues(widget(),XmNpushButtonEnabled, &b,NULL);
   return b;
}
void 
DrawnButtonClass::shadowType(unsigned char c)
{
   XtVaSetValues(widget(),XmNshadowType,c,NULL);
}

unsigned char 
DrawnButtonClass::shadowType()
{
   unsigned char c;
   XtVaGetValues(widget(),XmNshadowType,&c,NULL);
   return c;
}

/* constructor */
DrawnButton::DrawnButton(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateDrawnButton(parent,"XmDrawnButton", arglist, cnt);
   widget(wid);
   manage();
}

/* */
