/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Command.C,v 1.3 1994/10/27 23:26:23 pgw Exp */

/* Include(s): */
#include <Xarm/Command.h>

/* CommandBoxClass Members */
void
CommandBoxClass::changedCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNcommandChangedCallback,fp,udata);
}

void
CommandBoxClass::enteredCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNcommandEnteredCallback,fp,udata);
}

void
CommandBoxClass::command(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNcommand, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
CommandBoxClass::command()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNcommand, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
CommandBoxClass::historyItems(XmStringTable st)
{
   XtVaSetValues(widget(), XmNhistoryItems, st, NULL);
}

XmStringTable
CommandBoxClass::historyItems()
{ 
   XmStringTable st;
   XtVaGetValues(widget(), XmNhistoryItems, &st, NULL);
   return st;
}

void
CommandBoxClass::historyItemCount(int no)
{
   XtVaSetValues(widget(), XmNhistoryItemCount, no, NULL);
}

int
CommandBoxClass::historyItemCount()
{
   int no;
   XtVaGetValues(widget(), XmNhistoryItemCount, &no, NULL);
   return no;
}

void
CommandBoxClass::historyMaxItems(int no)
{
   XtVaSetValues(widget(), XmNhistoryMaxItems, no, NULL);
}

int
CommandBoxClass::historyMaxItems()
{
   int no;
   XtVaGetValues(widget(), XmNhistoryMaxItems, &no, NULL);
   return no;
}

void
CommandBoxClass::historyVisibleItemCount(int no)
{
   XtVaSetValues(widget(), XmNhistoryVisibleItemCount, no, NULL);
}

int
CommandBoxClass::historyVisibleItemCount()
{
   int no;
   XtVaGetValues(widget(), XmNhistoryVisibleItemCount, &no, NULL);
   return no;
}

void
CommandBoxClass::promptString(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNpromptString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
CommandBoxClass::promptString()
{
   XmString xmstr; 
   XtVaGetValues(widget(), XmNpromptString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

/* constructor */
CommandBox::CommandBox(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateCommand(parent,"XmCommandBox",
                                      arglist, cnt);
   widget(wid);
   manage();
}

