/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* CascadeB.C,v 1.3 1994/10/27 23:26:21 pgw Exp */

/* Include(s): */
#include <Xarm/CascadeB.h>

/* CascadeButtonClass member functions */
void
CascadeButtonClass::activateCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNactivateCallback,fp,udata);
}

void
CascadeButtonClass::cascadingCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNcascadingCallback,fp,udata);
}

void
CascadeButtonClass::cascadePixmap(Pixmap id)
{
   XtVaSetValues(widget(),XmNcascadePixmap,id, NULL);
}

Pixmap
CascadeButtonClass::cascadePixmap()
{
   Pixmap id;
   XtVaSetValues(widget(),XmNcascadePixmap, &id, NULL);
   return id;
}

void
CascadeButtonClass::mappingDelay(int delay)
{
   XtVaSetValues(widget(),XmNmappingDelay,delay, NULL);
}   

int
CascadeButtonClass::mappingDelay()
{
   int delay;
   XtVaSetValues(widget(),XmNmappingDelay, &delay, NULL);
   return delay;
}   

void
CascadeButtonClass::subMenuId(Widget sub)
{
   if(sub)
   {
      XtVaSetValues(widget(),XmNsubMenuId,sub, NULL);
   }
}

Widget
CascadeButtonClass::subMenuId()
{
   Widget w;
   XtVaSetValues(widget(),XmNsubMenuId,&w, NULL);
   return w;
}

/* constructors */

CascadeButton::CascadeButton(Widget parent,char *str)
{
   Widget wid = XtVaCreateWidget("XmCascadeButton",
                                 xmCascadeButtonWidgetClass,
                                 parent,
                                 NULL);
   widget(wid);
   labelString(str);
   manage();
}

CascadeButton::CascadeButton(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateCascadeButton(parent,"XmCascadeButton",
                                      arglist, cnt);
   widget(wid);
   manage();
}


/* */
