/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Base.C,v 1.3 1994/10/27 23:26:20 pgw Exp */

/* Include(s): */
#include <Xarm/Base.h>

/* Conversion function */
WObject
WidgetToWObject(Widget w)
{
   if(XtIsWidget(w))
   {
      if(XtHasCallbacks(w, XmNdestroyCallback) == XtCallbackHasSome)
      {
         XtCallbackList clist;
         XtVaGetValues(w, XmNdestroyCallback, &clist, NULL); 
         for(;clist->callback;clist++)
         {
            if(clist->callback == BaseClass::destructor)
            {  
               return (WObject) clist->closure;
            }
         }
      }
   }
   return NULL;
}

/* =============================================================== */
/* BaseClass members */

void 
BaseClass::destructor(Widget widget, XtPointer killme, XtPointer event)
{
   widget = widget;
   event = event;
   delete ((BaseClass *)killme);
}

BaseClass::operator Widget() 
{ 
   return widget(); 
}

BaseClass::operator Display*()
{ 
   return display();
}

void 
BaseClass::deleteOnClose(int option)
{
   if(option == FALSE)
   {
      if(isDelete == TRUE && wid) 
      {
         removeDestructor(); /* remove previous setting */
      }
      isDelete = FALSE;
   }
   else if(option == TRUE)
   {
      if(isDelete == FALSE && wid) 
      {
         addDestructor(); /* add setting */
      }
      isDelete = TRUE;
   }
   /* else invalid setting */
}

void
BaseClass::destroyCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNdestroyCallback, fp, data);
}

/* */
