/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* ArrowBG.C,v 1.4 1994/10/27 23:26:19 pgw Exp */

/* Include(s): */
#include <Xarm/ArrowBG.h>

/* ArrowButtonGadgetClass member functions */

void
ArrowButtonGadgetClass::activateCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNactivateCallback,fp,udata);
}

void
ArrowButtonGadgetClass::armCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNarmCallback,fp,udata);
}

void
ArrowButtonGadgetClass::disarmCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdisarmCallback,fp,udata);
}

void
ArrowButtonGadgetClass::arrowDirection(unsigned char direction)
{
   XtVaSetValues(widget(),XmNarrowDirection,direction,NULL);
}

void
ArrowButtonGadgetClass::multiClick(unsigned char click)
{
   XtVaSetValues(widget(),XmNmultiClick,click,NULL);
}

/* ArrowButtonGadget constructor */

ArrowButtonGadget::ArrowButtonGadget(Widget p, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateArrowButton(p,"XmArrowButton",arglist, cnt);

   widget(wid);
   manage();
}

/* */
