/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* ArrowB.C,v 1.5 1994/10/27 22:28:59 pgw Exp */

#include <Xarm/ArrowB.h>
/* ArrowButtonClass member functions */

void
ArrowButtonClass::activateCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNactivateCallback,fp,udata);
}

void
ArrowButtonClass::armCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNarmCallback,fp,udata);
}

void
ArrowButtonClass::disarmCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdisarmCallback,fp,udata);
}

void
ArrowButtonClass::arrowDirection(unsigned char direction)
{
   XtVaSetValues(widget(),XmNarrowDirection,direction,NULL);
}

void
ArrowButtonClass::multiClick(unsigned char click)
{
   XtVaSetValues(widget(),XmNmultiClick,click,NULL);
}

/* Arrow Button Constructor */

ArrowButton::ArrowButton(Widget p, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateArrowButton(p,"XmArrowButton",arglist, cnt);

   widget(wid);
   manage();
}

/* */
