/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* ToggleBG.h,v 1.7 1994/10/27 23:25:53 pgw Exp */

#if !defined(_TOGGLEBG_H_)
#define _TOGGLEBG_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/LabelG.h>

class ToggleButtonGadgetClass : public LabelGadgetClass {
 protected:
   ToggleButtonGadgetClass() {}
 public:
   /* callbacks */
   void armCallback(XtCallbackProc funcp, XtPointer data = NULL); 
   void disarmCallback(XtCallbackProc funcp, XtPointer data = NULL); 
   void valueChangedCallback(XtCallbackProc funcp, XtPointer data = NULL); 

   /* convenience functions */
   Boolean getState();
   void setState(Boolean state, Boolean notify = FALSE);

   /* resources */
   void fillOnSelect(Boolean);
   Boolean fillOnSelect();
   void indicatorOn(Boolean);
   Boolean indicatorOn();
   void indicatorSize(Dimension);
   Dimension indicatorSize();
   void indicatorType(unsigned char);
   unsigned char indicatorType();
   void selectColor(Pixel);
   Pixel selectColor();
   void selectInsensitivePixmap(Pixmap);
   Pixmap selectInsensitivePixmap();
   void set(Boolean);
   Boolean set();
   void spacing(Dimension);
   Dimension spacing();
   void visibleWhenOff(Boolean);
   Boolean visibleWhenOff();
};

class ToggleButtonGadget : public ToggleButtonGadgetClass {
 public:
   ToggleButtonGadget(Widget parent, char *text, KeySym mn = 0,
                      String acc = NULL, char *acc_text = NULL);
   ToggleButtonGadget(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

#endif
