/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* TextF.h,v 1.6 1994/10/27 23:25:51 pgw Exp */

#if !defined(_TEXTF_H_)
#define _TEXTF_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class TextFieldClass : public PrimitiveClass {
 protected:
   TextFieldClass() {} /* only a derived class can make this */
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void focusCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void gainPrimaryCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void losePrimaryCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void losingFocusCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void modifyVerifyCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void modifyVerifyCallbackWcs(XtCallbackProc funcp, XtPointer data = NULL);
   void motionVerifyCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void valueChangedCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* convenience functions */
   void clearSelection(Time time);
   Boolean copy(Time time);
   Boolean cut(Time time);
   int getBaseline();
   XmTextPosition getCursorPosition();
   Boolean getEditable();
   XmTextPosition getInsertionPosition();
   XmTextPosition getLastPosition();
   int getMaxLength();
   char *getSelection();
   Boolean getSelectionPosition(XmTextPosition *left, XmTextPosition *right);
   wchar_t *getSelectionWcs();
   char *getString();
   wchar_t *getStringWcs();
   int getSubstring(XmTextPosition start, int no_chars, int buf_sz, char *buf);
   int getSubstringWcs(XmTextPosition start, int no_chars, int buf_sz, 
                       wchar_t *buf);
   void insert(XmTextPosition pos, char *str);
   void insertWcs(XmTextPosition pos, wchar_t *str);
   Boolean paste();
   Boolean posToXY(XmTextPosition pos, Position *x, Position *y);
   Boolean remove();
   void replace(XmTextPosition from, XmTextPosition to, char *value);
   void replaceWcs(XmTextPosition from, XmTextPosition to, wchar_t *value);
   void setAddMode(Boolean state);
   void setCursorPosition(XmTextPosition position);
   void setEditable(Boolean editable);
   void setHighlight(XmTextPosition left, XmTextPosition right,
                     XmHighlightMode mode);
   void setInsertionPosition(XmTextPosition pos);
   void setMaxLength(int max);
   void setSelection(XmTextPosition first, XmTextPosition last,
                     Time t);
   void setString(char *str);
   void setStringWcs(wchar_t *str);
   void showPosition(XmTextPosition pos);
   XmTextPosition xyToPos(Position x, Position y);
   
   /* resources */
   void blinkRate(int);
   int blinkRate();
   void columns(short);
   short columns();
   void cursorPosition(XmTextPosition);
   XmTextPosition cursorPosition();
   void cursorPositionVisible(Boolean);
   Boolean cursorPositionVisible();
   void editable(Boolean);
   Boolean editable();
   void fontList(XmFontList);
   XmFontList fontList();
   void marginHeight(Dimension);
   Dimension marginHeight();
   void marginWidth(Dimension);
   Dimension marginWidth();
   void maxLength(int);
   int maxLength();
   void pendingDelete(Boolean);
   Boolean pendingDelete();
   void resizeWidth(Boolean);
   Boolean resizeWidth();
   void selectionArray(XmTextScanType *);
   XmTextScanType *selectionArray();
   void selectionArrayCount(int);
   int selectionArrayCount();
   void selectThreshold(int);
   int selectThreshold();
   void value(String);
   String value();
   void valueWcs(wchar_t *);
   wchar_t *valueWcs();
   void verifyBell(Boolean);
   Boolean verifyBell();
};

class TextField : public TextFieldClass {
 public:
   TextField(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};


#endif
