/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Shell.h,v 1.6 1994/10/27 23:25:49 pgw Exp */

#if !defined(_SHELL_H_)
#define _SHELL_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Composite.h>

class ShellClass : public CompositeClass {
 protected:
   ShellClass() {}
 public:
   /* callbacks */
   void popdownCallback(XtCallbackProc fp, XtPointer data = NULL);
   void popupCallback(XtCallbackProc fp, XtPointer data = NULL);

   /* convenience routines */
   void activateProtocol(Atom property, Atom protocol);
   void activateWMProtocol(Atom protocol);

   /* resources */
   Boolean allowShellResize();
   void createPopupChildProc(XtCreatePopupChildProc);
   XtCreatePopupChildProc createPopupChildProc();
   void geometry(String);
   String geometry();
   void overrideRedirect(Boolean);
   Boolean overrideRedirect();
   void saveUnder(Boolean);
   Boolean saveUnder();
   void visual(Visual *);
   Visual *visual();
};


class WMShellClass : public ShellClass {
 protected:
   WMShellClass() {}
 public:
   /* resources */
   void baseHeight(int);
   int baseHeight();
   void baseWidth(int);
   int baseWidth();
   void heightInc(int);
   int heightInc();
   void iconMask(Pixmap);
   Pixmap iconMask();
   void iconPixmap(Pixmap);
   Pixmap iconPixmap();
   void iconWindow(Window);
   Window iconWindow();
   void iconX(int);
   int iconX();
   void iconY(int);
   int iconY();
   void initialState(int);
   int initialState();
   void input(Boolean);
   Boolean input();
   void maxAspectX(int);
   int maxAspectX();
   void maxAspectY(int);
   int maxAspectY();
   void maxHeight(int);
   int maxHeight();
   void maxWidth(int);
   int maxWidth();
   void minAspectX(int);
   int minAspectX();
   void minAspectY(int);
   int minAspectY();
   void minHeight(int);
   int minHeight();
   void minWidth(int);
   int minWidth();
   void title(String);
   String title();
   void titleEncoding(Atom);
   Atom titleEncoding();
   void transient(Boolean);
   Boolean transient();
   void waitForWm(Boolean);
   Boolean waitForWm();
   void widthInc(int);
   int widthInc();
   void windowGroup(Window);
   Window windowGroup();
   void winGravity(int);
   int winGravity();
   void wmTimeout(int);
   int wmTimeout();
};

#include <Xarm/VendorS.h>

class TransientShellClass : public VendorShellClass {
 protected:
   TransientShellClass() {}
 public:
   /* resources */
   void transientFor(Widget);
   Widget transientFor();
};

class TopLevelShellClass : public VendorShellClass {
 protected:
   TopLevelShellClass() {}
 public:
   /* resources */
   void iconic(Boolean);
   Boolean iconic();
   void iconName(String);
   String iconName();
   void iconNameEncoding(Atom);
   Atom iconNameEncoding();

   /* extra */
   void realize();
   void unrealize(); 
};


class OverrideShellClass : public ShellClass {
 protected:
   OverrideShellClass() {}
};

#endif
