/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* ScrolledW.h,v 1.6 1994/10/27 23:25:45 pgw Exp */

#if !defined(_SCROLLEDW_H_)
#define _SCROLLEDW_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>

class ScrolledWindowClass: public ManagerClass {
 protected:
   ScrolledWindowClass() {} /* only a derived class can make this */
 public:
   /* callbacks */
   void traverseObscuredCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   Widget horizontalScrollBar();
   void horizontalScrollBar(Widget);
   void scrollBarDisplayPolicy(unsigned char); 
   unsigned char scrollBarDisplayPolicy(); 
   void scrollBarPlacement(unsigned char);
   unsigned char scrollBarPlacement();
   void scrolledWindowMarginHeight(Dimension);
   Dimension scrolledWindowMarginHeight();
   void scrolledWindowMarginWidth(Dimension);
   Dimension scrolledWindowMarginWidth();
   unsigned char scrollingPolicy(); 
   void spacing(int);
   int spacing();
   Widget verticalScrollBar();
   void verticalScrollBar(Widget);
   unsigned char visualPolicy();
   void workWindow(Widget);
   Widget workWindow();
};

class ScrolledWindow : public ScrolledWindowClass {
 public:
   ScrolledWindow(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

#endif
