/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* ScrollBar.h,v 1.6 1994/10/27 23:25:44 pgw Exp */

#if !defined(_SCROLLBAR_H_)
#define _SCROLLBAR_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class ScrollBarClass : public PrimitiveClass {
 protected:
   ScrollBarClass() {}
 public:
   /* Callbacks */
   void decrementCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void dragCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void incrementCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void pageDecrementCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void pageIncrementCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void toBottomCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void toTopCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void valueChangedCallback(XtCallbackProc funcp, XtPointer data = NULL);  

   /* Resources */
   void increment(int);
   int increment();
   void initialDelay(int);
   int initialDelay();
   void maximum(int);
   int maximum();
   void minimum(int);
   int minimum();
   void processingDirection(unsigned char);   
   unsigned char processingDirection();   
   void repeatDelay(int);
   int repeatDelay();
   void showArrows(Boolean);
   Boolean showArrows(); 
   void sliderSize(int);
   int sliderSize();
   void troughColor(Pixel);
   Pixel troughColor();
   void value(int);
   int value();
};

class ScrollBar : public ScrollBarClass {
 public:
   ScrollBar(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

#endif
