/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Scale.h,v 1.6 1994/10/27 23:25:41 pgw Exp */

#if !defined(_SCALE_H_)
#define _SCALE_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>

class ScaleClass : public ManagerClass {
 protected:
   ScaleClass() {}
 public:
   /* callbacks */
   void dragCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void valueChangedCallback(XtCallbackProc funcp, XtPointer data = NULL); 

   /* resources */
   void decimalPoints(short);
   short decimalPoints();
   void fontList(XmFontList);
   XmFontList fontList();
   void highlightOnEnter(Boolean);
   Boolean highlightOnEnter();
   void highlightThickness(Dimension);
   Dimension highlightThickness();
   void maximum(int);    
   int maximum();    
   void minimum(int);    
   int minimum();    
   void orientation(unsigned char);
   unsigned char orientation();
   void processingDirection(unsigned char);
   unsigned char processingDirection();
   void scaleHeight(Dimension);
   Dimension scaleHeight();
   void scaleMultiple(int);
   int scaleMultiple();
   void scaleWidth(Dimension);
   Dimension scaleWidth();
   void showValue(Boolean);
   Boolean showValue();
   void titleString(char *);
   char *titleString();
   void value(int);
   int value();
};

class Scale : public ScaleClass {
 public:
   Scale(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

#endif
