/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Registry.h,v 1.3 1994/10/28 03:49:26 pgw Exp */

#if !defined(_REGISTRY_H_)
#define _REGISTRY_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/ConRes.h>

class DropSiteClass : public ConstraintResources
{
 protected:
   DropSiteClass() {}
 public:
   /* callbacks */
   void dragProc(XtCallbackProc, XtPointer);
   void dropProc(XtCallbackProc, XtPointer);

   /* convenience routines */
   void configureStackingOrder(Widget sibling, Cardinal stack_mode);
   void endUpdate();
   Status queryStackingOrder(Widget *parent_ret, 
                             Widget **children_ret, 
                             Cardinal *num_children_ret);
   void Register(ArgList arglist = NULL, Cardinal cnt = 0);
   void retrieve(ArgList arglist, Cardinal cnt);
   void startUpdate();
   void update(ArgList arglist, Cardinal cnt);
   void unregister();
   
   /* resources */
   void animationMask(Pixmap);
   Pixmap animationMask();
   void animationPixmap(Pixmap);
   Pixmap animationPixmap();
   void animationPixmapDepth(int);
   int animationPixmapDepth();
   void animationStyle(unsigned char);
   unsigned char animationStyle();
   void dropRectangles(XRectangle *);
   XRectangle *dropRectangles();
   void dropSiteActivity(unsigned char);
   unsigned char dropSiteActivity();
   void dropSiteOperations(unsigned char);
   unsigned char dropSiteOperations();
   unsigned char dropSiteType();
   void importTargets(Atom *);
   Atom *importTargets();
   void numDropRectangles(Cardinal);
   Cardinal numDropRectangles();
   void numImportTargets(Cardinal);
   Cardinal numImportTargets();
};

#endif

