/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* PushB.h,v 1.6 1994/10/27 23:25:37 pgw Exp */

#if !defined(_PUSHB_H_)
#define _PUSHB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Label.h>

class PushButtonClass : public LabelClass {
 protected:
   PushButtonClass() {} /* only a derived class can make this */
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void armCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void disarmCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   void armColor(Pixel);
   Pixel armColor();
   void defaultButtonShadowThickness(Dimension);
   Dimension defaultButtonShadowThickness();
   void fillOnArm(Boolean);
   Boolean fillOnArm();
   void multiClick(unsigned char);
   unsigned char multiClick();
   void showAsDefault(Dimension);
   Dimension showAsDefault();

   /* extra functionality */
   void autoSpace(int size = 100);
};
   
class PushButton : public PushButtonClass {
 public:
   PushButton(Widget parent, char *text, KeySym mn = 0,
                String acc = NULL, char *acc_text = NULL);
   PushButton(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

#endif
