/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* LabelG.h,v 1.6 1994/10/27 23:25:28 pgw Exp */

#if !defined(_LABELG_H_)
#define _LABELG_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Gadget.h>

class LabelGadgetClass : public GadgetClass {
 protected:
   LabelGadgetClass() {} /* only a derived class can make this */
 public:
   /* resources */
   void accelerator(String str);
   String accelerator();
   void acceleratorText(char *str);
   char *acceleratorText();
   void alignment(unsigned char);
   unsigned char alignment();
   void fontList(XmFontList);
   XmFontList fontList();
   void labelInsensitivePixmap(Pixmap);
   Pixmap labelInsensitivePixmap();
   void labelPixmap(Pixmap);
   Pixmap labelPixmap();
   void labelString(char *str);
   char *labelString();
   void labelType(unsigned char);
   unsigned char labelType();
   void marginBottom(Dimension);
   Dimension marginBottom();
   void marginHeight(Dimension);
   Dimension marginHeight();
   void marginLeft(Dimension);
   Dimension marginLeft();
   void marginRight(Dimension);
   Dimension marginRight();
   void marginTop(Dimension);
   Dimension marginTop();
   void marginWidth(Dimension);
   Dimension marginWidth();
   void mnemonic(KeySym);
   KeySym mnemonic();
   void mnemonicCharSet(String);
   String mnemonicCharSet();
   void recomputeSize(Boolean);
   Boolean recomputeSize();
   void stringDirection(XmStringDirection);
   XmStringDirection stringDirection();
};

class LabelGadget : public LabelGadgetClass {
 public:
   LabelGadget(Widget parent,char *str);
   LabelGadget(Widget parent,ArgList arglist = NULL, Cardinal cnt = 0);
};


#endif
