/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Label.h,v 1.7 1994/10/27 23:25:27 pgw Exp */

#if !defined(_LABEL_H_)
#define _LABEL_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class LabelClass : public PrimitiveClass {
 protected:
   LabelClass() {} /* only a derived class can make this */
 public:
   /* resources */
   void accelerator(String str);
   String accelerator();
   void acceleratorText(char *str);
   char *acceleratorText();
   void alignment(unsigned char);
   unsigned char alignment();
   void fontList(XmFontList);
   XmFontList fontList();
   void labelInsensitivePixmap(Pixmap);
   Pixmap labelInsensitivePixmap();
   void labelPixmap(Pixmap);
   Pixmap labelPixmap();
   void labelString(char *str);
   char *labelString();
   void labelType(unsigned char);
   unsigned char labelType();
   void marginBottom(Dimension);
   Dimension marginBottom();
   void marginHeight(Dimension);
   Dimension marginHeight();
   void marginLeft(Dimension);
   Dimension marginLeft();
   void marginRight(Dimension);
   Dimension marginRight();
   void marginTop(Dimension);
   Dimension marginTop();
   void marginWidth(Dimension);
   Dimension marginWidth();
   void mnemonic(KeySym);
   KeySym mnemonic();
   void mnemonicCharSet(String);
   String mnemonicCharSet();
   void recomputeSize(Boolean); 
   Boolean recomputeSize();
   void stringDirection(XmStringDirection);
   XmStringDirection stringDirection();
};

class Label : public LabelClass {
 public:
   Label(Widget parent,char *str);
   Label(Widget parent,ArgList arglist = NULL, Cardinal cnt = 0);
};

#endif
