/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* DragDrop.h,v 1.8 1994/10/27 23:25:19 pgw Exp */

#if !defined(_DRAGDROP_H_)
#define _DRAGDROP_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Core.h>

class DragContextClass : public CoreClass {
 protected:
   DragContextClass() {} /* only a derived class can make this */
 public:
   /* callbacks */
   void dragDropFinishCallback(XtCallbackProc, XtPointer);
   void dragMotionCallback(XtCallbackProc, XtPointer);
   void dropFinishCallback(XtCallbackProc, XtPointer);
   void dropSiteEnterCallback(XtCallbackProc, XtPointer);
   void dropSiteLeaveCallback(XtCallbackProc, XtPointer);
   void dropStartCallback(XtCallbackProc, XtPointer);
   void operationChangedCallback(XtCallbackProc, XtPointer);
   void topLevelEnterCallback(XtCallbackProc, XtPointer);
   void topLevelLeaveCallback(XtCallbackProc, XtPointer);

   /* resources */
   unsigned char blendModel();
   void clientData (XtPointer);
   XtPointer clientData();
   void convertProc(XtConvertSelectionIncrProc);
   XtConvertSelectionIncrProc convertProc();
   void cursorBackground(Pixel);
   Pixel cursorBackground();
   void cursorForeground(Pixel);
   Pixel cursorForeground();
   void exportTargets(Atom *);
   Atom *exportTargets();
   void incremental(Boolean);
   Boolean incremental();
   void invalidCursorForeground(Pixel);
   Pixel invalidCursorForeground();
   void noneCursorForeground(Pixel);
   Pixel noneCursorForeground();
   void numExportTargets(Cardinal);
   Cardinal numExportTargets();
   void operationCursorIcon(Widget);
   Widget operationCursorIcon();
   void sourceCursorIcon(Widget);
   Widget sourceCursorIcon();
   void sourcePixmapIcon(Widget);
   Widget sourcePixmapIcon();
   void stateCursorIcon(Widget);
   Widget stateCursorIcon();
   void validCursorForeground(Pixel);
   Pixel validCursorForeground();
};

class DragIconClass : public _ObjectClass {
 protected:
   DragIconClass() {}     
 public:
   /* resources */
   void attachment(unsigned char);
   unsigned char attachment();
   void depth(int);
   int depth();
   void height(Dimension);
   Dimension height();
   void hotX(Position);
   Position hotX();
   void hotY(Position);
   Position hotY();
   void mask(Pixmap);
   Pixmap mask();
   void offsetX(Position);
   Position offsetX();
   void offsetY(Position);
   Position offsetY();
   void pixmap(Pixmap);
   Pixmap pixmap();
   void width(Dimension);
   Dimension width();
};

class DropTransferClass : public _ObjectClass 
{
 protected:
   DropTransferClass() {}
 public:
   /* resources */
   XmDropTransferEntryRec *dropTransfers();
   void incremental(Boolean);
   Boolean incremental();
   void numDropTransfers(Cardinal);
   Cardinal numDropTransfers();
   void transferProc(XtSelectionCallbackProc);
   XtSelectionCallbackProc transferProc();
   void transferStatus(unsigned char);
   unsigned char transferStatus();
};

#endif
