/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* ConRes.h,v 1.2 1994/10/29 18:33:37 pgw Exp */

#if !defined(_CHILDRES_H_)
#define _CHILDRES_H_

#include <Xarm/Base.h>

class FormConstraintResources : public BaseClass { 
 protected:
   FormConstraintResources() {}
 public:
   /* constraint resources */
   void bottomAttachment(unsigned char);
   unsigned char bottomAttachment();
   void bottomOffset(int);
   int bottomOffset();
   void bottomPosition(int);
   int bottomPosition();
   void bottomWidget(Widget);
   Widget bottomWidget();
   void leftAttachment(unsigned char);
   unsigned char leftAttachment();
   void leftOffset(int);
   int leftOffset();
   void leftPosition(int);
   int leftPosition();
   void leftWidget(Widget);
   Widget leftWidget();
   void resizable(Boolean); 
   Boolean resizable(); 
   void rightAttachment(unsigned char);
   unsigned char rightAttachment();
   void rightOffset(int);
   int rightOffset();
   void rightPosition(int);
   int rightPosition();
   void rightWidget(Widget);
   Widget rightWidget();
   void topAttachment(unsigned char);
   unsigned char topAttachment();
   void topOffset(int);
   int topOffset();
   void topPosition(int);
   int topPosition();
   void topWidget(Widget);
   Widget topWidget(); 

};

class FrameConstraintResources : public FormConstraintResources { 
 protected:
   FrameConstraintResources() {}
 public:
   /* constraint resources */
   void childType(unsigned char);
   unsigned char childType();
   void childHorizontalAlignment(unsigned char);
   unsigned char childHorizontalAlignment();
   void childHorizontalSpacing(unsigned char);
   unsigned char childHorizontalSpacing();
   void childVerticalAlignment(unsigned char);
   unsigned char childVerticalAlignment();
};

class PanedWindowConstraintResources : public FrameConstraintResources {
 protected:
   PanedWindowConstraintResources() {}
 public:
   /* constraints */
   void allowResize(Boolean);
   Boolean allowResize();
   void paneMaximum(Dimension);
   Dimension paneMaximum();
   void paneMinimum(Dimension);
   Dimension paneMinimum();
   void positionIndex(short);
   short positionIndex();
   void skipAdjust(Boolean);
   Boolean skipAdjust();
};

class RowColumnConstraintResources : public PanedWindowConstraintResources {
 protected:
   RowColumnConstraintResources() {}
 public:
   /* constraint resources */
   void positionIndex(short s);
   short positionIndex();
};

class ConstraintResources : public RowColumnConstraintResources {
 protected:
   ConstraintResources() {}
};

#endif
