/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* CascadeB.h,v 1.6 1994/10/27 23:25:11 pgw Exp */

#if !defined(_CASCADEB_H_)
#define _CASCADEB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Label.h>

class CascadeButtonClass : public LabelClass {
 protected:
   CascadeButtonClass() {} /* only a derived class can make this */
 public:
   /* Callbacks */
   void activateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void cascadingCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   void cascadePixmap(Pixmap);
   Pixmap cascadePixmap();
   void mappingDelay(int);
   int mappingDelay();
   void subMenuId(Widget sub); /* expects a PulldownMenu */
   Widget subMenuId();
};

class CascadeButton : public CascadeButtonClass {
 public:
   CascadeButton(Widget parent, char *str);
   CascadeButton(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

#endif
