/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* BulletinB.h,v 1.6 1994/10/27 23:25:10 pgw Exp */

#if !defined(_BULLETINB_H_)
#define _BULLETINB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>

class BulletinBoardClass : public ManagerClass {
 protected:
   BulletinBoardClass() {} /* only a derived class can make this */
 public:
   /* callbacks */
   void focusCallback(XtCallbackProc fp, XtPointer udata = NULL);
   void mapCallback(XtCallbackProc fp, XtPointer udata = NULL);
   void unmapCallback(XtCallbackProc fp, XtPointer udata = NULL);

   /* resources */
   void allowOverlap(Boolean);
   Boolean allowOverlap();
   Boolean autoUnmanage();
   void buttonFontList(XmFontList);
   XmFontList buttonFontList();
   void cancelButton(Widget);
   Widget cancelButton();
   void defaultButton(Widget);
   Widget defaultButton();
   void defaultPosition(Boolean);
   Boolean defaultPosition();
   void dialogStyle(unsigned char);
   unsigned char dialogStyle();
   void dialogTitle(char *str);
   char *dialogTitle();
   void labelFontList(XmFontList);
   XmFontList labelFontList();
   void marginHeight(Dimension);
   Dimension marginHeight();
   void marginWidth(Dimension);
   Dimension marginWidth();
   void noResize(Boolean);
   Boolean noResize();
   void resizePolicy(unsigned char);
   unsigned char resizePolicy();
   void shadowType(unsigned char);
   unsigned char shadowType();
   void textFontList(XmFontList);
   XmFontList textFontList();

};

class BulletinBoard : public BulletinBoardClass {
 public:
   BulletinBoard(Widget p, ArgList arglist = NULL, Cardinal cnt = 0); 
};

#endif
