/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* AppContext.h,v 1.8 1994/10/27 23:25:05 pgw Exp */

#if !defined(_APPCONTEXT_H_)
#define _APPCONTEXT_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Shell.h>

/*
*  Author's note:  Although it is not stated (to my knowledge), the
*  AppContext inherits from the toplevelShellWidget sort of.  
*/
class AppContextClass : public TopLevelShellClass {
 private:
   XtAppContext app_context;
 protected:
   void appContext(XtAppContext ac) { app_context = ac; }
   AppContextClass() {}
 public:
   void addActions(XtActionList actions, Cardinal no);
   void addConverter(String from_type, String to_type, XtConverter converter,
                     XtConvertArgList convert_args, Cardinal no_args);
   XtInputId addInput(int source,XtPointer condition, XtInputCallbackProc proc,
                      XtPointer client_data);
   XtIntervalId addTimeOut(unsigned long interval, XtTimerCallbackProc proc, 
                           XtPointer client_data);
   XtWorkProcId addWorkProc(XtWorkProc proc, XtPointer client_data);
   Boolean dispatchEvent(XEvent *event);
   void error(String msg);
   void errorMsg(String name, String type, String _class, String _default,
                 String *params, Cardinal *no);
   XrmDatabase *getErrorDatabase();
   void getErrorDatabaseText(char *name, char *type, char *_class,
                             char *_default, char *buffer_return, int nbytes, 
                             XrmDatabase database);
   unsigned long getSelectionTimeout();
   void mainLoop();
   void nextEvent(XEvent * event_return);
   void processEvent(XtInputMask mask); 
   Boolean peekEvent(XEvent * event_return);
   XtInputMask pending();
   
   void removeInput(XtInputId id);
   void removeTimeOut(XtIntervalId timer);
   void removeWorkProc(XtWorkProcId id);
   void setErrorHandler(XtErrorHandler handler);
   void setErrorMsgHandler(XtErrorMsgHandler handler);
   void setSelectionTimeout(unsigned long timeout);
   void setWarningHandler(XtErrorHandler handler);
   void setWarningMsgHandler(XtErrorMsgHandler handler);
   void warning(String msg);
   void warningMsg(String name, String type, String _class, String _default,
                   String *params, Cardinal *no);
   
   /* extras */
   XtAppContext appContext() { return app_context; }
   operator XtAppContext(); // auto cast self to XtApp 
   void quit();
};

class AppContext : public AppContextClass {
 public:
   AppContext(char *app_class,XrmOptionDescList options, Cardinal no, 
              int argc, char **argv);
};



#endif
