/* main.C,v 1.2 1994/11/20 08:32:14 pgw Exp */
/*
 * Copyright (c) 1994, Jettero Heller
 * 
 * You may distribute this source code under the terms of the license
 * in the COPYING file.
 * 
 */

/* Include(s) */
#include <string.h>
#include <stdlib.h>
#include <Xarm/AppContext.h>
#include <Xarm/PushB.h>
#include <Xarm/MessageB.h>

/* Declaration(s) */
class Application: public AppContext
{
 private:
   static void exit(Widget,XtPointer,XtPointer);
  
 public:
   Application(char *app_class,int argc, char **argv);
};

char *basename(char *name)
{
   char *s;

   if((s=strrchr(name,'/'))!=NULL)
   {
      s++;
   }
   else
   {
      s = name;
   }	
   return s;
}

int
main (int argc, char **argv)
{
   // initialize application 
   Application app(basename(argv[0]),argc,argv);

   // realize application
   app.realize();

   // start the main loop 
   app.mainLoop();

   // exit code just in case we get here.
   exit(EXIT_SUCCESS);
   return EXIT_SUCCESS;  /* SOME compilers like a return statement */
}

Application::Application(char *app_class, int argc, char **argv) :
   AppContext(app_class, NULL, 0, argc, argv)
{

   // install window manager message handler(s)
   deleteWindowCallback(exit, NULL);

   title(app_class);

   // install window(s) into the application window 
   PushButton *button = new PushButton(*this, "Press Me");
   button->autoSpace();
}

void
exitOk(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;

   ((Application *) udata)->quit();
}

void 
Application::exit(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;

   QuestionDialog *diag = new QuestionDialog(w,"Do you really want to quit?");
   diag->okCallback(exitOk, udata);
   diag->dialogTitle("Exit Dialog");
   diag->manage();
}

