#include "vector.h"

static void default_error(s)
	char *s;
	{
	fprintf(stderr,"Vector error: %s\n",s);
	exit(-1);
	}

static void (*error)()=default_error;

void vector_error(fn)
	void  (*fn)();
	{
	error=fn;
	}

void vector_default()
	{
	error=default_error;
	}

vector new_vector(size)
	int size;
	{
	vector v;
	int i;

	if(size<0) error("Bad size");
	v=(vector)malloc(sizeof(struct VECTOR));
	if(v==NULL) error("Allocation error");
	v->v=(char**)calloc(size,sizeof(char*));
	if(v->v==NULL) error("Allocation error");
	v->sz=size;
	for(i=0;i<size;i++)
		v->v[i]=NULL;
	v->curr=0;
	return(v);
	}

vector vector_copy(v,copy_elem)
	vector v;
	char *(*copy_elem)();
	{
	vector nv;
	int i;

	nv=new_vector(v->sz);
	nv->curr=v->curr;
	for(i=0;i<v->curr;i++)
		if(v->v[i]!=NULL)
			nv->v[i]=copy_elem(v->v[i]);
	return(nv);
	}

void vector_insert(v,datum)
	vector v;
	char *datum;
	{
	if(v->curr==v->sz) error("Vector full");
	v->v[v->curr++]=datum;
	}

int vector_num(v)
	vector v;
	{
	return(v->curr);
	}

int vector_search(v,datum,cmp)
	vector v;
	char *datum;
	int (*cmp)();
	{
	int i;
	
	for(i=0;i<v->curr;i++)
		if(v->v[i]!=NULL)
			if(cmp(datum,v->v[i])==0)
				{
				return(i);
				}
	return(-1);
	}

void vector_delete(v,datum,cmp,free_elem)
	vector v;
	char *datum;
	int (*cmp)();
	void (*free_elem)();
	{
	int pos,i;

	pos=vector_search(v,datum,cmp);
	if(pos==-1) return;
	free_elem(v->v[pos]);
	for(i=pos+1;i<v->curr;i++)
		v->v[i-1]=v->v[i];
	v->curr--;	
	}

void vector_replace(v,datum,cmp,free_elem)
	vector v;
	char *datum;
	int (*cmp)();
	void (*free_elem)();
	{
	int pos;

	pos=vector_search(v,datum,cmp);
	if(pos!=-1)
		{
		free_elem(v->v[pos]);
		v->v[pos]=datum;
		}
	else
		vector_insert(v,datum);
	}


char *vector_read(v,i)
	vector v;
	int i;
	{
	if(i<0 || i>=v->curr) error("Out of range");
	return(v->v[i]);
	}

void vector_put(v,f,put_elem)
	vector v;
	FILE *f;
	void (*put_elem)();
	{
	int i;

	fprintf(f,"%08d\n",v->curr);
	for(i=0;i<v->curr;i++)
		if(v->v[i]!=NULL)
			put_elem(v->v[i],f);
	}

vector vector_get(f,get_elem)
	FILE *f;
	char *(*get_elem)();
	{
	vector v;
	int i,size,dummy;

	if(fscanf(f,"%8d",&size)!=1) error("Bad vector read from file");
	v=new_vector(size);
	for(i=0;i<v->sz;i++)
		v->v[i]=get_elem(f);
	v->curr=v->sz;
	return(v);
	}

void vector_free(v,free_elem)
	vector v;
	void (*free_elem)();
	{
	int i;

	for(i=0;i<v->curr;i++)
		if(v->v[i]!=NULL)
			free_elem(v->v[i]);
	free(v);
	}

int vector_loopover(v,f,param)
	vector v;
	int (*f)();
	char *param;
	{
	int i;
	int done;

	for(i=0,done=0;(i<v->curr)&&(!done);i++)
		if(v->v[i]!=NULL)
			done=f(v->v[i],param);
	if(done) return(i-1);
	else return(-1);
	}

void vector_traverse(v,f,param)
	vector v;
	void (*f)();
	char *param;
	{
	int i;

	for(i=0;i<v->curr;i++)
		if(v->v[i]!=NULL)
			f(v->v[i],param);
	}
