#include "scanner.h"

extern FILE *hdf;
extern vector pagev;
extern int currpage;
extern Window canvas_win;
extern int nofile;

static long pos;
static char *pageptr=NULL;

static void corrupted(s)
	char *s;
	{	
	free_resources();
	xverror("Sorry, file corrupted...recompile it");
	}

static void photword(index)
	long *index;
	{
	int action,c,i;
	long len;
	char *param;

	action=pageptr[pos++];
	if(sscanf(pageptr+pos,NUMFORMAT,&len)!=1)
		corrupted("no action length");
	pos+=NUMLEN;
	*index+=len+NUMLEN+1;
	param=(char*)malloc(len+1);
	if(param==NULL) corrupted("Allocation error");
	for(i=0;i<len;i++)
		param[i]=pageptr[pos++];
	param[len]='\0';
 
	start(COMHOT,action,param);

	free(param);
	if(sscanf(pageptr+pos,NUMFORMAT,&len)!=1)
		corrupted("no hotword length");
	pos+=NUMLEN;	
	*index+=len+NUMLEN+1;
	for(;len>0;len--)
		writechar(pageptr[pos++]);

	start(COMTEXT,0);
	}

static void ptext()
	{
	long len,i;
	int c;

	if(sscanf(pageptr+pos,NUMFORMAT,&len)!=1)
		corrupted("no text length");
	pos+=NUMLEN;
	start(COMTEXT,0);
	for(i=0;i<len;i++)
		{
		c=pageptr[pos++];
		if(c==ESCAPE)
			{
			if(pageptr[pos++]==COMHOT)
				photword(&i);
			else
				corrupted("bad escape sequence");
			}
		else
			writechar(c);
		}
	writechar('\n');
	}

static void psubtitle()
	{
	int c;
	long len;

	if(sscanf(pageptr+pos,NUMFORMAT,&len)!=1)
		corrupted("no subtitle length");
	pos+=NUMLEN;
	start(COMSUB,0);
	for(;len>0;len--)
		writechar(pageptr[pos++]);
	writechar('\n');
	}

static void psource()
	{
	int c;
	long len;

	if(sscanf(pageptr+pos,NUMFORMAT,&len)!=1)
		corrupted("no source length");
	pos+=NUMLEN;
	start(COMSOURCE,0);
	for(;len>0;len--)
		writechar(pageptr[pos++]);
	writechar('\n');
	}

static void ptitle()
	{
	int c;
	long len;

	if(sscanf(pageptr+pos,NUMFORMAT,&len)!=1)
		 corrupted("no title length");
	pos+=NUMLEN;
	start(COMTITLE,0);
	for(;len>0;len--)
		writechar(pageptr[pos++]);
	writechar('\n');
	}

static void ppage()
	{
	int done;

	for(done=0;!done;)
		{
		switch(pageptr[pos++])
			{
			case COMTEXT:
				ptext();
				break;
			case COMSOURCE:
				psource();
				break;
			case COMSUB:
				psubtitle();
				break;
			case COMTITLE:
				ptitle();
				break;
			case COMENDPAGE:
				done=1;
				break;
			default:
				corrupted("unknown command");
				break;
			}
		}
	}

void display_page()
	{
	if(nofile) return;
	pos=0;
	start_viewer(canvas_win);
	ppage();
	end_viewer();
	}

void read_page()
	{
	long lungh;
	int c,i;

	if(nofile) return;
	fseek(hdf,page_pos(vector_read(pagev,currpage)),0);
	fscanf(hdf,NUMFORMAT,&lungh);
	pageptr=(char *)malloc(lungh+1);
	if(pageptr==NULL)
		xverror("Allocation Error");
	for(i=0;i<lungh;i++)
		{
		c=fgetc(hdf);
		if(c==EOF) xverror("Unexpected End Of File");
		pageptr[i]=c;
		}
	pageptr[lungh]='\0';
	}

void discard_page()
	{
	if(nofile) return;
	free(pageptr);
	}
