#include "lex.h"

static int idx=0;
token_type curr_tok;
char tok_value[BIGNUMBER];

extern FILE *hlpfile;
extern char *hlpname;
extern long line_cnt;
extern int warnings;

static void error(s)
	char *s;
	{
	fprintf(stderr,"\nLexical error \"%s\" in file %s near line %ld\n",
		s,hlpname,line_cnt);
	exit(-1);
	}

static void command()
	{
	int i;

	for(i=0;i<TOKEN;i++)
		if(strcmp(tkn[i],tok_value)==0)
			{
			curr_tok=i;
			return;
			}
	error("Unknown symbol");
	}

static void escape()
	{
	int c,ill_esc;

	c=getchr(hlpfile);
	switch(c)
		{
		case '\\':
		case '\"':
			tok_value[idx++]=c;
			break;
		case 'n':
			tok_value[idx++]='\n';
			break;
		case '\n':
			ill_esc=0;
			c=getchr(hlpfile);
			while(c!='\\')
				{
				if(!isspace(c) && !ill_esc)
					{
					ill_esc=1;
					fprintf(stderr,
		"\nWarning: Illegal character skipped in escape sequence!\n");
					warnings++;
					}
				c=getchr(hlpfile);
				}
			 break;
		default:
			error("Wrong escape sequence");
			break;
		}
	}

token_type get_token()
	{
	int c,done;

	while(isspace(c=getchr(hlpfile)));
	switch(c)
		{
		case '\"':
			idx=0;
			c=getchr(hlpfile);
			while((c!='\"')&&(idx<BIGNUMBER))
				{
				if(c=='\\') escape();
				else if(c==EOF) error("Unexpected EOF");
				else tok_value[idx++]=c;
				c=getchr(hlpfile);
				}
			if(idx==BIGNUMBER) error("String too large");
			tok_value[idx]='\0';
			curr_tok=STRING;
			break;
		case ';':
			curr_tok=END;
			break;
		case ',':
			curr_tok=SEP;
			break;
		case EOF:
			curr_tok=END_FILE;
			break;
		default:
			idx=0;
			done=0;
			while((!isspace(c))&&(idx<BIGNUMBER)&&(!done))
				{
				switch(c)
					{
					case EOF:
					case '\"':
					case ',':
					case ';':
						ungetchr(hlpfile,c);
						done=1;
						break;
					default:
						tok_value[idx++]=c;
						c=getchr(hlpfile);
						break;
					}
				}
			if(idx==BIGNUMBER)
					error("Symbol too large");
			tok_value[idx]='\0';
			command();
			break;
		}
	fprintf(stderr,"\rNow compiling line: %6ld",line_cnt);
	return(curr_tok);
	}
