#include "hotword.h"

#define sign(x) ((x>=0)?((x==0)?0:1):-1)

static void default_error(mess)
	char *mess;
	{
	fprintf(stderr,"Hotword error: %s\n",mess);
	exit(-1);
	}

static void (*error)()=default_error;

void hotword_error(fn)
	void  (*fn)();
	{
	error=fn;
	}

void hotword_default()
	{
	error=default_error;
	}


hotw new_hotw(name,action,param)
	char *name;
	int action;
	char *param;
	{
	hotw h;

	h=(hotw)malloc(sizeof(struct HOTWORD));
	if(h==NULL) error("Allocation error");
	h->name=(char*)malloc(strlen(name)+1);
	if(h->name==NULL) error("Allocation error");
	h->param=(char*)malloc(strlen(param)+1);
	if(h->param==NULL) error("Allocation error");
	collapse(strupr(strcpy(h->name,name)));
	h->action=action;
	collapse(strcpy(h->param,param));
	return(h);
	}

char *hotw_name(h)
	hotw h;
	{
	return(h->name);
	}

hotw hotw_copy(h)
	hotw h;
	{
	hotw nh;

	nh=new_hotw(h->name,h->action,h->param);
	return(nh);
	}

int hotw_cmp(left,right)
	hotw left,right;
	{
	int result;

	result=strcmp(left->name,right->name);
	return(sign(result));
	}

void hotw_free(h)
	hotw h;
	{
	free(h->name);
	free(h->param);
	free(h);
	}

char *hotw_strput(h)
	hotw h;
	{
	char *p;

	p=(char*)malloc(strlen(h->name)+strlen(h->param)+NUMLEN*2+4);
	if(p==NULL) error("Allocation error");
	sprintf(p,"%c%c%c",ESCAPE,COMHOT,h->action);
	sprintf(p+3,NUMFORMAT,(long)strlen(h->param));
	sprintf(p+3+NUMLEN,"%s",h->param);
	sprintf(p+3+NUMLEN+strlen(h->param),NUMFORMAT,(long)strlen(h->name));
	sprintf(p+3+NUMLEN*2+strlen(h->param),"%s",h->name);
	return(p);
	}

void hotw_put(h,f)
	hotw h;
	FILE *f;
	{
	char *p;

	fprintf(f,"%c%c%c",ESCAPE,COMHOT,h->action);
	fprintf(f,NUMFORMAT,(long)strlen(h->param));
	fprintf(f,"%s",h->param);
	fprintf(f,NUMFORMAT,(long)strlen(h->name));
	fprintf(f,"%s",h->name);
	}

 
static char *del_hotw(str)
	char *str;
	{
	char *pos,def[3];
	int i;
	long len;

	pos=str;
	def[0]=ESCAPE;
	def[1]=COMHOT;
	def[2]='\0';
	while((pos=strstr(pos,def))!=NULL)
		{
		sscanf(pos+3,NUMFORMAT,&len);
		for(i=0;i<len+3+NUMLEN;i++)
			*(pos+i)='$';
		pos+=len+3+NUMLEN;
		sscanf(pos,NUMFORMAT,&len);
		for(i=0;i<len+NUMLEN;i++)
			*(pos+i)='$';
		pos+=len+NUMLEN;
		}
	return(str);
	}
		
		
	
void hotw_subst(h,text)
	hotw h;
	char *text;
	{
	char *uprtext,*start,*pos;
	char *textcopy,*hotwstring;
	int offset,delta,increment,i,namelen;
	char first,last;

	delta=0;
	collapse(text);
	namelen=strlen(h->name);
	hotwstring=hotw_strput(h);
	increment=strlen(hotwstring)-namelen;
	pos=hotwstring+3+NUMLEN*2+strlen(h->param);
	textcopy=(char*)malloc(strlen(text)+1);
	if(textcopy==NULL) error("Allocation error");
	strcpy(textcopy,text);
	uprtext=(char*)malloc(strlen(text)+1);
	if(uprtext==NULL) error("Allocation error");
	start=del_hotw(strupr(strcpy(uprtext,text))); 
	while((start=strstr(start,h->name))!=NULL)      
		{               
		if(start!=uprtext)
			{
			first=*(start-1);
			if(!ispunct(first) && !isspace(first))
				{
				start++;
				continue;
                                }
			}
		last=*(start+namelen);
		if(last!='\0')
			{
			if(!ispunct(last) && !isspace(last))
			        {
                                start++;
				continue;
				}
			}
		offset=(start-uprtext);
		for(i=0;i<namelen;i++)
			pos[i]=(textcopy+offset)[i];
		sprintf(text+offset+delta,"%s%s",
			hotwstring,textcopy+offset+namelen);
		for(i=0;i<namelen;i++)
			pos[i]=toupper(pos[i]);
		start+=namelen;
		delta+=increment;
		}
	free(uprtext);
	free(textcopy);
	free(hotwstring);
	}
