-- ---------------------------------------------------------------------------
-- Toi
-- ---------------------------------------------------------------------------
-- 
-- ToiString.cs -- realizes my own string type
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- Author          : Lutz Hilken
-- 
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 
-- DOCUMENTS
-- 	|>Related documents<|
-- ---------------------------------------------------------------------------
-- 
-- Created On      : Thu Feb 17 14:00:55 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Fri Feb 18 15:14:42 1994
-- Update Count    : 5
-- 
-- HISTORY
-- ---------------------------------------------------------------------------
-- 

SPECIFICATION ToiString

PROCEDURE get_pos_of_str2_in_str1 (IN  str1      : STRING, 
				   IN  str2      : STRING, 
				   OUT start_pos : INT, 
				   OUT end_pos   : INT) : BOOL;

---------------------------------------------------------------------

PROCEDURE get_pos_of_str2_in_str1_from_pos (IN  str1      : STRING, 
					    IN  str2      : STRING, 
					    OUT start_pos : INT, 
					    OUT end_pos   : INT,
					    IN  start     : INT) : BOOL;

----------------------------------------------------------------------

PROCEDURE change_name (IN  name1  : STRING, 
		       OUT name2  : STRING, 
		       IN  delim1 : STRING, 
		       IN  delim2 : STRING);

----------------------------------------------------------------------

PROCEDURE change_name_at_pos (IN  name1  : STRING, 
			      OUT name2  : STRING, 
			      IN  delim1 : STRING, 
			      IN  delim2 : STRING,
			      IN  start  : INT);

----------------------------------------------------------------------

PROCEDURE IsWhiteSpace (IN c : CHAR) : BOOL;
  
----------------------------------------------------------------------

PROCEDURE cool_skip_leading_blanks (INOUT str : STRING);

----------------------------------------------------------------------

PROCEDURE cool_skip_trailing_blanks (INOUT str : STRING);

----------------------------------------------------------------------

PROCEDURE split_string (IN  base : STRING, 
			OUT left : STRING, 
			OUT right : STRING);

----------------------------------------------------------------------

PROCEDURE split_string_at_delimiter (IN  base      : STRING, 
				     OUT left      : STRING, 
				     OUT right     : STRING,
				     IN  delimiter : CHAR);

--------------------------------------------------------------------------

PROCEDURE compare_start_of_strings  (IN s1 : STRING,
				     IN s2 : STRING) : BOOL;
--------------------------------------------------------------------------

PROCEDURE isPositivInteger (IN s : STRING) : BOOL;

--------------------------------------------------------------------------

PROCEDURE isInteger (IN s : STRING) : BOOL;


END SPECIFICATION;
