-- ***************************************************************
-- SOI
-- ---------------------------------------------------------------
--
-- SoiBasics.cs -- Low Level Functions of SOI
-- 
--   Copyright (C) sietec Systemtechnik GmbH & Co OHG 1994
--   All rights reserved
-- 
-- Author          : Torsten Dumm
-- 
-- REFER
--      |>Documents with client documentation<|
--
-- ---------------------------------------------------------------
--
-- Created On      : Wed Feb 09 18:52:43 1994
-- Last Modified By: Karl-Heinz Koester
-- Last Modified On: Fri Feb 25 17:50:43 1994
-- Update Count    : 4
-- 
-- ***************************************************************

SPECIFICATION SoiBasics

--
-- from stdlib.t
--
FOREIGN PROCEDURE malloc (IN size : INT
			  ) : ADDRESS;         -- SqlChar, SqlDate, SqlInterval

FOREIGN PROCEDURE free  (IN ptr : ADDRESS);    -- SqlChar, SqlDate, SqlInterval

FOREIGN PROCEDURE atoi (IN str : REF ARRAY OF CHAR
			) : INT;               -- SqlDate, SqlInterval

--
-- from string.t
--
FOREIGN PROCEDURE strcat (IN s1 : REF ARRAY OF CHAR,
			  IN s2 : REF ARRAY OF CHAR
			  ) : REF ARRAY OF CHAR;        -- SqlInterval

FOREIGN PROCEDURE strtok (IN s1 : REF ARRAY OF CHAR,
			  IN s2 : REF ARRAY OF CHAR
			  ) : REF ARRAY OF CHAR;        -- SqlDate, SqlInterval

FOREIGN PROCEDURE strcspn (IN s1 : REF ARRAY OF CHAR,
			   IN s2 : REF ARRAY OF CHAR
			   ) : INT;                     -- SqlDecimal

FOREIGN PROCEDURE strlen (IN s : REF ARRAY OF CHAR
			  ) : INT;                      -- SqlInterval

FOREIGN PROCEDURE strcpy (IN s1 : REF ARRAY OF CHAR,
			  IN s2 : REF ARRAY OF CHAR
			  ) :  REF ARRAY OF CHAR;       -- SqlChar

--
-- from stdio.t
-- 
FOREIGN PROCEDURE sprintf (IN s      : REF ARRAY OF CHAR,
			   IN format : REF ARRAY OF CHAR,
			   .. 
			   ) : INT;                     -- SqlDate, SqlInterval

--
-- from String.t
--
CONST NullChar             : CHAR = '\0';	 
CONST Blank                : CHAR = ' ' ;

--
-- selfdefined
--
CONST TEMP_C_STRING_LENGTH : INT  = 256;

TYPE TempCString = ARRAY [TEMP_C_STRING_LENGTH] OF CHAR;

-- ***************************************************************
CONST spec_vid : STRING = 
   "@(#) $__Header$" ;

END SPECIFICATION (* SoiBasics *);

