/***************************************************************************/
/*                   MY_STAB.C - SQLGEN-symbol table                       */
/*-------------------------------------------------------------------------*/
/*      Copyright (C) Siemens Nixdorf Informationssysteme AG 1992          */
/*      All rights reserved                                                */
/***************************************************************************/

# include "sql_defs.h"

static char sccsid[] = "@(#) sql_stab.c 1.0 1992-12-03";

int Level = 0;

/*--- HASH ----------------------------------------------------------------*/

       /*
          The hash function works with an open hash table. The hash table
          consists of a list of hash vectors. Every hash vector has HASHINC
          elements. The maximal count of used entries in the hash vector 
          is 75 percent. If a hash vector can not take in further identifiers
          a new hash vector is built. In the hash function a hash vector is
          named as niveau. The count of these niveaus is only limited by the
          resources of the used operating system.
          The hash function itself is a square function which has the following
          form: hash(n) = hash(n-1) ** 2 + value(actual_character)
          If all characters are computed a modulo division is used to 
          calculate the hash index into the first hash vector (first niveau).
          If the entry in the hash vector is already used by another
          identifier it is searched a next free entry using a square distance
          function. If in the current niveau can not be find a free entry
          then the next niveau is used to store the identifier. If a niveau
          change takes place this is saved into the resulting hash code of
          the identifier.
       */

static HASH_TABLE *Hash_Table_Pointer = NULL;
static HASH_TABLE **Pointer_to_Hash_Table_Pointer = &Hash_Table_Pointer;

# define HASHINC 1013

int hash( Symbol, Length )
char *Symbol;
int Length;
{
    long count;
    int niveau;
    int return_count;
    char *Pointer_for_Symbol;
    HASH_TABLE *Temp_Pointer;
    HASHENTRY *Index_Pointer;

    Pointer_for_Symbol = Symbol;
    count = 0;
    while( *Pointer_for_Symbol )
    count = (count << 1) + *Pointer_for_Symbol++;
    count = (count & 077777L) % HASHINC;

    niveau = -1;
    for (Temp_Pointer = Hash_Table_Pointer;;
           Temp_Pointer = Temp_Pointer->next)
        {
        niveau++;
        if ( Temp_Pointer == NULL )
            {
            *Pointer_to_Hash_Table_Pointer = Get_Hash_Table();
            Temp_Pointer = *Pointer_to_Hash_Table_Pointer;
            Pointer_to_Hash_Table_Pointer = &(Temp_Pointer->next);
            Temp_Pointer->hash_Table_low = 
                            Get_Hashentries( HASHINC * sizeof( HASHENTRY ) );
            Temp_Pointer->hash_Table_high =
            Temp_Pointer->hash_Table_low + HASHINC;
            }
        Index_Pointer = Temp_Pointer->hash_Table_low + count;
        return_count = count;

        count = 1;
        do
            {
            if ( Index_Pointer->symbol == NULL )
                {
                if ( Temp_Pointer->used_Entries > (HASHINC * 3) / 4 )
                    break;
                Temp_Pointer->used_Entries++;
                Index_Pointer->symbol = save_string( Symbol, Length );
                Index_Pointer->stab = STAB_NULL;
                return( return_count + HASHINC * niveau );
                }
            if ( *(Index_Pointer->symbol) == *Symbol &&
                    strcmp( Index_Pointer->symbol, Symbol ) == 0 )
                return( return_count + HASHINC * niveau );

            Index_Pointer += count;
              return_count += count;
            count += 2;
            if ( Index_Pointer >= Temp_Pointer->hash_Table_high )
                {
                Index_Pointer -= HASHINC;
                return_count -= HASHINC;
                }
             } while ( count < HASHINC );
        }
}

/*---- GET_SYMBOL ---------------------------------------------------------*/

char *get_symbol( Hashindex )
int Hashindex;
{
    int niveau;
    HASH_TABLE *Pointer_to_Hash_Table;

    niveau = Hashindex / HASHINC;
    for ( Pointer_to_Hash_Table = Hash_Table_Pointer; niveau--;
            Pointer_to_Hash_Table = Pointer_to_Hash_Table->next );
    return(Pointer_to_Hash_Table->hash_Table_low[Hashindex % HASHINC].symbol);
}

/*---- INSERT_STAB ---------------------------------------------------------*/

void insert_stab( Hashindex, Stab )
int Hashindex;
TSTAB *Stab;
{
    int niveau;
    HASH_TABLE *Pointer_to_Hash_Table;

    niveau = Hashindex / HASHINC;
    for ( Pointer_to_Hash_Table = Hash_Table_Pointer; niveau--;
            Pointer_to_Hash_Table = Pointer_to_Hash_Table->next );
    Stab->other = 
           Pointer_to_Hash_Table->hash_Table_low[Hashindex % HASHINC].stab;
    Pointer_to_Hash_Table->hash_Table_low[Hashindex % HASHINC].stab = Stab;
}

/*---- DELETE_STAB ---------------------------------------------------------*/

void delete_stab( Hashindex )
int Hashindex;
{
    int niveau;
    HASH_TABLE *Pointer_to_Hash_Table;

    niveau = Hashindex / HASHINC;
    for ( Pointer_to_Hash_Table = Hash_Table_Pointer; niveau--;
            Pointer_to_Hash_Table = Pointer_to_Hash_Table->next );
    Pointer_to_Hash_Table->hash_Table_low[Hashindex % HASHINC].stab =
        Pointer_to_Hash_Table->hash_Table_low[Hashindex % HASHINC].stab->other;
}

/*---- GET_STAB -----------------------------------------------------------*/

TSTAB *get_stab( Hashindex )
int Hashindex;
{
    int niveau;
    HASH_TABLE *Pointer_to_Hash_Table;

    niveau = Hashindex / HASHINC;
    for ( Pointer_to_Hash_Table = Hash_Table_Pointer; niveau--;
            Pointer_to_Hash_Table = Pointer_to_Hash_Table->next );
    return(Pointer_to_Hash_Table->hash_Table_low[Hashindex % HASHINC].stab);
}

/*---- SAVE_STRING --------------------------------------------------------*/

# define NSAVE_STRING 2048

static char *Free_String_Memory = (char *)0;
static int Free_String_Space_Counter = 0;

char *save_string( String, Length )
char *String;
int Length;
{
    int String_length;
    char * Destination;

    String_length = Length + 1;
    if ( String_length > Free_String_Space_Counter )
        {
        Free_String_Space_Counter = NSAVE_STRING;
        if ( String_length > Free_String_Space_Counter )
            Free_String_Space_Counter = String_length;
        Free_String_Memory = Get_String_Space( Free_String_Space_Counter );
        }
    Destination = Free_String_Memory;
    while( --String_length )
        {
        *(Free_String_Memory++) = *String++;
        Free_String_Space_Counter--;
        }
    *(Free_String_Memory++) = '\0';
    Free_String_Space_Counter--;
    return( Destination );
}


       /* Here the symbol table operations begin */

/*---- LOOKUP_ENTRY -------------------------------------------------------*/

TSTAB *lookup_Entry( Hashindex, Symbol_Space )
int Hashindex;
KIND_STAB Symbol_Space;
{
  TSTAB *Current_Stab;

  Current_Stab = get_stab( Hashindex );
  while ( Current_Stab != STAB_NULL && Current_Stab->Kind != Symbol_Space)  
    Current_Stab = Current_Stab->other;
  return Current_Stab;
}

/*---- INSERT_ENTRY -------------------------------------------------------*/

int Stab_Entries = 0;
struct stab *Last_Entry = STAB_NULL;

TSTAB *insert_Entry( Hashindex )
int Hashindex;
{
    TSTAB *Pointer_to_item;

    Pointer_to_item = Get_Stab_Item();
    Pointer_to_item->Hashindex = Hashindex;
    Pointer_to_item->Value = 0;
    Pointer_to_item->Kind = S_UNKNOWN;
    Pointer_to_item->level = Level;
    insert_stab( Hashindex, Pointer_to_item );
    return( Pointer_to_item );
}    

/*---- DELETE_LEVEL -------------------------------------------------------*/

void delete_Level( Current_Level )
int Current_Level;
{
  TSTAB *Current_Item;
  int Hashindex;

  while( Last_Entry != STAB_NULL && Last_Entry->level == Current_Level )
    {
      Current_Item = Last_Entry;
      Hashindex = Current_Item->Hashindex;
      Last_Entry = Last_Entry->next_entry;
      delete_stab( Hashindex );
      Free_Stab_Item( Current_Item );
    }
}

/*---- PRINT_STAB ---------------------------------------------------------*/

void print_stab()
{
    TSTAB *Stab;

    printf( "\nContents of Symboltable:\n" );
    for ( Stab = Last_Entry; Stab != STAB_NULL; Stab = Stab->next_entry )
        printf( "%s, %s, %d\n", get_symbol( Stab->Hashindex ),
            (Stab->Kind == S_HOSTVARIABLE) ? ("host variable"):("constant"),
		    Stab->Value );
}

