/*****************************************************************************/
/*                rtsinc.h - C-runtime structures for CooLV2.0               */
/*                         DO NOT EDIT THIS FILE!                            */
/*****************************************************************************/
#ifndef C3IC3IC3IC3Irts
#define C3IC3IC3IC3Irts

/* ---- definitions for builtin types -------------------------------------- */

typedef enum C3IBOOL 
    { 
    C3IFALSE = 0, 
    C3ITRUE = 1 
    } C3IBOOL;

typedef struct C3IC3IMEM_BLOCK_DESCR
    {
    void * IVRS;
    void * MTABR;
    char * MemoryBlock;
    int Size;
    } C3IC3IMEM_BLOCK_DESCR;

#define C3IC3IMaxStringLength 255
typedef struct C3ISTRING
    {
    char Value [C3IC3IMaxStringLength+1];
    } C3ISTRING;

typedef void * C3IADDRESS;

typedef enum C3IENUM 
    { 
    C3IC3IDUMMY 
    } C3IENUM;

/* ---- method pointer type ------------------------------------------------ */

typedef struct C3IC3IOBJECT
    {
    void *C3IIVR;
    void *C3IMTABR;
    } * C3IC3IOBJECT;

typedef struct C3IMETHOD
    {
    C3IC3IOBJECT C3IOBJECT;
    void       (*C3IMETHOD)( void);
    } C3IMETHOD;

/* ---- generic type ------------------------------------------------------- */

typedef char * C3IC3ITYPENAME;

typedef struct C3IC3ITYPE
    {
    C3IC3ITYPENAME C3IName;
    } C3IC3ITYPE;

typedef struct C3IC3IGENERIC
    {
    void *C3IIVR;
    void *C3IMTABR;
    } * C3IC3IGENERIC;

/* ---- definitions for method pointer handling (rtsmtp.c) ----------------- */

extern C3IMETHOD C3IC3INIL;

C3IMETHOD C3IC3IBuildMethodPointer (void *, void (*)(void));

/* ---- definitions for builtin exception handling (rtsexc.c) -------------- */

# include <setjmp.h> 

extern jmp_buf C3IC3ICurrExceptBuf;
extern void *C3IC3ICurrExcept;
extern int C3IC3IExceptLevel;

void C3IC3IRAISE (void);
void C3IC3ISetCurrentExceptionHandler (jmp_buf);
void C3IC3IRestorePrevExceptionHandler (jmp_buf);

/* ---- definitions for typeselect handling (rtstsl.c) --------------------- */

int C3IC3IIsDynamicSubtypeOf (void *, void *);

/* ---- definitions for memory handling (rtsmem.c) ------------------------- */

void C3IC3IMemCpy (void *, void *, int);

C3IBOOL C3IC3IEqual (void *, void *, int);

C3IBOOL C3IC3INotEqual (void *, void *, int);

/* ---- definitions for object allocation (rtsalloc.c) --------------------- */

C3IC3IMEM_BLOCK_DESCR * C3IC3INEW (int Size, void * MTABR);

void C3IC3IDELETE (C3IC3IMEM_BLOCK_DESCR * Candidate);

/* ---- definitions for string handling (rtsstr.c) ------------------------- */

  /* boolean operators */

C3IBOOL C3IC3IEqualString        (C3ISTRING S1, C3ISTRING S2);
C3IBOOL C3IC3INotEqualString     (C3ISTRING S1, C3ISTRING S2);
C3IBOOL C3IC3IGreaterEqualString (C3ISTRING S1, C3ISTRING S2);	
C3IBOOL C3IC3ILessString         (C3ISTRING S1, C3ISTRING S2);	
C3IBOOL C3IC3ILessEqualString    (C3ISTRING S1, C3ISTRING S2);	

  /* [Index], [Lwb..Upb] on right side */

char C3IC3ICharAtIndex    (C3ISTRING S, int Index);
C3ISTRING C3IC3ISubString (C3ISTRING S, int Lwb, int Upb);

  /* [Index], [Lwb..Upb] on left side */

void C3IC3IReplaceSubString (C3ISTRING *S, int Lwb, int Upb, 
			     C3ISTRING Replacement);
void C3IC3IReplaceChar (C3ISTRING * S, int Index, char C);

  /* string assignments */

void C3IC3ICopyString           (C3ISTRING * Dest, C3ISTRING Src);
C3ISTRING C3IC3IInitWithRefChar (char (*CString)[]);
void C3IC3IInitWithChar         (C3ISTRING *S, char Char);

  /* string concatenation */

C3ISTRING C3IC3IConcatStrings (C3ISTRING S1, C3ISTRING S2);
C3ISTRING C3IC3IAppendChar    (C3ISTRING S, char C);
C3ISTRING C3IC3IPrependChar   (char C, C3ISTRING S);
C3ISTRING C3IC3IConcatChars   (char C1, char C2);

  /* misc */
int C3IC3ILengthOf (C3ISTRING * String);
char (*C3IC3IToRefArrayOfChar (C3ISTRING *S ))[];
void C3IC3IStrCpy (char * S, char * RefChar);

#include "CooL.h"

#endif /* C3IC3IC3IC3Irts */
