--                             -*- Mode: Cool2 -*- 
-- unixsymtab.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: unixsymtab.cs[1.0] Tue Feb 22 10:02:32 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 10:07:36 1994
-- Last Modified By: unknown full name
-- Last Modified On: Wed Jun 15 12:49:42 1994
-- Update Count    : 30
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION unixsymtab

IMPORT FixedString, size_t 
  FROM globals;
IMPORT File 
  FROM maxfile;
IMPORT MySet 
  FROM Bayer;
IMPORT String 
  FROM mystring;
IMPORT Function 
  FROM function;
IMPORT OBJECTType 
  FROM objecttype;
IMPORT StructuredType 
  FROM type;
IMPORT FILE 
  FROM Basics;

VAR c3iprefix        : FixedString;
VAR genericprefix    : FixedString;
VAR formaltypepre    : FixedString;
VAR mtabpre          : FixedString;
VAR instacevarspre   : FixedString;
VAR unnamedstructpre : FixedString;
VAR objectpre        : FixedString;
VAR addresspre       : FixedString;
VAR stringpre        : FixedString;
VAR boolpre          : FixedString;
VAR methodpre        : FixedString;
VAR newroutinepre    : FixedString;
VAR deleteroutinepre : FixedString;
VAR initiallypre     : FixedString;
VAR finallypre       : FixedString;
VAR moduleidentifier : FixedString;
VAR currentexception : FixedString;
VAR currentobject    : FixedString;

VAR info             : FileInfo;	 -- describes the layout of
					 -- the executable object file

VAR start_address       : INT;		 -- Base address of the memory
					 -- area, that contains the
					 -- .debug section
VAR debug_length        : INT;		 -- number of bytes of the
					 -- debug section

PROCEDURE init_unix_symtab_symbols;
  -- -----------------------------------------------------------------
  -- This procedure initializes symbol table specific identifiers. 
  -- Because of the prefix notation of the DWARF symbol table, this
  -- routine is empty here.
  -- -----------------------------------------------------------------

PROCEDURE get_act_pos : INT;

PROCEDURE create_function_list (IN  offset : UNSIGNED INT,
                                IN  limit  : UNSIGNED INT,
                                IN  file   : File,
                                OUT funcs  : MySet);
  -- -----------------------------------------------------------------
  -- This procedure creates the function list of the debugged process.
  -- -----------------------------------------------------------------

PROCEDURE search_unknown_func (IN  pc    : INT,
			       OUT start : INT, 
			       OUT end   : INT,
			       OUT func  : Function);
  
PROCEDURE posit_to_first_file (IN info : FileInfo);
  -- -----------------------------------------------------------------
  -- This procedure posits the symbol table pointer to the first file
  -- entry of the symbol table.
  -- -----------------------------------------------------------------

PROCEDURE read_file_entry (OUT file : File) : BOOL;
  -- -----------------------------------------------------------------
  -- This procedure interpretes the symbol table entires describing a
  -- source file. It expects the symbol table pointer standing on the
  -- tag entry of a source file description.
  -- It creates an object describing the source file.
  -- In case of an error a NIL object is returned.
  -- -----------------------------------------------------------------

PROCEDURE LoadStaticVariables (IN file : File);
  -- -----------------------------------------------------------------
  -- This procedure loads all static variables of the specified file.
  -- The problem is, that static variables are coded as local
  -- variables, so function descriptions must be skipped.
  -- -----------------------------------------------------------------

PROCEDURE LoadComponents (IN type : StructuredType);
  -- -----------------------------------------------------------------
  -- This procedure collecrs the components of a structure and stores
  -- them in a set.
  -- -----------------------------------------------------------------

PROCEDURE LoadInstanceVariables (IN otype : OBJECTType);
  -- -----------------------------------------------------------------
  -- This procedure loads the instrance variables of an Object Type
  -- description.
  -- -----------------------------------------------------------------

PROCEDURE LoadTypes ();
  -- -----------------------------------------------------------------
  -- This routine reads all types used in the program. Called on
  -- demand (generic types) only.
  -- -----------------------------------------------------------------

PROCEDURE LoadGlobals (OUT globals : MySet,
		       IN  globals_offset : UNSIGNED INT);
  -- -----------------------------------------------------------------
  -- This procedure creates the set of global variables. For this
  -- purpose, it scans the whole symbol table for global variable
  -- entries. See procedure above.
  -- -----------------------------------------------------------------

PROCEDURE LoadLocals (IN  function : Function);
  -- -----------------------------------------------------------------
  -- This procedure loads the local variables (parameter, locals,
  -- block) of the specified function.
  -- -----------------------------------------------------------------

PROCEDURE CreateTypeSet ();

-- -----------------------------------------------------------------
-- special constants for reading memory.
-- -----------------------------------------------------------------

CONST SIZEOF_CHAR         	  : size_t = 1;
CONST SIZEOF_SHORT_INT    	  : size_t = 2;
CONST SIZEOF_UNSIGNED_SHORT_INT   : size_t = 2;
CONST SIZEOF_INT          	  : size_t = 4;
CONST SIZEOF_UNSIGNED_INT 	  : size_t = 4;
CONST SIZEOF_ElfAttributeType     : size_t = 2;
CONST SIZEOF_DwarfEntryType       : size_t = 6;
CONST SIZEOF_FundamentalTypeEntry : INT    = 2;
CONST SIZEOF_UserDefinedTypeEntry : INT    = 4;

TYPE Elf32_Sym = RECORD 
  st_name  : Elf32_Word;
  st_value : Elf32_Addr;
  st_size  : Elf32_Word;
  st_info  : CHAR;
  st_other : CHAR;
  st_shndx : Elf32_Half;
END RECORD;

TYPE Elf32_Addr  = UNSIGNED INT;
TYPE Elf32_Half  = UNSIGNED SHORT INT;
TYPE Elf32_Off   = UNSIGNED INT;
TYPE Elf32_Sword = INT;
TYPE Elf32_Word  = UNSIGNED INT;

TYPE DwarfEntryType = RECORD
  length : UNSIGNED INT;
  tag    : UNSIGNED SHORT INT;
END RECORD;

PROCEDURE Dump ();
  -- -----------------------------------------------------------------
  -- Dump the symbol table of the process.
  -- -----------------------------------------------------------------

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE FileInfo = OBJECT (OUT fil    : REF FILE,
                        IN  filnam : ARRAY OF CHAR)

PUBLIC

  METHOD GetName () : String;
    -- -----------------------------------------------------------------
    -- The Name of the executable;
    -- -----------------------------------------------------------------
  
  METHOD GetSymbolTableStart : INT;
    -- -----------------------------------------------------------------
    -- This method returns the offset of the symbol table within the
    -- executbale file.
    -- -----------------------------------------------------------------

  METHOD GetNumberOfSymbols  : INT;
    -- -----------------------------------------------------------------
    -- This method returns the number of symbol table entries.
    -- -----------------------------------------------------------------

  METHOD EntryPoint          : INT;
    -- -----------------------------------------------------------------
    -- This method returns the entry point of the debugged process.
    -- -----------------------------------------------------------------

  METHOD TextStart           : INT;
    -- -----------------------------------------------------------------
    -- This method returns the address of the text area of the
    -- debugged process.
    -- -----------------------------------------------------------------

  METHOD DataStart           : INT;
    -- -----------------------------------------------------------------
    -- This method returns the addrees of the data area of the
    -- debugged process
    -- -----------------------------------------------------------------

  METHOD TextSize            : INT;
    -- -----------------------------------------------------------------
    -- This method returns the size of the text area of the debugged
    -- process.
    -- -----------------------------------------------------------------

  METHOD DataSize            : INT;
    -- -----------------------------------------------------------------
    -- This method returns the size of the data area of the debugged
    -- process. 
    -- -----------------------------------------------------------------

  METHOD BssSize             : INT;
    -- -----------------------------------------------------------------
    -- This method returns the size of the bss area of the debugged
    -- process. 
    -- -----------------------------------------------------------------

  METHOD GetLinenumberLimit  : INT;
    -- -----------------------------------------------------------------
    -- This method returns the size of the breakpoint table of the
    -- debugged process.
    -- -----------------------------------------------------------------

  METHOD GetLinenumberStart  : INT;
    -- -----------------------------------------------------------------
    -- This method returns the address of the linenumber table of the
    -- debugged process.
    -- -----------------------------------------------------------------

  METHOD GetModificationDate : INT;
    -- -----------------------------------------------------------------
    -- This method returns the date of the last modification of the
    -- debugged process.
    -- -----------------------------------------------------------------

  METHOD GetImageBase        : INT;
    -- -----------------------------------------------------------------
    -- This method returns the offset of the code start point. Needed
    -- for justifying the breakpoint addresses.    
    -- -----------------------------------------------------------------

PROTECTED
    
STATE
  filename : String;			 -- the name of the debugged process
  symboltable_start : INT;		 -- address of the symbol table
  number_of_symbols : INT;		 -- no comment.

  breaklines_limit  : INT;		 -- dito
  breaklinesStart   : INT;		 -- dito
  entry_point : INT;
  text_start  : INT;
  data_start  : INT;
  text_size   : INT;
  data_size   : INT;
  bss_size    : INT;
  time        : INT;
  image_base  : INT;

END OBJECT;

END SPECIFICATION;
