--                             -*- Mode: Cool2 -*- 
-- system486.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: machine.cs[1.0] Tue Feb 22 10:00:36 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 09:57:22 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Tue Apr 12 13:02:55 1994
-- Update Count    : 9
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION machine

IMPORT Function FROM function;
IMPORT STACK_ADDRESS_T FROM runstack;

CONST PC_SUBTRACT : INT = 1;		 -- on a 386/486
CONST PC_LOOKAHEAD : INT = 20;		 -- For searchNearestPc: it's
					 -- different for differrent
					 -- machines 
CONST SIGNALSTOP    : INT  = 33555839;
CONST FAULTSTOP     : INT  = 100664447;
CONST STOPPED_STATE : INT = 127;	 -- optimization for the
					 -- wait-system call 

CONST LENGTH_BREAK_INSTRUCTION : UNSIGNED INT = 1;

CONST NGREG : INT = 19;			 -- Number of registers saved
					 -- used for S-5.41. Not used
					 -- for S-ODT.
CONST EIP : INT       = 15;		 -- This is the offset of the
					 -- pc-register in ar0 area
					 -- (see <sys/user.h>)
CONST EBP : INT       = 7;		 -- This is the offset of the
					 -- fp-register in ar0 area
					 -- (see <sys/user.h>)
CONST INT_SIZE : INT = 4;

TYPE MachineCode = UNION
  -- -----------------------------------------------------------------
  -- The following type describes a 4 byte value, that represents a
  -- machine instruction read from the text space of the debugged
  -- process using the ptrace system call.
  -- original_code  specifies the code originally read
  -- patch_code     represents the code patched by MaX, e.g. for a
  --                breakpoint 
  -- -----------------------------------------------------------------
  original_code : INT;
  patch_code    : ARRAY [INT_SIZE] OF CHAR;
END UNION;

------------------------------------------------------------------------

VAR global_pc : INT;			 -- Actual pc-value of the
					 -- debugged process.
VAR global_fp : STACK_ADDRESS_T;	 -- Actual fp-value of the
					 -- debugged process.
VAR illegal_instruction : MachineCode;	 -- optimization. Must be
					 -- filled once, but is used
					 -- always. 

PROCEDURE RegisterOffsetCorrection (IN index : INT) : INT;
  -- -----------------------------------------------------------------
  -- Correct the index for our machine. In this case we have to
  -- translate the given values from the C compiler into this give in
  -- <sys/reg.h>. We have to add one, because we are in CooL (hae hae,
  -- arrays, you know?) 
  -- -----------------------------------------------------------------

PROCEDURE get_pc_and_fp;
  -- -----------------------------------------------------------------
  -- Optimized. This procedure reads the actual fp and pc value of the
  -- debugged process.
  -- -----------------------------------------------------------------
PROCEDURE get_old_fp (INOUT function : Function, 
		      IN    act_pc   : INT,
		      IN    act_fp   : STACK_ADDRESS_T) : STACK_ADDRESS_T;
PROCEDURE get_old_pc (INOUT function : Function, 
		      IN    act_pc   : INT,
		      IN    act_fp   : STACK_ADDRESS_T) : INT;
  
PROCEDURE init_illegal_instruction;

PROCEDURE patch_instruction (INOUT instruction : MachineCode,
			     IN    patch       : MachineCode);
  
END SPECIFICATION;

