--                             -*- Mode: Cool2 -*- 
-- objecttype.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: objecttype.cs[1.0] Tue Feb 22 10:01:26 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 10:02:33 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Fri Jun 10 15:16:34 1994
-- Update Count    : 4
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION objecttype

IMPORT Type, StructuredType FROM type;
IMPORT FixedString FROM globals;
IMPORT Variable, Address FROM variable;
IMPORT File FROM maxfile;
IMPORT MySet FROM Bayer;
IMPORT Method FROM method;
IMPORT String FROM mystring;

EXCEPTION NO_OBJECTTYPE_FOUND;
EXCEPTION HANDLE_NOT_INITIALIZED;
EXCEPTION HANDLE_NIL;

TYPE OBJECTHANDLEType = Type OBJECT (IN typesize : INT,
				     IN name     : FixedString)
  -- -----------------------------------------------------------------
  -- This type is a model of an objecttype handle. Through this handle
  -- we are able to reach the real object.
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD PrintValue (IN address    : Address,
		     IN resolve    : BOOL,
		     IN show_value : BOOL,
		     IN varname    : FixedString);
    -- -----------------------------------------------------------------
    -- This Method is the overall interface to a type. every subtype
    -- redefines this method to its adequate needs (if needed).
    -- address is the adress,where the values of a variable of this
    -- type can be found. resolve means, should a structured type
    -- resolved to its components or not. show_value is given, if the
    -- address shold be referenced. 
    -- -----------------------------------------------------------------
    
  METHOD GetName () : FixedString;
    -- -----------------------------------------------------------------
    -- Deliver the name of this type.
    -- -----------------------------------------------------------------
    
  METHOD PutRangeOffset (IN offset : INT);
    -- -----------------------------------------------------------------
    -- Correct the array ranges by offset.
    -- -----------------------------------------------------------------
  
  METHOD SearchInstVar (IN address : Address,
			IN name : FixedString) : Variable;
    -- -----------------------------------------------------------------
    -- Retrieve the instance variable belonging to this handle. NIL
    -- otherwise.
    -- -----------------------------------------------------------------

  METHOD InstVarAddr (IN address : Address) : Address;
    -- -----------------------------------------------------------------
    -- Retrieve the address of the instance variable record. NIL
    -- otherwise.
    -- -----------------------------------------------------------------

  METHOD GetDynamicType (IN address : Address) : OBJECTType;
    -- -----------------------------------------------------------------
    -- Compute the dynamic type to this handle
    -- -----------------------------------------------------------------
    
PROTECTED
  
STATE
  static_type : FixedString;
  
END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE OBJECTType = StructuredType OBJECT (IN typesize : INT,
					 IN name     : FixedString, 
					 IN tag_ndx  : UNSIGNED INT,
					 IN ende     : UNSIGNED INT)
   
  -- -----------------------------------------------------------------
  -- This type represents an objecttype with a set of instance
  -- variables 
  -- -----------------------------------------------------------------

PUBLIC
  
  METHOD GetStructureTag () : FixedString;
    -- -----------------------------------------------------------------
    -- Return the kind of the structure as string (f.e. "RECORD")
    -- -----------------------------------------------------------------
  
  METHOD GetFile              : File;
    -- -----------------------------------------------------------------
    -- This method returns the descriptor of the file the objecttype
    -- is declared in.
    -- -----------------------------------------------------------------

  METHOD PutFile (IN fil : File);
    -- -----------------------------------------------------------------
    -- This method puts the descriptor of the file the objecttype
    -- is declared in.
    -- -----------------------------------------------------------------

  METHOD ComputeSupertype (IN TypeInfoVar : Variable);
    -- -----------------------------------------------------------------
    -- This method computes the supertype of this objecttype recursivly
    -- -----------------------------------------------------------------

  METHOD GetMethods           : MySet;
    -- -----------------------------------------------------------------
    -- This method returns the set of methods of the objecttype.
    -- -----------------------------------------------------------------

  METHOD GetSupertype : OBJECTType;
    -- -----------------------------------------------------------------
    -- Return the supertype of this objecttype
    -- -----------------------------------------------------------------
  
  METHOD CompleteMethods (IN TypeInfoVar : Variable);
    -- -----------------------------------------------------------------
    -- Complete the set of methods while reading the method table mtab
    -- and examing the supertype for redefined and inherited methods.
    -- -----------------------------------------------------------------
  
  METHOD SearchMethodByAddress   (IN address : INT) : Method;
    -- -----------------------------------------------------------------
    -- Deliver the method with this address.
    -- -----------------------------------------------------------------
  
  METHOD SearchMethod (IN name     : FixedString,
		       IN exported : BOOL) : Method;
    -- -----------------------------------------------------------------
    -- Deliver the method with this name.
    -- -----------------------------------------------------------------
  
  METHOD GetInstanceVariables : MySet;
    -- -----------------------------------------------------------------
    -- This method returns the set of instance variable of the
    -- objecttype. 
    -- -----------------------------------------------------------------

  METHOD AddMethod            (IN method : Method);
    -- -----------------------------------------------------------------
    -- This method adds a new method to the set of methods of the
    -- object type.
    -- -----------------------------------------------------------------

  METHOD AddInstanceVariable  (IN var : Variable);
    -- -----------------------------------------------------------------
    -- This method adds a new instance variable to the set of instance
    -- variables of the object type.
    -- -----------------------------------------------------------------

  METHOD BreakInvocation (IN thistype : BOOL);
    -- -----------------------------------------------------------------
    -- This method marks all methods of the object type with a
    -- breakpoint. Whenever a method of the object type is invoked,
    -- the execution stops. If thistype is FALSE, stop if the method is
    -- called even for subtypes. Otherwise, stop only for this type.
    -- -----------------------------------------------------------------

  METHOD UnbreakInvocation ();
    -- -----------------------------------------------------------------
    -- This method unmarks all methods of the object type with a
    -- breakpoint. If thistype is FALSE, unbreak the method also for
    -- subtypes. Otherwise, do it only for this type. 
    -- -----------------------------------------------------------------

  METHOD BreakObjectInvocation (IN handle : Variable);
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------

  METHOD TraceInvocation (IN thistype : BOOL);
    -- -----------------------------------------------------------------
    -- This method marks all methods of the object type with a
    -- trace point. Whenever a method of the object type is invoked,
    -- the execution of this method is displayed. If thistype is
    -- FALSE, trace if the method is called even for subtypes.
    -- Otherwise, trace only for this type. 
    -- -----------------------------------------------------------------

  METHOD UntraceInvocation ();
    -- -----------------------------------------------------------------
    -- This method removes all trace points from the methods of the
    -- objecttype. If thistype is FALSE, untrace the method also for
    -- subtypes. Otherwise, do it only for this type.
    -- -----------------------------------------------------------------

  METHOD TraceObjectInvocation (IN handle : Variable);
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
  
  METHOD PrintSelf;
    -- -----------------------------------------------------------------
    -- This method prints the list of methods and the list of instance
    -- variables of the object type.
    -- -----------------------------------------------------------------

  METHOD PrintHierarchy (IN indent : INT);
    -- -----------------------------------------------------------------
    -- This method prints the objecttype hierarchy of the object type.
    -- -----------------------------------------------------------------

  METHOD PrintAllSupertypes;
    -- -----------------------------------------------------------------
    -- This method prints all supertypes this object type.
    -- -----------------------------------------------------------------

  METHOD GetSupertypeName () : FixedString;
    -- -----------------------------------------------------------------
    -- This method gives the supertype name of this type.
    -- -----------------------------------------------------------------

  METHOD GetNameAsString () : String;
    -- -----------------------------------------------------------------
    -- This method gives the name of this type as a String object for
    -- the breakpoint registration.
    -- -----------------------------------------------------------------

PROTECTED
  
STATE
  supertype          : OBJECTType;	 -- our supertype;
  rootObjecttype     : BOOL;		 -- Is is known, in a file
					 -- compiled with -g?
  file               : File;		 -- file descriptor of the
					 -- file, in which the object
					 -- type is declared.
  methods            : MySet;		 -- SET OF Methods.
  methodsComplete    : BOOL;		 -- completing methods only once

END OBJECT;

END SPECIFICATION;
