/*                               -*- Mode: C -*- 
 * elflowlev.c -- contains some routines for the elf format
 * 
 *   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
 *   All rights reserved
 * 
 * AtFSID          : $Header: elflowlev.c[1.1] Tue Feb 22 09:58:07 1994 lutz@hawaii saved $
 * Author          : Lutz Hilken
 *
 * Created On      : Fri Mar  5 09:52:13 1993
 * Last Modified By: Lutz Hilken
 * Last Modified On: Fri Mar 25 14:27:36 1994
 * Update Count    : 34
 * 
 * HISTORY
 * 28-Oct-1993		Lutz Hilken	
 *    Last Modified: Tue Oct 26 14:49:21 1993 #25 (Lutz Hilken)
 *    Version after Champs error
 * 5-Mar-1993		Lutz Hilken	
 *    Last Modified: Fri Mar  5 09:53:40 1993 #1 (Lutz Hilken)
 *    first Version
 * PURPOSE
 * 	|>Description of modules purpose<|
 * TABLE OF CONTENTS
 * 
 */

#include <unistd.h>
#include <stdio.h>
#include <syms.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/procfs.h>
#include <varargs.h>

/* **************************************************************/

PrFillFltSet (set)
     fltset_t *set;
{
  prfillset (set);
}

/* **************************************************************/

PrClearFltSet (set)
     fltset_t *set;
{
  premptyset (set);
}

/* **************************************************************/

PrAddFltSet (set, flag)
     fltset_t *set;
     int flag;
{
  praddset (set, flag);
}

/* **************************************************************/

PrDelFltSet (set, flag)
     fltset_t *set;
     int flag;
{
  prdelset (set, flag);
}

/* **************************************************************/

PrFillSigSet (set)
     sigset_t *set;
{
  prfillset (set);
}
/* **************************************************************/

PrAddSigSet (set, flag)
     sigset_t *set;
     int flag;
{
  praddset (set, flag);
}

/* **************************************************************/

int getFileDate (fil)
     int fil;
     /* **************************************************************
      * Used in the good ol' CoLibri-free days. Sigh.
      * LIE! NOT TRUE! Damned Colibri! Still need this one! Doesn't
      * work correct on MX 300i!
      * ************************************************************** */
{
  struct stat buf;

  fstat (fil, &buf);
  return buf.st_mtime;
}

/* **************************************************************/

int shift_byte_right (b, count)
     char b;
     int  count;
     /* **************************************************************
      * Used for bit hacking. Not possible in CooL. At least in a
      * simple way.
      * ************************************************************** */
{
  return (int) b>>count;
}

/* **************************************************************/

int shift_byte_left (b, count)
     char b;
     int  count;
     /* **************************************************************
      * Used for bit hacking. Not possible in CooL. At least in a
      * simple way.
      * ************************************************************** */
{
  return (int) b<<count;
}

/* **************************************************************/

int ByteAnD (a1, a2)
     char a1;
     char a2;
     /* **************************************************************
      * Used for bit hacking. Not possible in CooL. At least in a
      * simple way.
      * ************************************************************** */
{
  return (int) a1 & a2;
}

/* **************************************************************/

extern FILE *errorC3IGetOutputFile ();

void Trace (va_alist)
     va_dcl
{
  va_list ap;
  char *msg;

  va_start (ap);
  msg = va_arg (ap, char *);
  fprintf  (errorC3IGetOutputFile (), " + ");
  vfprintf (errorC3IGetOutputFile (), msg, ap);
  va_end (ap);
}

/* **************************************************************/

void Message (va_alist)
     va_dcl
{
  va_list ap;
  char *msg;

  va_start (ap);
  msg = va_arg (ap, char *);
  vfprintf (errorC3IGetOutputFile (), msg, ap);
  va_end (ap);
}

/* **************************************************************/

extern int opsysC3Iget_process_id ();

int read_framesize (entry, first_line)
     int entry;
     int first_line;
{
  int instruction;
  int cur_pc;
  int frame_size = 0;

  for (cur_pc = entry; cur_pc < first_line; cur_pc += 4) {
    opsysC3Imy_ptrace (&instruction, 1, opsysC3Iget_process_id (),
			  cur_pc, 0);
    /* Trace ("PC:Act instr = 0x%x:0x%x\n", cur_pc, instruction); */
    if ((instruction & 0xFFFF0000) == 0x27bd0000) /* addiu $sp,$sp,-i */
      frame_size += (-instruction) & 0xFFFF;
    else if ((instruction & 0xFFFF0000) == 0x23bd0000) /* addu $sp,$sp,-i */
      frame_size += (-instruction) & 0xFFFF;
  }
  return frame_size;
}

/* **************************************************************/

int read_old_pc_offset (entry, first_line)
     int entry;
     int first_line;
{
  int instruction;
  int cur_pc;
  int old_pc = 0;

  for (cur_pc = entry; cur_pc < first_line; cur_pc += 4) {
    opsysC3Imy_ptrace (&instruction, 1, opsysC3Iget_process_id (),
			  cur_pc, 0);
    /* Trace ("PC:Act instr = 0x%x:0x%x\n", cur_pc, instruction); */
    if ((instruction & 0xFFFF0000) == 0xafbf0000) /* sw ra,i(sp) */
      {
	old_pc = (instruction) & 0xFFFF;
	break;
      }
  }
  return old_pc;
}
