--                             -*- Mode: Cool2 -*- 
-- mysetgen.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: mysetgen.cs[1.0] Tue Feb 22 10:01:10 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 10:01:00 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Fri Jun 10 15:16:36 1994
-- Update Count    : 3
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION mysetgen

IMPORT StopPoint, BreakTracePoint FROM break;
IMPORT Function, Block FROM function;
IMPORT Method FROM method;
IMPORT Variable FROM variable;
IMPORT File, SourceFile, Line_t FROM maxfile;
IMPORT Type, StructuredType, EnumerationValue FROM type;
IMPORT OBJECTType FROM objecttype;
IMPORT String FROM mystring;
IMPORT Directories FROM director;
IMPORT Elf32_Sym FROM unixsymtab;

TYPE Fanta = OBJECT
PUBLIC
   -- intentionally left blank
PROTECTED
   -- intentionally left blank
STATE
   -- intentionally left blank
END OBJECT;

-- ---------------------------------------------------------------

TYPE OBJECT_TYPE = UNION
  fanta       : Fanta; -- DO NOT DELETE THIS ONE!!!!!
  --- append here your own classes to be stored in a set
  break      	: StopPoint;
  breaktrace 	: BreakTracePoint;
  func       	: Function;
  method     	: Method;
  var        	: Variable;
  file       	: File;
  type       	: Type;
  struct     	: StructuredType;
  object     	: OBJECTType;
  string     	: String;
  dir        	: Directories;
  adr        	: ADDRESS;
  line       	: REF Line_t;
  block      	: Block;
  src_line   	: INT;
  enumtag    	: EnumerationValue;
  symbol     	: REF Elf32_Sym;
  source_file   : SourceFile;
END UNION;

-- ---------------------------------------------------------------

TYPE KEYTYPE = RECORD
  tag       : INT; -- 1 = INT, 2 = String, 3 = FLOAT
  key_value : KEY_VALUE;
  is_less   : PROCEDURE (IN KEY_VALUE, IN KEY_VALUE) : BOOL;
  is_equal  : PROCEDURE (IN KEY_VALUE, IN KEY_VALUE) : BOOL;
END RECORD;

-- ---------------------------------------------------------------

TYPE KEY_VALUE = UNION
  i : INT;
  s : REF ARRAY OF CHAR;
  f : FLOAT;
END UNION;

-- ---------------------------------------------------------------

VAR global_int_key    : KEYTYPE;
VAR global_string_key : KEYTYPE;

PROCEDURE init_int_key;
PROCEDURE init_string_key;
END SPECIFICATION;

