--                             -*- Mode: Cool2 -*- 
-- method.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: method.cs[1.0] Tue Feb 22 10:00:53 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 10:00:06 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Fri Jun 10 15:16:38 1994
-- Update Count    : 6
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION method

IMPORT Function 
  FROM function;
IMPORT Type 
  FROM type;
IMPORT File 
  FROM maxfile;
IMPORT String 
  FROM mystring;
IMPORT FixedString, CRet, CStr 
  FROM globals;
IMPORT strcpy
  FROM Basics;
IMPORT OBJECTType 
  FROM objecttype;
IMPORT Variable 
  FROM variable;

CONST NORMAL_METHOD     : INT = 0;
CONST INITIALLY_METHOD  : INT = 1;
CONST FINALLY_METHOD    : INT = 2;
CONST LOCAL_METHOD      : INT = 3;
CONST REDEFINED_METHOD  : INT = 4;
CONST INHERITED_METHOD  : INT = 5;

TYPE Method = Function OBJECT 
   (INOUT funcname  : ARRAY OF CHAR,	 -- name of the function
    IN address      : UNSIGNED INT,	 -- entry point of the function
    IN smbtaboffset : UNSIGNED INT,	 -- offset in the symbol table
    IN nxt_block    : UNSIGNED INT,	 -- end of description of this
					 -- function in the symbol table
    IN frst_line    : INT,		 -- number of the first
					 -- source line of this function
    IN lst_line     : INT,		 -- number of the last
					 -- source line of this function
    IN type         : Type,		 -- type of this function
    IN file         : File,		 -- the file this function is
					 -- declared in
    IN Kind         : INT)		 -- What's that for a method
  
PUBLIC
  
  METHOD Print (IN forobjecttype : FixedString);
    
  METHOD SetKind (IN Kind : INT);
    
  METHOD IsLocal () : BOOL;
    
  METHOD GetMethodName () : String;
  METHOD GetTypeName () : String;
    
  METHOD BreakEntryForOType (IN otype : OBJECTType);
    -- -----------------------------------------------------------------
    -- This method marks the first source line of this method with a
    -- break point for objects of type otype. 
    -- -----------------------------------------------------------------

  METHOD TraceAllForOType (IN otype : OBJECTType);
    -- -----------------------------------------------------------------
    -- This method marks this method as being traced for objects of
    -- type otype.
    -- -----------------------------------------------------------------

  METHOD BreakEntryForObject (IN handle : Variable);
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------

  METHOD TraceAllForObject (IN handle : Variable);
    -- -----------------------------------------------------------------
    -- 
    -- -----------------------------------------------------------------
PROTECTED
    
STATE
  kind : INT;
  methodname : String;
  typename : String;
  
END OBJECT;

END SPECIFICATION;

