--                             -*- Mode: Cool2 -*- 
-- maxui.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: maxui.cs[1.0] Tue Feb 22 10:01:02 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 09:59:23 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Tue Mar 15 11:57:36 1994
-- Update Count    : 8
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION maxui

IMPORT Toi, ArgumentList 
  FROM Toi;
IMPORT TextFile
  FROM TextFile;
IMPORT FILE
  FROM Basics;

VAR Interface       : UserInterface;	 -- The command interpreter.

TYPE UserInterface = Toi OBJECT
      (IN Prompt        : STRING,
       IN Separator     : CHAR,
       IN EndCmd        : STRING,
       IN InputFile     : STRING,
       IN OutputFile    : TextFile,
       IN HistoryLength : INT)

PUBLIC
  
  METHOD ExecuteSetBreak        (IN parameter : ArgumentList);
  METHOD ExecuteUnsetBreak      (IN parameter : ArgumentList);
  METHOD ExecuteSetTrace        (IN parameter : ArgumentList);
  METHOD ExecuteUnsetTrace      (IN parameter : ArgumentList);
  METHOD ExecuteHelp            (IN parameter : ArgumentList);
  METHOD ExecuteVersion         (IN parameter : ArgumentList);
  METHOD ExecuteWhereis         (IN parameter : ArgumentList);
  METHOD ExecuteList            (IN parameter : ArgumentList);
  METHOD ExecuteWindow          (IN parameter : ArgumentList);
  METHOD ExecuteStartCallChain  (IN parameter : ArgumentList);
  METHOD ExecuteListCallChain   (IN parameter : ArgumentList);
  METHOD ExecuteEndCallChain    (IN parameter : ArgumentList);
  METHOD ExecuteStartCallCount  (IN parameter : ArgumentList);
  METHOD ExecuteListCallCount   (IN parameter : ArgumentList);
  METHOD ExecuteEndCallCount    (IN parameter : ArgumentList);
  METHOD ExecuteStacktrace      (IN parameter : ArgumentList);
  METHOD ExecuteObjecttype      (IN parameter : ArgumentList);
  METHOD ExecuteType            (IN parameter : ArgumentList);
  METHOD ExecuteFiles           (IN parameter : ArgumentList);
  METHOD ExecuteRoutines        (IN parameter : ArgumentList);
  METHOD ExecuteProcedures      (IN parameter : ArgumentList);
  METHOD ExecuteQuit            (IN parameter : ArgumentList);
  METHOD ExecuteStatics         (IN parameter : ArgumentList);
  METHOD ExecuteGlobals         (IN parameter : ArgumentList);
  METHOD ExecuteLocals          (IN parameter : ArgumentList);
  METHOD ExecuteShowVariable    (IN parameter : ArgumentList);
  METHOD ExecuteHierarchy       (IN parameter : ArgumentList);
  METHOD ExecuteUse             (IN parameter : ArgumentList);
  METHOD ExecuteRun             (IN parameter : ArgumentList);
  METHOD ExecuteSinglestep      (IN parameter : ArgumentList);
  METHOD ExecuteSkip            (IN parameter : ArgumentList);
  METHOD ExecuteRestart         (IN parameter : ArgumentList);
  METHOD ExecuteReturn          (IN parameter : ArgumentList);
  METHOD ExecuteExit            (IN parameter : ArgumentList);
    -- -----------------------------------------------------------------
    -- This methods execute the commands given by the user. The
    -- command is that without the "Execute". :-)
    -- -----------------------------------------------------------------
  METHOD ExecuteDumpBreakPoints (IN parameter : ArgumentList);
  METHOD ExecuteDumpBlocks      (IN parameter : ArgumentList);
  METHOD ExecuteDumpPrologues   (IN parameter : ArgumentList);
  METHOD ExecuteDump            (IN parameter : ArgumentList);
  METHOD ExecuteCorrectArray    (IN parameter : ArgumentList);
    -- -----------------------------------------------------------------
    -- This methods execute the Debugging commands given by the user.
    -- -----------------------------------------------------------------
  METHOD GetOutputFile : TextFile;
    
PROTECTED
      
STATE
  
END OBJECT;

END SPECIFICATION;

