--                             -*- Mode: Cool2 -*- 
-- globals.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: globals.cs[1.0] Tue Feb 22 10:00:22 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 09:56:17 1994
-- Last Modified By: unknown full name
-- Last Modified On: Thu Jun 16 13:11:21 1994
-- Update Count    : 48
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION globals

IMPORT FILE FROM Basics;

EXCEPTION NoFile;
EXCEPTION Stop;
EXCEPTION IllegalFileFormat;
EXCEPTION NoAccessToProcess;

FOREIGN PROCEDURE shift_byte_right (b : CHAR, count: INT) : INT;
FOREIGN PROCEDURE ByteAnD          (a1 : CHAR, a2 : CHAR) : INT;
FOREIGN PROCEDURE getFileDate      (IN fil : INT) : INT;

TYPE time_t   = INT;            (* <time> type *)

TYPE timestruc_t =
   RECORD
      tv_sec  : time_t;         (* seconds *)
      tv_nsec : INT;	        (* and nanoseconds *)
   END RECORD;

TYPE pid_t   = INT;

FOREIGN PROCEDURE getpid () : pid_t;

CONST SIGINT : INT    =  2;
CONST SIGTRAP : INT   =  5;
CONST SIGKILL : INT   =  9;

FOREIGN PROCEDURE signal (IN sig  : INT, ..) : PROCEDURE ();

TYPE sigset_t = RECORD
  sigbits : ARRAY [ 4 ] OF UNSIGNED INT ;
END RECORD (* sigset_t *) ;

TYPE sigaction_t =
   RECORD
       sa_flags   : INT;
       sa_handler : PROCEDURE ();        (* signal handler *)
       sa_mask    : sigset_t;            (* signal mask to apply *)
       sa_resv    : ARRAY [ 2 ] OF INT;  (* see signal options below *)
   END RECORD;

FOREIGN PROCEDURE sigaction (IN sig  : INT,
			     IN act  : REF sigaction_t,
			     IN oact : REF sigaction_t) : INT;

FOREIGN PROCEDURE strcat (IN s1 : REF ARRAY OF CHAR,
			  IN s2 : REF ARRAY OF CHAR) : REF ARRAY OF CHAR;

FOREIGN PROCEDURE strncat (IN s1 : REF ARRAY OF CHAR,
			   IN s2 : REF ARRAY OF CHAR,
			   IN n  : size_t) : REF ARRAY OF CHAR;

FOREIGN PROCEDURE strcmp (IN s1 : REF ARRAY OF CHAR,
			  IN s2 : REF ARRAY OF CHAR) : INT;

FOREIGN PROCEDURE strncmp (IN s1 : REF ARRAY OF CHAR,
			   IN s2 : REF ARRAY OF CHAR,
			   IN n  : size_t) : INT;

FOREIGN PROCEDURE strlen (IN s : REF ARRAY OF CHAR) : size_t;

FOREIGN PROCEDURE strerror (IN errnum : INT) : REF ARRAY OF CHAR;

FOREIGN PROCEDURE sscanf (IN s      : REF ARRAY OF CHAR,
			  IN format : REF ARRAY OF CHAR,
			  .. ) : INT;

FOREIGN PROCEDURE lseek (IN fildes : INT,
			 IN offset : off_t,
			 IN whence : INT) : off_t;

--- FOREIGN PROCEDURE fseek (IN stream : REF FILE,
--- 			 IN offset : INT,
--- 			 IN whence : INT) : INT;

CONST SEEK_SET : INT  = 0;

--- FOREIGN PROCEDURE ftell (IN stream : REF FILE) : INT;

FOREIGN PROCEDURE fgets (IN s      : REF ARRAY OF CHAR,
			 IN n      : INT,
			 IN stream : REF FILE) : REF ARRAY OF CHAR;

---FOREIGN PROCEDURE fclose (IN stream : REF FILE) : INT;
---
---FOREIGN PROCEDURE fopen (IN filename : REF ARRAY OF CHAR,
---			 IN mode     : REF ARRAY OF CHAR) : REF FILE;

FOREIGN PROCEDURE read (IN fildes : INT,
			IN buf    : REF ARRAY OF CHAR,
			IN nbyte  : UNSIGNED INT) : INT;

FOREIGN PROCEDURE write (IN fildes : INT,
			 IN buf    : REF ARRAY OF CHAR,
			 IN nbyte  : UNSIGNED INT) : INT;

FOREIGN PROCEDURE memcpy (IN s1 : ADDRESS,
			  IN s2 : ADDRESS,
			  IN n  : size_t) : ADDRESS;

--- FOREIGN PROCEDURE malloc (IN size : size_t) : ADDRESS;

--- FOREIGN PROCEDURE free (IN ptr : ADDRESS);

FOREIGN PROCEDURE exit (IN status : INT);
FOREIGN PROCEDURE kill (IN pid : pid_t, IN sig : INT) : INT;

FOREIGN PROCEDURE fork () : pid_t;
FOREIGN PROCEDURE execv (IN path : REF ARRAY OF CHAR,
			 IN argv : ARRAY OF REF ARRAY OF CHAR) : INT;


CONST R_OK : INT      = 4; (* Test for Read permission *)
CONST W_OK : INT      = 2; (* Test for Write permission *)
CONST X_OK : INT      = 1; (* Test for eXecute permission *)
CONST F_OK : INT      = 0; (* Test for existence of File *)

FOREIGN PROCEDURE access (IN path  : REF ARRAY OF CHAR,
			  IN amode : INT) : INT;

FOREIGN PROCEDURE dup (IN fildes : INT) : INT;

FOREIGN PROCEDURE dup2 (IN fildes  : INT,
			IN fildes2 : INT) : INT;

FOREIGN PROCEDURE close (IN fildes : INT) : INT;

CONST O_RDONLY : INT  =    0; --  0000
CONST O_WRONLY : INT  =    1; --  0001
CONST O_RDWR : INT    =    2; --  0002

FOREIGN PROCEDURE open (IN path  : REF ARRAY OF CHAR,
			IN oflag : INT,
			..) : INT;

-- FOREIGN VAR stdin  : REF FILE; -- (&_iob[0]) 
-- FOREIGN VAR stdout : REF FILE; -- (&_iob[1])
-- FOREIGN VAR stderr : REF FILE; -- (&_iob[2])

--- FOREIGN PROCEDURE isdigit (IN c : INT) : INT;
FOREIGN PROCEDURE isalpha (IN c : INT) : INT;

FOREIGN PROCEDURE atoi (IN str : REF ARRAY OF CHAR) : INT;

CONST UINT_MAX : UNSIGNED INT  =  4294967295; -- max value of 'unsigned int'

--- FOREIGN PROCEDURE getenv (IN name : REF ARRAY OF CHAR) : REF ARRAY OF CHAR;

FOREIGN PROCEDURE getopt (IN argc      : INT,
			  IN argv      : REF REF ARRAY OF CHAR,
			  IN optstring : REF ARRAY OF CHAR) : INT;

FOREIGN VAR optarg : REF ARRAY OF CHAR;

FOREIGN VAR optind : INT;

FOREIGN VAR errno : INT;

---- constants ---------------------------------------------------------

CONST MAX_STRING : INT = 255;
CONST STDOUT : INT = 0;
CONST PIPE : INT   = 1;
CONST FIL : INT    = 2;

---- types -----------------------------------------------------------

TYPE FixedString = ARRAY [MAX_STRING] OF CHAR;

--- TYPE FILE = RECORD
---   _cnt  : INT;
---   _ptr  : REF ARRAY OF CHAR;
---   _base : REF ARRAY OF CHAR;
---   _flag : CHAR;
---   _file : CHAR;
--- END RECORD;

TYPE off_t   = INT;
TYPE size_t = UNSIGNED INT;

---- globals ---------------------------------------------------------

VAR CRet            : INT;		 -- dummy variable for some results
VAR CStr            : REF ARRAY OF CHAR; -- dummy variable for some results

VAR process_id : INT;			 -- process number of the
					 -- debugged process
VAR gfilename       : FixedString;	 -- name of the debugged process
VAR nox             : BOOL;		 -- asccii or x surface?
VAR execfile        : REF FILE;		 -- file pointer the
					 -- executable object file
VAR son_input       : FixedString;	 -- name of the new input
					 -- device of the debugged process
VAR son_output      : FixedString;	 -- name of the new output
					 -- device of the debugged process
VAR son_tty         : FixedString;	 -- name of the new input/output
					 -- device of the debugged process

END SPECIFICATION;

