--                             -*- Mode: Cool2 -*- 
-- execut.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: execut.cs[1.0] Tue Feb 22 09:59:43 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 09:50:29 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Fri Jun 10 15:16:48 1994
-- Update Count    : 11
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION execut

IMPORT File FROM maxfile;
IMPORT FileInfo FROM unixsymtab;
IMPORT Function FROM function;
IMPORT StopPoint, BreakTracePoint FROM break;
IMPORT String FROM mystring;
IMPORT Type FROM type;
IMPORT OBJECTType FROM objecttype;
IMPORT FixedString FROM globals;
IMPORT MySet FROM Bayer;
IMPORT Variable FROM variable;
IMPORT ActiveFunctionStack, CallChain FROM runstack;

VAR son             : Executable;	 -- object describing the
					 -- debugged process
---------------------------------------------------------------------

TYPE Executable = OBJECT (IN filename : ARRAY OF CHAR)
    -- --------------------------------------------------------------
    -- This type describes an executable object file. 
    -- filename specifies the name of the executable.
    -- --------------------------------------------------------------
PUBLIC
  
-- -----------------------------------------------------------------
-- Here we go along with the file handling stuff...
-- -----------------------------------------------------------------
  
  METHOD AddFile            (IN file : File);
    -- -----------------------------------------------------------------
    -- This methods adds the specified file to the set of files the
    -- executable is constructed of
    -- -----------------------------------------------------------------

  METHOD AddUnknownFile (IN file : File);
    -- -----------------------------------------------------------------
    -- This methods adds the specified file to the set of unknown
    -- files which are detected after it is clear, whether we have
    -- compiler debug information (see file.t)
    -- -----------------------------------------------------------------

  METHOD DeleteUnknownFile  (IN file : File);
    -- -----------------------------------------------------------------
    -- This method deletes the specified from the set of files known
    -- by MaX. All symbols declared in this file are not known by MaX
    -- anymore.
    -- -----------------------------------------------------------------

  METHOD GetFileInfo        : FileInfo;
    -- -----------------------------------------------------------------
    -- This method returns the file information of the executable
    -- source file needed to extract the symbolic information (e.g.
    -- position of the symbol table, break point table etc.)
    -- -----------------------------------------------------------------

  METHOD SearchFile         (IN file_name : ARRAY OF CHAR) : File;
    -- -----------------------------------------------------------------
    -- This Method searches the file, specified by its name, in the
    -- list of known files. filename specifies the "official" file
    -- name that is pepresented e.g. with the command "files". 
    --
    -- If the specified file cannot be found, NIL is returned.
    -- -----------------------------------------------------------------

  METHOD PrintFileList;
    -- -----------------------------------------------------------------
    -- This method prints the list of known files.
    -- -----------------------------------------------------------------

  METHOD ListFile;
    -- -----------------------------------------------------------------
    -- This method lists the source of the actual source file.
    -- A file is the actual source file, if it contains the actual
    -- source line.
    -- -----------------------------------------------------------------

-- -----------------------------------------------------------------
-- Here we go along with the function handling stuff...
-- -----------------------------------------------------------------
  
  METHOD PrintFunctionList;
    -- -----------------------------------------------------------------
    -- This method prints the list of functions known by MaX. METHODs
    -- as well as PROCEDUREs are listed.
    -- -----------------------------------------------------------------

  METHOD PrintProcedureList;
    -- -----------------------------------------------------------------
    -- This method prints the set of procedures known by MaX. METHODs
    -- are not listed.
    -- -----------------------------------------------------------------

  METHOD SearchFunction    (IN function_name : ARRAY OF CHAR) : Function;
    -- -----------------------------------------------------------------
    -- This method searches the function specified by its name in the
    -- set of functions. 
    -- -----------------------------------------------------------------

  METHOD MarkFunctionEntries;
    -- -----------------------------------------------------------------
    -- This method marks all function entries with an invisible
    -- breakpoint. See Technical Description.
    -- -----------------------------------------------------------------

  METHOD UnmarkFunctionEntries;
    -- -----------------------------------------------------------------
    -- This method removes the invisible breakpoints from all function
    -- entries. See Technical Description.
    -- -----------------------------------------------------------------

  METHOD AddFunctionEntry      (IN tracepoint : StopPoint);
    -- -----------------------------------------------------------------
    -- This method adds the specified StopPoint to the set of function
    -- entries. See doc for instance variable "function_entries"
    -- -----------------------------------------------------------------

  METHOD SearchFunctionByAddress (IN address : INT) : Function;
    -- -----------------------------------------------------------------
    -- This method searches a function by its entry point (used for
    -- procedure-variables).
    -- NIL is returned if no function can be found.
    -- -----------------------------------------------------------------

  METHOD SearchFunctionByIndex   (IN index : INT) : Function;
    -- -----------------------------------------------------------------
    -- This method searches a function by its position in the symbol
    -- table.
    -- NIL is returned if no function can be found.
    -- -----------------------------------------------------------------

-- -----------------------------------------------------------------
-- Here we go along with the type handling stuff...
-- -----------------------------------------------------------------
  
  METHOD CorrectArrayOffsets ();
    -- -----------------------------------------------------------------
    -- This methods corrects the array offsets for CooL arrays.
    -- -----------------------------------------------------------------
  
  METHOD AddArrayOffsetInfo (IN info : String);
    -- -----------------------------------------------------------------
    -- This methods adds information for array correction
    -- -----------------------------------------------------------------
  
  METHOD AddType (IN type : Type);
    -- -----------------------------------------------------------------
    -- This methods adds the type to the set of types.
    -- -----------------------------------------------------------------
  
  METHOD ListAllTypes;
    -- -----------------------------------------------------------------
    -- This method lists all types of the debugged program.
    -- -----------------------------------------------------------------

  METHOD ListType (IN name : ARRAY OF CHAR);
    -- -----------------------------------------------------------------
    -- This method lists an type specified by name.
    -- -----------------------------------------------------------------

  METHOD SearchType  (IN name : ARRAY OF CHAR) : Type;
    -- -----------------------------------------------------------------
    -- This method searches a type specified by name.
    -- NIL is returned, if no type can be found.
    -- -----------------------------------------------------------------

-- -----------------------------------------------------------------
-- Here we go along with the objecttype handling stuff...
-- -----------------------------------------------------------------
  
  METHOD AddObjecttype (IN methodname : FixedString) : OBJECTType;
    -- -----------------------------------------------------------------
    -- This methods adds the specified otypename to the set of
    -- object_types, if it isn't created yet. The new objecttype or
    -- the one found is returned.
    -- -----------------------------------------------------------------
  
  METHOD GetObjecttypes () : MySet;
    -- -----------------------------------------------------------------
    -- This method returns the objecttype set.
    -- -----------------------------------------------------------------

  METHOD ListAllObjectTypes;
    -- -----------------------------------------------------------------
    -- This method lists all object types of the debugged program.
    -- -----------------------------------------------------------------

  METHOD ListObjectType    (IN name : ARRAY OF CHAR);
    -- -----------------------------------------------------------------
    -- This method lists an object type specified by name.
    -- -----------------------------------------------------------------

  METHOD PrintObjecttypeHierarchy ();
    -- -----------------------------------------------------------------
    -- This method lists the objecttype hirarchy grafically.
    -- -----------------------------------------------------------------
  
  METHOD SearchObjecttype  (IN name : ARRAY OF CHAR) : OBJECTType;
    -- -----------------------------------------------------------------
    -- This method searches an object type specified by name.
    -- NIL is returned, if no object type can be found.
    -- -----------------------------------------------------------------

-- -----------------------------------------------------------------
-- Here we go along with the variable handling stuff...
-- -----------------------------------------------------------------
  
  METHOD SearchGlobal (IN varname : ARRAY OF CHAR) : Variable;
    -- -----------------------------------------------------------------
    -- This method searches varname as a global variable.
    -- NIL is returned, if no variable can be found.
    -- -----------------------------------------------------------------

  METHOD SearchCoolGlobal (IN varname : ARRAY OF CHAR) : Variable;
    -- -----------------------------------------------------------------
    -- This method searches varname as a cool global variable. If the
    -- process is living, we retrieve the actual file...
    -- -----------------------------------------------------------------

  METHOD SearchEverywhere (IN  varname  : ARRAY OF CHAR,
                           OUT file     : File,
                           OUT function : Function) : Variable;
    -- -----------------------------------------------------------------
    -- This method searches the specified variable in the following
    -- areas: 
    -- If the debugged process is already started:
    --     o local  variables of active routines
    --     o static variable of active routines
    --     o global variables
    -- If the debugged process is not active or the variable is still
    -- not found:
    --     o all routines
    --     o all static variables
    --     o all global variables
    -- When the variable is found, file and function are set as
    -- follows:
    --     o if the variable is local, function is the object
    --       describing the function, anf file describes the file
    --       containing the function
    --     o if the variable is static, function is NIL and file
    --       describes the file containing the variable
    --     o if the variable is global, file and function are NIL
    -- If the variable is not found, file and function are NIL and
    -- NIL is returned.
    -- -----------------------------------------------------------------
  
  METHOD SearchTypeInfoVariable (IN address : INT) : Variable;
    -- -----------------------------------------------------------------
    -- This method searches the specified address in the sets of
    -- static variables (used for identifying instance variables of
    -- object types). address must match the base address of one of
    -- the static variables.
    -- NIL is returned if no variable with the specified can be found.
    -- -----------------------------------------------------------------

  METHOD PrintGlobals;
    -- -----------------------------------------------------------------
    -- This method prints the list of global variables of the debugged
    -- process.
    -- -----------------------------------------------------------------

  METHOD PrintStatics;
    -- -----------------------------------------------------------------
    -- This method prints the list of static variables of the debugged
    -- process.
    -- -----------------------------------------------------------------

  METHOD PrintLocals;
    -- -----------------------------------------------------------------
    -- This method prints the list of local variables of the actual
    -- function of the debugged process.
    -- -----------------------------------------------------------------

  METHOD Whereis (IN  varname  : ARRAY OF CHAR);
    -- -----------------------------------------------------------------
    -- This method prints all definitions of variables specified by
    -- varname.
    -- -----------------------------------------------------------------

-- -----------------------------------------------------------------
-- Here we go along with the breakline handling stuff...
-- -----------------------------------------------------------------
  
  METHOD SearchLine            (IN line : INT) : BreakTracePoint;
    -- -----------------------------------------------------------------
    -- This method searches a source line specified by line and
    -- returns the break point information for this line.
    -- NIL is returned, if the source line cannot be found.
    -- -----------------------------------------------------------------

  METHOD ReMarkDefinedBreakPoints;
    -- -----------------------------------------------------------------
    -- This method marks all defined break points in the debugged
    -- process. This method is called when the process is started the
    -- very first time or the user issues the reexecute command.
    -- -----------------------------------------------------------------

  METHOD UndefineBreakPoints;
    -- -----------------------------------------------------------------
    -- This method marks all break points as not being initialized.
    -- This must be done in the restart command, because a completely
    -- new process is created, where some breakpoint information must
    -- be re-initialized. See doc of break.t.
    -- -----------------------------------------------------------------

  METHOD AddBreakTracePoint    (IN tracepoint : StopPoint);
    -- -----------------------------------------------------------------
    -- This method adds the break point specified by tracepoint to
    -- the set of breakpoints.
    -- -----------------------------------------------------------------

  METHOD SearchBreakpoint      (IN txt_addr : INT) : StopPoint;
    -- -----------------------------------------------------------------
    -- This methos searches a breakpoint specified by txt_addr in the
    -- set of breakpoints.
    -- -----------------------------------------------------------------

  METHOD Window;
    -- -----------------------------------------------------------------
    -- This method prints a source window of the actual file around
    -- the actual source line.
    -- -----------------------------------------------------------------

  METHOD TraceAll;
    -- -----------------------------------------------------------------
    -- This method marks all execitable source lines of the debugged
    -- process as being traced.
    -- -----------------------------------------------------------------

  METHOD UntraceAll;
    -- -----------------------------------------------------------------
    -- This method marks all execitable source lines of the debugged
    -- process as not being traced.
    -- -----------------------------------------------------------------

  METHOD UnbreakAll;
    -- -----------------------------------------------------------------
    -- This method deletes all defined break points.
    -- -----------------------------------------------------------------

  METHOD ListBreaksAndTraces;
    -- -----------------------------------------------------------------
    -- This method lists all defined break and trace points.
    -- -----------------------------------------------------------------

  METHOD SearchNearestPc (IN txtAddress : INT) : BreakTracePoint;
    -- -----------------------------------------------------------------
    -- This method searches a breakpoint with an address that is as
    -- near as possible and less or equal to the specified txtAddress.
    -- NIL is returned if no such break point is available.
    -- -----------------------------------------------------------------

  METHOD SearchPreviousPc (IN txtAddress : INT) : BreakTracePoint;
    -- -----------------------------------------------------------------
    -- This method searches a breakpoint with an address that is as
    -- near as possible (previous) to the specified txtAddress.
    -- NIL is returned if no such break point is available.
    -- -----------------------------------------------------------------

  METHOD GetActualLine : BreakTracePoint;
    -- -----------------------------------------------------------------
    -- This method returns break point information of the the actual
    -- source line.
    -- -----------------------------------------------------------------

-- -----------------------------------------------------------------
-- Here we go along with the runstack handling stuff...
-- -----------------------------------------------------------------
  
  METHOD ComputeFunctionStack;
    -- -----------------------------------------------------------------
    -- This method computes the stack of avtive routines. Before
    -- computing, we destroy the actual kept stack, because it's not
    -- valid anymore.
    -- -----------------------------------------------------------------

  METHOD ValidFunctionStack : BOOL;
    -- -----------------------------------------------------------------
    -- This method tests for an existing function stack.
    -- -----------------------------------------------------------------

  METHOD GetFunctionStack      : ActiveFunctionStack;
    -- -----------------------------------------------------------------
    -- This method returns the stack of avtive routines.
    -- -----------------------------------------------------------------

  METHOD ShowStacktrace;
    -- -----------------------------------------------------------------
    -- This method prints the stack of active routines.
    -- -----------------------------------------------------------------

  METHOD StartCallChain;
    -- -----------------------------------------------------------------
    -- This method starts the recording of routine calls.
    -- -----------------------------------------------------------------

  METHOD HandleCallChain (IN function : Function);
    -- -----------------------------------------------------------------
    -- This method registers a function on the call stack, if nessesary.
    -- -----------------------------------------------------------------
  
  METHOD EndCallChain;
    -- -----------------------------------------------------------------
    -- This method stops the recording of routine calls.
    -- -----------------------------------------------------------------

  METHOD ListCallChain;
    -- -----------------------------------------------------------------
    -- This method lists the recording of routine calls.
    -- -----------------------------------------------------------------

  METHOD IsCallChainActive : BOOL;
    -- -----------------------------------------------------------------
    -- This method tests for active recording of routine calls.
    -- -----------------------------------------------------------------

  METHOD StartCallCount;
    -- -----------------------------------------------------------------
    -- This method starts the recording of routine calls.
    -- -----------------------------------------------------------------

  METHOD EndCallCount;
    -- -----------------------------------------------------------------
    -- This method stops the recording of routine calls.
    -- -----------------------------------------------------------------

  METHOD ListCallCount;
    -- -----------------------------------------------------------------
    -- This method lists the recording of routine calls.
    -- -----------------------------------------------------------------

  METHOD IsCallCountActive : BOOL;
    -- -----------------------------------------------------------------
    -- This method tests for active recording of routine calls.
    -- -----------------------------------------------------------------

-- -----------------------------------------------------------------
-- Here we go along with the additional stuff...
-- -----------------------------------------------------------------
  
  METHOD RuntimeInitialized    : BOOL;
    -- -----------------------------------------------------------------
    -- This routine returns 
    --   TRUE  if the debugged process has been started using the run
    --         command 
    --   FALSE if not.
    -- -----------------------------------------------------------------

  METHOD PutRuntimeInitialized (IN b : BOOL);
    -- -----------------------------------------------------------------
    -- This routine modifies the instance variable runtime_initialized.
    -- -----------------------------------------------------------------

  METHOD Init;
    -- -----------------------------------------------------------------
    -- This method initializes an object of type Executable. It is
    -- excluded from INITIALLY, because some routines called here need
    -- some information from the object "son", which must be created
    -- before some methods of it are called (e.g. GetFileInfo).
    -- -----------------------------------------------------------------

  METHOD PrintFunctionEntries (IN long : BOOL);
    -- -----------------------------------------------------------------
    -- Method for debugiing needs
    -- -----------------------------------------------------------------

  METHOD PrintBreakTracePoints (IN long : BOOL);
    -- -----------------------------------------------------------------
    -- Method for debugiing needs
    -- -----------------------------------------------------------------

  METHOD PrintBlocks ();
    -- -----------------------------------------------------------------
    -- Method for debugiing needs
    -- -----------------------------------------------------------------

  METHOD PrintPrologueSizes ();
    -- -----------------------------------------------------------------
    -- Method for debugiing needs
    -- -----------------------------------------------------------------

PROTECTED
    
STATE
  files          : MySet;		 -- SET OF File; contains all
					 -- files known by MaX
  unknown_files  : MySet;		 -- SET OF File; contains all
					 -- files  unknown by MaX
  globals        : MySet;		 -- SET OF Variable; contains
					 -- all global variables of
					 -- the debugged process
  types          : MySet;		 -- SET OF Type;
					 -- contains all types
					 -- of the debugged process.
  types_loaded   : BOOL;		 -- to avoid extra loading of
					 -- types 
  object_types   : MySet;		 -- SET OF OBJECTType;
					 -- contains all object types
					 -- of the debugged process.
  object_types_loaded : BOOL;		 -- to avoid extra loading of
					 -- objecttypes 

  array_info     : MySet;		 -- Information for array
					 -- correction
  function_entries : MySet;		 -- SET OF StopPoint
    -- -----------------------------------------------------------------
    -- The searching of breakpoints must be as efficient as possible;
    -- therefore all breakpoints are stored in a "Bayer-Tree", that
    -- provides very efficient searching on sets. 
    -- For this purpose, all function entries are stored in a special
    -- set.
    -- -----------------------------------------------------------------

  breaktracepoints : MySet;		 -- SET OF StopPoint
    -- -----------------------------------------------------------------
    -- For the same reason, all other breakpints are stored in a Bayer
    -- tree, too. They are distinct from function entries, because
    -- function entries must be handled in a special way and also be
    -- found as quick as possible. See doc break.t
    -- -----------------------------------------------------------------

  function_stack : ActiveFunctionStack;	 -- contains the stack of
					 -- active routines.
  globals_offset : UNSIGNED INT;	 -- specified the start offset of
					 -- global variables in the
					 -- object file
  runtime_initialized : BOOL;		 -- specifies whether the
					 -- debugged process is
					 -- already started or not
  callChain         : CallChain;	 -- Callchain stack of
					 -- recorded function calls
  callCountActive   : BOOL;		 -- Sould we count the calling of 
					 -- functions

END OBJECT;

END SPECIFICATION;

