--                             -*- Mode: Cool2 -*- 
-- director.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: director.cs[1.0] Tue Feb 22 09:59:27 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 09:43:16 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Mon Mar 14 18:14:31 1994
-- Update Count    : 4
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION director

IMPORT String FROM mystring;
IMPORT FILE FROM Basics;
IMPORT MySet FROM Bayer;

VAR directories     : Directories;	 -- container for the
					 -- directories searched by
					 -- MaX for accessing source files
TYPE Directories =  OBJECT

PUBLIC
  
  METHOD AddDirectory (IN path : ARRAY OF CHAR);
    -- -----------------------------------------------------------------
    -- This method adds the path to the set of directories. If the
    -- path is already in the set, it is not inserted.
    -- -----------------------------------------------------------------

  METHOD DirSearchFile   (IN name : String) : BOOL;
    -- -----------------------------------------------------------------
    -- This method searches the list of directories for the file
    -- specified by name. If the file can be found, TRUE is returned,
    -- FALSE otherwise.
    -- -----------------------------------------------------------------

  METHOD OpenFile     (IN name : String) : REF FILE;  
    -- -----------------------------------------------------------------
    -- This methods opens a UNIX file descriptor for a file specified
    -- by name. If the file can be opened, the descriptor is returned,
    -- FALSE otherwise.
    -- -----------------------------------------------------------------

  METHOD ListDirectories;
    -- -----------------------------------------------------------------
    -- This method list the set of directories on the screen.
    -- -----------------------------------------------------------------

PROTECTED
  
STATE

  dirs : MySet;				 -- SET OF String, KEY = number

END OBJECT;

PROCEDURE extract_directory (INOUT filename : ARRAY OF CHAR);

END SPECIFICATION;

