--                             -*- Mode: Cool2 -*- 
-- Bayer.cs -- 
-- 
--   Copyright (C) SieTec Systemtechnik GmbH & Co OHG 1993
--   All rights reserved
-- 
-- AtFSID          : $Header: Bayer.cs[1.0] Tue Feb 22 09:59:06 1994 lutz@hawaii saved $
-- Author          : Lutz Hilken
-- 
-- Created On      : Thu Jan 27 09:38:51 1994
-- Last Modified By: Lutz Hilken
-- Last Modified On: Wed Feb 23 16:47:12 1994
-- Update Count    : 2
-- 
-- HISTORY
-- PURPOSE
-- 	|>Description of module's purpose<|
-- 

SPECIFICATION Bayer

IMPORT KEY_VALUE, KEYTYPE, OBJECT_TYPE, Fanta FROM mysetgen;

TYPE MySet = OBJECT

PUBLIC
  METHOD IsIn     (IN  searchkey : KEYTYPE) : OBJECT_TYPE;
  METHOD Incl     (IN  key : KEYTYPE, IN  pobj : OBJECT_TYPE);
  METHOD Excl     (IN  key : KEYTYPE);
  METHOD Choose   (OUT pobj : OBJECT_TYPE);
  METHOD Cardinal : INT;
  METHOD DeleteAll;
  METHOD GetSet : BayerPage;

PROTECTED

STATE
  set      : BayerPage;  -- this IS the set of persistent objects
  Kardinal : INT;           -- number of elements

END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE MyCursor = OBJECT (IN pset : MySet)

PUBLIC
  METHOD MyCursorNilOrWhat : BOOL;
  METHOD GetElement        : OBJECT_TYPE;
  METHOD GetKey            : KEY_VALUE;
  METHOD Advance;
  METHOD GetAn  : INT;
  METHOD GetDel : INT;
  METHOD Finalize;
PROTECTED
  
STATE
  page_stack : BayerPageList;
  act_index  : INT;
  act_obj    : OBJECT_TYPE;
  act_key    : KEY_VALUE;
  act_page   : BayerPage;
  angelegt   : INT;
  geloescht  : INT;

END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

PROCEDURE CloseMyCursor (INOUT cursor : MyCursor);
  
-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

CONST PAGESIZE           : INT = 20;
CONST HALFPAGE           : INT = 10;
CONST HALFPAGE_PLUS_ONE  : INT = 11;
CONST HALFPAGE_MINUS_ONE : INT = 9;
(*
CONST PAGESIZE           : INT = 128
CONST HALFPAGE           : INT = 64
CONST HALFPAGE_PLUS_ONE  : INT = 65
CONST HALFPAGE_MINUS_ONE : INT = 63
*)
(* ORIGINAL values:
CONST PAGESIZE           : INT = 64
CONST HALFPAGE           : INT = 32
CONST HALFPAGE_PLUS_ONE  : INT = 33
CONST HALFPAGE_MINUS_ONE : INT = 31
*)

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE BayerPage = OBJECT
  
PUBLIC
  METHOD GetP0Page       : BayerPage;
  METHOD PutP0Page       (IN nxt : BayerPage);
  METHOD PutIthElement   (IN i : INT,
		  	  IN elem : BayerElement);
  METHOD PutOccupied     (IN val : INT);
  METHOD GetOccupied     : INT;
  METHOD GetIthElement   (IN i : INT) : BayerElement;
  METHOD GetIthElementsPage  (IN i : INT) : BayerPage;
  METHOD GetIthElementsKeyValue   (IN i : INT) : KEY_VALUE;
  METHOD GetIthElementsValue (IN i : INT) : Fanta;
  METHOD GetAllElements  : ARRAY [PAGESIZE] OF BayerElement;
  METHOD PutAllElements (IN new_elements : ARRAY [PAGESIZE] OF BayerElement);

PROTECTED
  
STATE
  occupied  : INT;
  p0        : BayerPage;
  elements  : ARRAY [PAGESIZE] OF BayerElement;

END OBJECT;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE BayerElement =
RECORD
  key   : KEYTYPE;
  value : Fanta;
  page  : BayerPage;
END RECORD;

-- -----------------------------------------------------------------
-- 
-- -----------------------------------------------------------------

TYPE BayerPageList = OBJECT (IN pg   : BayerPage,
			     IN nxt  : BayerPageList, 
			     IN indx : INT)
PUBLIC
  METHOD GetPage  : BayerPage;
  METHOD GetNext  : BayerPageList;
  METHOD GetIndex : INT;
  METHOD PutIndex (IN ndx : INT);

PROTECTED

STATE
  page  : BayerPage;
  next  : BayerPageList;
  index : INT;
  
END OBJECT;

END SPECIFICATION;

