.so manmac.ms
.OH "''''"
.EH "''''"
.ds Fg "Fig.
.nr Ph 1                \" Initialize picture-numbering-
.nr Pn 0                \"                      registers
.if '\*(Fg'' .ds Fg Abb.
.de Pc  \" Draw Picture --- .Pc title height filename alignment
.KS                     \" ms dependent keep
.sp \\$2+2v             \" vertical space for picture (2 lines frame)
.if !\\n(Ph=\\n(H1 \{ .nr Ph \\n(H1  \" if new chapter-save chapter number
.nr Pn 0 \}             \" initialize Picture-number
.nr Pn \\n(Pn+1         \" increase picture-number
.ce 
\f3\\*(Fg \\n(Ph.\\n(Pn\fP \\$1  \" write picture Title
.KE                     \" release keep
.if !'\\$3'' \{         \" if a filename is given
.if \\n(.P \{           \" and if page should be printed
.nr Vp \\n(nl-\\$2-4v   \" In,Vp upper left corner of picture
.nr In \\n(.o-32+\\n(.i \" 32 is a LW+-correction
.nr He \\$2             \" Picture height given by caller
.nr Wi \\n(.l-\\n(.i    \" Picture width (line len. - cur. indent)
\!E /usr/local/lib/gem2ps -V\\n(Vp -I\\n(In -H\\n(He -W\\n(Wi -A\\$4 \\$3
.rr Vp
.rr In
.rr He
.rr Wi
\}
\}
.br
..
.fp 1 H
.fp 2 HO
.fp 3 HB
.nr PS 12
.nr VS 14
.LP
\&
.sp 20
.ps 18
.vs 20p
\f(HBSINIX\fP
.LP
.sp 2
.ps 30
.vs 34p
\f(HBCooL V2.1\fP
.LP
.sp
.ps 18
.vs 20p
\f(HBSQL - Object - Interface\fP
.sp 11
\f(HBReference Manual\fP
.LP
.bp
\&
.bp
\&
.sp 10
.ps 30
.vs 34p
\f(HBCooL (SINIX)\fP
.LP
.sp 2
.ps 18
.vs 20p
\f(HBSQL - Object - Interface\fP
.sp 3
\f(HBReference Manual\fP
.LP
.sp 23
.ps 12
.vs 14p
Edition January 1994 (CooL V2.1)
.LP
.bp
\&
.sp 29
.ps 9
.vs 11p
.TS
tab($);
l.
CooL\u\s-1\(rg\s+1\d
Copyright \s+2\(co\s-2 Siemens Nixdorf Informationssysteme AG 1994
All rights reserved
.sp 0.5
SINIX\u\s-1\(rg\s+1\d Copyright \s+2\(co\s-2 Siemens Nixdorf Informationssysteme AG 1990
SINIX is the UNIX\u\s-1\(rg\s+1\d System derivate of Siemens Nixdorf Informationssysteme AG
UNIX is a registered trademark of UNIX Systems Laboratories, Inc. in the USA and other countries
.sp 0.5
The reproduction, transmission or use of this document or its contents is not permitted
without express written authority.
.sp 0.5
Offenders will be liable for damages. All rights, including rights created
by patent grant or registration of a utility model or design, are reserved.
.sp 0.5
Delivery subject to availability;
right of technical modifications reserved.
.sp 0.5
Published by
Siemens Nixdorf Informationssysteme AG
.TE
.OH "''''"
.EH "''''"
.bp
.OH "'SOI Reference Manual''Preface'"
.EH "'Preface''SOI Reference Manual'"
.OF "'''\\\\n(PN'"
.EF "'\\\\n(PN'''"
.NX 0 "Preface"
.sp
Most application systems in the domain of information systems require
data base system support.  For applications written with
object-oriented languages like CooL, object-oriented data base systems
would be best suited to work in close cooperation.  However,
object-oriented (o-o) data base systems are just arising at market and
yet far away from any standardization.
.br
Besides this there is often the problem to write new applications for
existing data bases.
.br
To integrate existing data bases and to provide persistence on top of
relational data base systems the SQL Object Interface (SOI) is a
programming interface to a SQL Database Management System (SQL-DBMS).
This interface supports nearly the complete language definition of
SQL.
.sp
The general idea is to separate the data manipulation by using SQL
from the application development using an object-oriented language.
This goal is achieved by providing an explicit description mechanism
using a slightly extended SQL and generating from this description a
semantically equivalent language-specific interface.  These object
types, methods and routines may be used to access relations and data
of a data base from an object-oriented application. Generated code is
either CooL or C++.
.sp
\f(HBAudience\fP
.sp
This manual contains all information required to work with the SQL
Object Interface.  It describes how to write a SOI description and how
to use the results of the generation process.
.br
This manual does not explain what is SQL, how to use it or how to
define data base schemes.  Nevertheless, it contains examples for using
SQL statements or creating data base relations.  However, this implies
that the reader should be familiar with SINIX, CooL or C++ and
especially with SQL.
.sp
.bp
\f(HBContents\fP
.sp
The SOI Reference Manual contains five chapters with the following
contents:
.IP "1. Preconditions for Using the SOI
This chapter provides an explanation of the preconditions which must be
fullfilled for generating and using the SOI.
.IP "2. Introduction"
It gives a survey of the general concepts and describes two different views
on SOI: The application programmer's and the data base programmer's point
of view.
.IP "3. Programming the Interface"
This chapter describes the language for programming an interface description
and how to use the SOI generator.
.IP "4. Application Programming Interface"
This chapter gives a description of the generated
interface and describes how it can be used in an application program.
.IP "5. SQL CooL Data Types"
The CooL Library (CoLibri) offers a set of so-called "SQL CooL Data
Types" and a set of routines to handle variables of these types.  This
is necessary because SQL has its own data types.  The connection
between these SQL types and the language-specific types is described
in this chapter.
.LP
.sp
\f(HBTypographical Conventions\fP
.sp
The following typographical conventions are used:
.IP \f(HBbold\fP 11
\f(HBBoldfaced\fP strings in syntax descriptions represent literals and must
be typed in the manner in which they appear.
.IP \f(HOitalic\fP 11
\f(HOItalicized\fP strings represent substitutable arguments and the names of
entries found elsewhere.
.IP \fCcourier\fP 11
\fCCourier\fP is used for program examples, user input, system output
and (error) messages.
.IP "[ ]" 11
Square brackets [ ] around arguments indicate that the arguments are optional
and may be omitted.
.IP \&... 11
Ellipses ... are used to show that the previous argument may be repeated.
.IP \f(HOname()\fP 11
The notation \f(HOname()\fP indicates CooL procedures and methods and
C functions.
.IP \f(HO/*...*/\fP 11
denotes comments.
.IP "{ }" 11
Braces { } around names represent constants.
.LP
.OH "''''"
.EH "''''"
.bp
.OH "'SOI Reference Manual''Preconditions for Using SOI'"
.EH "'Preconditions for Using SOI''SOI Reference Manual'"
.NX 1 "Preconditions for Using SOI"
.sp
The SQL Object Interface is defined by using a description file.  To
edit this file you need an editor and careful study of this manual.
The interface generator generates the SOI.  The generator produces
either CooL or C++ code and can be used in two different modes.
.sp
The first mode is: 'Without SQL checks', i.e. generating the interface without
checking the syntax of the SQL statements.
.sp 0.5
The second mode is: 'With SQL checks', i.e. generating the interface including
checks of the SQL statement syntax.
.sp
In the second case a data base system and a data base schema are needed.
.sp
The generated interface can be linked to an application like any other
object types or routines,
i.e. all things of the choosen programming environment are necessary.
.sp
Running the application the choosen data base must be available.
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'SOI Reference Manual''Introduction'"
.EH "'Introduction''SOI Reference Manual'"
.NX 1 "Introduction"
.sp
This chapter describes the general concepts of the SQL Object
Interface \&(SOI), explains what it is and underlines different
aspects for application and data base programmers.
.sp
.NX 2 "General Overview"
.sp
The SOI enables the programmer to integrate an object-oriented
application written in CooL or C++ with the relational data base system
INFORMIX.  This goal is achieved by providing an explicit description
mechanism which is a slightly extended SQL and to generate from this
description a semantically equivalent language-specific compilation
unit.  This compilation unit may be used by the application programmer
in his object-oriented application to access the relations of a
data base.  Additionally \f(HOCoLibri\fP offers for CooL a number of
procedures for data type manipulation.
.sp
.Pc "Production cycle" 3.8i soicycle.gem c
.bp
.NX 3 "What it is and what it is not"
.sp
The SOI is based on two things.  First there is a language to describe
data base units, so-called views, and cursor-oriented operations on
these views.  This language is based on SQL, enriched by a few special
terms for the SOI generator.  Second there is the possibility to write
SOI statements containing any (static) SQL statement, so-called
non-cursor SQL statements.  The view and the related operations are
translated into language specific object type definitions while the
SOI statements are translated into language-specific routines (e.g.
CooL procedures).  Both may be used in programs of this specific
language.
.br
The descriptions are stored in a so-called 'description file'.  From
this file the SOI generator produces a language-specific interface
(LSI) and a SQL interface.  These interfaces are stored in separate
compilation units.
.br
The LSI contains object type definitions and routines.  An application
program then may interact with the data base in an object-oriented way.
.br
The access to the SQL system is mapped to ESQL/C routines,
which are bundled within a compilation unit.
.sp 0.5
This approach is far away from any object-oriented persistence as it
is provided by object-oriented data base systems but it opens the way
to integrate the wide world of relational data bases.  Furthermore,
programming is, with a little restriction, independent of the special
data base system i.e. the generator produces a different ESQL/C
interface but the LSI remains still the same.  The major restriction
is that different data base systems may have different sets of types.
.sp 0.5
The current SOI supports a static interface. The term static refers to
the fact that all operations on the data base must be known at
generation time.
.sp
.NX 3 "Concepts"
.sp
The SQL Object Interface (SOI) realizes the data exchange between the
application object types and the data base system.  This data exchange
may be done by cursor operations which are defined as \f(HOCURSOR\fP
specifications within a \f(HOVIEW\fP specification in the description
file.  A view describes a virtual table on top of the data base schema.
It may define a subset of columns of one table or may combine more
than one table.  The generator transforms these specifications into
language-specific data base access object types (DBA-OT).
.br
Cursor specifications define data base operations on a view.  
Three kinds of cursor specifications are supported by the SOI:
.IP \(bu 3
(simple) select cursor
.IP \(bu 3
select cursor for update
.IP \(bu 3
insert cursor
.LP
Note, that the select cursor optionally provides update operations.
.sp
The cursor specifications are transformed into methods of the DBA-OTs.
The application programmer has to use objects of these DBA-OTs and
their methods to read/write data from/into the data base.
.br
While programming directly with ESQL/C host variables and indicator
variables are used.  Host variables are used to hold values of the
data base within an application program.  Indicator variables are used
to indicate null values and/or errors.  These variables are not used
in the LSI but the information of these variables are transformed into
language-specific (re)presentations.
.sp
As mentioned above it is possible to declare non-cursor SQL statements
in the description file.  This can be done with the so-called
STATEMENT specification.  Any (static) SQL statement can be denoted
within this STATEMENT specification.  These statements are transformed
into language-specific routines.  The programmer has to use these
routines in his application program to perform the non-cursor data base
operations.
.br
Two such statement specifications are always necessary: One which
realizes a connection to the data base and one which realizes the
disconnection. All other data base specifications are valid only
between these two.
.sp
The concept of this SQL interface has two major advantages.  First, it
reduces the effort and complexity of SQL programming dramatically.
.br
Second, developing an application can be devided into two parts:
Database programming and application programming i.e. programming the
application's object types which realize the semantic behaviour of the
problem area.  Both tasks can be assigned to appropriate specialists
for each domain.  The following two chapters characterize these
different tasks.
.sp
.NX 3 "Data Base Programmer's Point of View"
.sp
Defining a SQL Object Interface requires SQL and data base system
knowledge.  So this job can be done by a data base specialist.  Two
different situations are supported by the SOI.  An application program
shall work on an existing data base (i.e. relations are already defined
and data may be stored in these relations) or a data base and the
relations must be defined first.  Both situations are supported by the
SOI.  In the second case the programmer should use the already
mentioned statement specifications to define the data base schemes
while in the first case he mainly has to use the view specification.
.sp
The following steps should be done for accessing an existing data base.
.sp
.IP \(bu 3
Design of:
.RS 3
.IP \(bu 3
views
.IP \(bu 3
cursor operations (one for each view)
.IP \(bu 3
additional SQL (non-cursor) operations
.RE
.IP \(bu 3
Writing the SQL description file
.IP \(bu 3
Generating the SOI object types, methods and procedures
.IP \(bu 3
Using the features of the SOI for the application object types
.LP
.sp
Depending on the architectural design of the complete data base
application the last step may be realized in different ways:
.IP \(bu 3
The application may use directly the DBA-OTs and their methods or
.IP \(bu 3
an additional 'layer' between application and DBA-OTs is built.
.LP
.sp
.NX 3 "Application Programmer's Point of View"
.sp
The application programmer designs the semantic features of a program
system.  The semantic behaviour is realized by application object
types. Data can be stored in instance variables of the object types.
These variables must be filled during the runtime of an application.
To do this the application programmer should use the generated
DBA-OTs.  The principle relation between these two object types is
the following:
.sp
.IP EXAMPLES
Application object type:
.CS L
\&...
VAR iv_1 : t_1;
\&...
VAR iv_n : t_n;
VAR dba  : DBA_OT;
\&...
dba := NEW DBA_OT ();
dba.GetData (...);
transDataToInstanceVariables (...);
\&...
.CE
.sp
Database access object type (DBA-OT):
.CS L
\&...
METHOD GetData (...);
\&...
METHOD PutData (...);
\&...
.CE
.LP
.OH "''''"
.EH "''''"
.bp
.OH "'SOI Reference Manual''Interface Specification'"
.EH "'Interface Specification''SOI Reference Manual'"
.NX 1 "Interface Specification"
.sp
As mentioned above there are two major tasks while programming an
application on top of a relational data base using the SOI.
.sp 0.5
.IP \(bu 3
Defining and generating the SOI
.IP \(bu 3
Application programming and using SOI
.LP
.sp 0.5
The next chapters describe the necessary steps to get a generated SOI.
This includes the complete syntax and semantics of the SOI description
language and the interface of the generator.  The descriptions are
independent of whether the data base and relations already exist or
not.  Program fragments are added as explanation. A complete example
is given in appendix D.  All examples are based on INFORMIX and CooL.
All keywords are written in capital letters although small letters are
allowed too.
.br
A comprehensive definition of the description file language is given
in the appendix.
.sp
.NX 2 "The Description File"
.sp
The description file is the input for the SOI generator.  It contains
one or more view, constant and statement specifications.  These
specifications are translated into data base access object types
(DBA-OT), methods, constant definitions and procedures (see also
\&"Application Programming Interface").
.sp
The structure of a description file is:
.sp 0.5
.in +2
.CS L
\f(HOdescriptionFile \fP::= \f(HOdbSystemSpecification\fP
                          \f(HOSpecificationList\fP

\f(HOSpecificationList\fP
                ::= \f(HOSpecification\fP |
                    \f(HOSpecificationList Specification\fP

\f(HOSpecification\fP
                ::= \f(HOviewSpecification\fP |
                    \f(HOconstantDeclaration\fP |
                    \f(HOstatementSpecification\fP

.CE
.in -2
.IP DESCRIPTION
A description file must contain the name of the data base system the
SOI will be generated for.  It may contain constant definitions which
can be used in subsequent specifications.  It should contain at least
one view specification including a cursor specification or at least
one SQL statement specification.
.br
Both lower-case and upper-case letters are allowed in identifiers.
However, letter case is not significant in keywords (e.g. \f(HOCONST\fP,
\f(HOconst\fP or \f(HOConsT\fP are all allowed as keyword \f(HOCONST\fP).
.br
The identifiers can be used directly in the generated language
interface, since they are not transformed in any way. If a
user-defined identifier is a reserved word in the generated language
interface, then this leads to an error. The generator does not check
this while generating the language interface. So be careful not to use
keywords as identifiers (e.g. \f(HOIF\fP, \f(HOclass\fP, \f(HONEW\fP,
\f(HOnew\fP etc.).
.br
Comments may be written in two forms:
.sp 0.5
.CS L
-- Comment
.CE
.sp 0.5
The characters \f(HO--\fP and the characters following them up to end of
line are skipped.
.sp 0.5
.CS L
(* Comment *)
.CE
.sp 0.5
With this form a multiline comment may be denoted. 
The characters \f(HO(*\fP, \f(HO*)\fP and all enclosed characters are 
skipped. 
Comments of this form must not be nested.
.LP
.sp 0.5
.NX 3 "Database System Specification"
.sp
The SOI provides the data base programmer with a general interface for
different data base systems.  The actual data base system on hand has to
be specified with the system clause:
.sp 0.5
.in +2
.CS L
\f(HOdbSystemSpecification\fP    ::= \f(HBSYSTEM\fP \f(HOdbmsName\fP \f(HB;\fP
.CE
.in -2
.sp 0.5
.IP DESCRIPTION
The \f(HO\fP \f(HOdbmsName\fP specifies the actual data base system.  
Based on this name the generator is able to include special constructs 
into the generated ESQL/C-file and the specific language interface.  
The data base specification must not be omitted.
.sp 0.5
The following table shows the supported data base systems and the
corresponding \f(HOdbmsName's\fP for the system specification:
.sp 0.5
.TS
tab(@)box;
l | l.
\f(HOdatabase system\fP@\f(HOdbmsName\fP
=
INFORMIX V4.0@informix40
_
INFORMIX V4.1@informix41
.TE
.IP EXAMPLES
.CS L
SYSTEM informix40;
.CE
.LP
.sp 0.5
.NX 3 "Constants"
.sp
A constant specification associates a name with a numeric value. 
It has the following form:
.sp 0.5
.in +2
.CS L
\f(HO constantDeclaration\fP ::=
      \f(HBCONST\fP \f(HOidentifier\fP \f(HB=\fP \f(HOconstantExpression\fP \f(HB;\fP

\f(HO constantExpression\fP    ::=
        \f(HOmultiplicativeConstantExpression\fP
    |   \f(HOconstantExpression\fP \f(HB+\fP \f(HOmultiplicativeConstantExpression\fP
    |   \f(HOconstantExpression\fP \f(HB-\fP \f(HOmultiplicativeConstantExpression\fP

\f(HO multiplicativeConstantExpression\fP ::=
        \f(HOunary_constant_expression\fP
    |   \f(HOmultiplicativeConstantExpression\fP \f(HB*\fP \f(HOunaryConstantExpression\fP
    |   \f(HOmultiplicativeConstantExpression\fP \f(HB/\fP \f(HOunaryConstantExpression\fP

\f(HO unaryConstantExpression\fP ::=
        \f(HOprimaryConstantExpression\fP
    |   \f(HB-\fP \f(HOprimaryConstantExpression\fP
    |   \f(HB+\fP \f(HOprimaryConstantExpression\fP

\f(HO primaryConstantExpression\fP ::=
        \f(HOnumber\fP
    |   \f(HOidentifier\fP
    |   (\f(HOconstantExpression\fP )
.CE
.in -2
.sp 0.5
.IP DESCRIPTION
\f(HOnumber\fP must be an integer value.  
The \f(HOconstantExpression\fP is calculated and thus fixed at compile 
time.  
The generator produces for the constant declaration an adequate language
specific constant definition.  
\f(HOidentifier\fP is the name of the constant which may be used in 
subsequent specifications.
.br 
Constants can be used as constant expressions for SQL-types in view 
specification (e.g. ... CHAR(length) ... ), and in the application 
program as constants (generated in the application language).
.br
Note, the characters \f(HO--\fP are start a comment. 
If the second \f(HO-\fP shall denote the unary minus operator, then the 
characters \f(HO--\fP must be separated with whitespace characters (e.g.
space character, new-line or tabulator).
.IP EXAMPLES
.CS L
CONST length = 5;
CONST width  = 10;
CONST volume = length * width * 20;
.CE
.LP
.sp 0.5
.NX 3 "View Specification"
.sp
With the \f(HOviewSpecification\fP the data base programmer may specify a
concrete data base subset (a view), and the cursor type (see below) for
this view.  The view defines a set of columns the programmer wants to
bundle.
.br
The generator generates a language-specific object type for each view
specification.  
Furthermore, a data type and an init procedure for variables of this 
type are generated.  
In CooL this data type is a record, in C++ it is a structure.  
The programmer should declare variables of this data type to keep the 
data of the defined tuple.
.br
To define the columns and the cursor, the view specification consists
of two parts.  The first part is the view specification itself and the
second part is the cursor specification.  The general structure of a
view specification is given by the following syntax rules:
.sp 0.5
.in +2
.CS L
\f(HOviewSpecification\fP ::=
      \f(HBVIEW\fP \f(HOidentifier\fP \f(HB(\fP \f(HOparameterList\fP \f(HB)\fP \f(HBAS\fP
        \f(HOcursorSpecification\fP \f(HB;\fP

\f(HO parameterList\fP ::=
      \f(HOidentifier sqlType\fP
    | \f(HOparameterList\fP \f(HB,\fP \f(HOidentifier sqlType\fP
.CE
.in -2
.sp 0.5
.IP DESCRIPTION
The \f(HOviewSpecification\fP consists of two parts, the
VIEW and the CURSOR part.  In the VIEW part the
programmer describes a virtual table on top of the data base schema.  A
virtual table can be a subset of columns of one table or it may
consist of columns from more than one table.  Such a virtual table is
called a view.
.sp 0.5
The \f(HOidentifier\fP is the name of the view and becomes the name of 
the generated object type.
.sp 0.5
The columns of the view are defined by the \f(HO\fP \f(HOparameterList\fP
of the VIEW part.  Each parameter must be denoted with name
(\f(HOidentifier\fP) and type (\f(HOsqlType\fP).  The \f(HOsqlType\fP must
be one of the SQL data types of the data base system.
.br
From these parameters the generator produces the data structure, where
the parameter names denote the component names of the data structure.
The type of each component is the language-specific type corresponding
to the SQL data type. For each SQL data type exists a corresponding
language-specific data type.  Thus SERIAL as a data type in INFORMIX
corresponds to the CooL type SqlSerial.  These SQL data types are
provided by CoLibri. (see also "SQL-CooL-Data-Types").
.IP NOTE
The view specification within the SOI does not define a view in the 
data base system.
.KS
.IP EXAMPLES
.CS L
VIEW Customers (name       CHAR   (20 ),
                address    CHAR   (20 ),
                customerId SERIAL,
                priority   INTEGER )
     AS \f(HOcursorSpecification\fP;
.CE
.KE
Thereby, \f(HOCustomers\fP is the name of the view and respectively the
name of the generated object type.  The data structure has the same
name extended by an '_R' \&(e.g. \f(HOCustomers_R\fP).
.sp
.NX 3 "Cursor Specification"
.sp
With the \f(HOCURSOR\fP part the programmer describes the interaction
between the view and the data base.  Three kinds of cursor
specifications are supported within the SOI:
.KS
.IP \(bu 3
A select cursor defines a select operation to fill the specified view.
.IP \(bu 3
A select cursor for update defines a select operation and in addition it
defines update operations to update the actual data base.
.IP \(bu 3
An insert cursor defines an insert operation to insert data of the
specified view into a table of the actual data base.
.LP
.KE
.KS
The following syntax rules show the general structure of the cursor
specification:
.sp 0.5
.in +2
.CS L
\f(HO cursorSpecification\fP ::=
      \f(HBCURSOR\fP [ \f(HBOPEN WITH\fP (\f(HOparameterList)\fP] \f(HBFOR\fP \f(HOcursorClause\fP

\f(HO cursorClause\fP        ::=
      \f(HOselectClause\fP [\f(HBFOR UPDATE\fP] | \f(HOinsertClause\fP

\f(HOselectClause\fP        ::=
      /* select specification from SQL */

\f(HO insertClause\fP        ::=
      \f(HBINSERT INTO\fP \f(HOidentifier\fP [\f(HO(\fP\f(HO identifierList\fP\f(HO )\fP ]
.CE
.in -2
.KE
.IP DESCRIPTION
With the \f(HOcursorClause\fP a select or insert operation may be
specified.
For update operations the \f(HO\fP \f(HOselectClause\fP has to be 
specified with the FOR UPDATE qualifier.
From these clauses the generator produces normal ESQL/C fetch, flush etc.
routines and corresponding language-specific methods of the object type.
.br
With the OPEN WITH clause it is possible to declare parameters which
should be used at run time to qualify a cursor operation.
.sp 0.5
In the \f(HOselectClause\fP of the \f(HOcursorSpecification\fP the
data base programmer has to specify a select statement as it is valid
in SQL.  This SQL statement must contain table and column names of the
data base which will be used.
.br
The INTO clause should not be used in the select statement
because the SOI does not support any access to the INTO clause
variables for the application programmer.  These variables are not
used by the generated fetch operations and thus these variables are
never filled with data base values.
.br
The result values of the select statement are stored in a
language-specific data structure, e.g. a CooL record, which is
returned by the corresponding fetch methods.  The language-specific
data structure consists of components corresponding to the
\f(HOviewSpecification\fP where this \f(HOselectClause\fP is part of.
.sp 0.5
The \f(HOidentifier\fP following the keywords INSERT INTO
represents the table in which data should be inserted.  Optionally in
the \f(HOinsertClause\fP the columns may be denoted in which data
should be inserted.  Denotation of columns is only necessary if the
table consists of more columns than are defined in the view or if the
data should be inserted in a different order than they are defined in
the view.
.br
In SQL insert clauses must have a VALUES specification or a select
statement.  In the SOI this is done by the generator itself.  The
values which will be inserted into the data base are taken out of the
language-specific data structure which has to be an actual parameter
when calling the put method of the language-specific object type.
.sp 0.5
The OPEN WITH clause allows to specify formal parameters which
may be used inside a select statement (e.g. WHERE clause).  These
parameters appear in the signature of the language-specific open
method.  Thus it is possible to qualify a cursor operation at runtime
when the open method is executed, e.g. specifying at run time the
actual value(s) for a predicate.
.br
These parameters must be denoted in the same way as the components of
the view specification.  The names of these parameters have to be
different from the column names in the \f(HOcursorClause\fP.  Inside the
SQL Interface the actual value of each parameter is assigned to a host
variable (see also "Host Variables, Indicator Variables
and Null Values").  This host variable is used to parameterize the
cursor in ESQL/C.
.IP NOTE
In INFORMIX it is possible to define a so-called \&'scroll cursor'.
In other data base systems this kind of cursor specification may not be
supported.  The generator checks whether the used data base system
supports scroll cursors or not.
.br
The SOI supports scroll cursors if the data base system knows such
cursors in case of a \f(HOselectClause\fP and generates it by default.
If the data base system does not support scroll cursors only a 'fetch
next' method is generated.
.br
For 'update cursors' and 'insert cursors' the scroll attribute is
prohibited.  These 'cursors' are used in so-called changeable views.
Changeable views are not allowed to use scroll cursors.  If the
data base programmer specifies an update cursor or an insert cursor the
generator produces a non-scroll cursor by default.
.IP RESTRICTIONS
For so-called changeable views there exist some restrictions for a
select statement.
.in +2
.IP \(bu 3
The ORDER-BY, the GROUP-BY and the HAVING clause and the
attributes DISTINCT and UNIQUE may not be used.
.IP \(bu 3
Set functions may not be used in column selection.
.IP \(bu 3
Only one table may be specified in the FROM  part.
.IP \(bu 3
Scroll cursors may not be used.
.in -2
.KS
.IP EXAMPLES
.CS L
-- 1. A complete example for a view specification of 'Customers'.

VIEW Customers (name        CHAR (20),
                address     CHAR (20),
                customerId  INTEGER,
                priority    INTEGER)
     AS CURSOR              
     FOR SELECT c_name      
                c_address   
                c_id        
                c_priority  FROM customer;
.CE
.KE
This view specification defines a select cursor without update
possibilities.
.br
Thereby, \f(HOCustomers\fP is the name of the generated object type.
.br
\f(HOname...priority\fP denotes the components of the generated
language-specific data structure.
.br
\f(HOcustomer\fP is the name of the table in the data base
.br
while \f(HOc_...\fP are the names of the columns of this relation.
.KS
.IP EXAMPLES
.CS L
-- 2. View specification with a condition parameter.

VIEW Customers (name        CHAR (20),
                address     CHAR (20),
                customerId  INTEGER,
                priority    INTEGER)
     AS CURSOR  OPEN WITH   
               (lowest_prio INTEGER)
     FOR SELECT c_name      
                c_address   
                c_id        
                c_priority  FROM customer
     WHERE      c_priority  > lowest_prio;
.CE
.KE
This cursor specification allows to select a subset of tuples from
\f(HOcustomer\fP.  The actual value of \f(HOlowest_prio\fP is used when
the open method of the object type Customers is performed.
.KS
.IP EXAMPLES
.CS L
--  3. View specification for insert data in customer

VIEW Customers (name        CHAR (20 ),
                address     CHAR (20 ),
                customerId  INTEGER,
                priority    INTEGER)
     AS CURSOR              
     FOR INSERT INTO  customer ( c_name,
                                  c_address,
                                  c_id,
                                  c_priority);
.CE
.KE
This cursor specification allows to insert data into the table
\f(HOcustomer\fP. The \f(HOc_...\fP are the names of the columns of this
relation.
.IP SUMMARY
The data base programmer may specify three kinds of cursors for data
exchange and data manipulation in the description file. These are:
.in +2
.IP \(bu 3
(simple) select cursor
.IP \(bu 3
select cursor for update
.IP \(bu 3
insert cursor
.in -2
.sp 0.5
The generated application programmer interface depends on the given
cursor.
Which methods in a language-specific interface do belong to a 
corresponding cursor specification is described in the chapter 
\&"Application programmer interface".
.LP
.sp 0.5
.NX 3 "SQL Statements"
.sp
SQL provides the possibility to denote SQL clauses not related to a
cursor.  Based on these clauses language-specific routines are
generated.  
.sp 0.5
The following syntax rules show the general structure of
the statement specification in the SQL Object Interface:
.sp 0.5
.in +2
.CS L
\f(HOstatementSpecification\fP ::=
      \f(HBSTATEMENT\fP \f(HOidentifier\fP [ ([ \f(HOstatementParameterList\fP ] ) ] \f(HBIS\fP \f(HOsql_statement_list\fP

\f(HOsqlStatementList\fP ::=
      \f(HOsqlStatement\fP \f(HB;\fP
    | \f(HOsqlStatementList sqlStatement\fP \f(HB;\fP

\f(HOstatementParameterList\fP ::=
      \f(HOmode identifier sqlType\fP
    | \f(HOstatementParameterList\fP \f(HB,\fP \f(HOmode identifier sqlType\fP
.CE
.in -2
.IP DESCRIPTION
In a \f(HOsqlStatement\fP any SQL statement may be used which is allowed
in embedded SQL/C.  The generator produces a language-specific routine
which may be used by the application programmer.  The name of the
routine is identical to the \f(HOidentifier\fP in
\f(HOstatementSpecification\fP.
.br
Parameters may be declared in the \f(HOstatementParameterList\fP.  These
parameters may be used in the SQL statements at any position where
host or indicator variables are allowed but nowhere else.
.sp 0.5
A \f(HOmode\fP may be specified for each parameter: IN, INOUT or INOUT. 
IN corresponds to call-by-value, OUT to call-by-reference, and INOUT to
call-by-value-result.  
The mode can be omitted and as default IN is generated.
.sp 0.5
As mentioned above it is necessary to have procedures available for
the application programmer which perform the connection to the
data base.  The following two statements are suggested to be used at
least.
.KS
.IP EXAMPLES
.CS L
STATEMENT Connect () IS DATABASE myDataBase;
.CE
.KE
.sp 0.5
From this statement a routine is generated which may be used to
realize a connection to the data base.
.br
\f(HOConnect\fP is a suggested name for the routine the application
programmer can use.
.br
\f(HOmyDataBase\fP is the name of the logical data base the application
should work on.
.KS
.IP EXAMPLES
.CS L
STATEMENT Disconnect () IS CLOSE DATABASE;
.CE
.KE
.sp 0.5
From this statement a routine is generated which may be used to
realize a disconnection from the data base.
.br
\f(HODisconnect\fP is a suggested name for the routine the application
programmer can use.
.IP EXAMPLES
The next example shows how parameters may be used in a
\f(HOstatementSpecification\fP.
.KS
.CS L
STATEMENT update_Customers (i_name CHAR(20),
                            i_address CHAR(20),
                            i_customer_id SERIAL,
                            i_priority INTEGER ) IS
         INSERT INTO customer (c_name, c_address, c_id, c_prio )
             VALUES (i_name, i_address, i_customer_id, i_priority);
.CE
.KE
.sp 0.5
From this SQL statement a language-specific routine
\f(HOupdate_Customers\fP will be generated with four IN parameters.  
The parameter types are transformed to the appropriate SQL data types.
The other parts of this example are SQL and not explained here.  
But take care of the significant sequence of i_... and c_... in the 
lines INSERT INTO and VALUES.  
More examples are given in the description of the application 
programmers interface.
.sp
It is possible to specify more than one SQL statement behind the
keyword STATEMENT.  Then each statement must end with a semicolon ";".
.KS
.IP EXAMPLES
.CS L
STATEMENT OpenDatabaseAccess () IS
      DATABASE myDataBase;
      BEGIN WORK;
.CE
.KE
.sp 0.5
From this statement a routine is generated which may be used to realize
a connection to the data base and to start a transaction.
.sp 0.5
\f(HOOpenDatabaseAccess\fP is a suggested name for the routine the
application programmer can use.
.sp 0.5
\f(HOmyDataBase\fP is the name of the logical data base the application
should work on.
.sp
.NX 3 "Host Variables, Indicator Variables and Null Values"
.sp
Host variables and indicator variables are used for accessing data in
a data base system.  In ESQL/C application programs host variables keep
the values of the data base while indicator variables indicates null
values and errors when accessing the data base.  These variables are
not available for the programmer in the SOI, but the SOI realizes a
language-specific representation.
.sp 0.5
Host variables correspond to the parameters of the view part (see "View
Specification") and to the parameters of the cursor statements as well. 
The information of these host and indicator variables are
stored in the components of the language-specific data structure.
.sp 0.5
Indicator variables are used for the language-specific error handling
mechanism, e.g. exception handling in CooL.
.sp 0.5
Null values indicate not filled data entries. 
Any language, the SOI is generated for, must be able to handle these
null values.  CoLibri offers for CooL some routines for null value
handling like check or set null value.  These functions are provided
for each SQL data type (see "SQL-CooL-Data-Types").
.sp
.NX 3 "Token"
.sp
Definitions of rules and tokens which are not explained in the above
chapters are given in the appendix.  It is pure BNF but not difficult
to understand.
.bp
.NX 3 "The SOI Generator"
.sp
The SOI generator \f(HOsqlgen()\fP transforms the contents of the
description file into two compilation units.  One is an application
programming language-specific one (e.g. *.cs and *.ci  in CooL) the 
other is an embedded SQL/C file (*E.ec).  
While the first contains object types, methods and routines the latter 
contains ESQL/C declarations and routines.
.br
Both compilation units must be to compiled with an appropriate
compiler (e.g. cool and esql).  The resulting '.o' files plus the
application object types can be linked together in one application.
.br
The 'E' is used in '*E.ec' to distinguish the resulting '*.o' files
.sp
.IP USAGE
\f(HOsqlgen\fP [options] \f(HOdescriptionfile\fP
.IP INPUT
Exactly one \f(HOdescriptionfile\fP has to be given.  The default
extension of the description file must be '.sql'. The extension can be
omitted in the command line.
.IP OPTIONS
The following options can be used to parameterize the generating process.
.IP "-v"
.br
If this option is set \f(HOsqlgen()\fP produces a protocol file.  The name of
this protocol file is the basename of the inputfile with the extension
'.prt'.
.br
If this option is not set no protocol file is produced.
.IP "-c\ \f(HOdatabasename\fP"
If this option is set the generator checks the specified SQL statements.
If the c option is set \f(HOdatabasename\fP must be given too.
.br
\f(HOdatabasename\fP determines the real data base which
should be used for checking the correctness of the SQL statements.
.br
If the specified data base does not exist \f(HOsqlgen()\fP terminates with an
error message.
.br
If the option is not set no checks will be performed.
.IP "-o\ \f(HOoutputname\fP"
If this option is set \f(HOoutputname\fP is used for the names of the
generated files.  Then \f(HOoutputname\fP gets the extensions '.prt',
\&'E.ec' or e.g. '.cs' and '.ci'.
.br
If the o option is set \f(HOoutputname\fP must be given too.
.br
If this option is not set, the default name \f(HOdescriptionfile\fP is
used for the names of the generated files.  This name gets the
extensions '.prt', 'E.ec' or e.g. '.cs' and '.ci'.
.IP "-l\ \f(HOlanguage\fP"
If this option is set \f(HOlanguage \fP determines the application
programming language for which the generator produces the SOI.
.br
If this option is not set the generator produces a SQL CooL interface.
.IP NOTE
Please refer to the actual release informations for the list
of supported data base systems and supported programming languages.
.KS
.IP OUTPUT
The following files are produced by the SOI generator:
.TS
tab($);
l l l.
\&*E.ec$-$ESQL/C declarations and procedures
\&*.prt$-$protocol file of the generation process
       $-$and the language-specific file types
       $ $which are neccessary for
       $ $defining object types and/or routines 
       $ $ (.cs, .ci for CooL and .h, .c for C++ ).
.TE
.KE
.sp 0.5
In any case the output file names consist of the
\f(HOdescriptionfilename\fP or the \f(HOoutputname\fP and the extensions
described above and the language-specific extensions.
.IP EXAMPLES
.CS L
sqlgen account
.CE
.sp 0.5
The SOI generator generates a SQL-CooL object interface for the data 
base system which is specified in the description file 
\f(HOaccount.sql\fP.  
Three files are generated: \f(HOaccount.cs\fP, \f(HOaccount.ci\fP and 
\f(HOaccountE.ec\fP.
.IP EXAMPLES
.CS L
sqlgen -v -c myDataBase -l C++ account
.CE
.sp 0.5
The SOI generator generates a SQL-C++ object interface for the
data base system which is specified in the description file
\f(HOaccount.sql\fP.  Four files are generated \f(HOaccount.prt\fP,
\f(HOaccount.h\fP, \f(HOaccount.c \fP and \f(HOaccountE.ec\fP.
.br
All SQL statements in \f(HOaccount.sql\fP are checked and detected 
errors are reported.  
The error messages are stored in the '*.prt' file, too.
.LP
.bp
.NX 3 "Restrictions"
.sp
In the current version of INFORMIX the length of an identifier is
limited to 18 characters. If the length of an identifier exceeds this
limit the identifier is truncated (this happens in the esql phase).
The generator \f(HOsqlgen()\fP uses the view names as cursor names 
inside the SQL interface. 
If the view name length is greater than 18 then the first 18 characters 
of the view name are used for the generated cursor name.  
In this case \f(HOsqlgen()\fP reports a warning.  The data base
programmer has to keep this limit in mind for all other identifiers
used in the SQL interface, such as column and table names.
.LP
The names of the view components and parameters must differ from the
names used inside the given SQL statement. The generator does not
check this restriction so the data base programmer has to keep this
restriction in mind. Otherwise this will lead to errors while
compiling the *E.ec file with the ESQL/C processor.
.LP
The SOI supports the following INFORMIX data types: 
.IP \(bu 2
CHAR
.IP \(bu 2
VARCHAR
.IP \(bu 2
INTEGER
.IP \(bu 2
SERIAL
.IP \(bu 2
SMALLINT
.IP \(bu 2
SMALLFLOAT
.IP \(bu 2
FLOAT
.IP \(bu 2
DECIMAL
.IP \(bu 2
MONEY
.IP \(bu 2
DATE
.IP \(bu 2
DATETIME
.IP \(bu 2
INTERVAL
.LP
Values of other types cannot be used directly.
.sp 0.5
If the check option (-c \f(HOdatabasename\fP) is used the denoted SQL
statements are checked using the SQL-PREPARE-statement. This statement
is used to prepare SQL-statements in dynamic SQL. In dynamic SQL not
all statements can be used in the same manner as in static SQL. If a
SQL-statement, which is only possible in static SQL, is checked with
the PREPARE-statement then the generator reports an error. (A typical
statement only possible in static SQL is the DECLARE-statement.)
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'SOI Reference Manual''Application Programmer Interface'"
.EH "'Application Programmer Interface''SOI Reference Manual'"
.NX 1 "Application Programmer Interface"
.sp
The application programmer interface provides the application
programmer with language-specific object types, data structures and
procedures which are generated from the description file.  
The data exchange with the data base takes place mainly by using methods 
of the generated object types.  
The following chapters explain this programming interface i.e. the 
generated object types, methods and routines. 
References to the corresponding part of the description file are given.
.sp 0.5
In the following chapter only the CooL notation is used like \f(HOobject
types\fP, \f(HOmethods\fP, \f(HOprocedures\fP and \f(HOrecords\fP.  
For other languages the reader has to adapt these language terms (e.g. 
C++ : \f(HOclasses\fP, \f(HOfunctions\fP, \f(HOstructs\fP etc.).
.sp
.NX 2 "The generated Language-specific Interface"
.sp
One description file leads to one compilation unit.  
One unit may consist of more than one file, depending on the programming
language for which the interface is generated (e.g. header and 
implementation file).  
For the following explanation it is assumed that there is only one file
containing the whole SQL application programming interface (SQL-API).  
Then this SQL-API is structured as follows:
.sp 0.5
.in +2
.CS L
\f(HOsqlDescriptionFile\fP ::= \f(HOsoiDeclarationList\fP

\f(HOsoiDeclarationList\fP ::= \f(HOsoiDeclaration\fP |
                       \f(HOsoiDeclarationList soiDeclaration\fP

\f(HOsoiDeclaration\fP ::= \f(HOconstantDeclaration\fP |
                   \f(HOdataDeclaration\fP |
                   \f(HOobjectTypeDefinition\fP |
                   \f(HOprocedureDefinition\fP
.CE
.in -2
.sp 0.5
Each \f(HOsoiDeclaration\fP is described in one of the next chapters.
.sp
.NX 3 "ConstantDeclaration"
.sp
This part contains the constant definition which is generated from the
\f(HOconstantDeclaration\fP in the \f(HOsqlDescriptionFile\fP according
to the language-specific syntax.
.sp 0.5
.KS
.IP EXAMPLES
SQL-description:
.CS L
CONST  length  =  5;
CONST  width   =  10;
.CE
.KE
.IP " "
.KS
generated API:
.CS L
CONST  length : INT  =  5;
CONST  width  : INT  =  10;
.CE
.KE
.LP
.sp 0.5
.NX 3 "Data Structure Declaration"
.sp
For each view a data structure is generated (see "View Specification").  
This structure is a record in CooL.  
The following example shows this relation for the VIEW of Customers.
.sp 0.5
.KS
.IP EXAMPLES
.CS L
VIEW  Customers (  name        CHAR   (20 ),
                   address     CHAR   (20 ),
                   customerId  SERIAL,
                   priority    INTEGER);

       AS \f(HOcursorSpecification\fP;


TYPE Customers_R = RECORD      
                      name       : SQLCHAR;
                      address    : SQLCHAR;
                      customerId : SQLSERIAL;
                      priority   : SQLINTEGER;
                   END RECORD;
.CE
.KE
.sp 0.5
This record type is used to define the result type of the fetch
methods and the parameter type of the put and update methods for the
cursor (see "Object Type Definition").  The formal syntax definition
for a record is given in the CooL Reference Manual (see [1]).
.sp 0.5
A record of this type is used for data exchange with the data base.
The application programmer should use a variable of this type to keep
the accessed or updated data.
.br
Before using such a variable it has to be initialized, otherwise an
undefined behaviour of the program may occur.  The SQL-API offers for
each data structure an initialization procedure which should be used
by the application programmer.  The general form of such a procedure
is:
.sp 0.5
.CS L
PROCEDURE init_\f(HOCooLRecordType\fP () : \f(HOCooLRecordType\fP;
.CE
.sp 0.5
Thereby,\f(HOCooLRecordType\fP is replaced by the name of the data
structure generated from the view specification.
.sp 0.5
.IP EXAMPLES
.CS L
PROCEDURE init_Customers_R () : Customers_R;
.CE
.LP
The procedure initializes all record components with type-specific
values.  The following table shows which values are used to initialize
the record components:
.sp 0.5
.TS
tab($)box;
l | l.
component type$value
=
SQLCHAR$""
_
SQLINTEGER$0
_
SQLSERIAL$0
_
SQLSMALLINT$0
_
SQLSMALLFLOAT$0.0
_
SQLFLOAT$0.0
_
SQLDECIMAL$0
_
SQLMONEY$0
_
SQLDATE$actual date
_
SQLDATETIME$actual date and time
_
SQLINTERVAL$0
.TE
.LP
.IP NOTE
The INFORMIX data types CHAR and VARCHAR are both mapped to the
Sql-CooL-Data-Type SQLCHAR.
.LP
.sp 0.5
.NX 3 "Object Type Definition"
.sp
One view, defined in the description file, is represented by one
object type. 
For each object type a set of methods is generated.  
For different cursor types different sets will be generated.  
Three different kinds of DBA-OTs are to distinguish.
.sp 0.5
.IP -
a \f(HOdbaSelectType\fP
.IP -
a \f(HOdbaUpdateType\fP
.IP -
a \f(HOdbaInsertType\fP
.LP
.sp 0.5
These kinds of object types are not totally different.  
There are common features which are described first.  
The following description form is like a reference manual although these
types only exist after generation.  
The names of the types are the names of the views.
The common features are described for \f(HOdbaCommonType\fP. 
Additional features are listed for \f(HOdbaSelectType\fP, 
\f(HOdbaUpdateType\fP and \f(HOdbaInsertType\fP corresponding to the 
three different kinds of DBA-OTs.
.sp 0.5
The names of the selected object types (e.g. InsertCustomers) used in
the following examples are arbitrary.  
The names an application programmer has to use depend on the names of 
the views.
.br
The data structure \f(HOCustomers_R\fP is given in 
\&"Data Structure Declaration".
.LP
.OH "'SOI Reference Manual''<DBA-OT>::INITIALLY'"
.EH "'<DBA-OT>::INITIALLY''SOI Reference Manual'"
.bp
.NX 4 "DbaCommonType"
.sp
.NX 5 "INITIALLY"
.sp
.IP "TYPE"
\f(HB\&'dbaCommonType'\fP
.IP SYNOPSIS
\f(HBINITIALLY : <DBA-OT>;\fP
.IP DESCRIPTION
This 'virtual' type describes all the features which are common to the
other three kinds of DBA object types generated by the SOI Generator.
\&'Virtual' means that this type never exists.
.br
Only one object of a DBA object type is allowed to exist at the same
time.  
.br
The \f(HOINITIALLY\fP method checks whether an object of the current DBA 
object type already exists or not. 
.br
If only one object exists then the execution of the INITIALLY method
continues with the declaration of the corresponding cursor in the
SQL-interface.  This declaration is done by a routine of the generated
SQL interface file (*E.ec).  The application programmer should not use
routines of this file because this leads to errors at runtime.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODBObjectAlreadyExists\fP" 
is raised if such an object already exists.
.IP EXAMPLES
.CS L
VAR my_Customers : Customers::Customers;
\&...
my_Customers := NEW Customers::Customers ();
.CE
.IP "SEE ALSO"
\f(HOClose\fP,
\f(HOFinally\fP,
\f(HOOpen\fP
.LP
.OH "'SOI Reference Manual''<DBA-OT>::Finally'"
.EH "'<DBA-OT>::Finally''SOI Reference Manual'"
.bp
.NX 5 "Finally"
.sp
.IP "TYPE"
\f(HB\&'dbaCommonType'\fP
.IP SYNOPSIS
\f(HBFinally;\fP
.IP DESCRIPTION
The method \f(HOFinally\fP releases the declared cursor and the current
object is deleted and so the application programmer has no access to it
anymore.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODatabaseError\fP" 
is raised in case of a data base error.  
CoLibri offers a global integer variable \f(HOSql_Error\fP to
get more information about this very global behaviour.  
This variable contains the original value of the data base system error 
message.
.IP EXAMPLES
.CS L
VAR my_Customers : Customers::Customers;
\&...
my_Customers := NEW Customers::Customers;
my_Customers.Finally ();
.CE
.IP "SEE ALSO"
\f(HOClose\fP,
\f(HOINITIALLY\fP,
\f(HOOpen\fP,
.LP
.OH "'SOI Reference Manual''<DBA-OT>::Open'"
.EH "'<DBA-OT>::Open''SOI Reference Manual'"
.bp
.NX 5 "Open"
.sp
.IP "TYPE"
\f(HB\&'dbaCommonType'\fP
.IP SYNOPSIS
\f(HBOpen (...);\fP
.IP DESCRIPTION
The method \f(HOOpen\fP opens the corresponding cursor.  
If the cursor (see "Cursor Specification") was specified with 
parameters then the open method has parameters, too.  
With the actual values of the parameters the corresponding select 
statement may be controlled dynamically at run time.  
E.g. if the parameters are used in a 'SQL-WHERE-clause'
only tuples are selected which fullfill the defined condition
with the actual values of these parameters.
.br
The type of each parameter must be a SQL CooL Data Type (see there).
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODatabaseError\fP" 
is raised in case of a data base error.
CoLibri offers a global integer variable \f(HOSql_Error\fP to got more
information about this very global behaviour.  
This variable contains the original value of the data base system error 
message.
.IP EXAMPLES
.CS L
VAR my_Customers : Customers::Customers;
VAR priority     : SqlInteger::SQLSERIAL;
\&...
my_Customers := NEW Customers::Customers;
priority     := SqlInteger::IntToSqlSerial (2);
my_Customers.Open (priority);
\&...
my_Customers.Finally ();
.CE
.IP "SEE ALSO"
\f(HOClose\fP,
\f(HOFinally\fP,
\f(HOINITIALLY\fP
.LP
.OH "'SOI Reference Manual''<DBA-OT>::Close'"
.EH "'<DBA-OT>::Close''SOI Reference Manual'"
.bp
.NX 5 "Close"
.sp
.IP "TYPE"
\f(HB\&'dbaCommonType'\fP
.IP SYNOPSIS
\f(HBClose;\fP
.IP DESCRIPTION
The method \f(HOClose\fP flushes the data base buffer if necessary and 
closes the corresponding cursor.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODatabaseError\fP" 
is raised in case of a data base error.  
CoLibri offers a global integer variable \f(HOSql_Error\fP to get
more information about this very global behaviour.  
This variable contains the original value of the data base system error 
message.
.IP EXAMPLES
.CS L
VAR my_Customers : Customers::Customers;
VAR priority     : SqlInteger::SQLSERIAL;
\&...
my_Customers := NEW Customers::Customers;
priority     := SqlInteger::IntToSqlSerial (2);
my_Customers.Open (priority);
\&...
my_Customers.Close ();
my_Customers.Finally ();
.CE
.IP "SEE ALSO"
\f(HOFinally\fP,
\f(HOINITIALLY\fP,
\f(HOOpen\fP
.OH "'SOI Reference Manual''<DBA-OT>::Fetch_next'"
.EH "'<DBA-OT>::Fetch_next''SOI Reference Manual'"
.LP
.bp
.NX 4 "DbaSelectType"
.sp
Methods of these object types perform read (fetch) operations.  
The number of different fetch methods depends on the used data base 
system.
At least the 'fetch next' operation is supported by every data base
system.  
SOI for INFORMIX supports four fetch operations: next, previous, first, 
last.
.sp
.NX 5 "Fetch_next"
.sp
.IP "TYPE"
\f(HB\&'dbaSelectType'\fP
.IP SYNOPSIS
\f(HBFetch_next () : CooLRecordType;\fP
.IP DESCRIPTION
The method \f(HOFetch_next\fP can be used to get the next row of a view.
If this method was not called before for this object it delivers the 
first row.
Before applying a \f(HOFetch_next\fP method the \f(HOOpen\fP method must
be called otherwise an error will occur.  
To get all rows of an \&'opened view' this method can be called 
repeatedly until no more rows are available.
.br
If no row is available, the exception \f(HODatabaseError\fP is raised.
.IP "RETURN VALUE"
A completely filled \f(HOCooLRecordType\fP is returned which corresponds
to the \f(HOparameterList\fP of the view part of the 
\f(HOviewSpecification\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODatabaseError\fP" 
is raised in case of a data base error \&(e.g. there was no open before 
or no more rows are available).
CoLibri offers a global integer variable \f(HOSql_Error\fP to get more
information about this very global behaviour.  
This variable contains the original value of the data base system error 
message.
.IP EXAMPLES
.CS L
VAR my_Customers : Customers::Customers;
VAR my_cust      : Customers::Customers_R;
VAR priority     : SqlInteger::SQLSERIAL;
\&...
my_Customers := NEW Customers::Customers;
priority     := SqlInteger::IntToSqlSerial (2);
my_Customers.Open (priority);
my_cust      := my_Customers.Fetch_next ();
\&...
my_Customers.Close ();
my_Customers.Finally ();
.CE
.IP "SEE ALSO"
\f(HOFetch_first\fP,
\f(HOFetch_last\fP,
\f(HOFetch_previous\fP,
\f(HOOpen\fP
.OH "'SOI Reference Manual''<DBA-OT>::Fetch_previous'"
.EH "'<DBA-OT>::Fetch_previous''SOI Reference Manual'"
.LP
.bp
.NX 5 "Fetch_previous"
.sp
.IP "TYPE"
\f(HB\&'dbaSelectType'\fP
.IP SYNOPSIS
\f(HBFetch_previous () : CooLRecordType;\fP
.IP DESCRIPTION
The method \f(HOFetch_previous\fP can be used to get the previous row of
a view.  
If no more rows are available an exception is raised.  
.br
This happens in the following cases:
.in +2
.IP \(bu 3
The cursor already points to the first row.
.IP \(bu 3
The cursor points to no row i.e. there were no \f(HOFetch_last()\fP
or no sequence of \f(HOFetch_first()\fP, \f(HOFetch_next()\fP calls 
before.
.LP
.in -2
.IP " "
Before applying a \f(HOFetch_previous\fP method the \f(HOOpen\fP method 
has to be called, otherwise an error will occur.
To get all rows of an 'opened view' this method can be called repeatedly
starting with \f(HOFetch_last\fP until no more rows are available.
.IP "RETURN VALUE"
A completely filled \f(HOCooLRecordType\fP is returned which corresponds
to the \f(HOparameterList\fP of the view part of the 
\f(HOviewSpecification\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODatabaseError\fP" 
is raised in case of a data base error (e.g. there was no open before or
no more row is available).
CoLibri offers a global integer variable \f(HOSql_Error\fP to get more
information about this very global behaviour.
This variable contains the original value of the data base system error 
message.
.IP EXAMPLES
.CS L
VAR my_Customers : Customers::Customers;
VAR my_cust      : Customers::Customers_R;
VAR priority     : SqlInteger::SQLSERIAL;
\&...
my_Customers := NEW Customers::Customers;
priority     := SqlInteger::IntToSqlSerial (2);
my_Customers.Open (priority);
my_cust      := my_Customers.Fetch_last ();
my_cust      := my_Customers.Fetch_previous ();
\&...
my_Customers.Close ();
my_Customers.Finally ();
.CE
.IP "SEE ALSO"
\f(HOFetch_first\fP,
\f(HOFetch_last\fP,
\f(HOFetch_next\fP,
\f(HOOpen\fP
.LP
.OH "'SOI Reference Manual''<DBA-OT>::Fetch_first'"
.EH "'<DBA-OT>::Fetch_first''SOI Reference Manual'"
.bp
.NX 5 "Fetch_first"
.sp
.IP "TYPE"
\f(HB\&'dbaSelectType'\fP
.IP SYNOPSIS
\f(HBFetch_first () : CooLRecordType;\fP
.IP DESCRIPTION
The method \f(HOFetch_first\fP can be used to get the first row of a 
view.  
If no row is available an exception is raised.
This happens if no row is available at all.
.br 
Before applying a \f(HOFetch_first\fP method the \f(HOOpen\fP method has
to be called, otherwise an error will occur.
.IP "RETURN VALUE"
A completely filled \f(HOCooLRecordType\fP is returned which corresponds
to the \f(HOparameterList\fP of the view part of the 
\f(HOviewSpecification\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODatabaseError\fP" 
is raised in case of a data base error (e.g. there was no open before or
no row is available).
CoLibri offers a global integer variable \f(HOSql_Error\fP to get more
information about this very global behaviour.  
This variable contains the original value of the data base system error 
message.
.IP EXAMPLES
.CS L
VAR my_Customers : Customers::Customers;
VAR my_cust      : Customers::Customers_R;
VAR priority     : SqlInteger::SQLSERIAL;
\&...
my_Customers := NEW Customers::Customers;
priority     := SqlInteger::IntToSqlSerial (2);
my_Customers.Open (priority);
my_cust      := my_Customers.Fetch_first ();
\&...
my_Customers.Close ();
my_Customers.Finally ();
.CE
.IP "SEE ALSO"
\f(HOFetch_last\fP,
\f(HOFetch_next\fP,
\f(HOFetch_previous\fP,
\f(HOOpen\fP
.LP
.OH "'SOI Reference Manual''<DBA-OT>::Fetch_last'"
.EH "'<DBA-OT>::Fetch_last''SOI Reference Manual'"
.bp
.NX 5 "Fetch_last"
.sp
.IP "TYPE"
\f(HB\&'dbaSelectType'\fP
.IP SYNOPSIS
\f(HBFetch_last () : CooLRecordType;\fP
.IP DESCRIPTION
The method \f(HOFetch_last\fP can be used to get the last row of a view.
If no row is available an exception is raised.  
This happens if no row is available at all.
.br
Before applying a \f(HOFetch_last\fP method the \f(HOOpen\fP method has 
to be called, otherwise an error will occur.
.IP "RETURN VALUE"
A completely filled \f(HOCooLRecordType\fP is returned which corresponds
to the \f(HOparameterList\fP of the view part of the 
\f(HOviewSpecification\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODatabaseError\fP" 
is raised in case of a data base error (e.g. there was no open before or
no row is available).
CoLibri offers a global integer variable \f(HOSql_Error\fP to get more
information about this very global behaviour.  
This variable contains the original value of the data base system error 
message.
.IP EXAMPLES
.CS L
VAR my_Customers : Customers::Customers;
VAR my_cust      : Customers::Customers_R;
VAR priority     : SqlInteger::SQLSERIAL;
\&...
my_Customers := NEW Customers::Customers;
priority     := SqlInteger::IntToSqlSerial (2);
my_Customers.Open (priority);
my_cust      := my_Customers.Fetch_last ();
\&...
my_Customers.Close ();
my_Customers.Finally ();
.CE
.IP "SEE ALSO"
\f(HOFetch_first\fP,
\f(HOFetch_next\fP,
\f(HOFetch_previous\fP,
\f(HOOpen\fP
.LP
.OH "'SOI Reference Manual''<DBA-OT>::Update'"
.EH "'<DBA-OT>::Update''SOI Reference Manual'"
.bp
.NX 4 "DbaUpdateType"
.sp
Object types of this type support updates or deletions of existing rows.
In contrast to types of \f(HOdbaSelectType\fP it is not possible that a
\f(HOdbaUpdateType\fP operates on rows with columns of different tables.
.sp
.NX 5 "Update"
.sp
.IP "TYPE"
\f(HB\&'dbaUpdateType'\fP
.IP SYNOPSIS
\f(HBUpdate ( IN row : CooLRecordType );\fP
.IP DESCRIPTION
The method \f(HOUpdate\fP can be used to change the contents of one row.
.br
Before calling this method an object of type \f(HOdbaUpdateType\fP has
to be created and the \f(HOOpen\fP method has to be called, otherwise an
error will occur.
.br
\f(HORow\fP is a \f(HOCooLRecordType\fP which is generated from the
\f(HOparameterList\fP of the view part of the \f(HOviewSpecification\fP.
This parameter should comprise the values for updating the row.
.br
As mentioned above it is necessary that the given \f(HOselectClause\fP
works only on columns of one table.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODatabaseError\fP" 
is raised in case of a data base error (e.g. there was no open before).
CoLibri offers a global integer variable \f(HOSql_Error\fP to get more 
information about this very global behaviour.  
This variable contains the original value of the data base system error 
message.
.IP EXAMPLES
.CS L
CONST NAME_LENGTH :  INT =  20;
\&...
VAR my_Customers  : Customers::UpdateCustomers;
VAR my_cust       : Customers::Customers_R;
VAR my_cust_id    : SqlInteger::SQLINTEGER;
\&...
my_cust_id        := SqlInteger::IntToSqlInteger (4812);
my_Customers      := NEW Customers::UpdateCustomers;
my_Customers.Open( my_cust_id );
my_cust           := my_Customers.Fetch_next ();
my_cust.address := SqlChar::SqlChar ("New York",10);
my_Customers.Update (my_cust);
.CE
.IP "SEE ALSO"
\f(HOFetch_next\fP,
\f(HOOpen\fP 
.OH "'SOI Reference Manual''<DBA-OT>::Delete'"
.EH "'<DBA-OT>::Delete''SOI Reference Manual'"
.LP
.bp
.NX 5 "Delete"
.sp
.IP "TYPE"
\f(HB\&'dbaUpdateType'\fP
.IP SYNOPSIS
\f(HBDelete;\fP
.IP DESCRIPTION
The method \f(HODelete\fP can be used to delete one row of a table.
.br
Before calling this method an object of type \f(HOdbaUpdateType\fP has
to be created and then the \f(HOOpen\fP method has to be called, 
otherwise an error will occur.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODatabaseError\fP" 
is raised in case of a data base error (e.g. there was no open before).
CoLibri offers a global integer variable \f(HOSql_Error\fP to get more 
information about this very global behaviour.  
This variable contains the original value of the data base system error 
message.
.IP EXAMPLES
.CS L
CONST NAME_LENGTH : INT = 20;
\&...
VAR my_Customers  : Customers::UpdateCustomers;
VAR my_cust       : Customers::Customers_R;
VAR my_cust_id    : SqlInteger::SQLINTEGER;
\&...
my_Customers      := NEW Customers::UpdateCustomers ;
my_cust_id        := SqlInteger::IntToSqlInteger (4812);
my_Customers.Open (my_cust_id);
my_cust           := my_Customers.Fetch_next ();
my_Customers.Delete (); -- delete current row
.CE
.IP "SEE ALSO"
\f(HOFetch_next\fP,
\f(HOOpen\fP
.LP
.OH "'SOI Reference Manual''<DBA-OT>::Put'"
.EH "'<DBA-OT>::Put''SOI Reference Manual'"
.bp
.NX 4 "DbaInsertType"
.sp
Object types of this type support inserting new rows in one table.
In contrast to types of \f(HOdbaSelectType\fP it is not possible that a
row consists of columns of different tables.
.sp
.NX 5 "Put"
.sp
.IP "TYPE"
\f(HB\&'dbaInsertType'\fP
.IP SYNOPSIS
\f(HBPut ( IN row : CooLRecordType );\fP
.IP DESCRIPTION
The method \f(HOPut\fP can be used to insert a new row into a table.
.br
Before calling this method an object of type \f(HOdbaInsertType\fP has
to be created and the \f(HOOpen\fP method has to be called, otherwise an
error will occur.
.br
\f(HORow\fP is of \f(HOCooLRecordType\fP generated from the
\f(HOparameterList\fP of the view part of the \f(HOviewSpecification\fP.
This parameter should comprise the values for updating the row.
.br
As mentioned above it is only possible to insert columns of one table.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODatabaseError\fP" 
is raised in case of a data base error (e.g. there was no open before).
CoLibri offers a global integer variable \f(HOSql_Error\fP to get more 
information about this very global behaviour.  
This variable contains the original value of the data base system error 
message.
.IP EXAMPLES
.CS L
CONST NAME_LENGTH : INT = 20;
\&...
VAR my_Customers  : Customers::InsertCustomers;
VAR my_cust       : Customers::Customers_R;
\&...
my_Customers      := NEW Customers::InsertCustomers;
my_Customers.Open ();
my_cust           := Customers::init_Customers_R ();
my_cust.name      := SqlChar::SqlChar ("Smith", 10);
my_cust.address   := SqlChar::SqlChar ("New York",10);
my_Customers.Put (my_cust);
.CE
.IP "SEE ALSO"
\f(HOOpen\fP
.LP
.OH "'SOI Reference Manual''<DBA-OT>::Flush'"
.EH "'<DBA-OT>::Flush''SOI Reference Manual'"
.bp
.NX 5 "Flush"
.sp
.IP "TYPE"
\f(HB\&'dbaInsertType'\fP
.IP SYNOPSIS
\f(HBFlush;\fP
.IP DESCRIPTION
The method \f(HOFlush\fP is used to write the contents of the view  
buffer into the data base.  
A flush is done automatically when the \f(HOClose\fP method is called 
for a cursor of this kind.
.br
Before calling this method an object of type \f(HOdbaInsertType\fP has
to be created and the \f(HOOpen\fP method has to be called, otherwise an
error will occur.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODatabaseError\fP"
is raised in case of a data base error (e.g. there was no open before).
CoLibri offers a global integer variable \f(HOSql_Error\fP to get more 
information about this very global behaviour.  
This variable contains the original value of the data base system error 
message.
.IP EXAMPLES
.CS L
CONST NAME_LENGTH : INT = 20;
\&...
VAR my_Customers      : Customers::InsertCustomers;
VAR my_cust           : Customers::Customers_R;
\&...
my_Customers      := NEW Customers::InsertCustomers;
my_Customers.Open ();
my_cust           := Customers::init_Customers_R ();
my_cust.name      := SqlChar::SqlChar ("Smith", 10);
my_cust.address   := SqlChar::SqlChar ("New York",10);
my_Customers.Put (my_cust);
my_Customers.Flush ();
my_cust.name      := SqlChar::SqlChar ("Baker", 10);
my_cust.address   := SqlChar::SqlChar ("Hollywood", 10);
my_Customers.Put (my_cust);
my_Customers.Close ();
.CE
.IP "SEE ALSO"
\f(HOOpen\fP,
\f(HOPut\fP
.LP
.OH "'SOI Reference Manual''Application Programmer Interface'"
.EH "'Application Programmer Interface''SOI Reference Manual'"
.bp
.NX 3 "Procedure Definition"
.sp
For each \f(HOstatementSpecification\fP a procedure is generated. The
following example shows the relation between a
\f(HOstatementSpecification\fP in the \f(HOsqlDescriptionFile\fP and the
generated language-specific procedure.
.sp 0.5
.KS
.IP EXAMPLES
.CS L
STATEMENT OpenDatabaseAccess() IS
       DATABASE myDataBase;
       BEGIN WORK;

PROCEDURE OpenDatabaseAccess()
DO
    Sql_Error := SQL_OpenDatabaseAccess();
    IF Sql_Error <> 0 THEN RAISE DatabaseError;
    END IF;
END DO;
.CE
.KE
.LP
The procedure \f(HOSQL_OpenDatabaseAccess\fP is an ESQL/C routine which
performs the defined SQL operations given in the
\f(HOstatementSpecification\fP. This SQL routine returns always an error
code. This error code is stored into the variable \f(HOSql_Error\fP. If
the error code is not equal zero then the exception
\f(HODatabase_Error\fP is raised.
.LP
The application programmer does not use the SQL routines directly
because this leads to errors.
.LP
If the \f(HOstatementSpecification\fP has parameters the generated
language-specific procedure has parameters too. The specified mode for
the parameters is also generated in the language-specific routine, so
parameters which were defined with mode \f(HOOUT\fP in the
\f(HOstatementSpecification\fP have in the language-specific routine
mode \f(HOOUT\fP too. The following example shows a parameterized
\f(HOstatementSpecification\fP and the corresponding language-specific
procedure.
.LP
.KS
.IP EXAMPLES
.CS L
STATEMENT update_Customers (i_name CHAR(20),
                            i_address CHAR(20),
                            i_customer_id SERIAL,
                            i_priority INTEGER ) IS
         INSERT INTO customer (c_name, c_address, c_id, c_prio )
             VALUES (i_name, i_address, i_customer_id, i_priority);


PROCEDURE update_Customers (IN i_name : SQLCHAR,
                            IN i_address : SQLCHAR,
                            IN i_customer_id : SQLSERIAL,
                            IN i_priority : SQLINTEGER )
DO
    Sql_Error := SQL_update_Customer (i_name, 
                                      i_address,
                                      i_customer_id,
                                      i_priority);
    IF Sql_Error <> 0 THEN RAISE DatabaseError;
    END IF;
END DO;
.CE
.KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'SOI Reference Manual''SQL-CooL-Data-Types'"
.EH "'SQL-CooL-Data-Types''SOI Reference Manual'"
.NX 1 "SQL-CooL-Data-Types"
.sp
.NX 2 "General Description of SQL-CooL-Data-Types"
.sp
Using the CoLibri it is possible to connect a relational data base with 
an application program written in CooL.
The data interface between the application and the data base is a set of
SQL-CooL-Data-Types.
Using them the programmer is able to handle data which were retrieved 
from the relational data base.
.sp 0.5
These SQL-CooL-Data-Types are derived from the SQL-Data-Types which are 
defined by the data base system itself.
Together with the data types a rich set of operations working on them is
offered by the data base system.
Both - data types and operations - are part of the interface of the data
base system which is provided in ESQL/C.
The purpose of the SQL-CooL-Data-Types provided by the CoLibri is to 
encapsulate this part of the ESQL/C interface in a CooL oriented-manner.
.sp 0.5
The CooL interface is restricted to those data types which are defined 
in standard SQL.
In addition to the operations defined by the data base system itself the
CooL interface offers a set of functions for initializing the 
SQL-CooL-Data-Types and a set of converting routines for the 
transformation of SQL-CooL-Data-Types into CooL-Data-Types defined by 
the CooL library CoLibri like Date, Time, String, etc. and vice versa.
.sp 0.5
In a first step the relational data base system INFORMIX release V4.0 
will be connected.
.bp
.NX 2 "Programming Interface of the SQL-CooL-Data-Types"
.sp
SOI supports the following SQL-Data-Types with a corresponding
SQL-CooL-Data-Type for each of them.
.LP
.KS
.TS
center box tab (#);
l1 | l.
SQL-Data-Type#SQL-CooL-Data-Type
=
CHARACTER#SQLCHAR
_
VARCHAR#SQLCHAR
_
SMALLINT#SQLSMALLINT
_
INTEGER#SQLINTEGER
_
SERIAL#SQLSERIAL
_
SMALLFLOAT#SQLSMALLFLOAT
_
FLOAT#SQLFLOAT
_
DECIMAL#SQLDECIMAL
_
MONEY#SQLMONEY
_
DATE#SQLDATE
_
DATETIME#SQLDATETIME
_
INTERVAL#SQLINTERVAL
_
.TE
.KE
.LP
The functions working on each of these types are the programming
interfaces of these SQL-CooL-Data-Types.
There functionalities are described in the following sections.
In each section the functions are listed in an alphabetical order.
.sp 0.5
For further information about the mapped SQL-Data-Types and the mapped
operations working on them one has to read the documentation of the 
relational data base system INFORMIX release V4.0 itself.
.bp
.NX 3 "The SQL-CooL-Data-Type SQLCHAR"
.sp
To work with the SQL-CooL-Data-Type SQLCHAR one has to declare at least
one variable of this type:
.sp 0.5
.CS L
VAR My_Sql_Char : SqlChar::SQLCHAR;
.CE
.sp 0.5
This SQL-CooL-Data-Type is used to contain values of the SQL-Data-Type
CHARACTER as well as values of the SQL-Data-Type VARCHAR.
.br
Since the corresponding SQL-Data-Types can have different lengths, this 
variable must be initialized by providing the length of the 
corresponding SQL-Data-Type.
This can be done with the procedures \f(HOSqlChar\fP or 
\f(HOSqlVarChar\fP or by assigning an initialized variable of type 
SQLCHAR to it.
.sp 0.5
In case of CHARACTER as corresponding SQL-Data-Type of the 
SQL-CooL-Data-Type SQLCHAR although the other SQL-Data-Types STRING and
FIXCHAR of the data base system INFORMIX are supported.
In case of VARCHAR STRING is supported too.
In every case a transformation between the SQL-Data-Types and SQLCHAR 
will be done automatically.
.sp 0.5
A variable of the type SQLCHAR can be manipulated by the following set 
of functions.
.sp 0.5
One can get more functionality by transforming this data type into the 
data type STRING which is provided by the CoLibri too.
.LP
.OH "'SOI Reference Manual''SqlChar::getSqlCharLength'"
.EH "'SqlChar::getSqlCharLength''SOI Reference Manual'"
.bp
.NX 4 "getSqlCharLength"
.sp
.IP MODULE
\f(HBSqlChar\fP
.IP TYPE
\f(HBSQLCHAR\fP
.IP SYNOPSIS
\f(HBPROCEDURE getSqlCharLength ( IN sql_char : SQLCHAR ) : INT;\fP
.IP DESCRIPTION
The function \f(HOgetSqlCharLength\fP can be used to get the length of 
the input variable \f(HOsql_char\fP as it was defined using the function
\f(HOSqlChar\fP.
.IP "RETURN VALUE"
The result of this function call is the length of the input variable
\f(HOsql_char\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_char\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_char      : SqlChar::SQLCHAR;
VAR sql_char_length : INT;
\&...
a_sql_char := SqlChar::SqlChar ("", 100);
-- \f(HOa_sql_char was initialized with a length of 100 characters,\fP
-- \f(HObut no contents.\fP
\&...
sql_char_length := SqlChar::getSqlCharLength (a_sql_char);
.CE
.KE
Now sql_char_length contains the value "100".
.IP "SEE ALSO"
\f(HOSqlChar\fP,
\f(HOSqlVarChar\fP
.LP
.OH "'SOI Reference Manual''SqlChar::isSqlCharEqualNull'"
.EH "'SqlChar::isSqlCharEqualNull''SOI Reference Manual'"
.bp
.NX 4 "isSqlCharEqualNull"
.sp
.IP MODULE
\f(HBSqlChar\fP
.IP TYPE
\f(HBSQLCHAR\fP
.IP SYNOPSIS
\f(HBPROCEDURE isSqlCharEqualNull ( IN sql_char : SQLCHAR ) : BOOL;\fP
.IP DESCRIPTION
The function \f(HOisSqlCharEqualNull\fP can be used to check if the 
input variable \f(HOsql_char\fP of type SQLCHAR contains the null value.
.IP "RETURN VALUE"
The result of this function call is the boolean value
.in +2
.IP "TRUE        "
if the input variable \f(HOsql_char\fP contains the null value.
.IP "FALSE       "
if the input variable \f(HOsql_char\fP does not contain the null value.
.in -2
.KS
.IP EXAMPLES
.CS L
VAR a_sql_char : SqlChar::SQLCHAR;
\&...
a_sql_char := SqlChar::SqlChar ("", 100);
-- \f(HOa_sql_char was initialized with a length of 100 characters,\fP
-- \f(HObut no contents.\fP
\&...
IF   SqlChar::isSqlCharEqualNull (a_sql_char)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_char\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOsetSqlCharToNull\fP
.LP
.OH "'SOI Reference Manual''SqlChar::setSqlCharToNull'"
.EH "'SqlChar::setSqlCharToNull''SOI Reference Manual'"
.bp
.NX 4 "setSqlCharToNull"
.sp
.IP MODULE
\f(HBSqlChar\fP
.IP TYPE
\f(HBSQLCHAR\fP
.IP SYNOPSIS
\f(HBPROCEDURE setSqlCharToNull ( INOUT sql_char : SQLCHAR );\fP
.IP DESCRIPTION
The function \f(HOsetSqlCharToNull\fP can be used to set the variable 
\f(HOsql_char\fP to the null value.
.IP NOTE
If one wants to reset a variable of type SQLCHAR to "normal values" 
again, one can do this by calling the function \f(HOStringToSqlChar\fP.
It is not necessary to initialize the variable again by calling the 
functions \f(HOSqlChar\fP or \f(HOSqlVarChar\fP.
This has to be done only before using this variable for the first time.
.br
Only if one wants to use the variable with a new length, one has to call
the functions \f(HOSqlChar\fP or \f(HOSqlVarChar\fP instead.
.IP "RETURN VALUE"
The result of this procedure call is the variable \f(HOsql_char\fP which
contains the null value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_char : SqlChar::SQLCHAR;
\&...
a_sql_char := SqlChar::SqlChar ("", 100);
-- \f(HOa_sql_char was initialized with a length of 100 characters,\fP
-- \f(HObut no contents.\fP
\&...
IF   SqlChar::isSqlCharEqualNull (a_sql_char)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_char\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
SqlChar::setSqlCharToNull (a_sql_char);
IF   SqlChar::isSqlCharEqualNull (a_sql_char)
THEN
     -- \f(HONow execution continues here.\fP
ELSE
     ...
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOisSqlCharEqualNull\fP
.OH "'SOI Reference Manual''SqlChar::SqlChar'"
.EH "'SqlChar::SqlChar''SOI Reference Manual'"
.LP
.bp
.NX 4 "SqlChar"
.sp
.IP MODULE
\f(HBSqlChar\fP
.IP TYPE
\f(HBSQLCHAR\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE SqlChar $($ IN string $ : STRING,
$$ IN length $ : INT )
$:$ SQLCHAR;$\fP
.TE
.IP DESCRIPTION
The function \f(HOSqlChar\fP has to be used to initialize a variable of 
type SQLCHAR with a length of \f(HOlength\fP characters.
Additionally the result will be filled with a literal or a string 
if the first input parameter \f(HOstring\fP has an actual length greater
than zero.
.IP "RETURN VALUE"
The result of this function call is an initialized variable of type
SQLCHAR.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOLengthOfStringIsZero\fP"
is raised, if the value of the second parameter \f(HOlength\fP is less 
than one.
.IP "\(bu \f(HOMaxSqlCharLengthExceeded\fP"
is raised, if the value of the second parameter \f(HOlength\fP is 
greater than the maximum length allowed for a variable of the 
SQL-Data-Type \f(HOCHARACTER\fP (see the documentation of the
relational data base system INFORMIX).
.IP "\(bu \f(HOStringIsTooLarge\fP"
is raised, if the actual length of the first parameter \f(HOstring\fP is
greater than the second parameter \f(HOlength\fP.
This exception will only be raised if the input parameter \f(HOstring\fP has
an actual length greater than zero.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_char : SqlChar::SQLCHAR;
VAR a_string   : STRING;
\&...
a_string   := "This is a test";
a_sql_char := SqlChar::SqlChar (a_string, 100);
.CE
.KE
a_sql_char was initialized with a length of 100 characters
and the contents "This is a test".
Additionally it was set to "not null".
.OH "'SOI Reference Manual''SqlChar::SqlCharToString'"
.EH "'SqlChar::SqlCharToString''SOI Reference Manual'"
.LP
.bp
.NX 4 "SqlCharToString"
.sp
.IP MODULE
\f(HBSqlChar\fP
.IP TYPE
\f(HBSQLCHAR\fP
.IP SYNOPSIS
\f(HBPROCEDURE SqlCharToString ( IN sql_char : SQLCHAR ) : STRING;\fP
.IP DESCRIPTION
The function \f(HOSqlCharToString"\fP can be used to convert the input 
variable \f(HOsql_char\fP of type SQLCHAR to a variable of type STRING.
Final blanks will not be transferred.
.IP "RETURN VALUE"
The result of this function call is the STRING representation of
the input variable \f(HOsql_char\fP of type SQLCHAR.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_char\fP contains the null 
value.
.IP "\(bu \f(HOStringIsTooLarge\fP" 
is raised, if the actual length of the input parameter \f(HOsql_char\fP 
is greater than the maximum length allowed for a variable of type 
STRING.
Final blanks are not counted.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_char : SqlChar::SQLCHAR;
VAR a_string   : STRING;
\&...
a_sql_char := SqlChar::SqlChar ("This is a test", 100);
-- \f(HOa_sql_char was initialized with a length of 100 characters\fP
-- \f(HOand the contents "This is a test".\fP
\&...
a_string := SqlChar::SqlCharToString (a_sql_char);
.CE
.KE
Now a_string contains the string "This is a test" also.
.IP "SEE ALSO"
\f(HOStringToSqlChar\fP
.OH "'SOI Reference Manual''SqlChar::SqlVarChar'"
.EH "'SqlChar::SqlVarChar''SOI Reference Manual'"
.LP
.bp
.NX 4 "SqlVarChar"
.sp
.IP MODULE
\f(HBSqlChar\fP
.IP TYPE
\f(HBSQLCHAR\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE SqlVarChar $($ IN string $ : STRING,
$$ IN max_length $ : INT,
$$ IN min_length $ : INT )
$:$ SQLCHAR;$\fP
.TE
.IP DESCRIPTION
The function \f(HOSqlVarChar\fP has to be used to initialize a variable 
of type SQLCHAR with a maximum length of \f(HOmax_length\fP characters
and a minimum length of \f(HOmin_length\fP characters.
Additionally the result will be filled with a literal or a string 
if the first input parameter \f(HOstring\fP has an actual length greater
than zero.
.br
The input parameter \f(HOmin_length\fP is tested but not used 
actually.
.IP "RETURN VALUE"
The result of this function call is an initialized variable of type
SQLCHAR.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOLengthOfStringIsZero\fP"
is raised, if the value of the second parameter \f(HOmax_length\fP is 
less than one.
.IP "\(bu \f(HOMaxLengthIsSmallerThanMinLength\fP"
is raised, if the value of the minimum length is greater than the value
of the maximum length.
.IP "\(bu \f(HOMaxSqlVarCharLengthExceeded\fP"
is raised, if the value of the second parameter \f(HOmax_length\fP is 
greater than the maximum length allowed for a variable of the 
SQL-Data-Type \f(HOVARCHAR\fP (see the documentation of the
relational data base system INFORMIX).
.IP "\(bu \f(HOMinLengthIsLessThanZero\fP"
is raised, if the value of the minimum length is smaller then zero.
.IP "\(bu \f(HOStringIsTooLarge\fP"
is raised, if the actual length of the first parameter \f(HOstring\fP is
greater than the second parameter \f(HOmax_length\fP.
This exception will only be raised if the input parameter \f(HOstring\fP has
an actual length greater than zero.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_char : SqlChar::SQLCHAR;
VAR a_string   : STRING;
\&...
a_string   := "This is a test";
a_sql_char := SqlChar::SqlVarChar (a_string, 100, 0);
.CE
.KE
a_sql_char was initialized with a maximum length of 100 
characters, a minimum length of 0 characters and the contents "This is a
test".
Additionally it was set to "not null".
.OH "'SOI Reference Manual''SqlChar::StringToSqlChar'"
.EH "'SqlChar::StringToSqlChar''SOI Reference Manual'"
.bp
.NX 4 "StringToSqlChar"
.sp
.IP MODULE
\f(HBSqlChar\fP
.IP TYPE
\f(HBSQLCHAR\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE StringToSqlChar ($ IN $ string $ : STRING,
$ INOUT $ sql_char $ : SQLCHAR );\fP
.TE
.IP DESCRIPTION
The procedure \f(HOStringToSqlChar\fP can be used to convert the input 
variable \f(HOstring\fP of type STRING to the variable \f(HOsql_char\fP
of type SQLCHAR.
The input parameter \f(HOstring\fP has to contain at least one character.
All characters will be transferred until the actual length of it is 
reached.
.IP "RETURN VALUE"
The result of this procedure call is the SQLCHAR representation 
of the input variable \f(HOstring\fP of type STRING.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOLengthOfStringIsZero\fP"
is raised, if the actual length of the input parameter \f(HOstring\fP is
zero.
.IP "\(bu \f(HOStringIsTooLarge\fP" 
is raised, if the actual length of the input parameter \f(HOstring\fP is
greater than the length defined for \f(HOsql_char\fP using the function
\f(HOSqlChar\fP.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_char : SqlChar::SQLCHAR;
VAR a_string   : STRING;
\&...
a_sql_char := SqlChar::SqlChar ("This is a test", 100);
-- \f(HOa_sql_char was initialized with a length of 100 characters\fP
-- \f(HOand the contents "This is a test".\fP
\&...
a_string := SqlChar::SqlCharToString (a_sql_char);
-- \f(HONow a_string contains the string "This is a test" also.\fP
a_string := String::ToUpper (a_string);
SqlChar::StringToSqlChar (a_string, a_sql_char);
.CE
.KE
Now a_sql_char contains the string "THIS IS A TEST".
.IP "SEE ALSO"
\f(HOSqlCharToString\fP
.LP
.OH "'SOI Reference Manual''SqlChar'"
.EH "'SqlChar''SOI Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOSqlChar\fP.
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
getSqlCharLength$IN$sql_char$SQLCHAR$ValueIsNull
$result$$INT$
_
isSqlCharEqualNull$IN$sql_char$SQLCHAR$
$result$$BOOL$
_
setSqlCharToNull$INOUT$sql_char$SQLCHAR$
_
SqlChar$IN$string$STRING$LengthOfStringIsZero
$IN$length$INT$MaxSqlCharLengthExceeded
$result$$SQLCHAR$StringIsTooLarge
_
SqlCharToString$IN$sql_char$SQLCHAR$ValueIsNull
$result$$STRING$StringIsTooLarge
_
SqlVarChar$IN$string$STRING$LengthOfStringIsZero
$IN$max_length$INT$MaxLengthIsSmallerThanMinLength
$IN$min_length$INT$MaxSqlVarCharLengthExceeded
$result$$SQLCHAR$MinLengthIsLessThanZero
$$$$StringIsTooLarge
_
StringToSqlChar$IN$string$STRING$LengthOfStringIsZero
$INOUT$sql_char$SQLCHAR$StringIsTooLarge
.TE
.NL
.nr PS 12
.LP
.OH "'SOI Reference Manual''SQL-CooL-Data-Types'"
.EH "'SQL-CooL-Data-Types''SOI Reference Manual'"
.bp
.NX 3 "The SQL-CooL-Data-Type SQLSMALLINT"
.sp
For working with the SQL-CooL-Data-Type SQLSMALLINT one has to 
declare at least one variable of this type:
.LP
.CS L
VAR my_sql_smallint : SqlInteger::SQLSMALLINT;
.CE
.LP
A variable of the type SQLSMALLINT can be manipulated by the 
following set of functions.
.sp 0.5
One can get more functionality by transforming this data type into the 
data type INT of CooL and then using the provided built-in 
functions.
.LP
.OH "'SOI Reference Manual''SqlInteger::IntToSqlSmallint'"
.EH "'SqlInteger::IntToSqlSmallint''SOI Reference Manual'"
.bp
.NX 4 "IntToSqlSmallint"
.sp
.IP MODULE
\f(HBSqlInteger\fP
.IP TYPE
\f(HBSQLSMALLINT\fP
.IP SYNOPSIS
\f(HBPROCEDURE IntToSqlSmallint ( IN integer : INT ) : SQLSMALLINT;\fP
.IP DESCRIPTION
The function \f(HOIntToSqlSmallint\fP can be used to convert an integer 
value to a value of type SQLSMALLINT.
.IP "RETURN VALUE"
The result of this function call is the SQLSMALLINT 
representation of the integer value.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsOutOfRange\fP"
is raised, if the value of the input parameter \f(HOinteger\fP is 
greater or smaller than the maximum/minimum values
allowed for a variable of the SQL-Data-Type SMALLINT (see the
documentation of the relational data base system INFORMIX).
.KS
.IP EXAMPLES
.CS L
VAR an_integer     : INT;
VAR a_sql_smallint : SqlInteger::SQLSMALLINT;
\&...
an_integer := 13;
a_sql_smallint := SqlInteger::IntToSqlSmallint (an_integer);
.CE
.KE
After this assignment a_sql_smallint contains the value "13".
.IP "SEE ALSO"
\f(HOSqlSmallintToInt\fP
.LP
.OH "'SOI Reference Manual''SqlInteger::isSqlSmallintEqualNull'"
.EH "'SqlInteger::isSqlSmallintEqualNull''SOI Reference Manual'"
.bp
.NX 4 "isSqlSmallintEqualNull"
.sp
.IP MODULE
\f(HBSqlInteger\fP
.IP TYPE
\f(HBSQLSMALLINT\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE isSqlSmallintEqualNull $( IN sql_smallint : SQLSMALLINT )
$: BOOL;\fP
.TE
.IP DESCRIPTION
The function \f(HOisSqlSmallintEqualNull\fP can be used to check if the 
input variable \f(HOsql_smallint\fP of type SQLSMALLINT contains
the null value.
.IP "RETURN VALUE"
The result of this function call is the boolean value
.in +2
.IP "TRUE        "
if the input variable \f(HOsql_smallint\fP contains the null value.
.IP "FALSE       "
if the input variable \f(HOsql_smallint\fP does not contain the null 
value.
.in -2
.KS
.IP EXAMPLES
.CS L
VAR a_sql_smallint : SqlInteger::SQLSMALLINT;
\&...
a_sql_smallint := SqlInteger::IntToSqlSmallint (0);
-- \f(HOa_sql_smallint was initialized with a value of "0".\fP
\&...
IF   SqlInteger::isSqlSmallintEqualNull (a_sql_smallint)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_smallint\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOsetSqlSmallintToNull\fP
.LP
.OH "'SOI Reference Manual''SqlInteger::setSqlSmallintToNull'"
.EH "'SqlInteger::setSqlSmallintToNull''SOI Reference Manual'"
.bp
.NX 4 "setSqlSmallintToNull"
.sp
.IP MODULE
\f(HBSqlInteger\fP
.IP TYPE
\f(HBSQLSMALLINT\fP
.IP SYNOPSIS
\f(HBPROCEDURE setSqlSmallintToNull () : SQLSMALLINT;\fP
.IP DESCRIPTION
The function \f(HOsetSqlSmallintToNull\fP can be used to set a variable 
of type SQLSMALLINT to the null value.
.IP "RETURN VALUE"
The result of this function call is a variable of type 
SQLSMALLINT which contains the null value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_smallint : SqlInteger::SQLSMALLINT;
\&...
a_sql_smallint := SqlInteger::IntToSqlSmallint (0);
-- \f(HOa_sql_smallint was initialized with a value of "0".\fP
\&...
IF   SqlInteger::isSqlSmallintEqualNull (a_sql_smallint)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_smallint\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
a_sql_smallint := SqlInteger::setSqlSmallintToNull ();
IF   SqlInteger::isSqlSmallintEqualNull (a_sql_smallint)
THEN
     -- \f(HONow execution continues here.\fP
ELSE
     ...
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOisSqlSmallintEqualNull\fP
.LP
.OH "'SOI Reference Manual''SqlInteger::SqlSmallintToInt'"
.EH "'SqlInteger::SqlSmallintToInt''SOI Reference Manual'"
.bp
.NX 4 "SqlSmallintToInt"
.sp
.IP MODULE
\f(HBSqlInteger\fP
.IP TYPE
\f(HBSQLSMALLINT\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE SqlSmallintToInt $( IN sql_smallint : SQLSMALLINT )
$: INT;\fP
.TE
.IP DESCRIPTION
The function \f(HOSqlSmallintToInt\fP can be used to convert the input 
variable \f(HOsql_smallint\fP of type SQLSMALLINT to an integer.
.IP "RETURN VALUE"
The result of this function call is the INT representation of 
the input variable \f(HOsql_smallint\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_smallint\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR an_integer     : INT;
VAR a_sql_smallint : SqlInteger::SQLSMALLINT;
\&...
a_sql_smallint := SqlInteger::IntToSqlSmallint (13);
-- \f(HOa_sql_smallint was initialized with a value of "13".\fP
\&...
an_integer := SqlInteger::SqlSmallintToInt (a_sql_smallint);
.CE
.KE
Now an_integer contains the value "13" also.
.IP "SEE ALSO"
\f(HOIntToSqlSmallint\fP
.LP
.OH "'SOI Reference Manual''SqlInteger'"
.EH "'SqlInteger''SOI Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOSqlInteger\fP concerning the data type SQLSMALLINT.
.\"KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
IntToSqlSmallint$IN$integer$INT$ValueIsOutOfRange
$result$$SQLSMALLINT$
_
isSqlSmallintEqualNull$IN$sql_smallint$SQLSMALLINT$
$result$$BOOL$
_
setSqlSmallintToNull$result$$SQLSMALLINT$
_
SqlSmallintToInt$IN$sql_smallint$SQLSMALLINT$ValueIsNull
$result$$INT$
.TE
.NL
.nr PS 12
.\"KE
.LP
.OH "'SOI Reference Manual''SQL-CooL-Data-Types'"
.EH "'SQL-CooL-Data-Types''SOI Reference Manual'"
.bp
.NX 3 "The SQL-CooL-Data-Type SQLINTEGER"
.sp
For working with the SQL-CooL-Data-Type SQLINTEGER one has to 
declare at least one variable of this type:
.LP
.CS L
VAR my_sql_integer : SqlInteger::SQLINTEGER;
.CE
.LP
A variable of the type SQLINTEGER can be manipulated by the 
following set of functions.
.LP
One can get more functionality by transforming this data type into the data type
INT of CooL and then using the provided built-in functions.
.LP
.OH "'SOI Reference Manual''SqlInteger::IntToSqlInteger'"
.EH "'SqlInteger::IntToSqlInteger''SOI Reference Manual'"
.bp
.NX 4 "IntToSqlInteger"
.sp
.IP MODULE
\f(HBSqlInteger\fP
.IP TYPE
\f(HBSQLINTEGER\fP
.IP SYNOPSIS
\f(HBPROCEDURE IntToSqlInteger ( IN integer : INT ) : SQLINTEGER;\fP
.IP DESCRIPTION
The function \f(HOIntToSqlInteger\fP can be used to convert an integer 
value to a value of type SQLINTEGER.
.IP "RETURN VALUE"
The result of this function call is the SQLINTEGER representation of the
\f(HOinteger\fP value.
.KS
.IP EXAMPLES
.CS L
VAR an_integer    : INT;
VAR a_sql_integer : SqlInteger::SQLINTEGER;
\&...
an_integer := 13;
a_sql_integer := SqlInteger::IntToSqlInteger (an_integer);
.CE
.KE
After this assignment a_sql_integer contains the value "13".
.IP "SEE ALSO"
\f(HOSqlIntegerToInt\fP
.LP
.OH "'SOI Reference Manual''SqlInteger::isSqlIntegerEqualNull'"
.EH "'SqlInteger::isSqlIntegerEqualNull''SOI Reference Manual'"
.bp
.NX 4 "isSqlIntegerEqualNull"
.sp
.IP MODULE
\f(HBSqlInteger\fP
.IP TYPE
\f(HBSQLINTEGER\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE isSqlIntegerEqualNull $( IN sql_integer : SQLINTEGER )
$: BOOL;\fP
.TE
.IP DESCRIPTION
The function \f(HOisSqlIntegerEqualNull\fP can be used to check if the 
input variable \f(HOsql_integer\fP of type SQLINTEGER contains 
the null value.
.IP "RETURN VALUE"
The result of this function call is the boolean value
.in +2
.IP "TRUE        "
if the input variable \f(HOsql_integer\fP contains the null value.
.IP "FALSE       "
if the input variable \f(HOsql_integer\fP does not contain the null 
value.
.in -2
.KS
.IP EXAMPLES
.CS L
VAR a_sql_integer : SqlInteger::SQLINTEGER;
\&...
a_sql_integer := SqlInteger::IntToSqlInteger (0);
-- \f(HOa_sql_integer was initialized with a value of "0".\fP
\&...
IF   SqlInteger::isSqlIntegerEqualNull (a_sql_integer)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_integer\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOsetSqlIntegerToNull\fP
.LP
.OH "'SOI Reference Manual''SqlInteger::setSqlIntegerToNull'"
.EH "'SqlInteger::setSqlIntegerToNull''SOI Reference Manual'"
.bp
.NX 4 "setSqlIntegerToNull"
.sp
.IP MODULE
\f(HBSqlInteger\fP
.IP TYPE
\f(HBSQLINTEGER\fP
.IP SYNOPSIS
\f(HBPROCEDURE setSqlIntegerToNull () : SQLINTEGER;\fP
.IP DESCRIPTION
The function \f(HOsetSqlIntegerToNull\fP can be used to set a variable 
of type SQLINTEGER to the null value.
.IP "RETURN VALUE"
The result of this function call is a variable of type 
SQLINTEGER which contains the null value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_integer : SqlInteger::SQLINTEGER;
\&...
a_sql_integer := SqlInteger::IntToSqlInteger (0);
-- \f(HOa_sql_integer was initialized with a value of "0".\fP
\&...
IF   SqlInteger::isSqlIntegerEqualNull (a_sql_integer)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_integer\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
a_sql_integer := SqlInteger::setSqlIntegerToNull ();
IF   SqlInteger::isSqlIntegerEqualNull (a_sql_integer)
THEN
     -- \f(HONow execution continues here.\fP
ELSE
     ...
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOisSqlIntegerEqualNull\fP
.LP
.OH "'SOI Reference Manual''SqlInteger::SqlIntegerToInt'"
.EH "'SqlInteger::SqlIntegerToInt''SOI Reference Manual'"
.bp
.NX 4 "SqlIntegerToInt"
.sp
.IP MODULE
\f(HBSqlInteger\fP
.IP TYPE
\f(HBSQLINTEGER\fP
.IP SYNOPSIS
\f(HBPROCEDURE SqlIntegerToInt ( IN sql_integer : SQLINTEGER ) : INT;\fP
.IP DESCRIPTION
The function \f(HOSqlIntegerToInt\fP can be used to convert the input 
variable \f(HOsql_integer\fP of type SQLINTEGER to an integer.
.IP "RETURN VALUE"
The result of this function call is the INT representation of 
the input variable \f(HOsql_integer\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_integer\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR an_integer    : INT;
VAR a_sql_integer : SqlInteger::SQLINTEGER;
\&...
a_sql_integer := SqlInteger::IntToSqlInteger (13);
-- \f(HOa_sql_integer was initialized with a value of "13".\fP
\&...
an_integer := SqlInteger::SqlIntegerToInt (a_sql_integer);
.CE
.KE
Now an_integer contains the value "13" also.
.IP "SEE ALSO"
\f(HOIntToSqlInteger\fP
.LP
.OH "'SOI Reference Manual''SqlInteger'"
.EH "'SqlInteger''SOI Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOSqlInteger\fP concerning the data type SQLINTEGER.
.\"KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
IntToSqlInteger$IN$integer$INT$
$result$$SQLINTEGER$
_
isSqlIntegerEqualNull$IN$sql_integer$SQLINTEGER$
$result$$BOOL$
_
setSqlIntegerToNull$result$$SQLINTEGER$
_
SqlIntegerToInt$IN$sql_integer$SQLINTEGER$ValueIsNull
$result$$INT$
.TE
.NL
.nr PS 12
.\"KE
.LP
.OH "'SOI Reference Manual''SQL-CooL-Data-Types'"
.EH "'SQL-CooL-Data-Types''SOI Reference Manual'"
.bp
.NX 3 "The SQL-CooL-Data-Type SQLSERIAL"
.sp
For working with the SQL-CooL-Data-Type SQLSERIAL one has to 
declare at least one variable of this type:
.LP
.CS L
my_sql_serial : SqlInteger::SQLSERIAL;
.CE
.LP
A variable of the type SQLSERIAL can be manipulated by the 
following set of functions.
.LP
One can get more functionality by transforming this data type into the 
data type INT of CooL and then using the provided built-in 
functions.
.LP
.OH "'SOI Reference Manual''SqlInteger::IntToSqlSerial'"
.EH "'SqlInteger::IntToSqlSerial''SOI Reference Manual'"
.bp
.NX 4 "IntToSqlSerial"
.sp
.IP MODULE
\f(HBSqlInteger\fP
.IP TYPE
\f(HBSQLSERIAL\fP
.IP SYNOPSIS
\f(HBPROCEDURE IntToSqlSerial ( IN integer : INT ) : SQLSERIAL;\fP
.IP DESCRIPTION
The function \f(HOIntToSqlSerial\fP can be used to convert an integer 
value to a value of type SQLSERIAL.
.IP "RETURN VALUE"
The result of this function call is the SQLSERIAL representation
of the \f(HOinteger\fP value.
.KS
.IP EXAMPLES
.CS L
VAR an_integer   : INT;
VAR a_sql_serial : SqlInteger::SQLSERIAL;
\&...
an_integer := 13;
a_sql_serial := SqlInteger::IntToSqlSerial (an_integer);
.CE
.KE
After this assignment a_sql_serial contains the value "13".
.IP "SEE ALSO"
\f(HOSqlSerialToInt\fP
.LP
.OH "'SOI Reference Manual''SqlInteger::SqlSerialToInt'"
.EH "'SqlInteger::SqlSerialToInt''SOI Reference Manual'"
.bp
.NX 4 "SqlSerialToInt"
.sp
.IP MODULE
\f(HBSqlInteger\fP
.IP TYPE
\f(HBSQLSERIAL\fP
.IP SYNOPSIS
\f(HBPROCEDURE SqlSerialToInt ( IN sql_serial : SQLSERIAL ) : INT;\fP
.IP DESCRIPTION
The function \f(HOSqlSerialToInt\fP can be used to convert the input 
variable \f(HOsql_serial\fP of type SQLSERIAL to an integer.
.IP "RETURN VALUE"
The result of this function call is the INT representation of 
the input variable \f(HOsql_serial\fP.
.KS
.IP EXAMPLES
.CS L
VAR an_integer   : INT;
VAR a_sql_serial : SqlInteger::SQLSERIAL;
\&...
a_sql_serial := SqlInteger::IntToSqlSerial (13);
-- \f(HOa_sql_serial was initialized with a value of "13".\fP
\&...
an_integer := SqlInteger::SqlSerialToInt (a_sql_serial);
.CE
.KE
Now an_integer contains the value "13" also.
.IP "SEE ALSO"
\f(HOIntToSqlSerial\fP
.LP
.OH "'SOI Reference Manual''SqlInteger'"
.EH "'SqlInteger''SOI Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOSqlInteger\fP concerning the data type SQLSERIAL.
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
IntToSqlSerial$IN$integer$INT$
$result$$SQLSERIAL$
_
SqlSerialToInt$IN$sql_serial$SQLSERIAL$
$result$$INT$
.TE
.NL
.nr PS 12
.LP
.OH "'SOI Reference Manual''SQL-CooL-Data-Types'"
.EH "'SQL-CooL-Data-Types''SOI Reference Manual'"
.bp
.NX 3 "The SQL-CooL-Data-Type SQLSMALLFLOAT"
.sp
For working with the SQL-CooL-Data-Type SQLSMALLFLOAT one has to
declare at least one variable of this type:
.LP
.CS L
VAR my_sql_smallfloat : SqlFloat::SQLSMALLFLOAT;
.CE
.LP
A variable of the type SQLSMALLFLOAT can be manipulated by the 
following set of functions.
.LP
One can get more functionality by transforming this data type into the 
data type DOUBLE of CooL and then using the provided built-in 
functions.
.LP
.OH "'SOI Reference Manual''SqlFloat::DoubleToSqlSmallfloat'"
.EH "'SqlFloat::DoubleToSqlSmallfloat''SOI Reference Manual'"
.bp
.NX 4 "DoubleToSqlSmallfloat"
.sp
.IP MODULE
\f(HBSqlFloat\fP
.IP TYPE
\f(HBSQLSMALLFLOAT\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE DoubleToSqlSmallfloat $( IN double : DOUBLE ) 
$: SQLSMALLFLOAT;\fP
.TE
.IP DESCRIPTION
The function \f(HODoubleToSqlSmallfloat\fP can be used to convert a 
double value to a variable of type SQLSMALLFLOAT.
.IP "RETURN VALUE"
The result of this function call is the SQLSMALLFLOAT 
representation of the double value.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsOutOfRange\fP"
is raised, if the value of the input parameter \f(HOdouble\fP is greater
or smaller than the maximum/minimum values allowed for a variable of the
SQL-Data-Type \f(HOSMALLFLOAT\fP (see the documentation of the 
relational data base system INFORMIX).
.KS
.IP EXAMPLES
.CS L
VAR a_double         : DOUBLE;
VAR a_sql_smallfloat : SqlFloat::SQLSMALLFLOAT;
\&...
a_double := 1.23E5;
a_sql_smallfloat := SqlFloat::DoubleToSqlSmallfloat (a_double);
.CE
.KE
After this assignment a_sql_smallfloat contains the value "1.23E5".
.IP "SEE ALSO"
\f(HOSqlSmallfloatToDouble\fP
.LP
.OH "'SOI Reference Manual''SqlFloat::isSqlSmallfloatEqualNull'"
.EH "'SqlFloat::isSqlSmallfloatEqualNull''SOI Reference Manual'"
.bp
.NX 4 "isSqlSmallfloatEqualNull"
.sp
.IP MODULE
\f(HBSqlFloat\fP
.IP TYPE
\f(HBSQLSMALLFLOAT\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBPROCEDURE $$isSqlSmallfloatEqualNull 
$($ IN sql_smallfloat : SQLSMALLFLOAT )
$:$ BOOL;\fP
.TE
.IP DESCRIPTION
The function \f(HOisSqlSmallfloatEqualNull\fP can be used to check if 
the input variable \f(HOsql_smallfloat\fP of type SQLSMALLFLOAT 
contains the null value.
.IP "RETURN VALUE"
The result of this function call is the boolean value
.in +2
.IP "TRUE        "
if the input variable \f(HOsql_smallfloat\fP contains the null value.
.IP "FALSE       "
if the input variable \f(HOsql_smallfloat\fP does not contain the null 
value.
.in -2
.KS
.IP EXAMPLES
.CS L
VAR a_sql_smallflaot : SqlFloat::SQLSMALLFLOAT;
\&...
a_sql_smallflaot := SqlFloat::DoubleToSqlSmallfloat (0.0);
-- \f(HOa_sql_smallflaot was initialized with a value of "0.0".\fP
\&...
IF   SqlFloat::isSqlSmallfloatEqualNull (a_sql_smallflaot)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_smallflaot\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOsetSqlSmallfloatToNull\fP
.LP
.OH "'SOI Reference Manual''SqlFloat::setSqlSmallfloatToNull'"
.EH "'SqlFloat::setSqlSmallfloatToNull''SOI Reference Manual'"
.bp
.NX 4 "setSqlSmallfloatToNull"
.sp
.IP MODULE
\f(HBSqlFloat\fP
.IP TYPE
\f(HBSQLSMALLFLOAT\fP
.IP SYNOPSIS
\f(HBPROCEDURE setSqlSmallfloatToNull () : SQLSMALLFLOAT;\fP
.IP DESCRIPTION
The function \f(HOsetSqlSmallfloatToNull\fP can be used to set a 
variable of type SQLSMALLFLOAT to the null value.
.IP "RETURN VALUE"
The result of this function call is a variable of type 
SQLSMALLFLOAT which contains the null value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_smallfloat : SqlFloat::SQLSMALLFLOAT;
\&...
a_sql_smallfloat := SqlFloat::DoubleToSqlSmallfloat (0.0);
-- \f(HOa_sql_smallfloat was initialized with a value of "0.0".\fP
\&...
IF   SqlFloat::isSqlSmallfloatEqualNull (a_sql_smallfloat)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_smallfloat\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
a_sql_smallfloat := SqlFloat::setSqlSmallfloatToNull ();
IF   SqlFloat::isSqlSmallfloatEqualNull (a_sql_smallfloat)
THEN
     -- \f(HONow execution continues here.\fP
ELSE
     ...
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOisSqlSmallfloatEqualNull\fP
.LP
.OH "'SOI Reference Manual''SqlFloat::SqlSmallfloatToDouble'"
.EH "'SqlFloat::SqlSmallfloatToDouble''SOI Reference Manual'"
.bp
.NX 4 "SqlSmallfloatToDouble"
.sp
.IP MODULE
\f(HBSqlFloat\fP
.IP TYPE
\f(HBSQLSMALLFLOAT\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBPROCEDURE $$SqlSmallfloatToDouble
$($ IN sql_smallfloat : SQLSMALLFLOAT )
$:$ DOUBLE;\fP
.TE
.IP DESCRIPTION
The function \f(HOSqlSmallfloatToDouble\fP can be used to convert the 
input variable \f(HOsql_smallfloat\fP of type SQLSMALLFLOAT to a
double.
.IP "RETURN VALUE"
The result of this function call is the DOUBLE representation of
the input variable \f(HOsql_smallfloat\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_smallfloat\fP contains the 
null value.
.KS
.IP EXAMPLES
.CS L
VAR a_double         : DOUBLE;
VAR a_sql_smallfloat : SqlFloat::SQLSMALLFLOAT;
\&...
a_sql_smallfloat := SqlFloat::DoubleToSqlSmallfloat (1.23E5);
-- \f(HOa_sql_smallfloat was initialized with a value of "1.23E5".\fP
\&...
a_double := SqlFloat::SqlSmallfloatToDouble (a_sql_smallfloat);
.CE
.KE
Now a_double contains the value "1.23E5" also.
.IP "SEE ALSO"
\f(HODoubleToSqlSmallfloat\fP
.LP
.OH "'SOI Reference Manual''SqlFloat'"
.EH "'SqlFloat''SOI Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOSqlFloat\fP concerning the data type SQLSMALLFLOAT.
.\"KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
DoubleToSqlSmallfloat$IN$double$DOUBLE$ValueIsOutOfRange
$result$$SQLSMALLFLOAT$
_
isSqlSmallfloatEqualNull$IN$sql_smallfloat$SQLSMALLFLOAT$
$result$$BOOL$
_
setSqlSmallfloatToNull$result$$SQLSMALLFLOAT$
_
SqlSmallfloatToDouble$IN$sql_smallfloat$SQLSMALLFLOAT$ValueIsNull
$result$$DOUBLE$
.TE
.NL
.nr PS 12
.\"KE
.LP
.OH "'SOI Reference Manual''SQL-CooL-Data-Types'"
.EH "'SQL-CooL-Data-Types''SOI Reference Manual'"
.bp
.NX 3 "SQL-CooL-Data-Type SQLFLOAT"
.sp
For working with the SQL-CooL-Data-Type SQLFLOAT one has to 
declare at least one variable of this type:
.LP
.CS L
VAR my_sql_float : SqlFloat::SQLFLOAT;
.CE
.LP
A variable of the type SQLFLOAT can be manipulated by the 
following set of functions.
.LP
One can get more functionality by transforming this data type into the 
data type DOUBLE of CooL and then using the provided built-in 
functions.
.sp
.OH "'SOI Reference Manual''SqlFloat::DoubleToSqlFloat'"
.EH "'SqlFloat::DoubleToSqlFloat''SOI Reference Manual'"
.bp
.NX 4 "DoubleToSqlFloat"
.sp
.IP MODULE
\f(HBSqlFloat\fP
.IP TYPE
\f(HBSQLFLOAT\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE DoubleToSqlFloat $( IN double : DOUBLE )
$: SQLFLOAT;\fP
.TE
.IP DESCRIPTION
The function \f(HODoubleToSqlFloat\fP can be used to convert a double 
value to a value of type SQLFLOAT.
.IP "RETURN VALUE"
The result of this function call is the SQLFLOAT representation 
of the double value.
.KS
.IP EXAMPLES
.CS L
VAR a_double    : DOUBLE;
VAR a_sql_float : SqlFloat::SQLFLOAT;
\&...
a_double := 1.23E5;
a_sql_float := SqlFloat::DoubleToSqlFloat (a_double);
.CE
.KE
After this assignment a_sql_float contains the value "1.23E5".
.IP "SEE ALSO"
\f(HOSqlFloatToDouble\fP
.LP
.OH "'SOI Reference Manual''SqlFloat::isSqlFloatEqualNull'"
.EH "'SqlFloat::isSqlFloatEqualNull''SOI Reference Manual'"
.bp
.NX 4 "isSqlFloatEqualNull"
.sp
.IP MODULE
\f(HBSqlFloat\fP
.IP TYPE
\f(HBSQLFLOAT\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE isSqlFloatEqualNull $( IN sql_float : SQLFLOAT )
$: BOOL;\fP
.TE
.IP DESCRIPTION
The function \f(HOisSqlFloatEqualNull\fP can be used to check if the 
input variable \f(HOsql_float\fP of type SQLFLOAT contains the 
null value.
.IP "RETURN VALUE"
The result of this function call is the boolean value
.in +2
.IP "TRUE        "
if the input variable \f(HOsql_float\fP contains the null value.
.IP "FALSE       "
if the input variable \f(HOsql_float\fP does not contain the null value.
.in -2
.KS
.IP EXAMPLES
.CS L
VAR a_sql_float : SqlFloat::SQLFLOAT;
\&...
a_sql_float := SqlFloat::DoubleToSqlFloat (0.0);
-- \f(HOa_sql_float was initialized with a value of "0.0".\fP
\&...
IF   SqlFloat::isSqlFloatEqualNull (a_sql_float)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_float\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOsetSqlFloatToNull\fP
.LP
.OH "'SOI Reference Manual''SqlFloat::setSqlFloatToNull'"
.EH "'SqlFloat::setSqlFloatToNull''SOI Reference Manual'"
.bp
.NX 4 "setSqlFloatToNull"
.sp
.IP MODULE
\f(HBSqlFloat\fP
.IP TYPE
\f(HBSQLFLOAT\fP
.IP SYNOPSIS
\f(HBPROCEDURE setSqlFloatToNull () : SQLFLOAT;\fP
.IP DESCRIPTION
The function \f(HOsetSqlFloatToNull\fP can be used to set a variable of 
type SQLFLOAT to the null value.
.IP "RETURN VALUE"
The result of this function call is a variable of type SQLFLOAT 
which contains the null value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_float : SqlFloat::SQLFLOAT;
\&...
a_sql_float := SqlFloat::DoubleToSqlFloat (0.0);
-- \f(HOa_sql_float was initialized with a value of "0.0".\fP
\&...
IF   SqlFloat::isSqlFloatEqualNull (a_sql_float)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_float\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
a_sql_float := SqlFloat::setSqlFloatToNull ();
IF   SqlFloat::isSqlFloatEqualNull (a_sql_float)
THEN
     -- \f(HONow execution continues here.\fP
ELSE
     ...
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOisSqlFloatEqualNull\fP
.LP
.OH "'SOI Reference Manual''SqlFloat::SqlFloatToDouble'"
.EH "'SqlFloat::SqlFloatToDouble''SOI Reference Manual'"
.bp
.NX 4 "SqlFloatToDouble"
.sp
.IP MODULE
\f(HBSqlFloat\fP
.IP TYPE
\f(HBSQLFLOAT\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE SqlFloatToDouble $( IN sql_float : SQLFLOAT )
$: DOUBLE;\fP
.TE
.IP DESCRIPTION
The function \f(HOSqlFloatToDouble\fP can be used to convert the input 
variable \f(HOsql_float\fP of type SQLFLOAT to a double.
.IP "RETURN VALUE"
The result of this function call is the DOUBLE representation of
the input variable \f(HOsql_float\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_float\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_double    : DOUBLE;
VAR a_sql_float : SqlFloat::SQLFLOAT;
\&...
a_sql_float := SqlFloat::DoubleToSqlFloat (1.23E5);
-- \f(HOa_sql_float was initialized with a value of "1.23E5".\fP
\&...
a_double := SqlFloat::SqlFloatToDouble (a_sql_float);
.CE
.KE
Now a_double contains the value "1.23E5" also.
.IP "SEE ALSO"
\f(HODoubleToSqlFloat\fP
.LP
.OH "'SOI Reference Manual''SqlFloat'"
.EH "'SqlFloat''SOI Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOSqlFloat\fP concerning the data type SQLFLOAT.
.\"KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
DoubleToSqlFloat$IN$double$DOUBLE$
$result$$SQLFLOAT$
_
isSqlFloatEqualNull$IN$sql_float$SQLFLOAT$
$result$$BOOL$
_
setSqlFloatToNull$result$$SQLFLOAT$
_
SqlFloatToDouble$IN$sql_float$SQLFLOAT$ValueIsNull
$result$$DOUBLE$
.TE
.NL
.nr PS 12
.\"KE
.LP
.OH "'SOI Reference Manual''SQL-CooL-Data-Types'"
.EH "'SQL-CooL-Data-Types''SOI Reference Manual'"
.bp
.NX 3 "The SQL-CooL-Data-Type SQLDECIMAL"
.sp
For working with the SQL-CooL-Data-Type SQLDECIMAL one has to 
declare at least one variable of this type:
.sp 0.5
.CS L
VAR my_sql_decimal : SqlDecimal::SQLDECIMAL;
.CE
.sp 0.5
The CooL library CoLibri provides a number of functions which manipulate
values of type SQLDECIMAL and functions which convert a value of type 
SQLDECIMAL to other types (e.g. INTEGER, DOUBLE, CHAR and \f(HOBCD\fP
\&(see [2])) and vice versa.
.sp 0.5
A variable of the type SQLDECIMAL can be manipulated by the 
following set of functions.
.LP
.OH "'SOI Reference Manual''SqlDecimal::addSqlDecimal'"
.EH "'SqlDecimal::addSqlDecimal''SOI Reference Manual'"
.bp
.NX 4 "addSqlDecimal"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE addSqlDecimal $($ IN left_operand $ : SQLDECIMAL,
$$ IN right_operand $ : SQLDECIMAL )
$:$ SQLDECIMAL;$\fP
.TE
.IP DESCRIPTION
The function \f(HOaddSqlDecimal\fP can be used to add the values of
\f(HOleft_operand\fP and \f(HOright_operand\fP.
.IP "RETURN VALUE"
The result of this function call is the sum of \f(HOleft_operand\fP and
\f(HOright_operand\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODecimalRangeOverflow\fP"
is raised, if the sum of \f(HOleft_operand\fP and \f(HOright_operand\fP
is too large for a variable of type SQLDECIMAL.
.IP "\(bu \f(HODecimalRangeUnderflow\fP"
is raised, if the sum of \f(HOleft_operand\fP and \f(HOright_operand\fP
is too small for a variable of type SQLDECIMAL.
.IP "\(bu \f(HOFirstOperandIsNull\fP"
is raised, if the input variable \f(HOleft_operand\fP contains the null 
value.
.IP "\(bu \f(HOSecondOperandIsNull\fP"
is raised, if the input variable \f(HOright_operand\fP contains the null
value.
.KS
.IP EXAMPLES
.CS L
VAR left_operand  : SqlDecimal::SQLDECIMAL;
VAR right_operand : SqlDecimal::SQLDECIMAL;
VAR result        : SqlDecimal::SQLDECIMAL;
\&...
left_operand := SqlDecimal::SqlDecimal ("123.456");
right_operand := SqlDecimal::SqlDecimal ("1.23456E2");
result := SqlDecimal::addSqlDecimal (left_operand, right_operand);
.CE
.KE
left_operand and right_operand were initialized with a value 
of "123.456".
Now result contains the value "246.912".
.IP "SEE ALSO"
\f(HOsubtractBcdDecimal\fP
.LP
.OH "'SOI Reference Manual''SqlDecimal::BcdToSqlDecimal'"
.EH "'SqlDecimal::BcdToSqlDecimal''SOI Reference Manual'"
.bp
.NX 4 "BcdToSqlDecimal"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
\f(HBPROCEDURE BcdToSqlDecimal ( IN bcd : BCD ) : SQLDECIMAL;\fP
.IP DESCRIPTION
The function \f(HOBcdToSqlDecimal\fP can be used to convert the input 
variable \f(HObcd\fP of type \f(HOBCD\fP (see [2]) to a variable of type
SQLDECIMAL.
.IP "RETURN VALUE"
The result of this function call is the SQLDECIMAL 
representation of the input variable \f(HObcd\fP.
.KS
.IP EXAMPLES
.CS L
VAR a_bcd         : Bcd::BCD;
VAR a_sql_decimal : SqlDecimal::SQLDECIMAL;
\&...
a_bcd := Conversions::StringToBcd ("1.23E5");
a_sql_decimal := SqlDecimal::BcdToSqlDecimal (a_bcd);
.CE
.KE
a_sql_decimal contains the value "123000.0".
.IP "SEE ALSO"
\f(HOSqlDecimalToBcd\fP
.LP
.OH "'SOI Reference Manual''SqlDecimal::compareSqlDecimal'"
.EH "'SqlDecimal::compareSqlDecimal''SOI Reference Manual'"
.bp
.NX 4 "compareSqlDecimal"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE compareSqlDecimal $($ IN left_operand $ : SQLDECIMAL,
$$ IN right_operand $ : SQLDECIMAL )
$:$ INT;$\fP
.TE
.IP DESCRIPTION
The function \f(HOcompareSqlDecimal\fP can be used to compare the values
of \f(HOleft_operand\fP and \f(HOright_operand\fP.
.IP "RETURN VALUE"
The result of this function call is the integer constant
.in +2
.IP "BOTH_ARE_EQUAL           "
if the \f(HOleft_operand\fP and the \f(HOright_operand\fP are equal.
.IP "FIRST_OPERAND_IS_GREATER "
if the \f(HOleft_operand\fP is greater than the \f(HOright_operand\fP.
.IP "SECOND_OPERAND_IS_GREATER"
if the \f(HOleft_operand\fP is less than the \f(HOright_operand\fP.
.in -2
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOFirstOperandIsNull\fP"
is raised, if the input variable \f(HOleft_operand\fP contains the null
value.
.IP "\(bu \f(HOSecondOperandIsNull\fP"
is raised, if the input variable \f(HOright_operand\fP contains the null
value.
.KS
.IP EXAMPLES
.CS L
VAR left_operand  : SqlDecimal::SQLDECIMAL;
VAR right_operand : SqlDecimal::SQLDECIMAL;
\&...
left_operand := SqlDecimal::SqlDecimal ("123.456");
-- \f(HOleft_operand was initialized with a value of "123.456".\fP

right_operand := SqlDecimal::SqlDecimal ("1.23456E2");
-- \f(HOright_operand was initialized with a value of "123.456".\fP

SELECT SqlDecimal::compareSqlDecimal (left_operand, right_operand) OF
   CASE BOTH_ARE_EQUAL :
      -- This is the branch, which will fit ...
   CASE FIRST_OPERAND_IS_GREATER :
      ...
   CASE SECOND_OPERAND_IS_GREATER :
      ...
END SELECT;
.CE
.KE
.OH "'SOI Reference Manual''SqlDecimal::divideSqlDecimal'"
.EH "'SqlDecimal::divideSqlDecimal''SOI Reference Manual'"
.LP
.bp
.NX 4 "divideSqlDecimal"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE divideSqlDecimal $($ IN dividend $ : SQLDECIMAL,
$$ IN divisor $ : SQLDECIMAL )
$:$ SQLDECIMAL;$\fP
.TE
.IP DESCRIPTION
The function \f(HOdivideSqlDecimal\fP can be used to divide the 
\f(HOdividend\fP by \f(HOdivisor\fP.
.IP "RETURN VALUE"
The result of this function call is the quotient of \f(HOdividend\fP and
\f(HOdivisor\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODecimalRangeOverflow\fP"
is raised, if the quotient of \f(HOdividend\fP and \f(HOdivisor\fP is 
too large for a variable of type SQLDECIMAL.
.IP "\(bu \f(HODecimalRangeUnderflow\fP"
is raised, if the quotient of \f(HOdividend\fP and \f(HOdivisor\fP is 
too small for a variable of type SQLDECIMAL.
.IP "\(bu \f(HODivisionByZero\fP"
is raised, if \f(HOdivisor\fP contains zero.
.IP "\(bu \f(HOFirstOperandIsNull\fP"
is raised, if the input variable \f(HOdividend\fP contains the null 
value.
.IP "\(bu \f(HOSecondOperandIsNull\fP"
is raised, if the input variable \f(HOdivisor\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR dividend : SqlDecimal::SQLDECIMAL;
VAR divisor  : SqlDecimal::SQLDECIMAL;
VAR result   : SqlDecimal::SQLDECIMAL;
\&...
dividend := SqlDecimal::SqlDecimal ("123.456");
divisor := SqlDecimal::SqlDecimal ("1.23456E2");
result := SqlDecimal::divideSqlDecimal (dividend, divisor);
.CE
.KE
dividend and divisor were initialized with a value of "123.456".
Now result contains the value "1.0".
.IP "SEE ALSO"
\f(HOmultiplySqlDecimal\fP
.LP
.OH "'SOI Reference Manual''SqlDecimal::DoubleToSqlDecimal'"
.EH "'SqlDecimal::DoubleToSqlDecimal''SOI Reference Manual'"
.bp
.NX 4 "DoubleToSqlDecimal"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE DoubleToSqlDecimal $( IN double : DOUBLE )
$: SQLDECIMAL;\fP
.TE
.IP DESCRIPTION
The function \f(HODoubleToSqlDecimal\fP can be used to convert the input
variable \f(HOdouble\fP of type DOUBLE to a variable of type SQLDECIMAL.
.IP "RETURN VALUE"
The result of this function call is the SQLDECIMAL 
representation of the input variable \f(HOdouble\fP.
.KS
.IP EXAMPLES
.CS L
VAR a_double      : DOUBLE;
VAR a_sql_decimal : SqlDecimal::SQLDECIMAL;
\&...
a_double := 1.23E5;
a_sql_decimal := SqlDecimal::DoubleToSqlDecimal (a_double);
.CE
.KE
a_sql_decimal contains the value "123000.0".
.IP "SEE ALSO"
\f(HOSqlDecimalToDouble\fP
.LP
.OH "'SOI Reference Manual''SqlDecimal::IntToSqlDecimal'"
.EH "'SqlDecimal::IntToSqlDecimal''SOI Reference Manual'"
.bp
.NX 4 "IntToSqlDecimal"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE IntToSqlDecimal $( IN integer : INT )
$: SQLDECIMAL;\fP
.TE
.IP DESCRIPTION
The function \f(HOIntToSqlDecimal\fP can be used to convert the input 
variable \f(HOinteger\fP of type INT to a variable of type SQLDECIMAL.
.IP "RETURN VALUE"
The result of this function call is the SQLDECIMAL representation of the
input variable \f(HOinteger\fP.
.KS
.IP EXAMPLES
.CS L
VAR an_integer    : INT;
VAR a_sql_decimal : SqlDecimal::SQLDECIMAL;
\&...
an_integer := 123;
a_sql_decimal := SqlDecimal::IntToSqlDecimal (an_integer);
.CE
.KE
a_sql_decimal contains the value "123.0".
.IP "SEE ALSO"
\f(HOSqlDecimalToInt\fP
.LP
.OH "'SOI Reference Manual''SqlDecimal::isSqlDecimalEqualNull'"
.EH "'SqlDecimal::isSqlDecimalEqualNull''SOI Reference Manual'"
.bp
.NX 4 "isSqlDecimalEqualNull"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE isSqlDecimalEqualNull $( IN sql_decimal : SQLDECIMAL )
$: BOOL;\fP
.TE
.IP DESCRIPTION
The function \f(HOisSqlDecimalEqualNull\fP can be used to check if the 
input variable \f(HOsql_decimal\fP of type SQLDECIMAL contains the null 
value.
.IP "RETURN VALUE"
The result of this function call is the boolean value
.in +2
.IP "TRUE        "
if the input variable \f(HOsql_decimal\fP contains the null value.
.IP "FALSE       "
if the input variable \f(HOsql_decimal\fP does not contain the null 
value.
.in -2
.KS
.IP EXAMPLES
.CS L
VAR a_sql_decimal : SqlDecimal::SQLDECIMAL;
\&...
a_sql_decimal := SqlDecimal::SqlDecimal ("");
-- \f(HOa_sql_decimal was initialized with a value of "0.0".\fP
\&...
IF   SqlDecimal::isSqlDecimalEqualNull (a_sql_decimal)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_decimal\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOsetSqlDecimalToNull\fP
.LP
.OH "'SOI Reference Manual''SqlDecimal::multiplySqlDecimal'"
.EH "'SqlDecimal::multiplySqlDecimal''SOI Reference Manual'"
.bp
.NX 4 "multiplySqlDecimal"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE multiplySqlDecimal $($ IN left_operand $ : SQLDECIMAL,
$$ IN right_operand $ : SQLDECIMAL )
$:$ SQLDECIMAL;$\fP
.TE
.IP DESCRIPTION
The function \f(HOmultiplySqlDecimal\fP can be used to multiply the 
value of \f(HOleft_operand\fP by \f(HOright_operand\fP.
.IP "RETURN VALUE"
The result of this function call is the product of \f(HOleft_operand\fP 
and \f(HOright_operand\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODecimalRangeOverflow\fP"
is raised, if the product of \f(HOleft_operand\fP and 
\f(HOright_operand\fP is too large for a variable of type SQLDECIMAL.
.IP "\(bu \f(HODecimalRangeUnderflow\fP"
is raised, if the product of \f(HOleft_operand\fP and 
\f(HOright_operand\fP is too small for a variable of type SQLDECIMAL.
.IP "\(bu \f(HOFirstOperandIsNull\fP"
is raised, if the input variable \f(HOleft_operand\fP contains the null 
value.
.IP "\(bu \f(HOSecondOperandIsNull\fP"
is raised, if the input variable \f(HOright_operand\fP contains the null
value.
.KS
.IP EXAMPLES
.CS L
VAR left_operand  : SqlDecimal::SQLDECIMAL;
VAR right_operand : SqlDecimal::SQLDECIMAL;
VAR result        : SqlDecimal::SQLDECIMAL;
\&...
left_operand := SqlDecimal::SqlDecimal ("2");
right_operand := SqlDecimal::SqlDecimal ("1.23456E2");
result := SqlDecimal::multiplySqlDecimal (left_operand, right_operand);
.CE
.KE
left_operand and right_operand were initialized with a value 
of "123.456".
Now result contains the value "246.912".
.IP "SEE ALSO"
\f(HOdivideSqlDecimal\fP
.LP
.OH "'SOI Reference Manual''SqlDecimal::roundSqlDecimal'"
.EH "'SqlDecimal::roundSqlDecimal''SOI Reference Manual'"
.bp
.NX 4 "roundSqlDecimal"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE roundSqlDecimal $($ IN sql_decimal $ : SQLDECIMAL,
$$ IN position $ : INT )
$:$ SQLDECIMAL;$\fP
.TE
.IP DESCRIPTION
The function \f(HOroundSqlDecimal\fP can be used to round the value of
\f(HOsql_decimal\fP right-of-the decimal sign at \f(HOposition\fP.
.IP "RETURN VALUE"
This function call delivers the result of the following expressions:
.in +2
.IP \(bu
\f(HOsql_decimal\fP + 0.5 * 1 E-(\f(HOposition\fP), if 
\f(HOsql_decimal\fP is greater than zero.
.br
The result will be truncated after \f(HOposition\fP.
.IP \(bu
\f(HOsql_decimal\fP - 0.5 * 1 E-(\f(HOposition\fP), if 
\f(HOsql_decimal\fP is less than zero.
.br
The result will be truncated after \f(HOposition\fP.
.IP \(bu
Zero, if \f(HOsql_decimal\fP is zero.
.in -2
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOPositionIsNegative\fP"
is raised, if the input variable \f(HOposition\fP contains a value less
than zero.
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_decimal\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_decimal : SqlDecimal::SQLDECIMAL;
\&...
a_sql_decimal := SqlDecimal::SqlDecimal ("123.456");
a_sql_decimal := SqlDecimal::roundSqlDecimal (a_sql_decimal, 2);
.CE
.KE
a_sql_decimal was initialized with a value of "123.456".
Now a_sql_decimal contains the value "123.46".
.IP "SEE ALSO"
\f(HOtruncateSqlDecimal\fP
.LP
.OH "'SOI Reference Manual''SqlDecimal::setSqlDecimalToNull'"
.EH "'SqlDecimal::setSqlDecimalToNull''SOI Reference Manual'"
.bp
.NX 4 "setSqlDecimalToNull"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
\f(HBPROCEDURE setSqlDecimalToNull () : SQLDECIMAL;\fP
.IP DESCRIPTION
The function \f(HOsetSqlDecimalToNull\fP can be used to set a variable 
of type SQLDECIMAL to the null value.
.IP "RETURN VALUE"
The result of this function call is a variable of type SQLDECIMAL which
contains the null value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_decimal : SqlDecimal::SQLDECIMAL;
\&...
a_sql_decimal := SqlDecimal::SqlDecimal ("");
-- \f(HOa_sql_decimal was initialized with a value of "0.0".\fP
\&...
IF   SqlDecimal::isSqlDecimalEqualNull (a_sql_decimal)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_decimal\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
a_sql_decimal := SqlDecimal::setSqlDecimalToNull ();
IF   SqlDecimal::isSqlDecimalEqualNull (a_sql_decimal)
THEN
     -- \f(HONow execution continues here.\fP
ELSE
     ...
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOisSqlDecimalEqualNull\fP
.LP
.OH "'SOI Reference Manual''SqlDecimal::SqlDecimal'"
.EH "'SqlDecimal::SqlDecimal''SOI Reference Manual'"
.bp
.NX 4 "SqlDecimal"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
\f(HBPROCEDURE SqlDecimal ( IN string : STRING ) : SQLDECIMAL;\fP
.IP DESCRIPTION
The function \f(HOSqlDecimal\fP must be used to initialize a variable 
of type SQLDECIMAL.
.sp 0.5
Additionally this variable will be filled with
.in +2
.IP "Zero           "
if the input parameter \f(HOstring\fP has an actual length of zero.
.IP "a decimal value"
if the input parameter \f(HOstring\fP has an actual length greater than
zero and contains a valid representation of a decimal value.
.in -2
.IP "RETURN VALUE"
The result of this function call is an initialized variable of type
SQLDECIMAL.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODecimalRangeOverflow\fP"
is raised, if the value of the input parameter \f(HOstring\fP is too 
large for a variable of type SQLDECIMAL.
.IP "\(bu \f(HODecimalRangeUnderflow\fP"
is raised, if the value of the input parameter \f(HOstring\fP is too 
small for a variable of type SQLDECIMAL.
.IP "\(bu \f(HOStringContainsCharacters\fP"
is raised, if the value of the input parameter \f(HOstring\fP contains 
character values.
.IP "\(bu \f(HOWrongExponent\fP"
is raised, if the value of the input parameter \f(HOstring\fP contains 
a wrong representation of an exponent (see the documentation of the 
relational data base system INFORMIX).
.KS
.IP EXAMPLES
.CS L
VAR a_string            : STRING;
VAR a_sql_decimal       : SqlDecimal::SQLDECIMAL;
VAR another_sql_decimal : SqlDecimal::SQLDECIMAL;
\&...
a_string      := "1.23E5";
a_sql_decimal := SqlDecimal::SqlDecimal (a_string);
\&...
another_sql_decimal := SqlDecimal::SqlDecimal ("4.56E-10");
.CE
.KE
a_sql_decimal was initialized with a value of "123000.0".
another_sql_decimal was initialized with a value of "0.000000000456".
Additionally both were set to "not null".
.IP "SEE ALSO"
\f(HOStringToSqlDecimal\fP
.LP
.OH "'SOI Reference Manual''SqlDecimal::SqlDecimalToBcd'"
.EH "'SqlDecimal::SqlDecimalToBcd''SOI Reference Manual'"
.bp
.NX 4 "SqlDecimalToBcd"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE SqlDecimalToBcd $( IN sql_decimal : SQLDECIMAL )
$: BCD;\fP
.TE
.IP DESCRIPTION
The function \f(HOSqlDecimalToBcd\fP can be used to convert the input 
variable \f(HOsql_decimal\fP of type SQLDECIMAL to a variable of type 
\f(HOBCD\fP (see [2]).
.IP NOTE
Because the type BCD has a precision of 18 digits (without the decimal
point) in contrast to the type SQLDECIMAL with a precision of 32 digits
one will loose precision by using SQLDECIMAL's with more than 18 digits.
.IP "RETURN VALUE"
The result of this function call is the BCD representation of the input
variable \f(HOsql_decimal\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODecimalConversionFailed\fP"
is raised, if the the conversion was not successful.
.IP "\(bu Conversions::\f(HOBcdIsOutOfRange\fP"
is raised, if the input variable \f(HOsql_decimal\fP is less than 
\&{DBL_MIN} or greater then {DBL_MAX}.
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_decimal\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_bcd         : Bcd::BCD;
VAR a_sql_decimal : SqlDecimal::SQLDECIMAL;
\&...
a_sql_decimal := SqlDecimal::SqlDecimal ("123000.0");
\&...
a_bcd := SqlDecimal::SqlDecimalToBcd (a_sql_decimal);
.CE
.KE
a_sql_decimal was initialized with a value of "123000.0".
Now a_bcd contains\fP the value "123000".
.IP "SEE ALSO"
\f(HOBcdToSqlDecimal\fP
.OH "'SOI Reference Manual''SqlDecimal::SqlDecimalToDouble'"
.EH "'SqlDecimal::SqlDecimalToDouble''SOI Reference Manual'"
.LP
.bp
.NX 4 "SqlDecimalToDouble"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE SqlDecimalToDouble $( IN sql_decimal : SQLDECIMAL )
$: DOUBLE;\fP
.TE
.IP DESCRIPTION
The function \f(HOSqlDecimalToDouble\fP can be used to convert the input
variable \f(HOsql_decimal\fP of type SQLDECIMAL to a variable of type
DOUBLE.
.IP "RETURN VALUE"
The result of this function call is the DOUBLE representation of the 
input variable \f(HOsql_decimal\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_decimal\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_double      : DOUBLE;
VAR a_sql_decimal : SqlDecimal::SQLDECIMAL;
\&...
a_sql_decimal := SqlDecimal::SqlDecimal ("1.23E5");
\&...
a_double := SqlDecimal::SqlDecimalToDouble (a_sql_decimal);
.CE
.KE
a_sql_decimal was initialized with a value of "123000.0".
Now a_double contains the value "1.230000E+05".
.IP "SEE ALSO"
\f(HODoubleToSqlDecimal\fP
.LP
.OH "'SOI Reference Manual''SqlDecimal::SqlDecimalToInt'"
.EH "'SqlDecimal::SqlDecimalToInt''SOI Reference Manual'"
.bp
.NX 4 "SqlDecimalToInt"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE SqlDecimalToInt $( IN sql_decimal : SQLDECIMAL )
$: INT;\fP
.TE
.IP DESCRIPTION
The function \f(HOSqlDecimalToInt\fP can be used to convert the input 
variable \f(HOsql_decimal\fP of type SQLDECIMAL to a variable of type 
INT.
.IP "RETURN VALUE"
The result of this function call is the INT representation of the input
variable \f(HOsql_decimal\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOIntegerRangeOverflow\fP"
is raised, if the value of the input parameter \f(HOsql_decimal\fP is 
too large or too small for a variable of type INT (see the definition of
the limits {min} and {max} in module \f(HOInt.cs\fP).
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_decimal\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR an_integer    : INT;
VAR a_sql_decimal : SqlDecimal::SQLDECIMAL;
\&...
a_sql_decimal := SqlDecimal::SqlDecimal ("123.456");
\&...
an_integer := SqlDecimal::SqlDecimalToInt (a_sql_decimal);
.CE
.KE
a_sql_decimal was initialized with a value of "123.456".
Now an_integer contains the value "123".
.IP "SEE ALSO"
\f(HOIntToSqlDecimal\fP
.OH "'SOI Reference Manual''SqlDecimal::SqlDecimalToString'"
.EH "'SqlDecimal::SqlDecimalToString''SOI Reference Manual'"
.LP
.bp
.NX 4 "SqlDecimalToString"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE SqlDecimalToString $($ IN sql_decimal $ : SQLDECIMAL,
$$ IN no_of_fractions $ : INT )
$:$ STRING;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOSqlDecimalToString\fP can be used to convert the 
input variable \f(HOsql_decimal\fP of type SQLDECIMAL to a STRING.
.br
With \f(HOno_of_fractions\fP the user can determine the number of 
fractions after the decimal point.
If "-1" is specified for this parameter the number of fractions is 
determined automatically.
.IP "RETURN VALUE"
The result of this function call is STRING representation of the 
input variable \f(HOsql_decimal\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODecimalConversionFailed\fP"
is raised, if the function call was not successful.
For example this is the case if the user of this function did not give a
character array which was sufficiantly large to accommodate the converted
value.
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_decimal\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_string      : STRING;
VAR a_sql_decimal : SqlDecimal::SQLDECIMAL;
\&...
a_sql_decimal := SqlDecimal::SqlDecimal ("-4711.007e-98");
\&...
a_string      := SqlDecimal::SqlDecimalToString (a_sql_decimal, -1);
.CE
.KE
a_sql_decimal was initialized with a value of "-4.711007e-98".
Now a_string contains the value "-4.711007e-98".
.IP "SEE ALSO"
\f(HOStringToSqlDecimal\fP
.OH "'SOI Reference Manual''SqlDecimal::StringToSqlDecimal'"
.EH "'SqlDecimal::StringToSqlDecimal''SOI Reference Manual'"
.LP
.bp
.NX 4 "StringToSqlDecimal"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE StringToSqlDecimal $( IN string : STRING )
$: SQLDECIMAL;\fP
.TE
.IP DESCRIPTION
The function \f(HOStringToSqlDecimal\fP can be used to convert a literal
or a string to a variable of type SQLDECIMAL.
The input parameter \f(HOstring\fP has to contain a valid representation
of a decimal value (see the documentation of the relational data base 
system INFORMIX).
.IP "RETURN VALUE"
The result of this function call is the SQLDECIMAL 
representation of the input literal or of the string.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODecimalRangeOverflow\fP"
is raised, if the value of the input parameter \f(HOstring\fP is too 
large for a variable of type SQLDECIMAL.
.IP "\(bu \f(HODecimalRangeUnderflow\fP"
is raised, if the value of the input parameter \f(HOstring\fP is too 
small for a variable of type SQLDECIMAL.
.IP "\(bu \f(HOLengthOfStringIsZero\fP"
is raised, if the actual length of the input parameter \f(HOstring\fP is
zero.
.IP "\(bu \f(HOStringContainsCharacters\fP"
is raised, if the value of the input parameter \f(HOstring\fP contains 
character values.
.IP "\(bu \f(HOWrongExponent\fP"
is raised, if the value of the input parameter \f(HOstring\fP contains a
wrong representation of an exponent.
.KS
.IP EXAMPLES
.CS L
VAR a_string      : STRING;
VAR a_sql_decimal : SqlDecimal::SQLDECIMAL;
\&...
a_string      := "-4711.007";
a_sql_decimal := SqlDecimal::StringToSqlDecimal (a_string);
.CE
.KE
a_sql_decimal contains the value "-4711.007".
.IP "SEE ALSO"
\f(HOSqlDecimal\fP,
\f(HOSqlDecimalToString\fP
.OH "'SOI Reference Manual''SqlDecimal::subtractSqlDecimal'"
.EH "'SqlDecimal::subtractSqlDecimal''SOI Reference Manual'"
.LP
.bp
.NX 4 "subtractSqlDecimal"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE subtractSqlDecimal $($ IN left_operand $ : SQLDECIMAL,
$$ IN right_operand $ : SQLDECIMAL)
$:$ SQLDECIMAL;$\fP
.TE
.IP DESCRIPTION
The function \f(HOsubtractSqlDecimal\fP can be used to subtract the 
value of \f(HOright_operand\fP from \f(HOleft_operand\fP.
.IP "RETURN VALUE"
The result of this function call is the difference of 
\f(HOleft_operand\fP and \f(HOright_operand\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODecimalRangeOverflow\fP"
is raised, if the difference of \f(HOleft_operand\fP and 
\f(HOright_operand\fP is too large for a variable of type SQLDECIMAL.
.IP "\(bu \f(HODecimalRangeUnderflow\fP"
is raised, if the difference of \f(HOleft_operand\fP and 
\f(HOright_operand\fP is too small for a variable of type SQLDECIMAL.
.IP "\(bu \f(HOFirstOperandIsNull\fP"
is raised, if the input variable \f(HOleft_operand\fP contains the null 
value.
.IP "\(bu \f(HOSecondOperandIsNull\fP"
is raised, if the input variable \f(HOright_operand\fP contains the null
value.
.KS
.IP EXAMPLES
.CS L
VAR left_operand  : SqlDecimal::SQLDECIMAL;
VAR right_operand : SqlDecimal::SQLDECIMAL;
VAR result        : SqlDecimal::SQLDECIMAL;
\&...
left_operand := SqlDecimal::SqlDecimal ("-123.456");
right_operand := SqlDecimal::SqlDecimal ("1.23456E2");
result := SqlDecimal::subtractSqlDecimal (left_operand, 
                                           right_operand);
.CE
.KE
left_operand was initialized with a value of "-123.456".
right_operand was initialized with a value of "123.456".
Now result contains the value "-246.912".
.IP "SEE ALSO"
\f(HOaddSqlDecimal\fP
.OH "'SOI Reference Manual''SqlDecimal::truncateSqlDecimal'"
.EH "'SqlDecimal::truncateSqlDecimal''SOI Reference Manual'"
.LP
.bp
.NX 4 "truncateSqlDecimal"
.sp
.IP MODULE
\f(HBSqlDecimal\fP
.IP TYPE
\f(HBSQLDECIMAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE truncateSqlDecimal $($ IN sql_decimal $ : SQLDECIMAL,
$$ IN position $ : INT )
$:$ SQLDECIMAL;$\fP
.TE
.IP DESCRIPTION
The function \f(HOtruncateSqlDecimal\fP can be used to truncate the 
value of \f(HOsql_decimal\fP right-of-the decimal sign after 
\f(HOposition\fP.
.IP "RETURN VALUE"
The result of this function call is the value of \f(HOsql_decimal\fP 
which is truncated after \f(HOposition\fP.
.IP ERRORS
The following exceptions may be raised:
value.
.IP "\(bu \f(HOPositionIsNegative\fP"
is raised, if the input variable \f(HOposition\fP contains a negative 
value.
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_decimal\fP contains the null 
.KS
.IP EXAMPLES
.CS L
VAR a_sql_decimal : SqlDecimal::SQLDECIMAL;
\&...
a_sql_decimal := SqlDecimal::SqlDecimal ("123.456");
a_sql_decimal := SqlDecimal::truncateSqlDecimal (a_sql_decimal, 2);
.CE
.KE
a_sql_decimal was initialized with a value of "123.456".
Now a_sql_decimal contains the value "123.45".
.IP "SEE ALSO"
\f(HOroundSqlDecimal\fP
.LP
.OH "'SOI Reference Manual''SqlDecimal'"
.EH "'SqlDecimal''SOI Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOSqlDecimal\fP.
.\"KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
addSqlDecimal$IN$left_operand$SQLDECIMAL$DecimalRangeOverflow
$IN$right_operand$SQLDECIMAL$DecimalRangeUnderflow
$result$$SQLDECIMAL$FirstOperandIsNull
$$$$SecondOperandIsNull
_
BcdToSqlDecimal$IN$bcd$BCD$
$result$$SQLDECIMAL$
_
compareSqlDecimal$IN$left_operand$SQLDECIMAL$FirstOperandIsNull
$IN$right_operand$SQLDECIMAL$SecondOperandIsNull
$result$$INT$
_
divideSqlDecimal$IN$dividend$SQLDECIMAL$DecimalRangeOverflow
$IN$divisor$SQLDECIMAL$DecimalRangeUnderflow
$result$$SQLDECIMAL$DivisionByZero
$$$$FirstOperandIsNull
$$$$SecondOperandIsNull
_
DoubleToSqlDecimal$IN$double$DOUBLE$
$result$$SQLDECIMAL$
_
IntToSqlDecimal$IN$integer$INT$
$result$$SQLDECIMAL$
_
isSqlDecimalEqualNull$IN$sql_decimal$SQLDECIMAL$
$result$$BOOL$
_
multiplySqlDecimal$IN$left_operand$SQLDECIMAL$DecimalRangeOverflow
$IN$right_operand$SQLDECIMAL$DecimalRangeUnderflow
$result$$SQLDECIMAL$FirstOperandIsNull
$$$$SecondOperandIsNull
_
roundSqlDecimal$IN$sql_decimal$SQLDECIMAL$PositionIsNegative
$IN$position$INT$ValueIsNull
$result$$SQLDECIMAL$
_
setSqlDecimalToNull$result$$SQLDECIMAL$
_
SqlDecimal$IN$string$STRING$DecimalRangeOverflow
$result$$SQLDECIMAL$DecimalRangeUnderflow
$$$$StringContainsCharacters
$$$$WrongExponent
.TE
.NL
.nr PS 12
.\"KE
.LP
.bp
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
SqlDecimalToBcd$IN$sql_decimal$SQLDECIMAL$BcdIsOutOfRange
$result$$BCD$DecimalConversionFailed
$$$$ValueIsNull
_
SqlDecimalToDouble$IN$sql_decimal$SQLDECIMAL$ValueIsNull
$result$$DOUBLE$
_
SqlDecimalToInt$IN$sql_decimal$SQLDECIMAL$IntegerRangeOverflow
$result$$INT$ValueIsNull
_
SqlDecimalToString$IN$sql_decimal$SQLDECIMAL$DecimalConversionFailed
$IN$no_of_fractions$INT$ValueIsNull
$result$$STRING$
_
StringToSqlDecimal$IN$string$STRING$DecimalRangeOverflow
$result$$SQLDECIMAL$DecimalRangeUnderflow
$$$$LengthOfStringIsZero
$$$$StringContainsCharacters
$$$$WrongExponent
_
subtractSqlDecimal$IN$left_operand$SQLDECIMAL$DecimalRangeOverflow
$IN$right_operand$SQLDECIMAL$DecimalRangeUnderflow
$result$$SQLDECIMAL$FirstOperandIsNull
$$$$SecondOperandIsNull
_
truncateSqlDecimal$IN$sql_decimal$SQLDECIMAL$PositionIsNegative
$IN$position$INT$ValueIsNull
$result$$SQLDECIMAL$
.TE
.NL
.nr PS 12
.LP
.OH "'SOI Reference Manual''SQL-CooL-Data-Types'"
.EH "'SQL-CooL-Data-Types''SOI Reference Manual'"
.bp
.NX 3 "The SQL-CooL-Data-Type SQLMONEY"
.sp
For working with the SQL-CooL-Data-Type SQLMONEY one has to 
declare at least one variable of this type:
.LP
.CS L
VAR my_sql_money : SqlDecimal::SQLMONEY;
.CE
.LP
The CooL library CoLibri provides a number of functions which manipulate
values of type SQLMONEY and functions which convert a value of type
SQLMONEY to other types (e.g. INTEGER, DOUBLE, CHAR and BCD) and vice 
versa.
.LP
A variable of the type SQLMONEY can be manipulated by calling the same
functions as they were defined for the SQL-CooL-Data-Type SQLDECIMAL.
.LP
.bp
.NX 3 "The SQL-CooL-Data-Type SQLDATE"
.sp
For working with the SQL-CooL-Data-Type SQLDATE one has to declare at
least one variable of this type:
.sp 0.5
.CS L
VAR my_sql_date : SqlDate::SQLDATE;
.CE
.sp 0.5
The CooL library CoLibri provides a number of functions which manipulate
values of type SQLDATE and functions which convert a value of type
SQLDATE to other types (e.g. CHAR and \f(HODate\fP (see [2])) and vice 
versa.
.sp 0.5
A variable of the type SQLDATE can be manipulated by the following set 
of functions.
.sp
.OH "'SOI Reference Manual''SqlDate::DateToSqlDate'"
.EH "'SqlDate::DateToSqlDate''SOI Reference Manual'"
.bp
.NX 4 "DateToSqlDate"
.sp
.IP MODULE
\f(HBSqlDate\fP
.IP TYPE
\f(HBSQLDATE\fP
.IP SYNOPSIS
\f(HBPROCEDURE DateToSqlDate ( IN date : Date ) : SQLDATE;\fP
.IP DESCRIPTION
The function \f(HODateToSqlDate\fP can be used to convert the input 
variable \f(HOdate\fP of type \f(HODate\fP (see [2]) to a variable of 
type SQLDATE.
.IP "RETURN VALUE"
The result of this function call is the SQLDATE representation of the
input variable \f(HOdate\fP.
.KS
.IP EXAMPLES
.CS L
VAR day        : INT;
VAR month      : INT;
VAR year       : INT;
VAR a_date     : Date::Date;
VAR a_sql_date : SqlDate::SQLDATE;
\&...
day   := 24;
month := 12;
year  := 1992;
\&...
a_date := NEW Date::Date (year, month, day);
a_sql_date := SqlDate::DateToSqlDate (a_date);
.CE
.KE
a_sql_date  initialized with the value "33961",
which is the number of days since 31.12.1899.
.IP "SEE ALSO"
\f(HOSqlDateToDate\fP
.LP
.OH "'SOI Reference Manual''SqlDate::getCurrentSqlDate'"
.EH "'SqlDate::getCurrentSqlDate''SOI Reference Manual'"
.bp
.NX 4 "getCurrentSqlDate"
.sp
.IP MODULE
\f(HBSqlDate\fP
.IP TYPE
\f(HBSQLDATE\fP
.IP SYNOPSIS
\f(HBPROCEDURE getCurrentSqlDate () : SQLDATE;\fP
.IP DESCRIPTION
The function \f(HOgetCurrentSqlDate\fP can be used to assign the actual 
date to a variable of type SQLDATE.
.IP "RETURN VALUE"
The result of this function call is the actual date.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_date : SqlDate::SQLDATE;
\&...
a_sql_date := SqlDate::getCurrentSqlDate ();
.CE
.KE
a_sql_date was initialized with the value "33961", if one 
imagine that this day is Christmas 1992. 
.LP
.OH "'SOI Reference Manual''SqlDate::getSqlDate'"
.EH "'SqlDate::getSqlDate''SOI Reference Manual'"
.bp
.NX 4 "getSqlDate"
.sp
.IP MODULE
\f(HBSqlDate\fP
.IP TYPE
\f(HBSQLDATE\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE getSqlDate ($ IN $ sql_date $ : SQLDATE,
$ OUT $ year $ : INT,
$ OUT $ month $ : INT,
$ OUT $ day $ : INT );\fP
.TE
.IP DESCRIPTION
The procedure \f(HOgetSqlDate\fP can be used to get the single 
components \f(HOyear\fP, \f(HOmonth\fP and \f(HOday\fP of 
\f(HOsql_date\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_date\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR year       : INT;
VAR month      : INT;
VAR day        : INT;
VAR a_sql_date : SqlDate::SQLDATE;
\&...
a_sql_date := SqlDate::StringToSqlDate ("24.12.1992");
\&...
SqlDate::getSqlDate (a_sql_date, year, month, day);
.CE
.KE
a_sql_date was initialized with the value "33961",
which is the number of days since 31.12.1899.
Now year contains the value "1992", month contains the 
value "12" and day contains the value "24".
.IP "SEE ALSO"
\f(HOputSqlDate\fP
.LP
.OH "'SOI Reference Manual''SqlDate::getDayOfWeekOfSqlDate'"
.EH "'SqlDate::getDayOfWeekOfSqlDate''SOI Reference Manual'"
.bp
.NX 4 "getDayOfWeekOfSqlDate"
.sp
.IP MODULE
\f(HBSqlDate\fP
.IP TYPE
\f(HBSQLDATE\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE getDayOfWeekOfSqlDate $( IN sql_date : SQLDATE )
$: INT;\fP
.TE
.IP DESCRIPTION
The function \f(HOgetDayOfWeekOfSqlDate\fP can be used to compute the 
day of the week of the date in the input parameter \f(HOsql_date\fP.
.IP "RETURN VALUE"
The result of this function call is the number of the day of the week of
the given date.
This number is in the range of zero (for sunday) upto six (for saturday).
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_date\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR day        : INT;
VAR a_sql_date : SqlDate::SQLDATE;
\&...
a_sql_date := SqlDate::StringToSqlDate ("24.12.1992");
\&...
day := SqlDate::getDayOfWeekOfSqlDate (a_sql_date);
.CE
.KE
a_sql_date was initialized with the value "33961",
which is the number of days since 31.12.1899.
Now day contains the value "4", which is equivalent with "Thursday".
.LP
.OH "'SOI Reference Manual''SqlDate::isLeapYear'"
.EH "'SqlDate::isLeapYear''SOI Reference Manual'"
.bp
.NX 4 "isLeapYear"
.sp
.IP MODULE
\f(HBSqlDate\fP
.IP TYPE
\f(HBSQLDATE\fP
.IP SYNOPSIS
\f(HBPROCEDURE isLeapYear ( IN year : INT ) : BOOL;\fP
.IP DESCRIPTION
The function \f(HOisLeapYear\fP can be used to check whether the value 
of the input parameter \f(HOyear\fP is a leap-year.
.IP NOTE
For the input parameter \f(HOyear\fP only values describing a year but 
not a complete date is allowed.
.IP "RETURN VALUE"
The result of this function call is the boolean value
.in +2
.IP TRUE 
if the value of the input variable \f(HOyear\fP is a leap-year.
.IP FALSE
if the value of the input variable \f(HOyear\fP is not a leap-year.
.in -2
.KS
.IP EXAMPLES
.CS L
VAR year : INT;
\&...
year := 1991;
IF   SqlDate::isLeapYear (year)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because 1991 was not a leap-year.\fP
END IF;
\&...
year := 1992;
IF   SqlDate::isLeapYear (year)
THEN
     -- \f(HONow execution continues here because 1992 was a leap-year.\fP
ELSE
     ...
END IF;
.CE
.KE
.LP
.OH "'SOI Reference Manual''SqlDate::isSqlDateEqualNull'"
.EH "'SqlDate::isSqlDateEqualNull''SOI Reference Manual'"
.bp
.NX 4 "isSqlDateEqualNull"
.sp
.IP MODULE
\f(HBSqlDate\fP
.IP TYPE
\f(HBSQLDATE\fP
.IP SYNOPSIS
\f(HBPROCEDURE isSqlDateEqualNull ( IN sql_date : SQLDATE ) : BOOL;\fP
.IP DESCRIPTION
The function \f(HOisSqlDateEqualNull\fP can be used to check if the 
input variable \f(HOsql_date\fP of type SQLDATE contains the null value.
.IP "RETURN VALUE"
The result of this function call is the boolean value
.in +2
.IP "TRUE        "
if the input variable \f(HOsql_date\fP contains the null value.
.IP "FALSE       "
if the input variable \f(HOsql_date\fP does not contain the null value.
.in -2
.KS
.IP EXAMPLES
.CS L
VAR a_sql_date : SqlDate::SQLDATE;
\&...
a_sql_date := SqlDate::StringToSqlDate ("24.12.1992");
-- \f(HOa_sql_date was initialized with the value "33961",\fP
-- \f(HOwhich is the number of days since 31.12.1899.\fP
\&...
IF   SqlDate::isSqlDateEqualNull (a_sql_date)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_date\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOsetSqlDateToNull\fP
.LP
.OH "'SOI Reference Manual''SqlDate::putSqlDate'"
.EH "'SqlDate::putSqlDate''SOI Reference Manual'"
.bp
.NX 4 "putSqlDate"
.sp
.IP MODULE
\f(HBSqlDate\fP
.IP TYPE
\f(HBSQLDATE\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE putSqlDate $($ IN year $ : INT,
$$ IN month $ : INT,
$$ IN day $ : INT )
$:$ SQLDATE;$\fP
.TE
.IP DESCRIPTION
The function \f(HOputSqlDate\fP can be used to convert the single 
components \f(HOyear\fP, \f(HOmonth\fP and \f(HOday\fP into a value of 
type SQLDATE.
.IP "RETURN VALUE"
The result of this function call is the SQLDATE representation of the
single components day, month and year.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOInvalidDay\fP"
is raised, if the input variable \f(HOday\fP does
not contain the representation of a valid day.
.IP "\(bu \f(HOInvalidMonth\fP"
is raised, if the input variable \f(HOmonth\fP
does not contain the representation of a valid month.
.IP "\(bu \f(HOInvalidYear\fP"
is raised, if the input variable \f(HOyear\fP does not contain the 
representation of a valid year.
.KS
.IP EXAMPLES
.CS L
VAR year       : INT;
VAR month      : INT;
VAR day        : INT;
VAR a_sql_date : SqlDate::SQLDATE;
\&...
year  := 1992;
month := 12;
day   := 31;
a_sql_date := SqlDate::putSqlDate (year, month, day);
.CE
.KE
a_sql_date was initialized with the value "33968",
which is the number of days since 31.12.1899.
.IP "SEE ALSO"
\f(HOgetSqlDate\fP
.LP
.OH "'SOI Reference Manual''SqlDate::setSqlDateToNull'"
.EH "'SqlDate::setSqlDateToNull''SOI Reference Manual'"
.bp
.NX 4 "setSqlDateToNull"
.sp
.IP MODULE
\f(HBSqlDate\fP
.IP TYPE
\f(HBSQLDATE\fP
.IP SYNOPSIS
\f(HBPROCEDURE setSqlDateToNull () : SQLDATE;\fP
.IP DESCRIPTION
The function \f(HOsetSqlDateToNull\fP can be used to set a variable of 
type SQLDATE to the null value.
.IP "RETURN VALUE"
The result of this function call is a variable of type SQLDATE which
contains the null value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_date : SqlDate::SQLDATE;
\&...
a_sql_date := SqlDate::StringToSqlDate ("24.12.1992");
-- \f(HOa_sql_date was initialized with the value "33961",\fP
-- \f(HOwhich is the number of days since 31.12.1899.\fP
\&...
IF   SqlDate::isSqlDateEqualNull (a_sql_date)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_date\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
a_sql_date := SqlDate::setSqlDateToNull ();
IF   SqlDate::isSqlDateEqualNull (a_sql_date)
THEN
     -- \f(HONow execution continues here.\fP
ELSE
     ...
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOisSqlDateEqualNull\fP
.LP
.OH "'SOI Reference Manual''SqlDate::SqlDateToDate'"
.EH "'SqlDate::SqlDateToDate''SOI Reference Manual'"
.bp
.NX 4 "SqlDateToDate"
.sp
.IP MODULE
\f(HBSqlDate\fP
.IP TYPE
\f(HBSQLDATE\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE SqlDateToDate ($ IN $ sql_date $ : SQLDATE,
$ INOUT $ date $ : Date );\fP
.TE
.IP DESCRIPTION
The procedure \f(HOSqlDateToDate\fP can be used to convert the input 
variable \f(HOsql_date\fP of type SQLDATE to a variable \f(HOdate\fP of
type \f(HODate\fP (see [2]).
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_date\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_date     : Date::Date;
VAR a_sql_date : SqlDate::SQLDATE;
\&...
a_sql_date := SqlDate::StringToSqlDate ("24.12.1992");
a_date := NEW Date::Date (1900, 1, 1);
\&...
SqlDate::SqlDateToDate (a_sql_date, a_date);
.CE
.KE
a_sql_date was initialized with the value "33961",
which is the number of days since 31.12.1899.
The instance variables of a_date were initialized with the 
values 1 for the day, 1 for the month and 1900 for the year.
.br
Now the instance variables of a_date contain the values
24 for the day, 12 for the month and 1992 for the year.
.IP "SEE ALSO"
\f(HODateToSqlDate\fP
.LP
.OH "'SOI Reference Manual''SqlDate::SqlDateToString'"
.EH "'SqlDate::SqlDateToString''SOI Reference Manual'"
.bp
.NX 4 "SqlDateToString"
.sp
.IP MODULE
\f(HBSqlDate\fP
.IP TYPE
\f(HBSQLDATE\fP
.IP SYNOPSIS
\f(HBPROCEDURE SqlDateToString ( IN sql_date : SQLDATE ) : STRING;\fP
.IP DESCRIPTION
The procedure \f(HOSqlDateToString\fP can be used to convert the input 
variable \f(HOsql_date\fP of type SQLDATE to a STRING.
The format of the delivered string representation of \f(HOsql_date\fP is
determined by the environment variable \f(HODBDATE\fP (see the 
documentation of the relational data base system INFORMIX).
.IP "RETURN VALUE"
The result of this function is the STRING representation of the input
variable \f(HOsql_date\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_date\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_string   : STRING;
VAR a_sql_date : SqlDate::SQLDATE;
\&...
a_sql_date := SqlDate::StringToSqlDate ("24.12.1992");
\&...
a_string := SqlDate::SqlDateToString (a_sql_date);
.CE
.KE
a_sql_date was initialized with the value "33961",
which is the number of days since 31.12.1899.
Now a_string contains the value "24.12.1992".
.IP "SEE ALSO"
\f(HOStringToSqlDate\fP
.LP
.OH "'SOI Reference Manual''SqlDate::SqlDateToStringFormatted'"
.EH "'SqlDate::SqlDateToStringFormatted''SOI Reference Manual'"
.bp
.NX 4 "SqlDateToStringFormatted"
.sp
.IP MODULE
\f(HBSqlDate\fP
.IP TYPE
\f(HBSQLDATE\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE $$SqlDateToStringFormatted$
$($ IN sql_date $ : SQLDATE,
$$ IN format $ : STRING )
$:$ STRING;$\fP
.TE
.IP DESCRIPTION
The procedure \f(HOSqlDateToStringFormatted\fP can be used to convert 
the input variable \f(HOsql_date\fP of type SQLDATE to a STRING.
The format of the delivered string representation of \f(HOsql_date\fP is
determined by the input variable \f(HOformat\fP.
.IP NOTE
To use this procedure one needs the INFORMIX message files (see the
documentation of the relational data base system INFORMIX).
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODateConversionFailed\fP"
is raised, if the input variable \f(HOsql_date\fP can not be transformed
successfully to a STRING.
.IP "\(bu \f(HOMemoryOverflow\fP"
is raised, if the memory space is exceeded during the conversion.
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_date\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_string   : STRING;
VAR a_format   : STRING;
VAR a_sql_date : SqlDate::SQLDATE;
\&...
a_sql_date := SqlDate::StringToSqlDate ("24.12.1992");
\&...
a_format   := "In yyyy Christmas was at ddd the ddth of mmm.";
a_string   := SqlDate::SqlDateToStringFormatted (a_sql_date, a_format);
.CE
.KE
a_sql_date was initialized with the value "33961",
which is the number of days since 31.12.1899.
Now a_string contains the following character sequence :
"In 1992 Christmas was at Thu the 24th of Dec."
.IP "SEE ALSO"
\f(HOStringFormattedToSqlDate\fP
.LP
.OH "'SOI Reference Manual''SqlDate::StringFormattedToSqlDate'"
.EH "'SqlDate::StringFormattedToSqlDate''SOI Reference Manual'"
.bp
.NX 4 "StringFormattedToSqlDate"
.sp
.IP MODULE
\f(HBSqlDate\fP
.IP TYPE
\f(HBSQLDATE\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE $$StringFormattedToSqlDate$
$($ IN string $ : STRING,
$$ IN format $ : STRING )
$:$ SQLDATE;$ \fP
.TE
.IP DESCRIPTION
The function \f(HOStringFormattedToSqlDate\fP can be used to convert a 
literal or a string to a variable of type SQLDATE.
The input parameter \f(HOstring\fP has to contain a valid representation
of a date value.
This representation is determined by the input parameter \f(HOformat\fP 
(see the documentation of the relational data base system INFORMIX).
.IP NOTE
To use this function one needs the INFORMIX message files (see the
documentation of the relational data base system INFORMIX).
.IP "RETURN VALUE"
The result of this function call is the SQLDATE representation of the
input literal or of the string.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODateComponentIsMissing\fP"
is raised, if the input parameter \f(HOstring\fP does not contain the 
representation of year, month or day.
.IP "\(bu \f(HOInvalidDay\fP"
is raised, if the input parameter \f(HOstring\fP does not contain the 
representation of a valid day.
.IP "\(bu \f(HOInvalidLength\fP"
is raised, if the input parameter \f(HOstring\fP does not contain 
delimiters between the date parts and does not have a length of six or 
eight characters.
.IP "\(bu \f(HOInvalidMonth\fP"
is raised, if the input parameter \f(HOstring\fP does not contain the 
representation of a valid month.
.IP "\(bu \f(HOInvalidYear\fP"
is raised, if the input parameter \f(HOstring\fP does not contain the 
representation of a valid year.
.IP "\(bu \f(HOLengthOfFormatIsZero\fP"
is raised, if the actual length of the input parameter \f(HOformat\fP is
zero.
.IP "\(bu \f(HOLengthOfStringIsZero\fP"
is raised, if the actual length of the input parameter \f(HOstring\fP is
zero.
.KS
.IP EXAMPLES
.CS L
VAR a_string   : STRING;
VAR a_format   : STRING;
VAR a_sql_date : SqlDate::SQLDATE;
\&...
a_string := "1992+12+24";
a_format := "yyyy+mm+dd";
a_sql_date := SqlDate::StringFormattedToSqlDate (a_string, a_format);
.CE
.KE
a_sql_date was initialized with the value "33961",
which is the number of days since 31.12.1899.
.IP "SEE ALSO"
\f(HOSqlDateToStringFormatted\fP
.LP
.OH "'SOI Reference Manual''SqlDate::StringToSqlDate'"
.EH "'SqlDate::StringToSqlDate''SOI Reference Manual'"
.bp
.NX 4 "StringToSqlDate"
.sp
.IP MODULE
\f(HBSqlDate\fP
.IP TYPE
\f(HBSQLDATE\fP
.IP SYNOPSIS
\f(HBPROCEDURE StringToSqlDate ( IN string : STRING ) : SQLDATE;\fP
.IP DESCRIPTION
The function \f(HOStringToSqlDate\fP can be used to convert a literal or
a string to a variable of type SQLDATE.
.sp 0.5
This variable will be filled with
.in +2
.IP "the actual date        "
if the input parameter \f(HOstring\fP has an actual length of zero.
.IP "a date value           "
if the input parameter \f(HOstring\fP has an actual length greater than
zero and contains a valid representation of a date value.
This representation is determined by the environment variable 
\f(HODBDATE\fP (see the documentation of the relational data base system
INFORMIX).
.in -2
.IP "RETURN VALUE"
The result of this function call is the SQLDATE representation of the
input literal or of the string.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HODateConversionFailed\fP"
is raised, if the function call was not successful, for example if 
\f(HOstring\fP does not contain a valid representation of a date value.
This exception will only be raised if the input parameter \f(HOstring\fP
has an actual length greater than zero.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_date : SqlDate::SQLDATE;
\&...
a_sql_date := SqlDate::StringToSqlDate ("24.12.1992");
.CE
.KE
After this assignment a_sql_date contains the value "33961",
which is the number of days since 31.12.1899.
.IP "SEE ALSO"
\f(HOSqlDateToString\fP
.LP
.OH "'SOI Reference Manual''SqlDate'"
.EH "'SqlDate''SOI Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOSqlDate\fP concerning the data type SQLDATE.
.\"KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
DateToSqlDate$IN$date$Date$
$result$$SQLDATE$
_
getCurrentSqlDate$result$$SQLDATE$
_
getSqlDate$IN$sql_date$SQLDATE$ValueIsNull
$OUT$year$INT$
$OUT$month$INT$
$OUT$day$INT$
_
getDayOfWeekOfSqlDate$IN$sql_date$SQLDATE$ValueIsNull
$result$$INT$
_
isLeapYear$IN$year$INT$
$result$$BOOL$
_
isSqlDateEqualNull$IN$sql_date$SQLDATE$
$result$$BOOL$
_
putSqlDate$IN$year$INT$InvalidDay
$IN$month$INT$InvalidMonth
$IN$day$INT$InvalidYear
$result$$SQLDATE$
_
setSqlDateToNull$result$$SQLDATE$
_
SqlDateToDate$IN$sql_date$SQLDATE$ValueIsNull
$INOUT$date$Date$
_
SqlDateToString$IN$sql_date$SQLDATE$ValueIsNull
$result$$STRING$
_
SqlDateToStringFormatted$IN$sql_date$SQLDATE$DateConversionFailed
$IN$format$STRING$MemoryOverflow
$result$$STRING$ValueIsNull
_
StringFormattedToSqlDate$IN$string$STRING$DateComponentIsMissing
$IN$format$STRING$InvalidDay
$result$$SQLDATE$InvalidLength
$$$$InvalidMonth
$$$$InvalidYear
$$$$LengthOfFormatIsZero
$$$$LengthOfStringIsZero
_
StringToSqlDate$IN$string$STRING$DateConversionFailed
$result$$SQLDATE$
.TE
.NL
.nr PS 12
.\"KE
.LP
.OH "'SOI Reference Manual''SQL-CooL-Data-Types'"
.EH "'SQL-CooL-Data-Types''SOI Reference Manual'"
.bp
.NX 3 "The SQL-CooL-Data-Type SQLDATETIME"
.sp
For working with the SQL-CooL-Data-Type SQLDATETIME one has to declare 
at least one variable of this type:
.sp 0.5
.CS L
VAR my_sql_ddtetime : SqlDate::SQLDATETIME;
.CE
.sp 0.5
The CooL library CoLibri provides a number of functions which manipulate
values of type SQLDATETIME and functions which convert a value of type
SQLDATETIME to other types (e.g. CHAR, \f(HOSqlDate\fP and
\f(HOTimeStamp\fP (see [2])) and vice versa.
.sp 0.5
A variable of the type SQLDATETIME can be manipulated by the following
set of functions.
.LP
.OH "'SOI Reference Manual''SqlDate::copySqlDatetime'"
.EH "'SqlDate::copySqlDatetime''SOI Reference Manual'"
.bp
.NX 4 "copySqlDatetime"
.sp
.IP MODULE
\f(HBSqlDatetime\fP
.IP TYPE
\f(HBSQLDATETIME\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE copySqlDatetime ($ IN $ source $ : SQLDATETIME,
$ INOUT $ destination $ : SQLDATETIME );\fP
.TE
.IP DESCRIPTION
The procedure \f(HOcopySqlDatetime\fP can be used to copy the contents 
of the input variable \f(HOsource\fP to the variable \f(HOdestination\fP.
Its components are filled with the same contents as the corresponding
components of the \f(HOsource\fP variable.
.IP NOTE
The components of the \f(HOdestination\fP variable determine which 
components of the \f(HOsource\fP variable will be copied.
For example if the \f(HOdestination\fP variable consists of the 
components year to day and the \f(HOsource\fP variable consists of the 
components year to second then only the contents of the components year,
month and day will be copied.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOInvalidComponent\fP"
is raised, if the input parameter \f(HOsource\fP consists of invalid 
components (e.g. this is the case if the function \f(HOSqlDatetime\fP 
was not called before calling this function).
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsource\fP contains the null value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_datetime       : SqlDate::SQLDATETIME;
VAR another_sql_datetime : SqlDate::SQLDATETIME;
\&...
a_sql_datetime := SqlDate::SqlDatetime (SqlDate::YEARS, 
                                        SqlDate::SECONDS, 
                                        "1992-12-24 15:30:45");
another_sql_datetime := SqlDate::SqlDatetime (SqlDate::HOURS, 
                                              SqlDate::SECONDS, 
                                              "");
\&...
SqlDate::copySqlDatetime (a_sql_datetime, another_sql_datetime);
.CE
.KE
a_sql_datetime is defined for the range years downto seconds and
initialized with the value "1992-12-24" for the date and "15:30:45" for
the time.
.br
another_sql_datetime is defined for the range hours downto 
seconds and initialized with the actual time.
.br
Now another_sql_datetime contains the value "15:30:45" for the 
time.
.OH "'SOI Reference Manual''SqlDate::getCurrentSqlDatetime'"
.EH "'SqlDate::getCurrentSqlDatetime''SOI Reference Manual'"
.LP
.bp
.NX 4 "getCurrentSqlDatetime"
.sp
.IP MODULE
\f(HBSqlDatetime\fP
.IP TYPE
\f(HBSQLDATETIME\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE $getCurrentSqlDatetime
$( INOUT sql_datetime : SQLDATETIME );\fP
.TE
.IP DESCRIPTION
The procedure \f(HOgetCurrentSqlDatetime\fP can be used to assign the 
actual date and time to a variable of type SQLDATETIME.
.IP NOTE
This procedure only works if the component YEARS is defined as part of 
this variable.
Otherwise zero will be assigned to all components.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_datetime : SqlDate::SQLDATETIME;
\&...
a_sql_datetime := SqlDate::SqlDatetime (SqlDate::YEARS, 
                                        SqlDate::SECONDS, 
                                        "1992-12-31 15:30:45");
\&...
SqlDate::getCurrentSqlDatetime (a_sql_datetime);
.CE
.KE
a_sql_datetime is defined for the range years downto seconds and
initialized with the value "1992-12-31" for the date and "15:30:45" for
the time.
.br
Now a_sql_datetime contains the value "1992-12-24" for the date
and "08:10:20" for the time, if one imagines that today is Christmas
in the morning.
.LP
.OH "'SOI Reference Manual''SqlDate::isSqlDatetimeEqualNull'"
.EH "'SqlDate::isSqlDatetimeEqualNull''SOI Reference Manual'"
.bp
.NX 4 "isSqlDatetimeEqualNull"
.sp
.IP MODULE
\f(HBSqlDatetime\fP
.IP TYPE
\f(HBSQLDATETIME\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE $$isSqlDatetimeEqualNull
$($ IN sql_datetime : SQLDATETIME )
$:$ BOOL;\fP
.TE
.IP DESCRIPTION
The function \f(HOisSqlDatetimeEqualNull\fP can be used to check if the 
input variable \f(HOsql_datetime\fP of type SQLDATETIME contains the 
null value.
.IP "RETURN VALUE"
The result of this function call is the boolean value
.in +2
.IP "TRUE        "
if the input variable \f(HOsql_datetime\fP contains the null value.
.IP "FALSE       "
if the input variable \f(HOsql_datetime\fP does not contain the null 
value.
.in -2
.KS
.IP EXAMPLES
.CS L
VAR a_sql_datetime : SqlDate::SQLDATETIME;
\&...
a_sql_datetime := SqlDate::SqlDatetime (SqlDate::YEARS, 
                                        SqlDate::SECONDS, 
                                        "1992-12-31 15:30:45");
\&...
IF   SqlDate::isSqlDatetimeEqualNull (a_sql_datetime)
THEN
     ...
ELSE
     ...
END IF;
.CE
.KE
a_sql_datetime is defined for the range years downto seconds and
initialized with the value "1992-12-31" for the date and "15:30:45" for
the time.
.br
The execution continues in the ELSE part of the IF statement because 
a_sql_datetime was initialized with "not null" automatically.
.IP "SEE ALSO"
\f(HOsetSqlDatetimeToNull\fP
.LP
.OH "'SOI Reference Manual''SqlDate::setSqlDatetimeToNull'"
.EH "'SqlDate::setSqlDatetimeToNull''SOI Reference Manual'"
.bp
.NX 4 "setSqlDatetimeToNull"
.sp
.IP MODULE
\f(HBSqlDatetime\fP
.IP TYPE
\f(HBSQLDATETIME\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBPROCEDURE $$setSqlDatetimeToNull
$($ INOUT sql_datetime : SQLDATETIME );\fP
.TE
.IP DESCRIPTION
The function \f(HOsetSqlDatetimeToNull\fP can be used to set the 
variable \f(HOsql_datetime\fP to the null value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_datetime : SqlDate::SQLDATETIME;
\&...
a_sql_datetime := SqlDate::SqlDatetime (SqlDate::YEARS, 
                                        SqlDate::SECONDS, 
                                        "1992-12-31 15:30:45");
-- \f(HOa_sql_datetime is defined for the range years downto seconds and\fP
-- \f(HOinitialized with the value "1992-12-31" for the date and\fP
-- \f(HO"15:30:45" for the time.\fP
\&...
IF   SqlDate::isSqlDatetimeEqualNull (a_sql_datetime)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_datetime\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
SqlDate::setSqlDatetimeToNull (a_sql_datetime);
IF   SqlDate::isSqlDatetimeEqualNull (a_sql_datetime)
THEN
     -- \f(HONow execution continues here.\fP
ELSE
     ...
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOisSqlDatetimeEqualNull\fP
.LP
.OH "'SOI Reference Manual''SqlDate::SqlDatetime'"
.EH "'SqlDate::SqlDatetime''SOI Reference Manual'"
.bp
.NX 4 "SqlDatetime"
.sp
.IP MODULE
\f(HBSqlDatetime\fP
.IP TYPE
\f(HBSQLDATETIME\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE SqlDatetime $($ IN from $ : INT,
$$ IN to $ : INT,
$$ IN string $ : STRING )
$:$ SQLDATETIME;$\fP
.TE
.IP DESCRIPTION
The function \f(HOSqlDatetime\fP has to be used to initialize a variable
of type SQLDATETIME.
.sp 0.5
The parameters \f(HOfrom\fP and \f(HOto\fP define which components will 
be part of this variable.
For both parameters the following values are possible: 
.in +2
.IP "\(bu {YEARS}"
.IP "\(bu {MONTHS}"
.IP "\(bu {DAYS}"
.IP "\(bu {HOURS}"
.IP "\(bu {MINUTES}"
.IP "\(bu {SECONDS}"
.IP "\(bu {FRACTIONS}"
.IP "\(bu {FRACTIONS_1}"
.IP "\(bu {FRACTIONS_2}"
.IP "\(bu {FRACTIONS_3}"
.IP "\(bu {FRACTIONS_4}"
.IP "\(bu {FRACTIONS_5}"
.in -2
(see the documentation of the relational data base system INFORMIX).
.br
The first parameter \f(HOfrom\fP has to contain the larger component.
.sp 0.5
Additionally this variable will be filled with
.in +2
.IP "the actual date and time"
if the input parameter \f(HOstring\fP has an actual length of zero and 
the input parameter \f(HOfrom\fP contains the value {YEARS}.
.IP "zero                    "
if the input parameter \f(HOstring\fP has an actual length of zero and 
the input parameter \f(HOfrom\fP does not contain the value {YEARS}.
.IP "a date and time value   "
if the input parameter \f(HOstring\fP has an actual length greater than
zero and contains a valid representation of a date and time value (see 
the documentation of the relational data base system INFORMIX).
.in -2
.IP "RETURN VALUE"
The result of this function call is an initialized variable of type
SQLDATETIME.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOIllegalComponent\fP"
is raised, if either the first parameter \f(HOfrom\fP or the second 
parameter \f(HOto\fP contain a value which is not in the range of 
\&{YEARS} to {FRACTIONS_5}.
.IP "\(bu \f(HOWrongOrderOfComponents\fP"
is raised, if the first parameter \f(HOfrom\fP contains the definition 
of a component which is less than the one contained by the second 
parameter \f(HOto\fP.
.sp
The following exceptions will only be raised if the input parameter
\f(HOstring\fP has an actual length greater than zero.
.sp
.IP "\(bu \f(HOIncompatibleConversion\fP"
is raised, if the input parameter \f(HOstring\fP consists of 
incompatible values for a variable of type SQLDATETIME.
.IP "\(bu \f(HOInvalidComponent\fP"
is raised, if the input parameter \f(HOstring\fP consists of values 
which are not in the range of \f(HOfrom\fP and \f(HOto\fP (e.g. the 
range is \f(HOfrom\fP year \f(HOto\fP hour and \f(HOstring\fP contains a
value for a second).
.IP "\(bu \f(HONoConversionPossible\fP"
is raised, if a initialization of the delivered variable of type 
SQLDATETIME is not possible.
.IP "\(bu \f(HORangeOverflow\fP"
is raised, if a component delivered by the input parameter 
\f(HOstring\fP contains a value which violates the range for
this component (e.g. value for the component "month" is bigger than 12).
.IP "\(bu \f(HOResultOverflow\fP"
is raised, if the result of the conversion violates the range for a 
variable of type SQLDATETIME (see the documentation of the relational 
data base system INFORMIX).
.IP "\(bu \f(HOStringContainsCharacters\fP"
is raised, if the input parameter \f(HOstring\fP contains character 
values.
.IP "\(bu \f(HOTooMuchValuesAtBeginning\fP"
is raised, if the input parameter \f(HOstring\fP contains too many 
values for the first part of the delivered variable of type SQLDATETIME.
.IP "\(bu \f(HOTooMuchValuesAtEnd\fP"
is raised, if there are remaining values at the end of the input 
parameter \f(HOstring\fP.
.IP "\(bu \f(HOValueOverflow\fP"
is raised, if an overflow occurs during the conversion.
.KS
.IP EXAMPLES
.CS L
VAR a_string             : STRING;
VAR a_sql_datetime       : SqlDate::SQLDATETIME;
VAR another_sql_datetime : SqlDate::SQLDATETIME;
\&...
a_sql_datetime := SqlDate::SqlDatetime (SqlDate::YEARS, 
                                        SqlDate::DAYS, 
                                        "");
\&...
.CE
.KE
a_sql_datetime is defined for the range years downto days and
initialized with the value "1992-12-06" for the date if one imagines
that today is St. Nicholas' Day.
Additionally it was set to "not null".
.KS
.CS L
\&...
a_string       := "1992-12-24 15:30:45.12345";
a_sql_datetime := SqlDate::SqlDatetime (SqlDate::YEARS, 
                                        SqlDate::FRACTIONS_5, 
                                        a_string);
\&...
.CE
.KE
Now \f(HOa_sql_datetime\fP is defined for the range years downto 5 
fractions and initialized with the value "1992-12-24" for the date and
"15:30:45.12345" for the time.
Additionally it was set to "not null".
.KS
.CS L
\&...
another_sql_datetime := SqlDate::SqlDatetime (SqlDate::YEARS, 
                                              SqlDate::SECONDS,
                                              "1992-12-31 20:30:40");
\&...
.CE
.KE
\f(HOanother_sql_datetime\fP is defined for the range years downto 
seconds and initialized with the value "1992-12-31" for the date and
"20:30:40" for the time.
Additionally it was set to "not null".
.IP "SEE ALSO"
\f(HOStringToSqlDatetime\fP
.LP
.OH "'SOI Reference Manual''SqlDate::SqlDatetimeToSqlDate'"
.EH "'SqlDate::SqlDatetimeToSqlDate''SOI Reference Manual'"
.bp
.NX 4 "SqlDatetimeToSqlDate"
.sp
.IP MODULE
\f(HBSqlDatetime\fP
.IP TYPE
\f(HBSQLDATETIME\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l.
\f(HBPROCEDURE $$SqlDatetimeToSqlDate
$($ IN sql_datetime : SQLDATETIME )
$:$ SQLDATE;\fP
.TE
.IP DESCRIPTION
The function \f(HOSqlDatetimeToSqlDate\fP can be used to convert the 
input variable \f(HOsql_datetime\fP of type SQLDATETIME to a variable of
type SQLDATE.
.sp 0.5
If \f(HOsql_datetime\fP is defined for more components than year to day,
the contents of the additional components will be lost.
.sp 0.5
If \f(HOsql_datetime\fP is defined for a combination less than year to
day, standard values will be used for the missing components (see the
documentation of the relational data base system INFORMIX).
.IP NOTE
For the use of this function one needs the INFORMIX message files (see 
the documentation of the relational data base system INFORMIX).
.IP "RETURN VALUE"
The result of this function call is the SQLDATE representation of the
input variable \f(HOsql_datetime\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_datetime\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_date     : SqlDate::SQLDATE;
VAR a_sql_datetime : SqlDate::SQLDATETIME;
\&...
a_sql_datetime := SqlDate::SqlDatetime (SqlDate::YEARS, 
                                        SqlDate::SECONDS, 
                                        "1992-12-24 15:30:45");
\&...
a_sql_date := SqlDate::SqlDatetimeToSqlDate (a_sql_datetime);
.CE
.KE
a_sql_datetime is defined for the range years downto seconds and
initialized with the value "1992-12-24" for the date and "15:30:45" for
the time.
.br
Now a_sql_date contains the value "33961" (24.12.1992), which is
the number of days since 31.12.1899.
.IP "SEE ALSO"
\f(HOSqlDateToSqlDatetime\fP
.OH "'SOI Reference Manual''SqlDate::SqlDatetimeToString'"
.EH "'SqlDate::SqlDatetimeToString''SOI Reference Manual'"
.LP
.bp
.NX 4 "SqlDatetimeToString"
.sp
.IP MODULE
\f(HBSqlDatetime\fP
.IP TYPE
\f(HBSQLDATETIME\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE $SqlDatetimeToString
$( IN sql_datetime : SQLDATETIME )
$: STRING;\fP
.TE
.IP DESCRIPTION
The procedure \f(HOSqlDatetimeToString\fP can be used to convert the 
input variable \f(HOsql_datetime\fP of type SQLDATETIME to a STRING.
.sp 0.5
The length of the string depends on the number of components defined for
\f(HOsql_datetime\fP using the function \f(HOSqlDatetime()\fP.
If \f(HOsql_datetime\fP consists of all components (year to fraction) 
one will get a string with at least 26 characters (see the documentation
of the relational data base system INFORMIX).
.IP "RETURN VALUE"
The result of this function call is the STRING representation of the 
input variable \f(HOsql_datetime\fP.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_datetime\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_string       : STRING;
VAR a_sql_datetime : SqlDate::SQLDATETIME;
\&...
a_sql_datetime := SqlDate::SqlDatetime (SqlDate::YEARS, 
                                        SqlDate::SECONDS, 
                                        "1992-12-31 15:30:45");
\&...
a_string := SqlDate::SqlDatetimeToString (a_sql_datetime);
.CE
.KE
a_sql_datetime is defined for the range years downto seconds and
initialized with the value "1992-12-31" for the date and "15:30:45" for
the time.
.br
Now a_string contains the value "1992-12-31 15:30:45".
.IP "SEE ALSO"
\f(HOStringToSqlDatetime\fP
.OH "'SOI Reference Manual''SqlDate::SqlDatetimeToTimeStamp'"
.EH "'SqlDate::SqlDatetimeToTimeStamp''SOI Reference Manual'"
.LP
.bp
.NX 4 "SqlDatetimeToTimeStamp"
.sp
.IP MODULE
\f(HBSqlDatetime\fP
.IP TYPE
\f(HBSQLDATETIME\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE $$SqlDatetimeToTimeStamp$
$($ IN    sql_datetime $ : SQLDATETIME,
$$ INOUT time_stamp $ : TimeStamp );\fP
.TE
.IP DESCRIPTION
The procedure \f(HOSqlDatetimeToTimeStamp\fP can be used to convert the 
input variable \f(HOsql_datetime\fP of type SQLDATETIME to a variable of
type \f(HOTimeStamp\fP (see [2]).
.IP NOTE
If \f(HOsql_datetime\fP contains the component fraction, the contents of
this component will be lost.
.sp 0.5
If \f(HOsql_datetime\fP is defined for a combination less than year to
second, standard values will be used for the missing components.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_datetime\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_string       : STRING;
VAR a_time         : Time::Time;
VAR a_time_stamp   : TimeSt::TimeStamp;
VAR a_sql_datetime : SqlDate::SQLDATETIME;
\&...
a_string       := "1992-12-24 15:30:45.12345";
a_sql_datetime := SqlDate::SqlDatetime (SqlDate::YEARS, 
                                        SqlDate::FRACTIONS_5, 
                                        a_string);
-- \f(HOa_sql_datetime is defined for the range years downto 5 fractions\fP
-- \f(HOand initialized with the value "1992-12-24" for the date and\fP
-- \f(HO"15:30:45.12345" for the time.\fP
.CE
.KE
.KS
.CS L
\&...
a_time := NEW Time::Time (12, 0, 0);
-- \f(HOThe instance variables of a_time were initialized with the values\fP
-- \f(HO12 for the hours, 0 for the minutes and 0 for the seconds.\fP
.CE
.KE
.KS
.CS L
\&...
a_time_stamp := NEW TimeSt::TimeStamp (1900, 1, 1, a_time);
-- \f(HOThe instance variables of a_time_stamp were initialized with\fP
-- \f(HOthe values 1 for the day, 1 for the month and 1900 for the year\fP
-- \f(HOtogether with the time value which was initialized before.\fP
.CE
.KE
.KS
.CS L
\&...
SqlDate::SqlDatetimeToTimeStamp (a_sql_datetime, a_time_stamp);
.CE
.KE
Now the instance variables of a_time_stamp contain the values
1992 for the year, 12 for the month and 24 for the day.
The instance variables of the included time contain the values 
15 for the hours, 30 for the minutes and 45 for the seconds.
The values for the fractions will be lost.
.IP "SEE ALSO"
\f(HOTimeStampToSqlDatetime\fP
.LP
.OH "'SOI Reference Manual''SqlDate::SqlDateToSqlDatetime'"
.EH "'SqlDate::SqlDateToSqlDatetime''SOI Reference Manual'"
.bp
.NX 4 "SqlDateToSqlDatetime"
.sp
.IP MODULE
\f(HBSqlDatetime\fP
.IP TYPE
\f(HBSQLDATETIME\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE $$SqlDateToSqlDatetime$
$($ IN    sql_date $ : SQLDATE,
$$ INOUT sql_datetime $ : SQLDATETIME );\fP
.TE
.IP DESCRIPTION
The procedure \f(HOSqlDateToSqlDatetime\fP can be used to convert the 
input variable \f(HOsql_date\fP of type SQLDATE to a variable of
type SQLDATETIME.
.sp 0.5
If \f(HOsql_datetime\fP is defined for more components than year to day,
standard values will be used for the additional components.
.sp 0.5
If \f(HOsql_datetime\fP is defined for a combination less than year to
day, the contents of the missing components will be lost.
.IP NOTE
To use this function one needs the INFORMIX message files (see the
documentation of the relational data base system INFORMIX).
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_date\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_date     : SqlDate::SQLDATE;
VAR a_sql_datetime : SqlDate::SQLDATETIME;
\&...
a_sql_date := SqlDate::StringToSqlDate ("24.12.1992");
-- \f(HOa_sql_date was initialized with the value "33961",\fP
-- \f(HOwhich is the number of days since 31.12.1899.\fP
\&...
a_sql_datetime := SqlDate::SqlDatetime (SqlDate::YEARS, 
                                        SqlDate::SECONDS, 
                                        "1992-12-31 15:30:45");
-- \f(HOa_sql_datetime is defined for the range years downto seconds and\fP
-- \f(HOinitialized with the value "1992-12-31" for the date and\fP
-- \f(HO"15:30:45" for the time.\fP
\&...
SqlDate::SqlDateToSqlDatetime (a_sql_date, a_sql_datetime);
.CE
.KE
Now a_sql_datetime contains the value "1992-12-24" for the date
and "00:00:00" for the time.
.IP "SEE ALSO"
\f(HOSqlDatetimeToSqlDate\fP
.OH "'SOI Reference Manual''SqlDate::StringToSqlDatetime'"
.EH "'SqlDate::StringToSqlDatetime''SOI Reference Manual'"
.LP
.bp
.NX 4 "StringToSqlDatetime"
.sp
.IP MODULE
\f(HBSqlDatetime\fP
.IP TYPE
\f(HBSQLDATETIME\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE $$StringToSqlDatetime$
$($ IN    string $ : STRING,
$$ INOUT sql_datetime $ : SQLDATETIME );\fP
.TE
.IP DESCRIPTION
The procedure \f(HOStringToSqlDatetime\fP can be used to convert a 
literal or a string to a variable of type SQLDATETIME.
The input parameter \f(HOstring\fP has to contain a valid representation
of a date and time value (see the documentation of the relational data 
base system INFORMIX).
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOIncompatibleConversion\fP"
is raised, if the input parameter \f(HOstring\fP consists of 
incompatible values for a variable of type SQLDATETIME (see the 
documentation of the relational data base system INFORMIX).
.IP "\(bu \f(HOInvalidComponent\fP"
is raised, if the input parameter \f(HOstring\fP consists of values 
which are not in the range as it was defined for \f(HOsql_datetime\fP by
calling the function \f(HOSqlDatetime\fP (e.g. the range is \f(HOfrom\fP
year \f(HOto\fP hour and \f(HOstring\fP contains a value for a second).
.IP "\(bu \f(HOLengthOfStringIsZero\fP"
is raised, if the actual length of the input parameter \f(HOstring\fP is
zero.
.IP "\(bu \f(HONoConversionPossible\fP"
is raised, if the conversion of the input parameter \f(HOstring\fP to a 
variable of type SQLDATETIME is not possible.
.IP "\(bu \f(HORangeOverflow\fP"
is raised, if a component delivered by the input parameter 
\f(HOstring\fP contains a value which violates the range for
this component (e.g. value for the component "month" is bigger than 12).
.IP "\(bu \f(HOResultOverflow\fP"
is raised, if the result of the conversion violates the range for a 
variable of type SQLDATETIME (see the documentation of the relational 
data base system INFORMIX).
.IP "\(bu \f(HOStringContainsCharacters\fP"
is raised, if the input parameter \f(HOstring\fP contains character 
values.
.IP "\(bu \f(HOTooMuchValuesAtBeginning\fP"
is raised, if the input parameter \f(HOstring\fP contains too many 
values for the first part of the delivered variable of type SQLDATETIME.
.IP "\(bu \f(HOTooMuchValuesAtEnd\fP"
is raised, if there are remaining values at the end of the input 
parameter \f(HOstring\fP.
.IP "\(bu \f(HOValueOverflow\fP"
is raised, if an overflow occurs during the conversion.
.KS
.IP EXAMPLES
.CS L
VAR a_string       : STRING;
VAR a_sql_datetime : SqlDate::SQLDATETIME;
\&...
a_sql_datetime := SqlDate::SqlDatetime (SqlDate::YEARS, 
                                        SqlDate::SECONDS, 
                                        "");
\&...
a_string       := "1992-12-24 15:30:45";
SqlDate::StringToSqlDatetime (a_string, a_sql_datetime);
.CE
.KE
a_sql_datetime is defined for the range years downto seconds and
initialized with the actual date and time.
Now a_sql_datetime contains the value "1992-12-24" for the date 
and "15:30:45" for the time.
.IP "SEE ALSO"
\f(HOSqlDatetime\fP,
\f(HOSqlDatetimeToString\fP 
.LP
.OH "'SOI Reference Manual''SqlDate::TimeStampToSqlDatetime'"
.EH "'SqlDate::TimeStampToSqlDatetime''SOI Reference Manual'"
.bp
.NX 4 "TimeStampToSqlDatetime"
.sp
.IP MODULE
\f(HBSqlDatetime\fP
.IP TYPE
\f(HBSQLDATETIME\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE $$TimeStampToSqlDatetime$
$($ IN    time_stamp $ : TimeStamp,
$$ INOUT sql_datetime $ : SQLDATETIME );\fP
.TE
.IP DESCRIPTION
The procedure \f(HOTimeStampToSqlDatetime\fP can be used to convert the 
input variable \f(HOtime_stamp\fP of type \f(HOTimeStamp\fP to a 
variable of type SQLDATETIME.
.sp 0.5
If \f(HOsql_datetime\fP contains the component fraction, a standard 
value will be used for this component.
.sp 0.5
If \f(HOsql_datetime\fP is defined for a combination less than year to
second, the contents of the missing components will be lost.
.KS
.IP EXAMPLES
.CS L
VAR a_year         : INT;
VAR a_month        : INT;
VAR a_day          : INT;
VAR a_hour         : INT;
VAR a_minute       : INT;
VAR a_second       : INT;
VAR a_time         : Time::Time;
VAR a_time_stamp   : TimeSt::TimeStamp;
VAR a_sql_datetime : SqlDate::SQLDATETIME;
.CE
.KE
.KS
.CS L
\&...
a_sql_datetime := SqlDate::SqlDatetime (SqlDate::YEARS, 
                                        SqlDate::FRACTIONS_5, 
                                        "");
-- \f(HOa_sql_datetime is defined for the range years downto 5 fractions\fP
-- \f(HOand initialized with the actual date and time.\fP
.CE
.KE
.KS
.CS L
\&...
a_year   := 1992;
a_month  := 12;
a_day    := 24;
a_hour   := 15;
a_minute := 30;
a_second := 45;
a_time := NEW Time::Time (a_hour, a_minute, a_second);
-- \f(HOThe instance variables of a_time were initialized with the values\fP
-- \f(HO15 for the hours, 30 for the minutes and 45 for the seconds.\fP
.CE
.KE
.KS
.CS L
\&...
a_time_stamp := NEW TimeSt::TimeStamp (a_year, a_month, a_day, a_time);
-- \f(HOThe instance variables of a_time_stamp were initialized with\fP
-- \f(HOthe values 24 for the day, 12 for the month and 1992 for the year\fP
-- \f(HOtogether with the time value which was initialized before.\fP
.CE
.KE
.KS
.CS L
\&...
SqlDate::TimeStampToSqlDatetime (a_time_stamp, a_sql_datetime);
.CE
.KE
Now a_sql_datetime contains the value "1992-12-24" for the date
and "15:30:45.00000" for the time.
.IP "SEE ALSO"
\f(HOSqlDatetimeToTimeStamp\fP
.LP
.OH "'SOI Reference Manual''SqlDate'"
.EH "'SqlDate''SOI Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOSqlDate\fP concerning the data type SQLDATETIME.
.\"KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
copySqlDatetime$IN$source$SQLDATETIME$InvalidComponent
$INOUT$destination$SQLDATETIME$ValueIsNull
_
getCurrentSqlDatetime$INOUT$sql_datetime$SQLDATETIME$
_
isSqlDatetimeEqualNull$IN$sql_datetime$SQLDATETIME$
$result$$BOOL$
_
setSqlDatetimeToNull$INOUT$sql_datetime$SQLDATETIME$
_
SqlDatetime$IN$from$INT$IllegalComponent
$IN$to$INT$IncompatibleConversion
$IN$string$STRING$InvalidComponent
$result$$SQLDATETIME$NoConversionPossible
$$$$RangeOverflow
$$$$ResultOverflow
$$$$StringContainsCharacters
$$$$TooMuchValuesAtBeginning
$$$$TooMuchValuesAtEnd
$$$$ValueOverflow
$$$$WrongOrderOfComponents
_
SqlDatetimeToSqlDate$IN$sql_datetime$SQLDATETIME$ValueIsNull
$result$$SQLDATE$
_
SqlDatetimeToString$IN$sql_datetime$SQLDATETIME$ValueIsNull
$result$$STRING$
_
SqlDatetimeToTimeStamp$IN$sql_datetime$SQLDATETIME$ValueIsNull
$INOUT$time_stamp$TimeStamp$
_
SqlDateToSqlDatetime$IN$sql_date$SQLDATE$ValueIsNull
$INOUT$sql_datetime$SQLDATETIME$
_
StringToSqlDatetime$IN$string$STRING$IncompatibleConversion
$INOUT$sql_datetime$SQLDATETIME$InvalidComponent
$$$$LengthOfStringIsZero
$$$$NoConversionPossible
$$$$RangeOverflow
$$$$ResultOverflow
$$$$StringContainsCharacters
$$$$TooMuchValuesAtBeginning
$$$$TooMuchValuesAtEnd
$$$$ValueOverflow
.TE
.NL
.nr PS 12
.LP
.bp
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
TimeStampToSqlDatetime$IN$time_stamp$TimeStamp$
$INOUT$sql_datetime$SQLDATETIME$
.TE
.NL
.nr PS 12
.\"KE
.LP
.OH "'SOI Reference Manual''SQL-CooL-Data-Types'"
.EH "'SQL-CooL-Data-Types''SOI Reference Manual'"
.bp
.NX 3 "The SQL-CooL-Data-Type SQLINTERVAL"
.sp
For working with the SQL-CooL-Data-Type SQLINTERVAL one has to 
declare at least one variable of this type:
.sp 0.5
.CS L
VAR my_sql_interval : SqlInterval::SQLINTERVAL;
.CE
.sp 0.5
The CooL library CoLibri provides a number of functions which manipulate
values of type SQLINTERVAL and functions which convert a value of type
SQLINTERVAL to other types (e.g. CHAR and \f(HODuration\fP (see [2])) 
and vice versa.
.sp 0.5
A variable of the type SQLINTERVAL can be manipulated by the following
set of functions.
.LP
.OH "'SOI Reference Manual''SqlInterval::DurationToSqlInterval'"
.EH "'SqlInterval::DurationToSqlInterval''SOI Reference Manual'"
.bp
.NX 4 "DurationToSqlInterval"
.sp
.IP MODULE
\f(HBSqlInterval\fP
.IP TYPE
\f(HBSQLINTERVAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE $$DurationToSqlInterval$
$($ IN    duration $ : Duration,
$$ INOUT sql_interval $ : SQLINTERVAL );\fP
.TE
.IP DESCRIPTION
The procedure \f(HODurationToSqlInterval\fP can be used to convert the 
input variable \f(HOduration\fP of type \f(HODuration\fP to a variable 
of type SQLINTERVAL.
.IP NOTE
This function can only be called for input variables of type SQLINTERVAL
which are defined for the combination day to fraction or a subrange of 
it.
.sp 0.5
If \f(HOsql_interval\fP contains the component fraction, a standard 
value will be used for this component.
.sp 0.5
If \f(HOsql_interval\fP is defined for a combination less than day to 
second, the contents of the missing components will be lost.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOIllegalCombination\fP"
is raised, if the input variable \f(HOsql_interval\fP is defined for the
combination year to month or a subrange of it.
.KS
.IP EXAMPLES
.CS L
VAR days           : INT;
VAR hours          : INT;
VAR minutes        : INT;
VAR seconds        : INT;
VAR a_duration     : Duration::Duration;
VAR a_sql_interval : SqlInterval::SQLINTERVAL;
.CE
.KE
.KS
.CS L
\&...
a_sql_interval := SqlInterval::SqlInterval (0, 
                                            SqlDate::DAYS, 
                                            SqlDate::FRACTIONS_5, 
                                            "10 20:30:40.12345");
-- \f(HOa_sql_interval is defined for the range days downto 5 fractions\fP
-- \f(HOand initialized with 10 days, 20 hours, 30 minutes, 40 seconds\fP
-- \f(HOand the value 12345 for the fractions.\fP
.CE
.KE
.KS
.CS L
\&...
days    := 11;
hours   := 22;
minutes := 33;
seconds := 44;
A_Duration := NEW Duration (Days, Hours, Minutes, Seconds);
-- \f(HOThe instance variables of A_Duration were initialized\fP
-- \f(HOwith the values 11 for the days, 22 for the hours,\fP
-- \f(HO33 for the minutes and 44 for the seconds.\fP
.CE
.KE
.KS
.CS L
\&...
SqlInterval::DurationToSqlInterval (a_duration, a_sql_interval);
.CE
.KE
Now a_sql_interval describes an interval of 11 days, 22 hours,
33 minutes and 44 seconds. 
The value for the fractions is 00000.
.IP "SEE ALSO"
\f(HOSqlIntervalToDuration\fP
.LP
.OH "'SOI Reference Manual''SqlInterval::isSqlIntervalEqualNull'"
.EH "'SqlInterval::isSqlIntervalEqualNull''SOI Reference Manual'"
.bp
.NX 4 "isSqlIntervalEqualNull"
.sp
.IP MODULE
\f(HBSqlInterval\fP
.IP TYPE
\f(HBSQLINTERVAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE $isSqlIntervalEqualNull
$( IN sql_interval : SQLINTERVAL )
$: BOOL;\fP
.TE
.IP DESCRIPTION
The function \f(HOisSqlIntervalEqualNull\fP can be used to check if the 
input variable \f(HOsql_interval\fP of type SQLINTERVAL contains the 
null value.
.IP "RETURN VALUE"
The result of this function call is the boolean value
.in +2
.IP "TRUE        "
if the input variable \f(HOsql_interval\fP contains the null value.
.IP "FALSE       "
if the input variable \f(HOsql_interval\fP does not contain the null 
value.
.in -2
.KS
.IP EXAMPLES
.CS L
VAR a_sql_interval : SqlInterval::SQLINTERVAL;
\&...
a_sql_interval := SqlInterval::SqlInterval (0, 
                                            SqlDate::DAYS, 
                                            SqlDate::SECONDS, 
                                            "10 20:30:40");
\&...
IF   SqlInterval::isSqlIntervalEqualNull (a_sql_interval)
THEN
     ...
ELSE
     ...
END IF;
.CE
.KE
a_sql_interval is defined for the range days downto seconds
and initialized with 10 days, 20 hours, 30 minutes and 40 seconds.
The execution continues in the ELSE part of the IF statement because 
a_sql_interval was initialized with "not null" automatically.
.IP "SEE ALSO"
\f(HOsetSqlIntervalToNull\fP
.LP
.OH "'SOI Reference Manual''SqlInterval::setSqlIntervalToNull'"
.EH "'SqlInterval::setSqlIntervalToNull''SOI Reference Manual'"
.bp
.NX 4 "setSqlIntervalToNull"
.sp
.IP MODULE
\f(HBSqlInterval\fP
.IP TYPE
\f(HBSQLINTERVALfP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE $setSqlIntervalToNull
$( INOUT sql_interval : SQLINTERVAL );\fP
.TE
.IP DESCRIPTION
The procedure \f(HOsetSqlIntervalToNull\fP can be used to set the 
variable \f(HOsql_interval\fP to the null value.
.KS
.IP EXAMPLES
.CS L
VAR a_sql_interval : SqlInterval::SQLINTERVAL;
\&...
a_sql_interval := SqlInterval::SqlInterval (0, 
                                            SqlDate::DAYS, 
                                            SqlDate::SECONDS, 
                                            "10 20:30:40");
-- \f(HOa_sql_interval is defined for the range days downto seconds\fP
-- \f(HOand initialized with 10 days, 20 hours, 30 minutes and 40 seconds.\fP
\&...
IF   SqlInterval::isSqlIntervalEqualNull (a_sql_interval)
THEN
     ...
ELSE
     -- \f(HOExecution continues here because a_sql_interval\fP
     -- \f(HOwas initialized with "not null" automatically.\fP
END IF;
\&...
SqlInterval::setSqlIntervalToNull (a_sql_interval);
IF   SqlInterval::isSqlIntervalEqualNull (a_sql_interval)
THEN
     -- \f(HONow execution continues here.\fP
ELSE
     ...
END IF;
.CE
.KE
.IP "SEE ALSO"
\f(HOisSqlIntervalEqualNull\fP
.LP
.OH "'SOI Reference Manual''SqlInterval::SqlInterval'"
.EH "'SqlInterval::SqlInterval''SOI Reference Manual'"
.bp
.NX 4 "SqlInterval"
.sp
.IP MODULE
\f(HBSqlInterval\fP
.IP TYPE
\f(HBSQLINTERVAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE SqlInterval $($ IN length $ : INT,
$$ IN from $ : INT,
$$ IN to $ : INT,
$$ IN string $ : STRING )
$:$ SQLINTERVAL;$\fP
.TE
.IP DESCRIPTION
The function \f(HOSqlInterval\fP has to be used to initialize a variable
of type SQLINTERVAL.
.sp 0.5
The parameters \f(HOfrom\fP and \f(HOto\fP define which components will 
be part of this variable.
Two combinations are possible, either years and months or days, hours, 
minutes, seconds and fractions.
The parameter \f(HOfrom\fP has to contain the larger component.
.sp 0.5
The parameter \f(HOlength\fP defines how many places (one upto nine) the
first component will have.
Calling this function with a \f(HOlength\fP of zero means that a 
standard value will be used (see the documentation of the relational 
data base system INFORMIX).
.sp 0.5
Additionally this variable will be filled with
.in +2
.IP "Zero                   "
if the parameter \f(HOstring\fP has an actual length of zero.
.IP "an interval value      "
if the parameter \f(HOstring\fP has an actual length greater than
zero and contains a valid representation of an interval value (see the
documentation of the relational data base system INFORMIX).
.in -2
.IP "RETURN VALUE"
The result of this function call is an initialized variable of type
SQLINTERVAL.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOIllegalComponent\fP"
is raised, if either the parameter \f(HOfrom\fP or the parameter 
\f(HOto\fP contains a value which is not in the range of year to 
fraction.
.IP "\(bu \f(HOIllegalComponentCombination\fP"
is raised, if the parameters \f(HOfrom\fP and \f(HOto\fP contain values
from different combinations (e.g. \f(HOfrom\fP contains the value month
and \f(HOto\fP contains the value minute).
.IP "\(bu \f(HOLengthForFractionsNotAllowed\fP"
is raised, if the parameter \f(HOlength\fP contains a value larger than 
zero and the parameter \f(HOfrom\fP contains the definition of a 
fraction.
.IP "\(bu \f(HOLengthIsLargerThanNine\fP"
is raised, if the parameter \f(HOlength\fP contains a value larger than 
nine.
.IP "\(bu \f(HOLengthIsLessThanZero\fP"
is raised, if the parameter \f(HOlength\fP contains a negative value.
.IP "\(bu \f(HOWrongOrderOfComponents\fP"
is raised, if the parameter \f(HOfrom\fP contains the definition of a 
component which is less than the one in the parameter \f(HOto\fP.
.sp
The following exceptions will only be raised if the parameter 
\f(HOstring\fP has an actual length greater than zero.
.sp 0.5
.IP "\(bu \f(HOIncompatibleConversion\fP"
is raised, if the parameter \f(HOstring\fP consists of incompatible 
values for a variable of type SQLINTERVAL (see the documentation of the
relational data base system INFORMIX).
.IP "\(bu \f(HOInvalidComponent\fP"
is raised, if the parameter \f(HOstring\fP consists of values which are
not in the range of \f(HOfrom\fP and \f(HOto\fP (e.g. the range is 
\f(HOfrom\fP hour \f(HOto\fP second and \f(HOstring\fP contains a value
for a fraction).
.IP "\(bu \f(HONoConversionPossible\fP"
is raised, if the conversion to SQLINTERVAL is not possible.
.IP "\(bu \f(HORangeOverflow\fP"
is raised, if a component in the parameter \f(HOstring\fP contains a 
value which violates the range for this component
(e.g. value for the component "month" is bigger than 12).
.IP "\(bu \f(HOResultOverflow\fP"
is raised, if the result of the conversion violates the range for a 
variable of type SQLINTERVAL (see the documentation of the relational 
data base system INFORMIX).
.IP "\(bu \f(HOStringContainsCharacters\fP"
is raised, if the parameter \f(HOstring\fP contains character values.
.IP "\(bu \f(HOTooMuchValuesAtBeginning\fP"
is raised, if the parameter \f(HOstring\fP contains too many values for
the first part of the delivered variable of type SQLINTERVAL.
.IP "\(bu \f(HOTooMuchValuesAtEnd\fP"
is raised, if there are remaining values at the end of the parameter 
\f(HOstring\fP.
.IP "\(bu \f(HOValueOverflow\fP"
is raised, if an overflow occurs during the conversion.
.KS
.IP EXAMPLES
.CS L
VAR a_string             : STRING;
VAR a_sql_interval       : SqlInterval::SQLINTERVAL;
VAR another_sql_interval : SqlInterval::SQLINTERVAL;
\&...
a_sql_interval := SqlInterval::SqlInterval (0, 
                                            SqlDate::DAYS, 
                                            SqlDate::SECONDS, 
                                            "");
.CE
.KE
a_sql_interval is defined for the range days downto seconds and
initialized with zero for all components of it.
The first component "DAYS" has a default length of 2 digits and
is defined for values from 0 upto 99.
Additionally a_sql_interval was set to "not null".
.KS
.CS L
\&...
a_string       := "999999999 23:59:59.99999";
a_sql_interval := SqlInterval::SqlInterval (9, 
                                            SqlDate::DAYS, 
                                            SqlDate::FRACTIONS_5, 
                                            a_string);
.CE
.KE
Now a_sql_interval is defined for the range days downto 5 
fractions and initialized with 999999999 days, 23 hours, 59 minutes
and 59 seconds. The value for the fractions is 99999.
The first component "DAYS" is defined with a length of 9 digits and
could be used for values from 0 upto 999999999.
Additionally a_sql_interval was set to "not null".
.KS
.CS L
\&...
another_sql_interval := SqlInterval::SqlInterval (0, 
                                                  SqlDate::YEARS, 
                                                  SqlDate::MONTHS, 
                                                  "9999-11");
.CE
.KE
another_sql_interval is defined for the range years downto 
months and initialized with 9999 years and 11 months.
The first component "YEARS" has a default length of 4 digits and
is defined for values from 0 upto 9999.
Additionally a_sql_interval was set to "not null".
.IP "SEE ALSO"
\f(HOStringToSqlInterval\fP
.LP
.OH "'SOI Reference Manual''SqlInterval::SqlIntervalToDuration'"
.EH "'SqlInterval::SqlIntervalToDuration''SOI Reference Manual'"
.bp
.NX 4 "SqlIntervalToDuration"
.sp
.IP MODULE
\f(HBSqlInterval\fP
.IP TYPE
\f(HBSQLINTERVAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE $$SqlIntervalToDuration$
$($ IN    sql_interval $ : SQLINTERVAL,
$$ INOUT duration $ : Duration );\fP
.TE
.IP DESCRIPTION
The procedure \f(HOSqlIntervalToDuration\fP can be used to convert the 
input variable \f(HOsql_interval\fP of type SQLINTERVAL to a variable of
type \f(HODuration\fP.
.IP NOTE
This procedure can only be called for input variables of type 
SQLINTERVAL which are defined for the combination day to fraction or a 
subrange of it.
.sp 0.5
If \f(HOsql_interval\fP contains the component fraction, the contents of
this component will be lost.
.sp 0.5
If \f(HOsql_interval\fP is defined for a combination less than day to 
second, standard values will be used for the missing components (see the
documentation of the relational data base system INFORMIX).
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOIllegalCombination\fP"
is raised, if the input variable \f(HOsql_interval\fP is defined for the
combination year to month or a subrange of it.
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_interval\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_C_string     : ARRAY [30] OF CHAR;
VAR a_duration     : Duration::Duration;
VAR a_sql_interval : SqlInterval::SQLINTERVAL;
\&...
a_C_string := "999999999 23:59:59.99999";
a_sql_interval := SqlInterval::SqlInterval (9, 
                                            SqlDate::DAYS, 
                                            SqlDate::FRACTIONS_5, 
                                            a_C_string);
-- \f(HOa_sql_interval is defined for the range days downto 5 fractions\fP
-- \f(HOand initialized with 999999999 days, 23 hours, 59 minutes\fP
-- \f(HOand 59 seconds. The value for the fractions is 99999.\fP
.CE
.KE
.KS
.CS L
\&...
a_duration := NEW Duration::Duration (1, 0, 0, 0);
-- \f(HOThe instance variables of a_duration were initialized\fP
-- \f(HOwith the values 1 for the days, 0 for the hours,\fP
-- \f(HO0 for the minutes and 0 for the seconds.\fP
.CE
.KE
.KS
.CS L
\&...
SqlInterval::SqlIntervalToDuration (a_sql_interval, a_duration);
-- \f(HONow the instance variables of a_duration contain the values\fP
-- \f(HO999999999 for the day, 23 for the hours, 59 for the minutes\fP
-- \f(HOand 59 for the seconds.\fP
-- \f(HOThe values for the fractions are lost.\fP
.CE
.KE
.IP "SEE ALSO"
\f(HODurationToSqlInterval\fP
.LP
.OH "'SOI Reference Manual''SqlInterval::SqlIntervalToString'"
.EH "'SqlInterval::SqlIntervalToString''SOI Reference Manual'"
.bp
.NX 4 "SqlIntervalToString"
.sp
.IP MODULE
\f(HBSqlInterval\fP
.IP TYPE
\f(HBSQLINTERVAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l.
\f(HBPROCEDURE $SqlIntervalToString 
$( IN sql_interval : SQLINTERVAL )
$: STRING;\fP
.TE
.IP DESCRIPTION
The procedure \f(HOSqlIntervalToString\fP can be used to convert the 
input variable \f(HOsql_interval\fP of type SQLINTERVAL to a STRING.
.sp 0.5
The length of the string depends on the number of components defined for
\f(HOsql_interval\fP using the function \f(HOSqlInterval()\fP.
If \f(HOsql_interval\fP consists in the largest range of the components 
day to fraction the string will contain at least 26 characters (see 
the documentation of the relational data base system INFORMIX).
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOValueIsNull\fP"
is raised, if the input variable \f(HOsql_interval\fP contains the null 
value.
.KS
.IP EXAMPLES
.CS L
VAR a_string       : STRING;
VAR a_sql_interval : SqlInterval::SQLINTERVAL;
\&...
a_sql_interval := SqlInterval::SqlInterval (0, 
                                            SqlDate::DAYS, 
                                            SqlDate::SECONDS, 
                                            "10 20:30:40");
\&...
a_string := SqlInterval::SqlIntervalToString (a_sql_interval);
.CE
.KE
a_sql_interval is defined for the range days downto seconds
and initialized with 10 days, 20 hours, 30 minutes and 40 seconds.
Now a_string contains the value "10 20:30:40".
.IP "SEE ALSO"
\f(HOStringToSqlInterval\fP
.LP
.OH "'SOI Reference Manual''SqlInterval::StringToSqlInterval'"
.EH "'SqlInterval::StringToSqlInterval''SOI Reference Manual'"
.bp
.NX 4 "StringToSqlInterval"
.sp
.IP MODULE
\f(HBSqlInterval\fP
.IP TYPE
\f(HBSQLINTERVAL\fP
.IP SYNOPSIS
.TS
tab($);
l0 l0 l0 l.
\f(HBPROCEDURE $$StringToSqlInterval$
$($ IN    string $ : STRING,
$$ INOUT sql_interval $ : SQLINTERVAL );\fP
.TE
.IP DESCRIPTION
The procedure \f(HOStringToSqlInterval\fP can be used to convert a 
literal or a string to a variable of type SQLINTERVAL.
The input parameter \f(HOstring\fP must contain a valid representation
of an interval value (see the documentation of the relational data base 
system INFORMIX).
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOIncompatibleConversion\fP"
is raised, if the input parameter \f(HOstring\fP consists of 
incompatible values for a variable of type SQLINTERVAL (see the 
documentation of the relational data base system INFORMIX).
.IP "\(bu \f(HOInvalidComponent\fP"
is raised, if the input parameter \f(HOstring\fP consists of values 
which are not in the range as it was defined for \f(HOsql_interval\fP by
calling the function \f(HOSqlInterval\fP (e.g. the range is \f(HOfrom\fP
hour \f(HOto\fP second and \f(HOstring\fP contains a value).
.IP "\(bu \f(HOLengthOfStringIsZero\fP"
is raised, if the actual length of the input parameter \f(HOstring\fP 
is zero.
.IP "\(bu \f(HONoConversionPossible\fP"
is raised, if the conversion of the input parameter \f(HOstring\fP to a
variable of type SQLINTERVAL is not possible.
.IP "\(bu \f(HORangeOverflow\fP"
is raised, if a component in the input parameter \f(HOstring\fP contains
a value which violates the range for this component (e.g. value for the
component "month" is bigger than 12).
.IP "\(bu \f(HOResultOverflow\fP"
is raised, if the result of the conversion violates the range for a 
variable of type SQLINTERVAL (see the documentation of the relational 
data base system INFORMIX).
.IP "\(bu \f(HOStringContainsCharacters\fP"
is raised, if the input parameter \f(HOstring\fP contains character 
values.
.IP "\(bu \f(HOTooMuchValuesAtBeginning\fP"
is raised, if the input parameter \f(HOstring\fP contains too many 
values for the first part of the delivered variable of type SQLINTERVAL.
.IP "\(bu \f(HOTooMuchValuesAtEnd\fP"
is raised, if there are remaining values at the end of the input 
parameter \f(HOstring\fP.
.IP "\(bu \f(HOValueOverflow\fP"
is raised, if an overflow occurs during the conversion.
for a fraction).
.KS
.IP EXAMPLES
.CS L
VAR a_string       : STRING;
VAR a_sql_interval : SqlInterval::SQLINTERVAL;
\&...
a_sql_interval := SqlInterval::SqlInterval (0, 
                                            SqlDate::DAYS, 
                                            SqlDate::SECONDS, 
                                            "");
-- \f(HOa_sql_interval is defined for the range days downto seconds and\fP
-- \f(HOinitialized with zero for all components of it.\fP
\&...
a_string := "24 15:30:45";
SqlInterval::StringToSqlInterval (a_string, a_sql_interval);
.CE
.KE
Now a_sql_interval describes an interval of 24 days, 15 hours,
30 minutes and 45 seconds.
.IP "SEE ALSO"
\f(HOSqlInterval\fP,
\f(HOSqlIntervalToString\fP
.LP
.OH "'SOI Reference Manual''SqlInterval'"
.EH "'SqlInterval''SOI Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOSqlInterval\fP.
.\"KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
DurationToSqlInterval$IN$duration$Duration$IllegalCombination
$INOUT$sql_interval$SQLINTERVAL$
_
isSqlIntervalEqualNull$IN$sql_interval$SQLINTERVAL$
$result$$BOOL$
_
setSqlIntervalToNull$INOUT$sql_interval$SQLINTERVAL$
_
SqlInterval$IN$length$INT$IllegalComponent
$IN$from$INT$IllegalComponentCombination
$IN$to$INT$IncompatibleConversion
$IN$string$STRING$InvalidComponent
$result$$SQLINTERVAL$LengthForFractionsNotAllowed
$$$$LengthIsLargerThanNine
$$$$LengthIsLessThanZero
$$$$NoConversionPossible
$$$$RangeOverflow
$$$$ResultOverflow
$$$$StringContainsCharacters
$$$$TooMuchValuesAtBeginning
$$$$TooMuchValuesAtEnd
$$$$ValueOverflow
$$$$WrongOrderOfComponents
_
SqlIntervalToDuration$IN$sql_interval$SQLINTERVAL$IllegalCombination
$INOUT$duration$Duration$ValueIsNull
_
SqlIntervalToString$IN$sql_interval$SQLINTERVAL$ValueIsNull
$result$$STRING$
_
StringToSqlInterval$IN$string$STRING$IncompatibleConversion
$INOUT$sql_interval$SQLINTERVAL$InvalidComponent
$$$$LengthOfStringIsZero
$$$$NoConversionPossible
$$$$RangeOverflow
$$$$ResultOverflow
$$$$StringContainsCharacters
$$$$TooMuchValuesAtBeginning
$$$$TooMuchValuesAtEnd
$$$$ValueOverflow
.TE
.NL
.nr PS 12
.\"KE
.LP
.OH "'SOI Reference Manual''SqlInf::SqlStart'"
.EH "'SqlInf::SqlStart''SOI Reference Manual'"
.bp
.NX 3 "Special Functions for the Handling of Database Processes"
.sp
This section describes functions to start, exit or interrupt data base
processes.
.sp
.NX 4 "SqlStart"
.sp
.IP MODULE
\f(HBSqlInf\fP
.IP SYNOPSIS
\f(HBPROCEDURE SqlStart;\fP
.IP DESCRIPTION
The procedure \f(HOSqlStart\fP can be used to start a data base process.
.IP NOTE
One should call this procedure only if no data base was opened.
Otherwise this function call has no effect.
.IP "RETURN VALUE"
The result of this call is a started data base process and an 
opened data base.
.IP ERRORS
The following exceptions may be raised:
.IP "\(bu \f(HOErrorOccurred\fP"
is raised, if the function call was not successful.
.IP "SEE ALSO"
\f(HOSqlBreak\fP,
\f(HOSqlExit\fP 
.LP
.OH "'SOI Reference Manual''SqlInf::SqlBreak'"
.EH "'SqlInf::SqlBreak''SOI Reference Manual'"
.bp
.NX 4 "SqlBreak"
.sp
.IP MODULE
\f(HBSqlInf\fP
.IP SYNOPSIS
\f(HBPROCEDURE SqlBreak;\fP
.IP DESCRIPTION
The procedure \f(HOSqlBreak\fP can be used to interrupt a data base 
process.
.IP "SEE ALSO"
\f(HOSqlExit\fP,
\f(HOSqlStart\fP
.LP
.OH "'SOI Reference Manual''SqlInf::SqlExit'"
.EH "'SqlInf::SqlExit''SOI Reference Manual'"
.bp
.NX 4 "SqlExit"
.sp
.IP MODULE
\f(HBSqlInf\fP
.IP SYNOPSIS
\f(HBPROCEDURE SqlExit;\fP
.IP DESCRIPTION
The procedure \f(HOSqlExit\fP can be used to exit a data base process.
The used memory space will be released.
.IP NOTE
One should call this procedure only if no data base was opened.
Otherwise this function call resets all openend transactions of the 
data base and closes it afterwards.
.IP "SEE ALSO"
\f(HOSqlBreak\fP,
\f(HOSqlStart\fP
.LP
.OH "'SOI Reference Manual''SqlInf'"
.EH "'SqlInf''SOI Reference Manual'"
.bp
.NX 4 "Quick Reference"
.sp
The table below summarizes the procedures provided by the module 
\f(HOSqlInf\fP for special handling of data base processes.
.\"KS
.ps 11
.SM
.TS
tab($)box;
l | l | l | l | l.
Name$Mode$Parameter$Type$Exceptions
=
SqlStart$$$$ErrorOccurred
_
SqlBreak$$$$
_
SqlExit$$$$
.TE
.NL
.nr PS 12
.\"KE
.LP
.OH "''''"
.EH "''''"
.bp
\&
.bp
.OH "'SOI Reference Manual''References'"
.EH "'References''SOI Reference Manual'"
.NX 0 "References
.sp
.IP [1] 5
CooL V2.1
.br
CooL - Language Reference Manual
.IP [2] 5
CooL V2.1
.br
CoLibri - Reference Manual
.LP
.OH "''''"
.EH "''''"
.bp
\&
.OH "'SOI Reference Manual''Appendix A'"
.EH "'Appendix A''SOI Reference Manual'"
.bp
.NX 0 "Appendix
.sp
.NX 0 "A) Language Definition (BNF)"
.sp 0.5
.DS
\f(HOdescriptionFile\fP ::=
     \f(HOdbSystemSpecification SpecificationList\fP
.DE
.LP
.DS
\f(HO\fP\f(HOdbSystemSpecification\fP ::=
      \f(HBSYSTEM\fP \f(HOidentifier\fP \f(HB;\fP
.DE
.LP
.DS
\f(HOSpecificationList\fP ::=
      \f(HOSpecification\fP
    | \f(HOSpecificationList Specification\fP
.DE
.LP
.DS
\f(HOSpecification\fP ::=
      \f(HOviewSpecification\fP
    | \f(HOconstantDeclaration\fP
    | \f(HOstatementSpecification\fP
.DE
.LP
.DS
\f(HO\fP\f(HOconstant_specification\fP ::=
       \f(HBCONST\fP \f(HOidentifier\fP \f(HB=\fP \f(HOconstant_expression\fP \f(HB;\fP
.DE
.LP
.DS
\f(HOviewSpecification\fP ::=
       \f(HBVIEW\fP \f(HOidentifier\fP \f(HB(\fP \f(HOparameterList\fP \f(HB) AS\fP \f(HOcursorSpecification\fP \f(HB;\fP
.DE
.LP
.DS
\f(HOcursorSpecification\fP ::=
       \f(HBCURSOR\fP [ \f(HBOPEN WITH (\fP \f(HOparameterList\fP \f(HO)\fP ] \f(HBFOR\fP  \f(HOcursorClause\fP
.DE
.LP
.DS
\f(HOcursorClause\fP ::=
      \f(HOselectClause\fP  [ \f(HBFOR UPDATE\fP ] | \f(HOinsertClause\fP
.DE
.LP
.DS
\f(HOselectClause\fP ::=
      \f(HO/* select specification of SQL */\fP
.DE
.LP
.DS
\f(HO\fP\f(HOinsertClause\fP ::=
      \f(HBINSERT INTO\fP \f(HOidentifier\fP [ \f(HB(\fP \f(HOidentifierList\fP \f(HB)\fP ]
.DE
.LP
.DS
\f(HOstatementSpecification\fP ::=
      \f(HBSTATEMENT\fP \f(HOidentifier\fP  [ \f(HB(\fP [ \f(HOstatementParameterList\fP ] \f(HB)\fP ] \f(HBIS\fP \f(HOsqlStatementList\fP
.DE
.LP
.DS
\f(HO\fP\f(HOsqlStatementList\fP ::=
        \f(HO\fP\f(HOsqlStatement\fP \f(HB;\fP
      | \f(HOsqlStatementList sqlStatement\fP \f(HB;\fP
.DE
.LP
.DS
\f(HOparameterList\fP ::=
      \f(HOidentifier sqlType\fP
    | \f(HOparameterList\fP \f(HB,\fP \f(HOidentifier sqlType\fP
.DE
.LP
.LP
.DS
\f(HOstatementParameterList\fP ::=
      \f(HOmode identifier sqlType\fP
    | \f(HOstatementParameterList\fP \f(HB,\fP \f(HOmode identifier sqlType\fP
.DE
.LP
.DS
\f(HO\fP\f(HOmode\fP ::=
      [ \f(HBIN\fP ]
    | \f(HBOUT\fP
    | \f(HBINOUT\fP
.DE
.LP
.DS
\f(HOidentifierList\fP ::=
      \f(HOidentifier\fP
    | \f(HOidentifierList\fP \f(HB,\fP \f(HOidentifier\fP
.DE
.LP
.DS
\f(HOsqlType\fP ::=
      \f(HBCHAR\fP [ \f(HB(\fP \f(HOnumber\fP \f(HB)\fP ]
    | \f(HBVARCHAR (\fP \f(HOnumber\fP [ \f(HB,\fP \f(HOnumber\fP ] \f(HB)\fP
    | \f(HBINTEGER\fP
    | \f(HBSERIAL\fP
    | \f(HBSMALLINT\fP
    | \f(HBSMALLFLOAT\fP
    | \f(HBFLOAT\fP
    | \f(HBDECIMAL\fP [ \f(HB(\fP \f(HOnumber\fP [ \f(HB,\fP \f(HOnumber\fP ] \f(HB)\fP ]
    | \f(HBMONEY\fP [ \f(HB(\fP \f(HOnumber\fP [ \f(HB,\fP \f(HOnumber\fP ] \f(HB)\fP ]
    | \f(HBDATE\fP
    | \f(HBDATETIME\fP \f(HOconversionPart\fP
    | \f(HBINTERVAL\fP \f(HOconversionPart\fP
.DE
.LP
.DS
\f(HOconversionPart\fP ::=
     \f(HOtime\fP [ \f(HO(\fP \f(HOe\fP \f(HO)\fP ] \f(HBTO\fP \f(HOtime\fP
.DE
.LP
.DS
\f(HO\fP\f(HOtime\fP::= 
    \f(HBYEAR\fP | \f(HBMONTH\fP | \f(HBDAY\fP | \f(HBHOUR\fP | \f(HBMINUTE\fP | \f(HBSECOND\fP | \f(HBFRACTION\fP [ \f(HB(\fP \f(HOe\fP \f(HB)\fP ]
.DE
.LP
.DS
\f(HOe\fP ::=
     \f(HOnumber\fP
.DE
.LP
.DS
\f(HOconstantExpression\fP ::=
      \f(HOmultiplicativeConstantExpression\fP
     | \f(HOconstantExpression\fP \f(HB+\fP \f(HOmultiplicativeConstantExpression\fP
     | \f(HOconstantExpression\fP \f(HB-\fP \f(HOmultiplicativeConstantExpression\fP
.DE
.LP
.DS
\f(HOmultiplicativeConstantExpression\fP ::=
       \f(HOunaryConstantExpression\fP
      | \f(HOmultiplicativeConstantExpression\fP \f(HB*\fP \f(HOunaryConstantExpression\fP
      | \f(HOmultiplicativeConstantExpression\fP \f(HB/\fP \f(HOunaryConstantExpression\fP
.DE
.LP
.DS
\f(HOunaryConstantExpression\fP ::=
        \f(HOprimaryConstantExpression\fP
      | \f(HB-\fP \f(HOprimaryConstantExpression\fP
      | \f(HB+\fP \f(HOprimaryConstantExpression\fP
.DE
.LP
.DS
\f(HO\fP\f(HOprimaryConstantExpression\fP ::=
        \f(HO\fP\f(HOnumber\fP
       | \f(HO\fP\f(HOidentifier\fP
       | \f(HO(\fP \f(HOconstantExpression\fP \f(HO)\fP
.DE
.LP
.DS
\f(HOsqlStatement\fP ::=
        \f(HO/* every possible SQL-statement for the static use */\fP
.DE
.LP
.DS
\f(HOidentifier\fP ::=
       \f(HOletter\fP
     |  \f(HOidentifier letter\fP
     |  \f(HOidentifier digit\fP
.DE
.LP
.DS
\f(HOnumber\fP ::=
      \f(HOdigit\fP
    | \f(HOnumber digit\fP
.DE
.LP
.DS
\f(HO\fP\f(HOletter\fP ::=
      \f(HBA\fP | ... | \f(HBZ\fP | \f(HBa\fP | ... | \f(HBa\fP | \f(HB_\fP
.DE
.LP
.DS
\f(HOdigit\fP ::=
      \f(HB0\fP | \f(HB1\fP | \f(HB2\fP | \f(HB3\fP | \f(HB4\fP | \f(HB5\fP | \f(HB6\fP | \f(HB7\fP | \f(HB8\fP | \f(HB9\fP
.DE
.LP
.DS
\f(HOcomment\fP ::=
       \f(HO--\fP \f(HOcharacterSequence eol\fP
     | \f(HO(*\fP \f(HOcharacterSequence\fP \f(HO*)\fP
.DE
.OH "'SOI Reference Manual''Appendix B'"
.EH "'Appendix B''SOI Reference Manual'"
.bp
.NX 0 "B) Generator Error Handling"
.sp
\f(HBMESSAGE CLASSIFICATION\fP
.sp
The generator \f(HOsqlgen()\fP knows four kinds of messages. These are:
.IP -
fatal errors
.IP -
errors
.IP -
warnings
.IP -
informations
.LP
A \f(HOfatal error\fP is reported when an error has occured which makes
it impossible for \f(HOsqlgen()\fP to continue the generating process.
These errors occur for example if the command line is incomplete or
\f(HOsqlgen()\fP has not enough memory to work on. In every case a
\f(HOfatal error\fP leads to a termination of \f(HOsqlgen()\fP.
.sp 0.5
An \f(HOerror\fP is reported when the given description file contains
illegal language constructs. These are for example illegal use of
an identifier or an erroneous combination of types.
.sp 0.5
A \f(HOwarning\fP is reported when \f(HOsqlgen()\fP detects weak errors such
as an integer value out of range or a too long identifier has been
truncated.
.sp 0.5
An \f(HOinformation\fP is used to clarify an error reported before and
to inform the user about the reaction of \f(HOsqlgen()\fP. An
\f(HOinformation\fP follows always a syntactical error reported before
and decribes what \f(HOsqlgen()\fP had expected when the syntax error occured.
.LP
.bp
\f(HBFATAL ERRORS\fP
.sp
.IP "\f(HBdata base\fP \f(HOdatabase\fP \f(HBnot found or permission denied\fP"
The generator \f(HOsqlgen()\fP was invoked with the -c option but
\f(HOdatabase\fP does not exist or permission is denied. 
First, you have to check if the data base name exists in the current 
working directory or in the directory given in your \f(HODBPATH\fP 
environment variable.
Second, you have to try to analyse the \f(HOC-ISAM\fP error to get a
clarification about the reason of this problem.
.IP "\f(HBillegal language specification\fP"
An illegal language specifier was used. 
You have to check your release notes which languages are supported and 
how it may be denoted in the command line.
.IP "\f(HBmissing input file\fP"
No input file was given in the command line or it was specified at a
wrong position. 
.IP "\f(HBcannot open protocol file\fP"
You have to check the read/write permissions in the current
directory, or if not enough disk space is available.
.IP "\f(HBcannot open output files\fP"
You have to check the read/write permissions in the current directory
or if not enough disk space is available. 
Furthermore, you have to check if the used file names are allowed on 
your system.
.IP "\f(HBillegal option flag:\fP \f(HOflag\fP"
The generator does not accept the given command line parameter.
.IP "\f(HBmissing argument after option flag:\fP \f(HOflag\fP"
The specified option \f(HOflag\fP requires an argument.
.IP "\f(HBtoo many arguments\fP"
In the command line was specified more than one input file.
.IP "\f(HBOut of memory\fP"
The generator \f(HOsqlgen()\fP cannot get more memory. 
You have to check in your system configuration how much memory is 
available at runtime of your process.
.IP "\f(HBinput file not found\fP"
The given input file does not exist in the current working directory.
.IP "\f(HBcannot read input file\fP"
You have to check the read/write permissions of the input file.
.LP
.bp
\f(HBERRORS\fP
.sp
.IP "\f(HByacc stack overflow\fP"
An internal table of \f(HOsqlgen()\fP has been overflowed. 
You have to simplify your description file. 
If after doing that this error will disappear.
.IP "\f(HBsyntax error\fP"
While analysing the description file \f(HOsqlgen()\fP has reached an
illegal syntactical contruct.
.IP "\f(HBdivision by zero\fP"
In a constant expression a division by zero is not allowed.
.IP "\f(HBunexpected EOF in comment\fP"
The description file ends inside a comment. 
The token \f(HO*)\fP is missing somewhere to close the comment.
.IP "\f(HBunexpected EOF in SQL-statement\fP"
The description file ends inside a SQL-statement. 
The token \f(HO;\fP is missing somewhere to end the SQL-statement.
.IP "\f(HBnewline not allowed in string constant\fP"
After a string literal the terminating \f(HO"\fP (double quotes) are
missing. 
A string literal must fit into one line.
.IP "\f(HBredefinition of identifier\fP"
An already defined identifier has been redefined. 
The new definition has been ignored.
.IP "\f(HBillegal use of identifier in constant expression\fP"
In a constant expression an identifier has been used which was not 
defined as constant before.
.IP "\f(HBsize out of range\fP"
The length attribute of CHAR exceeds the limits of this type.
.IP "\f(HBstart must be greater or equal than end\fP"
In a DATETIME or INTERVAL type declaration the first
component is smaller than the second (HOUR < MONTH).
.IP "\f(HBillegal combination of components\fP"
The generator has reached an illegal combination of DATETIME or
INTERVAL components.
.IP "\f(HB(DB errno:\fP \f(HOnumber\fP \f(HB)\fP \f(HOinformixmessage\fP"
While checking a specified SQL statement an error occured. 
The INFORMIX message number \f(HOnumber\fP represents the internal error
code of the INFORMIX system. 
The \f(HOinformixmessage\fP is the corresponding message text of the 
INFORMIX system. 
The used message language depends on the settings of the INFORMIX system.
.LP
.bp
\f(HBWARNINGS\fP
.sp
.IP "\f(HBparameter for insert cursor ignored\fP"
For an insert cursor parameters are not allowed. 
Given parameters are ignored.
.IP "\f(HBidentifier truncated\fP"
The used identifier is too long. 
The surplus characters are truncated.
.IP "\f(HBinteger literal truncated\fP"
The used integer literal is too long. 
The surplus characters are truncated.
.IP "\f(HBinteger literal out of range\fP"
The generator had to analyse an integer literal with a value greater
than {MAX_INT}. 
Here \f(HOsqlgen()\fP generates probably an erroneous value.
.IP "\f(HBillegal character ignored\fP"
An illegal character was found in the description file. 
This character is discarded.
.IP "\f(HBlength of first interval component out of range\fP"
The specified length of the first INTERVAL component is too
long. 
In this case \f(HOsqlgen()\fP generates the default length attribute
for the first component.
.IP "\f(HBfraction precision out of range\fP"
The generator had to analyse an integer literal with a value greater
than the maximal FRACTION length. 
In this case \f(HOsqlgen()\fP generates a default length for the 
FRACTION.
.LP
.bp
\f(HBINFORMATIONS\fP
.sp
.IP "\f(HBcursor name\fP \f(HOname\fP \f(HBtruncated\fP"
The cursor name is too long. 
The surplus characters are truncated.
.IP "\f(HBillegal system specification, INFORMIX4.0 is assumed\fP"
The given system specification was illegal. 
In this case \f(HOsqlgen()\fP generates the SOI for INFORMIX 4.0.
.IP "\f(HBview, const or statement specification is aspected\fP"
A syntax error had been reported before. 
\f(HOsqlgen()\fP expected a view, const or statement specification.
.IP "\f(HBillegal const specification\fP"
A syntax error had been reported before. 
\f(HOsqlgen()\fP expected a const specification.
.IP "\f(HBillegal view specification\fP"
A syntax error had been reported before. 
\f(HOsqlgen()\fP expected a view specification.
.IP "\f(HBillegal statement specification\fP"
A syntax error had been reported before. 
\f(HOsqlgen()\fP expected a statement specification.
.IP "\f(HBmissing ; inserted\fP"
A syntax error had been reported before. 
\f(HOsqlgen()\fP expected a semicolon.
.LP
.OH "'SOI Reference Manual''Appendix C'"
.EH "'Appendix C''SOI Reference Manual'"
.bp
.NX 0 "C) TestApplication"
.sp
\f(HBDescription File\fP
.sp
.CS L
(* TestAppl.sql *)

SYSTEM informix41;

-- statement specification

STATEMENT Connect() IS
    DATABASE markus;

STATEMENT Disconnect() IS
    CLOSE DATABASE;

-- View specification

-- Select

VIEW Customers (name       CHAR(20),
                 address    CHAR(20),
                 customerId INTEGER,
                 priority   INTEGER)
     AS CURSOR OPEN WITH (lowest_prio INTEGER)
        FOR SELECT c_name,
                   c_address,
                   c_id,
                   c_priority FROM customer
            WHERE c_id > lowest_prio;

-- Insert

VIEW insert_customer (name       CHAR(20),
                       address    CHAR(20),
                       customerId INTEGER,
                       priority   INTEGER)
     AS CURSOR 
        FOR INSERT INTO customer;

-- Update / Delete

VIEW update_customer (name       CHAR(20),
                       address    CHAR(20),
                       customerId INTEGER,
                       priority   INTEGER)
     AS CURSOR OPEN WITH (Identification INTEGER)
        FOR SELECT c_name, 
                   c_address,
                   c_id,
                   c_priority FROM customer
             WHERE c_id = Identification FOR UPDATE;
.CE
.bp
\f(HBTest Application Module - Specification Part\fP
.sp
.CS L
SPECIFICATION TestApplS

IMPORT Customers,
       SqlInteger;

TYPE Service = OBJECT
  PUBLIC
    METHOD GetCustomerList (IN CustomerPrio : SqlInteger::SQLINTEGER);
    METHOD InsertNewCustomer ();
    METHOD ChangeData (IN CustomerId : SqlInteger::SQLINTEGER);
    METHOD PrintInfo ();
    METHOD GetValues ();
  PROTECTED
  STATE
    Customer : Customers::Customers_R;
END OBJECT;

PROCEDURE main();

END SPECIFICATION (* TestApplS *);
.CE
.bp
\f(HBTest Application Module - Implementation Part\fP
.sp
.KS
.CS L
IMPLEMENTATION TestApplS

IMPORT SqlChar,
       SqlInf,
       stdio,
       String;

TYPE Service = OBJECT
  BODY
    INITIALLY
    DO
      Customer := Customers::init_Customers_R();
    END DO;

    METHOD GetCustomerList (IN CustomerPrio : SqlInteger::SQLINTEGER)
      VAR DBAccessObject : Customers::Customers;
      VAR Code : INT;
      VAR Flag : CHAR;
    DO
      DBAccessObject := NEW Customers::Customers;

      DBAccessObject.Open (CustomerPrio);

      LOOP
        TRY
          Customer := DBAccessObject.Fetch_next ();
          PrintInfo ();
        EXCEPT
          CASE SqlInf::DatabaseError :
            Code := stdio::printf ("ErrorCode: %d\\\\n", SqlInf::Sql_Error);
            EXIT;
        END TRY;
        Code := stdio::printf ("next\\\\n");
        LOOP
          Code := stdio::scanf("%c", ADR Flag);
          IF Flag = ' ' THEN EXIT; END IF;
        END LOOP;
      END LOOP;

      DBAccessObject.Close ();
      DBAccessObject.Finally ();
    END DO;
.CE
.KE
.KS
.CS L
    METHOD InsertNewCustomer ()
      VAR DBAccessObject : Customers::InsertCustomers;
      VAR Code : INT;
      VAR Flag : CHAR;
    DO
      DBAccessObject := NEW Customers::InsertCustomers;

      DBAccessObject.Open ();

      LOOP
        TRY
          GetValues ();
          DBAccessObject.Put (Customer);
        EXCEPT
          CASE SqlInf::DatabaseError :
            Code := stdio::printf ("ErrorCode: %d\\\\n", SqlInf::Sql_Error);
            EXIT;
        END TRY;
        Code := stdio::printf ("continue (y/n): ");
        LOOP
          Code := stdio::scanf ("%c", ADR Flag);
          IF Flag = 'n' OR Flag = 'y' THEN EXIT; END IF;
        END LOOP;
        IF Flag = 'n' THEN EXIT; END IF;
        Code := stdio::printf ("\\\\n");
      END LOOP;

      DBAccessObject.Close ();
      DBAccessObject.Finally ();
    END DO;

    METHOD ChangeData (IN CustomerId : SqlInteger::SQLINTEGER)
      VAR DBAccessObject : Customers::UpdateCustomers;
      VAR Code : INT;
    DO
      DBAccessObject := NEW Customers::UpdateCustomers;

      DBAccessObject.Open (CustomerId);

      TRY
        Customer := DBAccessObject.Fetch_next ();
        PrintInfo ();
        GetValues ();
        DBAccessObject.Update (Customer);
      EXCEPT
        CASE SqlInf::DatabaseError:
          Code := stdio::printf("ErrorCode: %d\\\\n", SqlInf::Sql_Error);
      END TRY;

      DBAccessObject.Close ();
      DBAccessObject.Finally ();
    END DO;
.CE
.KE
.KS
.CS L
    METHOD PrintInfo ()
      VAR Code : INT;
    DO
      Code := stdio::printf ("Customer:\\\\n");
      Code := stdio::printf("\t%s\\\\n", Customer.name);
      Code := stdio::printf("\t%s\\\\n", Customer.address);
      Code := stdio::printf("\t%d\\\\n", Customer.customerId);
      Code := stdio::printf("\t%d\\\\n", Customer.priority);
    END DO;

    METHOD GetValues ()
      VAR String : ARRAY [21] OF CHAR;
      VAR Value  : INT;
      VAR Code : INT;
    DO
      Code := stdio::printf ("Input new Customer:\\\\n");
      Code := stdio::printf ("Name: ");
      Code := stdio::scanf ("%s", ADR String);
      Customer.name := 
              SqlChar::SqlChar (String, String::GetLength (String));
      Code := stdio::printf ("Address: ");
      Code := stdio::scanf ("%s", ADR String);
      Customer.address := 
              SqlChar::SqlChar (String, String::GetLength (String));
      Code := stdio::printf ("Customer Id: ");
      Code := stdio::scanf ("%d", ADR Value);
      Customer.customerId := SqlInteger::IntToSqlInteger (Value);
      Code := stdio::printf ("Priority: ");
      Code := stdio::scanf ("%d", ADR Value);
      Customer.priority := SqlInteger::IntToSqlInteger(Value);
      Code := stdio::printf("\\\\n");
    END DO;

  END OBJECT;
.CE
.KE
.KS
.CS L
PROCEDURE main()
  VAR Code : INT;
  VAR Flag : INT;
  VAR Id : SqlInteger::SQLINTEGER;
  VAR Prio : SqlInteger::SQLINTEGER;
  VAR Appl : Service;
  VAR Value : INT;
DO
  Appl := NEW Service;

  Customers::Connect ();

  Prio := SqlInteger::IntToSqlInteger (0);
  Id := SqlInteger::IntToSqlInteger (0);
  Code := stdio::printf ("Service dialog\\\\n");
  LOOP
    Code := stdio::printf ("Menu:\\\\n");
    Code := stdio::printf ("1 - Insert\\\\n");
    Code := stdio::printf ("2 - List\\\\n");
    Code := stdio::printf ("3 - Update\\\\n");
    Code := stdio::printf ("9 - Exit\\\\n");
    Code := stdio::printf ("enter your choise: ");
    Code := stdio::scanf ("%d", ADR Flag);
    SELECT Flag OF
      CASE 1:
        Appl.InsertNewCustomer ();
      CASE 2:
        Code := stdio::printf ("lowest priority: ");
        Code := stdio::scanf ("%d", ADR Value);
        Prio := SqlInteger::IntToSqlInteger (Value);
        Appl.GetCustomerList (Prio);
      CASE 3:
        Code := stdio::printf ("customer id: ");
        Code := stdio::scanf ("%d", ADR Value);
        Id := SqlInteger::IntToSqlSerial (Value);
        Appl.ChangeData (Id);
      CASE 9:
        EXIT;
    END SELECT;
  END LOOP;

  Customers::Disconnect ();

END DO;

END IMPLEMENTATION (* TestApplS.cm *);
.CE
.KE
.OH "'SOI Reference Manual''Appendix D'"
.EH "'Appendix D''SOI Reference Manual'"
.bp
.NX 0 "D) Abbreviations"
.sp
.TS
tab($);
l l.
A-OT    $Application object types
BNF     $Backus-Naur Form
CooL    $Combined object-oriented Language
CoLibri $CooL Library
DBA-OT  $Database access object type
DBMS    $Database Management System
LSI     $Language Specific Interface
o-o     $object oriented
SOI     $SQL Object Interface
.TE
.OH "''''"
.EH "''''"
.bp
.OH "'SOI Reference Manual''Contents'"
.EH "'Contents''SOI Reference Manual'"
.PX
