.OH "'CooL Language Reference Manual''Types'"
.EH "'Types''CooL Language Reference Manual'"
.bp
.NX 1 "Types"
.LP
Each designator and each expression has a type known at compile time.
The type characterizes the possible values of a designator or
expression.
.LP
A type is either
.Si BOOL,
an integer type, a floating point type,
.Si CHAR,
.Si STRING,
an enumeration type, a record type, a union type, an array type, a
reference type,
.Si ADDRESS,
a procedure type, a method type, or an object type.
.LP
An identifier may be used as a type if it is defined in a type
declaration.
.\"===========================================================================
.NX 2 "The Type Bool"
.LP
The type
.Si BOOL
comprises the values
.Si FALSE
and
.Si TRUE.
.\"===========================================================================
.NX 2 "Integer Types"
.LP
The types
.Si INT,
.Si "LONG\ INT"
and
.Si "SHORT\ INT"
comprise implementation-defined subranges of the integer.
.LP
The types
.Si "UNSIGNED\ INT,"
.Si "UNSIGNED\ LONG\ INT"
and
.Si "UNSIGNED\ SHORT\ INT"
comprise implementation-defined subranges of the natural numbers
(including zero).
.\"===========================================================================
.NX 2 "Floating Point Types"
.LP
The type 
.Si FLOAT 
comprises single-precision floating point numbers.
.LP
The type 
.Si DOUBLE 
comprises double-precision floating point numbers.
.\"===========================================================================
.NX 2 "The Type Char"
.LP
The type
.Si CHAR
comprises the characters of the ASCII character set.
.\"===========================================================================
.NX 2 "The Type String"
.LP
Values of type
.Si STRING
are character sequences with an arbitrary number of elements.
.LP
If 
.Si D
is a designator of type
.Si STRING
and 
.Si I
an expression of an integer type, then
.Ss
D [I]
.Se
designates the 
.Si I
th character of the string.
.LP
If 
.Si D
is a designator of type
.Si STRING
and 
.Si Lwb
and
.Si Upb
are expressions of an integer type, then
.Ss
D [Lwb .. Upb]
.Se
designates the substring of
.Si D
of length
.Si "Upb - Lwb + 1"
starting at the 
.Si Lwb
th character. It denotes the empty string if 
.Si Lwb
is greater than
.Si Upb.
.\"===========================================================================
.NX 2 "Enumeration Types"
.LP
An enumeration type
.Ss
ENUM
  I1, I2, .. , In
END ENUM
.Se
where
.Si Ii
are distinct identifiers, comprises an ordered set of 
.Si n
values.
.LP
If
.Si T
is an enumeration type, then
.Ss
T.Ii
.Se
denotes the
.Si i
\&'s value of the type
.Si T
in increasing order.
.\"===========================================================================
.NX 2 "Record Types"
.LP
Values of a record type
.Ss
RECORD
   I1 : T1;
   ...
   In : Tn;
END RECORD
.Se
are tuples of named fields 
.Si "F1, ... , Fn,"
where 
.Si Ii
is an identifier used as the name of field
.Si Fi
and
.Si Ti
is the type of that field.  The identifiers
.Si Ii
have to be distinct.
.LP
The notation
.Ss
I1, ... , In : T;
.Se
is equivalent to
.Ss
I1 : T; 
\&... 
In : T;
.Se
.LP
If
.Si D
is a designator of a record type, then
.Ss
D.Ii
.Se
designates the field named
.Si Ii.
.\"===========================================================================
.NX 2 "Union Types"
.LP
Values of a union type
.Ss
UNION
   I1 : T1;
   ...
   In : Tn;
END UNION
.Se
where
.Si Ii
are distinct identifiers and
.Si Ti
are types, may be interpreted as values of types
.Si "T1, ... , Tn."
.Si Ti
must not be the type
.Si STRING
or a type 
.Si T
containing the type
.Si STRING.
.LP
The notation
.Ss
I1, ... , In : T;
.Se
is equivalent to
.Ss
I1 : T; 
\&... 
In : T;
.Se
.LP
If
.Si D
is a designator of a union type, then
.Ss
D.Ii
.Se
is used to interpret
.Si D 
as a value of type
.Si Ti.
.\"===========================================================================
.NX 2 "Array Types"
.LP
Values of an array type
.Ss
ARRAY Index OF T
.Se
are indexed sequences of values of type
.Si T.
.LP
.Si Index
has the form
.Ss
[Lwb .. Upb]
.Se
where
.Si Lwb
and
.Si Upb
are constant expressions of an integer type.
.Si Index
denotes the range of the indices.
.Si Lwb
must be less than or equal to
.Si Upb.
If
.Si "Lwb .."
is omitted,
.Si "1 .."
is assumed and the indices are in the range
.Si "1 .. Upb."
.LP
The notation
.Ss
ARRAY [L1 .. U1] [L2 .. U2] ... [Ln .. Un] OF T
.Se
is equivalent to
.Ss
ARRAY [L1 .. U1] OF ARRAY [L2 .. U2] OF ... ARRAY [Ln .. Un] OF T
.Se
.LP
If 
.Si D
is the designator of an array type and
.Si I
an expression of type, then
.Ss
D [I]
.Se
designates the element with index 
.Si I
of the sequence.
.\"===========================================================================
.SH
Open Arrays
.LP
The type
.Ss
ARRAY OF T
.Se
is called an 
.Ii "open array"
type and corresponds to an array type 
.Si "ARRAY [Lwb .. Upb] OF T,"
where the values of the lower and upper bound
.Si Lwb
and
.Si Upb
are not known statically but are specific for the individual value of
the array type.
.LP
Open array types are only allowed as types of formal parameters, or as
referent type
.Si T
in reference type 
.Si "REF T,"
or as the type of a foreign variable.
.\"===========================================================================
.NX 2 "Reference Types"
.LP
Values of a reference type
.Ss
REF T
.Se
are either 
.Si NIL
or addresses of variables of type
.Si T.
.LP
If
.Si D
is a designator of type
.Si "REF T",
then
.Ss
D ^
.Se
designates the variable whose address is the value of
.Si D.
.LP
The type 
.Si ADDRESS
denotes references to variables of arbitrary types.
.\"===========================================================================
.NX 2 "Procedure Types"
.LP
A value of a procedure type
.Ss
PROCEDURE (M1 T1, ... , Mn Tn) : T0
.Se
is either
.Si NIL
or a procedure declared as
.Ss
PROCEDURE P (M1 I1: T1, ..., Mn In: Tn) : T0
.Se
The specification
.Si ": T0"
is omitted in the case of a proper procedure.
.LP
If such a procedure has been assigned to a variable of the procedure
type, this variable may be used instead of the procedure name
.Si P.
.\"===========================================================================
.NX 2 "Method Types"
.LP
A value of a method type
.Ss
METHOD (M1 T1, ... , Mn Tn) : T0
.Se
is either
.Si NIL
or a pair
.Si "(O, M)," 
where
.Si O
is a value of an object type that provides a method 
.Si M 
declared as
.Ss
METHOD M (M1 I1: T1, ..., Mn In: Tn) : T0
.Se
The specification
.Si ": T0"
is omitted in the case of a method without a return value.
.LP
If such a pair has been assigned to a variable of the method type,
this variable may be used instead of the term
.Si "O.M"
in a method call.
.\"===========================================================================
.NX 2 "Object Types"
.LP
A value of an object type is either 
.Si NIL
or a handle to an object state.
.LP
The declaration of an object type defines an interface that enumerates
methods to access and manipulate the object state.  The actual
implementation of these methods is given in the body of the object
type.
.LP
An object type is written in the form
.Ss
OBJECT Params
   Interface
STATE
   State
BODY
   Body
END OBJECT
.Se
.Si Params
is either empty or a signature of the form
.Ss
(P1 , ... , Pn)
.Se
where
.Si Pi
are formal parameters called
.Ii "object parameters."
.LP
.Si Interface
has the form
.Ss
PUBLIC
   PublicMethods
PROTECTED
   ProtectedMethods
.Se
where
.Si PublicMethods
and
.Si ProtectedMethods
are lists of method specifications of the form
.Ss
METHOD M Sig;
.Se
where
.Si M
is an identifier and
.Si Sig
is a signature. The methods mentioned in
.Si PublicMethods
are called
.Ii "public methods."
They are visible outside the object type definition and define the
interface to any user of the object type.  The methods mentioned in
.Si ProtectedMethods 
are called
.Ii "protected methods"
and are only visible inside the definition of the object type or a
subtype of the object type (see section
.Ii "3.13 Derived Object Types)."
.LP
.Si State
is a list of declarations of the form
.Ss
I : T;
.Se
where
.Si I
is an identifier and 
.Si T
is a type, which specifies that the state of the object has a
component (field) named
.Si I
which may have values of type
.Si T.
.LP
.KS
The notation
.Ss
I1, ... , In : T;
.Se
is equivalent to
.Ss
I1 : T;
\&...
In : T;
.Se
.KE
.LP
The fields of an object state are not visible outside the object type
definition.
.LP
.Si Body
is a list of method declarations.  For all methods mentioned in the
.Si Interface,
the body must provide an implementation with the same signature.  The
body may provide additional methods (called 
.Ii "local or private methods),"
which are not accessible outside the object type.
.LP
An object type must be named.
.\"===========================================================================
.SH
Method Declaration
.LP
A method declaration has the form
.Ss
METHOD M Sig;
   Locals
DO
   Stmts
END DO;
.Se
This declaration is equivalent to a procedure declaration
where 
.Si METHOD
is replaced by
.Si PROCEDURE.
.LP
The body of an object type may provide a method to initialize the
object state. This method has the form
.Ss
INITIALLY Params
   Locals
DO
   Stmts
END DO;
.Se
where
.Si Params
are the object parameters, which are treated as formal parameters of
this method.  The method is invoked when an object is created.
.LP
The body of an object type may provide a method to finalize the object
state. This method has the form
.Ss
FINALLY
   Locals
DO
   Stmts
END DO;
.Se
This method is invoked when an object is deleted.
.\"===========================================================================
.SH
Object Creation
.LP
An object of type 
.Si T 
is created by the evaluation of the expression
.Ss
NEW T
.Se
which yields a handle to the object state. 
.LP
.KS
If the object type is defined with parameters
.Ss
(P1 , ... , Pn)
.Se
corresponding actual parameters
.Si Ai
must be supplied to create an object:
.Ss
NEW T (A1 , ... , An)
.Se
.KE
The initialization, if present, is called, where the
.Si Ai
act as actual parameters.
.LP
The predefined exception 
.Si STORAGE_ERROR
is raised in the case of a storage error during object creation.
.\"===========================================================================
.SH
Object Deletion
.LP
An object is deleted by evaluation of a delete statement of the form
.Ss
DELETE Expr
.Se
where 
.Si Expr 
is an expression of an object type. The expression is evaluated and
must yield a handle to an object. The finalization, if present, is
called and the object is deleted.
.LP
.\"===========================================================================
.SH
Method Calls
.LP
A method is called with a prefix denoting an object:
.Ss
X . M (A1 , ... , An);
.Se
where 
.Si X
is an expression of an object type that provides a method
.Si M,
and 
.Si Ai
are actual parameters according to the signature of
.Si M.
During the execution of
.Si M,
.Si X
is called the 
.Ii "current object."
.LP
The statements in a method declaration may access the fields of the
current object in the same manner as other variables.
.LP
Within the object type body, methods may be called without a prefix;
then they refer to the current object.  The call of local methods must
not have a prefix denoting an object; they always refer to the current
object.
.\"===========================================================================
.SH
Method Expression
.LP
An expression of the form
.Ss
X . M
.Se
where 
.Si X
is an expression of an object type that provides a method
.Si M
declared as
.Ss
METHOD M (M1 I1: T1, ..., Mn In: Tn) : T0
.Se
is an expression of a method type
.Ss
METHOD (M1 T1, ... , Mn Tn) : T0
.Se
.LP
.Si X
is evaluated and must yield a handle 
.Si O
to an object state. Then the value of the method expression is the pair
.Si "(O, M)."
.LP
A method expression 
.Si E
may be used inside a method call of the form
.Ss
E (A1 , ... , An)
.Se
where
.Si Ai
are actual parameters.
.\"===========================================================================
.NX 2 "Derived Object Types"
.LP
An object type
.Si T1
may be derived from an existing object type
.Si T0.
In this case
.Si T1
the type declaration of 
.Si T1
is written in the form
.Ss
TYPE T1 = T0 OBJECT ... END OBJECT
.Se
.Si T0
is called the 
.Ii "parent type"
of
.Si T1.
A type 
.Ii "X"
is called a 
.Ii "supertype"
of a type 
.Ii "Y"
if it is
the parent type of 
.Ii "Y"
or a supertype of the parent type of 
.Ii "Y."
If 
.Ii "X"
is a supertype of 
.Ii "Y"
then 
.Ii "Y"
is called
a 
.Ii "subtype"
of 
.Ii "X."
.LP
A subtype inherits the methods defined in the interface of its
supertype, i.e. all methods mentioned in the interface of the
supertype are provided by the subtype. The interface of the subtype
must not contain any inherited methods, but may contain additional
methods. A subtype inherits the state fields of the supertype and may
specify additional state fields.
.LP
The parameter list of
.Si T1
must contain the parameter list of 
.Si T0
as an initial sublist.  When an object of type
.Si T1
is created first the initialization specified for 
.Si T0
is invoked, then the initialization for
.Si T1
is executed. When an object of type
.Si T1
is deleted first the finalization for
.Si T1
is executed, then the finalization specified for 
.Si T0
is invoked.
.\"===========================================================================
.SH
Dynamic Method Selection
.LP
The implementation of an inherited method may be redefined in the
subtype by giving an alternative method declaration in the body of the
subtype. This declaration has the form
.Ss
REDEFINED METHOD M Sig;
   Locals
DO
   Stmts
END DO;
.Se
The signatures of the original and the redefined implementation must
be identical.
.LP
A variable of the supertype may hold a value of a subtype (this is
called 
.Ii "polymorphism)."  
In this case only methods defined in the interface of the supertype
can be applied. In case of redefined methods, the actual
implementation is dynamically selected according to the actual type of
the object value. 
.LP
Inside a method declaration a method call may have the form
.Ss
SUPER.M (P1, ... , Pn)
.Se
In this case a possible redefinition of
.Si M
in the actual object type declaration is ignored, and the method
.Si M
as defined in the supertype is called.
.\"===========================================================================
.SH
Visibility of Methods
.LP
A public method of an object type is visible if the object type is
visible.
.LP
A protected method defined in an object type 
.Si T0
is only visible in 
.Si T0
or in a subtype
.Si T1
of
.Si T0; 
i.e. inside the definition of
.Si T1
a protected method provided by the supertype
.Si T0
may be called, if the prefix of the call denotes an object of the type
.Si T0
or
.Si T1.
.LP
A local method is only visible in its defining object type.
.\"===========================================================================
.KS
.NX 2 "Generic Object Types"
.LP
A type declaration of the form
.Ss
TYPE T [F1, ... , Fn] = OBJECT ... END OBJECT;
.Se
defines a generic object type
.Si T.
.Si T
and 
.Si Fi
are identifiers. The
.Si Fi
are called
.Ii "formal generic parameters"
of the generic type
.Si T.
.KE
.LP
An instantiation of a generic object type defines an object type and has the
form
.Ss
T [A1, ... , An] 
.Se
where
.Si Ai
are existing object types or formal generic paramters, called
.Ii "actual generic parameters."
There must be as many actual generic parameter as there are formal
generic parameters.  In the case of an instantiation every occurrence
of a formal generic parameter
.Si Fi
inside of
.Si T
is replaced by the corresponding actual generic parameter
.Si Ai.
.LP
Let
.Si x 
be a designator of type 
.Si F,
where
.Si F 
is a formal generic parameter, then
.Si x
may only be used as follows:
.IP (1)
.Si x
is the source of an assignment statement 
.Si "y := x"
, where 
.Si y
is a designator of type
.Si F.
.IP (2)
.Si x
is the target of an assignment statement 
.Si "x := y"
, where 
.Si y
is a designator of type 
.Si F 
or a function call returning a value of type
.Si F.
.IP (3)
.Si x
is an actual parameter of a method call
.Si "o . M (..., x, ...)"
, where the corresponding formal parameter has the type
.Si F.
.IP (4)
.Si x
is the expression of a return statement 
.Si "RETURN x"
, inside a method returning a value of type
.Si F.
.IP (5)
.Si x
is part of a boolean expression of the form 
.Si "x = y"
or
.Si "x <> y"
, where 
.Si y
has the type
.Si F.
.IP (6)
.Si x 
is the operand in an expression of the form
.Si "ADR x."
.\"===========================================================================
.SH
Constrained Genericity
.LP
A formal generic parameter of a generic object type may have the form
.Ss
F -> T
.Se
where
.Si T
is an existing object type. In this case 
.Si F
is called a constrained formal generic parameter. The corresponding
actual generic parameter in an instantiation of the generic object
type must be the type
.Si T
or a subtype of
.Si T. 
.LP
A generic object type is called constrained generic object type, if it
has at least one constrained formal generic parameter, otherwise it is
called unconstrained.
.LP 
If a formal generic parameter is constrained of the form
.Si "F -> T,"
the type 
.Si F
is compatible to the type
.Si T.
In addition to the rules (1) - (6) a designator
.Si x
of type 
.Si F
may be used as follows:
.IP (7)
.Si "x . M (A1 , ... , An)"
, where
.Si M
is a method provided by the object type
.Si T
and
.Si Ai
are actual parameters of the call.
.\"===========================================================================
.bp
.SH
Object Creation
.LP
If
.Si T
is an generic object type, an object may only be created of the
generic instantiation of 
.Si T.
The object creation expression has then the form
.Ss
New T [T1, ... , Tm] (A1, ... , An)
.Se
where
.Si Ti
are types and
.Si Ai
are actual parameters (which are omitted in the case of no object
parameters). 
.\"===========================================================================
.SH
Derived Generic Types
.LP
A generic object type
.Si T1
may be derived from an existing generic or non-generic object type
.Si T0.
In this case the type declaration of 
.Si T1
is written in the form
.Ss
TYPE T1 [F1, ... , Fn] = T0 OBJECT ... END OBJECT;
.Se
where
.Si Fi
are identifiers. 
.Si T1
is called a subtype of
.Si T0.
If the supertype
.Si T0
is a generic object type the list of formal generic parameters of
.Si T1
must contain the list of formal generic parameters of
.Si T0
as an initial sublist.
.\"===========================================================================
.SH 
Derived Types from Instantiated Generic Types
.LP
An object type 
.Si T1
may be derived from an instantiation
.Si "T0 [A1, ... , An]"
of a generic object type
.Si T0. 
In this case
.Si T1
is called a subtype of 
.Si "T0 [A1, ... , An]."
Let 
.Si M
be a method provided by
.Si T0
with a signature containing a formal generic parameter.  In the case
of a redefined implementation of
.Si M
in 
.Si T1
the signature of
.Si M
must be identical with the signature of
.Si M
in the instantiation
.Si "T0 [A1, ... , An]."
.\"===========================================================================
.NX 2 "Abstract Object Types"
.LP
An abstract object type is written in the form
.Ss
ABSTRACT OBJECT .. END OBJECT
.Se
An abstract object type is an object type that can only be used as a
supertype of other object types. No objects of an abstract object type
may be created. 
.LP
The interface of an abstract object type may contain
the specification of an abstract method of the form
.Ss
ABSTRACT METHOD M Sig;
.Se
where
.Si M
is an identifier and
.Si Sig
is a signature. The body of an abstract object type must not provide
an implementation of an abstract method. An object type providing an
abstract method must be an abstract object type.
.LP
If an abstract object type
.Si T0
provides an abstract method of the form 
.Ss
ABSTRACT METHOD M Sig;
.Se
a subtype of
.Si T0
may provide an implementation of
.Si M.
.KS
In this case the interface of a subtype
.Si T1
must contain a signature of the form
.Ss
METHOD M Sig;
.Se
while the body of
.Si T1
provides the implementation of the method
.Si M.
.KE
.LP
The supertype of an abstract object type must be an abstract object type.
.\"===========================================================================
.NX 2 "Type Compatibility"
.LP
Two types are 
.Ii "equivalent"
if their expanded definitions are
structurally identical.  The (possibly infinite) expanded form of a type
definition is obtained by replacing each identifier by its (expanded)
definitions unless the identifier denotes an object type.
.LP
A Type 
.Ii "X"
is 
.Ii "compatible"
to a type 
.Ii "Y"
if one of the
following conditions holds:
.IP (1)
.Ii "X"
is equivalent to 
.Ii "Y."
.IP (2)
.Ii "X"
is a subtype of 
.Ii "Y."
.IP (3)
.Ii "X"
is an instantiation of a generic object type 
.Si T1 
of the form
.br
.Si "T1 [A1, ... , An+m]"
and 
.Ii "Y"
is an instantiation of a generic object type 
.Si T0 
of the form
.Si "T0 [B1, ... , Bn]"
where 
.Si T1 
is compatible to 
.Si T0
and
.Si Ai
is equivalent to
.Si Bi
for all values
.Si "1 \(<= i \(<= n."
.IP (4)
.Ii "X"
is the type 
.Si F
of a constrained generic parameter of the form
.Si "F -> T"
and
.Ii "Y"
is the type 
.Si T.
.IP (5)
.Ii "X"
is
.Si "ARRAY [Lwb .. Upb] OF T"
and 
.Ii "Y"
is
.Si "ARRAY OF T"
for arbitrary
.Si Lwb,
.Si Upb
and 
.Si T
or vice versa.
.IP (6)
.Ii "X"
is 
.Si ADDRESS
and 
.Ii "Y"
is a reference type or vice versa.
.IP (7)
.Ii "X"
is the type of 
.Si NIL
and 
.Ii "Y"
is an object type, the type of a formal generic parameter, a procedure type, 
a method type, a reference type, or 
.Si ADDRESS.
